/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

static void make_date_index(void);
static void make_file_index(void);
static void file_index_to_date_index(const char *entry);
static void date_index_to_file_index(const char *entry);

void make_index(void)
{
   DIR *dirp;
   struct dirent *direntp;
   char wdir[MAXLEN];

   if(LastLog > 0) mklastlog(outdir);

   if(strcmp(Index,"no") == 0) {
      sprintf(wdir,"%sindex.html",outdir);
      if(access(wdir, R_OK) == 0) unlink(wdir);
      return;
   }

   if(debug) debuga("%s",text[53]);

   // convert any old report hierarchy
   dirp = opendir(outdir);
   while ((direntp = readdir( dirp )) != NULL) {
      if(isdigit(direntp->d_name[0]) && isdigit(direntp->d_name[1])) {
         if(strcmp(IndexTree,"date") == 0)
            file_index_to_date_index(direntp->d_name);
         else
            date_index_to_file_index(direntp->d_name);
      }
   }
   closedir(dirp);

   if(strcmp(IndexTree,"date") == 0) {
      make_date_index();
   } else {
      make_file_index();
   }
}

static void make_date_index(void)
{
   FILE *fp_ou, *fp_ou2, *fp_ou3;
   DIR *dirp, *dirp2, *dirp3;
   struct dirent *direntp;
   struct dirent *direntp2;
   struct dirent *direntp3;
   char hbc1[30];
   char yearindex[MAXLEN];
   char yeardir[MAXLEN];
   char yearnum[10];
   char monthindex[MAXLEN];
   char monthdir[MAXLEN];
   char monthname1[9], monthname2[9];
   char nmonth[30];
   char monthnum[10];
   char dayindex[MAXLEN];
   char daynum[10];
   int yearsort[150];
   int nyears;
   int year;
   int monthsort[144];
   int nmonths;
   int m1, m2, month;
   int daysort[31*31];
   int ndays;
   int d1, d2, day;
   int i, y, m, d;
   int order;

   sprintf(yearindex,"%sindex.html",outdir);
   strcpy(hbc1,"class=\"header\"");

   nyears=0;
   dirp = opendir(outdir);
   while ((direntp = readdir( dirp )) != NULL) {
      if(strlen(direntp->d_name) > 4 || !isdigit(direntp->d_name[0]) || !isdigit(direntp->d_name[1]) ||
         !isdigit(direntp->d_name[2]) || !isdigit(direntp->d_name[3])) continue;
      year=atoi(direntp->d_name);
      if (nyears>=sizeof(yearsort)/sizeof(yearsort[0])) {
         /*
         If too many years are listed in the directory, we ignore the earliest years. The yearsort array
         is big enough to accomodate the most ambitious use of sarg but this safety is added to prevent
         a crash should the directory be polluted by other entries.
         */
         if (year>yearsort[0]) {
            for (i=1 ; i<nyears && year>yearsort[i] ; i++)
               yearsort[i-1]=yearsort[i];
            yearsort[i-1]=year;
         }
      } else {
         for (i=nyears ; i>0 &&  year<yearsort[i-1] ; i--) {
            yearsort[i]=yearsort[i-1];
         }
         yearsort[i]=year;
         nyears++;
      }
   }
   (void)closedir( dirp );

   order=(strcmp(IndexSortOrder,"A") == 0) ? 1 : -1;

   if((fp_ou=fopen(yearindex,"w"))==NULL) {
      fprintf(stderr, "SARG: (index) %s: %s - %s\n",text[45],yearindex,strerror(errno));
      exit(1);
   }
   write_html_header(fp_ou, ".");
   fprintf(fp_ou,"<tr><th %s>%s</th><th %s>%s</th></tr>\n",hbc1,text[130],hbc1,text[132]);
   for (y=0 ; y<nyears ; y++) {
      if (order>0)
         year=yearsort[y];
      else
         year=yearsort[nyears-1-y];
      sprintf(yearnum,"%04d",year);
      fprintf(fp_ou,"<tr><td class=\"data2\"><a href=\"%s/index.html\">%s</a></td><td class=\"data2\">%s</td></tr>\n",yearnum,yearnum,get_size(outdir,yearnum));
      sprintf(yeardir,"%s%s",outdir,yearnum);
      // Year dir
      nmonths=0;
      dirp2 = opendir(yeardir);
      while ((direntp2 = readdir( dirp2 )) != NULL) {
         if(!isdigit(direntp2->d_name[0]) || !isdigit(direntp2->d_name[1])) continue;
         i=-1;
         if (sscanf(direntp2->d_name,"%d%n",&m1,&i)!=1 || m1<=0 || m1>12 || i<0) continue;
         if (direntp2->d_name[i]=='-') {
            if (sscanf(direntp2->d_name+i+1,"%d",&m2)!=1 || m2<m1 || m2>12) continue;
         } else if (direntp2->d_name[i]!='\0') {
            continue;
         } else {
            m2=0;
         }
         if (nmonths>=sizeof(monthsort)/sizeof(monthsort[0])) {
            fprintf(stderr,"SARG: Too many month directories in %s\nSupernumerary entries are ignored\n",yeardir);
            break;
         }
         month=m1*16+m2;
         for (i=nmonths ; i>0 &&  month<monthsort[i-1] ; i--) {
            monthsort[i]=monthsort[i-1];
         }
         monthsort[i]=month;
         nmonths++;
      }
      (void)closedir(dirp2);
      sprintf(monthindex,"%s/index.html",yeardir);
      if((fp_ou2=fopen(monthindex,"w"))==NULL) {
         fprintf(stderr, "SARG: (index) %s: %s - %s\n",text[45],monthindex,strerror(errno));
         exit(1);
      }
      write_html_header(fp_ou2,"..");
      fprintf(fp_ou2,"<tr><th %s>%s/%s</th></tr>\n",hbc1,text[130],text[131]);
      for (m=0 ; m<nmonths ; m++) {
         if (order>0)
            month=monthsort[m];
         else
            month=monthsort[nmonths-1-m];
         m1=month / 16;
         if(month % 16 != 0) {
            m2=month % 16;
            sprintf(monthnum,"%02d-%02d",m1,m2);
            sprintf(monthname1,"%02d",m1);
            sprintf(monthname2,"%02d",m2);
            name_month(monthname1,sizeof(monthname1));
            name_month(monthname2,sizeof(monthname2));
            sprintf(nmonth,"%s-%s",monthname1,monthname2);
         } else {
            sprintf(nmonth,"%02d",m1);
            sprintf(monthnum,"%02d",m1);
            name_month(nmonth,sizeof(nmonth));
         }
         fprintf(fp_ou2,"<tr><td class=\"data2\"><a href=\"%s/index.html\">%s %s</a></td></tr>\n",monthnum,yearnum,nmonth);

         sprintf(monthdir,"%s/%s",yeardir,monthnum);
         // month dir
         ndays=0;
         dirp3 = opendir(monthdir);
         while ((direntp3 = readdir( dirp3 )) != NULL) {
            if(!isdigit(direntp3->d_name[0]) && !isdigit(direntp3->d_name[1])) continue;
            i=-1;
            if (sscanf(direntp3->d_name,"%d%n",&d1,&i)!=1 || d1<=0 || d1>31 || i<0) continue;
            if (direntp3->d_name[i]=='-') {
               if (sscanf(direntp3->d_name+i+1,"%d",&d2)!=1 || d2<d1 || d2>31) continue;
            } else if (direntp3->d_name[i]!='\0') {
               continue;
            } else {
               d2=0;
            }
            if (ndays>=sizeof(daysort)/sizeof(daysort[0])) {
               fprintf(stderr,"SARG: Too many day directories in %s\nSupernumerary entries are ignored\n",monthdir);
               break;
            }
            day=d1*32+d2;
            for (i=ndays ; i>0 &&  day<daysort[i-1] ; i--) {
               daysort[i]=daysort[i-1];
            }
            daysort[i]=day;
            ndays++;
         }
         (void)closedir(dirp3);
         sprintf(dayindex,"%s/index.html",monthdir);
         if((fp_ou3=fopen(dayindex,"w"))==NULL) {
            fprintf(stderr, "SARG: (index) %s: %s - %s\n",text[45],dayindex,strerror(errno));
            exit(1);
         }
         write_html_header(fp_ou3,"../..");
         fprintf(fp_ou3,"<tr><th %s>%s/%s/%s</th></tr>\n",hbc1,text[130],text[131],text[127]);
         for (d=0 ; d<ndays ; d++) {
            if (order>0)
               day=daysort[d];
            else
               day=daysort[ndays-1-d];
            d1=day / 32;
            if(day % 32 != 0) {
               d2=day % 32;
               sprintf(daynum,"%02d-%02d",d1,d2);
            } else {
               sprintf(daynum,"%02d",d1);
            }
            fprintf(fp_ou3,"<tr><td class=\"data2\"><a href=\"%s/index.html\">%s %s %s</a></td></tr>\n",daynum,yearnum,nmonth,daynum);
         }
         write_html_trailer(fp_ou3);
         fclose(fp_ou3);
      }
      write_html_trailer(fp_ou2);
      fclose(fp_ou2);
   }

   write_html_trailer(fp_ou);
   fclose(fp_ou);
}

static void make_file_index(void)
{
   #define MAX_CREATION_DATE 15
   #define MAX_DIR_NAME 30
   FILE *fp_ou;
   DIR *dirp;
   struct dirent *direntp;
   char wdir[MAXLEN];
   char month[4];
   char data[80];
   char tuser[20];
   char tbytes[20];
   char media[20];
   char ftime[128];
   char day[6], mon[8], year[40], hour[10];
   int iyear, imonth, iday, ihour, iminute, isecond, idst;
   int nsort;
   int nallocated;
   int order;
   int i;
   int cmp;
   struct getwordstruct gwarea;
   struct sortstruct
   {
      char sortname[9];
      char creationdate[MAX_CREATION_DATE];
      char dirname[MAX_DIR_NAME];
      char date[60];
   } **sortlist, *item, **tempsort;

   sprintf(wdir,"%sindex.html",outdir);
   strcpy(hbc1,"class=\"header\"");

   order=(strcmp(IndexSortOrder,"A") == 0) ? 1 : -1;

   dirp = opendir(outdir);

   nsort=0;
   nallocated=0;
   sortlist=NULL;
   while ((direntp = readdir( dirp )) != NULL) {
      if (strchr(direntp->d_name,'-') == 0) continue;
      if (strlen(direntp->d_name)>MAX_DIR_NAME) continue;
      item=malloc(sizeof(*item));
      if (!item) {
         fprintf(stderr,"SARG: not enough memory to sort the index\n");
         exit(1);
      }
      if(strcmp(df,"u") == 0) {
         strncpy(item->sortname,direntp->d_name,4);
         strncpy(month,direntp->d_name+4,3);
      } else {
         strncpy(item->sortname,direntp->d_name+5,4);
         strncpy(month,direntp->d_name+2,3);
      }
      item->sortname[4]='\0';
      month[3]='\0';
      conv_month(month);
      strcat(item->sortname,month);
      if(strcmp(df,"u") == 0) strncat(item->sortname,direntp->d_name+7,2);
      else strncat(item->sortname,direntp->d_name,2);
      obtdate(outdir,direntp->d_name,data);
      if (sscanf(data,"%d-%d-%d %d:%d:%d %d",&iyear,&imonth,&iday,&ihour,&iminute,&isecond,&idst)==7) {
         formatdate(data,sizeof(data),iyear,imonth,iday,ihour,iminute,isecond,idst);
         snprintf(item->creationdate,sizeof(item->creationdate),"%04d%02d%02d%02d%02d%02d",iyear,imonth,iday,ihour,iminute,isecond);
      } else {
         /*
         Old code to parse a date stored by sarg before 2.2.6.1 in the sarg-date file of each report directory.
         */
         getword_start(&gwarea,data);
         if (getword_skip(16,&gwarea,' ')<0) {
            printf("SARG: Maybe you have a broken week day in your %s%s/sarg-date file.\n",outdir,direntp->d_name);
            exit(1);
         }
         if (getword_multisep(mon,sizeof(mon),&gwarea,' ')<0) {
            printf("SARG: Maybe you have a broken month in your %s%s/sarg-date file.\n",outdir,direntp->d_name);
            exit(1);
         }
         if (getword_multisep(day,sizeof(day),&gwarea,' ')<0) {
            printf("SARG: Maybe you have a broken day in your %s%s/sarg-date file.\n",outdir,direntp->d_name);
            exit(1);
         }
         if (getword_multisep(hour,sizeof(hour),&gwarea,' ')<0) {
            printf("SARG: Maybe you have a broken time in your %s%s/sarg-date file.\n",outdir,direntp->d_name);
            exit(1);
         }
         do {
            if (getword_multisep(year,sizeof(year),&gwarea,' ')<0) {
               printf("SARG: Maybe you have a broken year in your %s%s/sarg-date file.\n",outdir,direntp->d_name);
               exit(1);
            }
         } while (year[0] && !isdigit(year[0])); //skip time zone information with spaces until the year is found
         if (sscanf(hour,"%d:%d:%d",&ihour,&iminute,&isecond)!=3) {
            printf("SARG: Maybe you have a broken time in your %s%s/sarg-date file.\n",outdir,direntp->d_name);
            exit(1);
         }
         buildymd(day,mon,year,ftime);
         snprintf(item->creationdate,sizeof(item->creationdate),"%s%02d%02d%02d",ftime, ihour, iminute, isecond);
      }
      strcpy(item->dirname,direntp->d_name);
      strncpy(item->date,data,sizeof(item->date));
      if (nsort+1>nallocated) {
         nallocated+=10;
         tempsort=realloc(sortlist,nallocated*sizeof(*item));
         if (!tempsort) {
            fprintf(stderr,"SARG: not enough memory to sort the index\n");
            exit(1);
         }
         sortlist=tempsort;
      }
      for (i=nsort ; i>0 ; i--) {
         cmp=strcmp(item->sortname,sortlist[i-1]->sortname);
         if (cmp==0) cmp=strcmp(item->creationdate,sortlist[i-1]->creationdate);
         if (cmp>=0) {
            break;
         }
         sortlist[i]=sortlist[i-1];
      }
      sortlist[i]=item;
      nsort++;
   }

   (void)closedir( dirp );

   if((fp_ou=fopen(wdir,"w"))==NULL) {
      fprintf(stderr, "SARG: (index) %s: %s\n",text[45],wdir);
      exit(1);
   }
   write_html_header(fp_ou,".");
   fprintf(fp_ou,"<tr><th %s>%s</th><th %s>%s</th><th %s>%s</th><th %s>%s</th><th %s>%s</th></tr>\n",hbc1,text[101],hbc1,text[102],hbc1,text[103],hbc1,text[93],hbc1,text[96]);
   for (i=0 ; i<nsort ; i++) {
      if (order>0)
         item=sortlist[i];
      else
         item=sortlist[nsort-i-1];
      obtuser(outdir,item->dirname,tuser);
      obttotal(outdir,item->dirname,tbytes,tuser,media);
      fprintf(fp_ou,"<tr><td class=\"data2\"><a href='%s/%s'>%s</a></td><td class=\"data2\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s</td></tr>\n",item->dirname,ReplaceIndex,item->dirname,item->date,tuser,tbytes,media);
   }
   write_html_trailer(fp_ou);
   fclose(fp_ou);

   if (sortlist) {
      for (i=0 ; i<nsort ; i++)
         free(sortlist[i]);
      free(sortlist);
   }
}

static void file_index_to_date_index(const char *entry)
{
   int y1, y2, d1, d2;
   int i, j;
   int ndirlen;
   int monthlen;
   char m1[8], m2[8];
   char olddir[MAXLEN], newdir[MAXLEN];

   if(strlen(entry) < 19) return;

   y1=0;
   y2=0;
   memset(m1,0,sizeof(m1));
   memset(m2,0,sizeof(m2));
   d1=0;
   d2=0;
   i=0;
   if(strcmp(df,"u") == 0) {
      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         y1=y1*10+(entry[i++]-'0');
      if (j!=4) return;
      for (j=0 ; j<sizeof(m1)-1 && entry[i] && isalpha(entry[i]) ; j++)
         m1[j]=entry[i++];
      if (j!=3) return;
      m1[j]='\0';
      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         d1=d1*10+(entry[i++]-'0');
      if (j!=2) return;

      if (entry[i++]!='-') return;

      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         y2=y2*10+(entry[i++]-'0');
      if (j!=4) return;
      for (j=0 ; j<sizeof(m2)-1 && entry[i] && isalpha(entry[i]) ; j++)
         m2[j]=entry[i++];
      if (j!=3) return;
      m2[j]='\0';
      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         d2=d2*10+(entry[i++]-'0');
      if (j!=2) return;
   } else if(strcmp(df,"e") == 0) {
      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         d1=d1*10+(entry[i++]-'0');
      if (j!=2) return;
      for (j=0 ; j<sizeof(m1)-1 && entry[i] && isalpha(entry[i]) ; j++)
         m1[j]=entry[i++];
      if (j!=3) return;
      m1[j]='\0';
      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         y1=y1*10+(entry[i++]-'0');
      if (j!=4) return;

      if (entry[i++]!='-') return;

      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         d2=d2*10+(entry[i++]-'0');
      if (j!=2) return;
      for (j=0 ; j<sizeof(m2)-1 && entry[i] && isalpha(entry[i]) ; j++)
         m2[j]=entry[i++];
      if (j!=3) return;
      m2[j]='\0';
      for (j=0 ; entry[i] && isdigit(entry[i]) ; j++)
         y2=y2*10+(entry[i++]-'0');
      if (j!=4) return;
   } else
      return;

   conv_month(m1);
   conv_month(m2);
   ndirlen=sprintf(newdir,"%s%04d",outdir,y1);
   if(access(newdir, R_OK) != 0) mkdir(newdir,0755);
   if(strcmp(m1,m2) != 0) ndirlen+=sprintf(newdir+ndirlen,"/%s-%s",m1,m2);
   else ndirlen+=sprintf(newdir+ndirlen,"/%s",m1);
   if(access(newdir, R_OK) != 0) mkdir(newdir,0755);
   monthlen=ndirlen;
   if(d1!=d2) ndirlen+=sprintf(newdir+ndirlen,"/%02d-%02d",d1,d2);
   else ndirlen+=sprintf(newdir+ndirlen,"/%02d",d1);

   sprintf(olddir,"%s%s",outdir,entry);
   if (rename(olddir,newdir)) {
      fprintf(stderr, "SARG: (index) rename error from \"%s\" to \"%s\" - %s\n",olddir,newdir,strerror(errno));
      exit(1);
   }

   strcpy(newdir+monthlen,"/images");
   if(access(newdir, R_OK) != 0) {
#ifdef HAVE_SYMLINK
      char linkdir[MAXLEN];

      sprintf(linkdir,"%simages",outdir);
      if (symlink(linkdir,newdir)) {
         fprintf(stderr, "SARG: failed to create link \"%s\" to \"%s\" - %s\n",linkdir,newdir,strerror(errno));
         exit(1);
      }
#else
      char cmd[MAXLEN];
      int cstatus;

      sprintf(cmd,"ln -s \"%simages\" \"%s/images\"",outdir,newdir);
      cstatus=system(cmd);
      if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
         fprintf(stderr, "SARG: command return status %d\n",WEXITSTATUS(cstatus));
         fprintf(stderr, "SARG: command: %s\n",cmd);
         exit(1);
      }
#endif
   }
}

static void date_index_to_file_index(const char *entry)
{
   int y1, next;
   int val1len;
   int d1, d2;
   int i, j;
   char val1[MAXLEN];
   char m1[8], m2[8];
   char *str;
   char newdir[MAXLEN], olddir[MAXLEN];
   DIR *dirp2, *dirp3;
   struct dirent *direntp2;
   struct dirent *direntp3;

   if(strlen(entry) != 4) return;

   next=-1;
   if (sscanf(entry,"%d%n",&y1,&next)!=1 || next<0 || entry[next]) return;

   val1len=sprintf(val1,"%s%s",outdir,entry);
   dirp2 = opendir(val1);
   if (!dirp2) return;
   while ((direntp2 = readdir( dirp2 )) != NULL) {
      if(!isdigit(direntp2->d_name[0]) || !isdigit(direntp2->d_name[1])) continue;
      i=0;
      str=direntp2->d_name;
      for (j=0 ; j<sizeof(m1) && str[i] && isdigit(str[i]) ; j++)
         m1[j]=str[i++];
      if (j>=sizeof(m1)) continue;
      m1[j]='\0';
      conv_month_name(m1);
      if (str[i]=='-') {
         i++;
         for (j=0 ; j<sizeof(m2) && str[i] && isdigit(str[i]) ; j++)
            m2[j]=str[i++];
         if (j>=sizeof(m2)) continue;
         m2[j]='\0';
         conv_month_name(m2);
      } else if (!str[i]) {
         strcpy(m2,m1);
      } else {
         continue;
      }

      sprintf(val1+val1len,"/%s",direntp2->d_name);
      dirp3 = opendir(val1);
      if (!dirp3) continue;
      while ((direntp3 = readdir( dirp3 )) != NULL) {
         if(!isdigit(direntp3->d_name[0]) || !isdigit(direntp3->d_name[1])) continue;
         i=0;
         str=direntp3->d_name;
         d1=0;
         for (j=0 ; str[i] && isdigit(str[i]) ; j++)
            d1=d1*10+(str[i++]-'0');
         if (j!=2) continue;
         if (str[i]=='-') {
            i++;
            d2=0;
            for (j=0 ; str[i] && isdigit(str[i]) ; j++)
               d2=d2*10+(str[i++]-'0');
            if (j!=2) continue;
         } else if (!str[i]) {
            d2=d1;
         } else {
            continue;
         }

         if(strcmp(df,"u") == 0) sprintf(newdir,"%s%04d%s%02d-%04d%s%02d",outdir,y1,m1,d1,y1,m2,d2);
         else if(strcmp(df,"e") == 0) sprintf(newdir,"%s%02d%s%04d-%02d%s%04d",outdir,d1,m1,y1,d2,m2,y1);
         else continue;
         sprintf(olddir,"%s%04d/%s/%s",outdir,y1,direntp2->d_name,direntp3->d_name);
         if(rename(olddir,newdir)) {
            fprintf(stderr, "SARG: (index) rename error from \"%s\" to \"%s\" - %s\n",olddir,newdir,strerror(errno));
            exit(1);
         }
      }
      (void)closedir( dirp3 );
   }
   (void)closedir( dirp2 );

   /*!
   \bug The links to the images in the reports are broken after moving the directories
   as the the HTML files are not at the right level for the images any more.
   */
}

