/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef __plextor_ecx
#define __plextor_ecx

#include <ui/plextor_ext_cx_ui.h>

const int ehres = 300;
const int evres = 160;

class QCanvas;
class QCanvasLine;
class QCanvasView;

class plextor_ext_cx : public plextor_ext_cx_UI
{
	Q_OBJECT
public:
	plextor_ext_cx( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0,
		int* BLER=0, int* E11=0, int* E21=0, int* E31=0, int* E12=0, int* E22=0, int* E32=0,
		int* blk_tot=0, int* blk_max=0, float* blk_avg=0, int* colors=0, int limit=0);
	~plextor_ext_cx();
//	void setptr();
//	void setcolor(int* colors);
//	void setlimit(int limit);
	void redraw();

//public functions:

private:
	int*	data[7];
	int*	dtot;
	int*	dmax;
	float*	davg;
	int	color[7];
	int	hlimit;
	QCanvas*	Canvas[7];
	QCanvasView*	CanvasView[7];
	QCanvasLine**	Grid[7];
	QCanvasLine**	Res[7];
	QCanvasLine**	Lim;

private slots:
	void DrawGrid(int idx);
	void pxecx_close();
};

#endif
