begin # require 'rubygems'
    require 'rubygems'
rescue Exception
end

require 'xmlrpc/client'
require 'digest/sha1'
require 'rexml/document'
require 'pp'

require 'OpenNebula/XMLUtils'
require 'OpenNebula/VirtualMachine'
require 'OpenNebula/VirtualMachinePool'
require 'OpenNebula/VirtualNetwork'
require 'OpenNebula/VirtualNetworkPool'
require 'OpenNebula/Image'
require 'OpenNebula/ImagePool'
require 'OpenNebula/ImageRepository'
require 'OpenNebula/User'
require 'OpenNebula/UserPool'
require 'OpenNebula/Host'
require 'OpenNebula/HostPool'
require 'OpenNebula/Cluster'
require 'OpenNebula/ClusterPool'

module OpenNebula

    # -------------------------------------------------------------------------
    # The Error Class represents a generic error in the OpenNebula
    # library. It contains a readable representation of the error.
    # Any function in the OpenNebula module will return an Error
    # object in case of error.
    # -------------------------------------------------------------------------
    class Error
        attr_reader :message

        # +message+ a description of the error
        def initialize(message=nil)
            @message=message
        end

        def to_str()
            @message
        end
    end

    # -------------------------------------------------------------------------
    # Returns true if the object returned by a method of the OpenNebula
    # library is an Error
    # -------------------------------------------------------------------------
    def self.is_error?(value)
        value.class==OpenNebula::Error
    end

    # -------------------------------------------------------------------------
    # The client class, represents the connection with the core and handles the
    # xml-rpc calls.
    # -------------------------------------------------------------------------
    class Client
        attr_accessor :one_auth

        begin
            require 'xmlparser'
            XMLPARSER=true
        rescue LoadError
            XMLPARSER=false
        end

        def initialize(secret=nil, endpoint=nil)
            if secret
                one_secret = secret
            elsif ENV["ONE_AUTH"] and !ENV["ONE_AUTH"].empty? and File.file?(ENV["ONE_AUTH"])
                one_secret=File.read(ENV["ONE_AUTH"])
            elsif File.file?(ENV["HOME"]+"/.one/one_auth")
                one_secret=File.read(ENV["HOME"]+"/.one/one_auth")
            else
                raise "ONE_AUTH file not present"
            end

            if !one_secret.match(".+:.+")
                raise "Authorization file malformed"
            end


            one_secret=~/^(.+?):(.+)$/
            user=$1
            password=$2

            if password.match(/^plain:/)
                @one_auth = "#{user}:#{password.split(':').last}"
            else
                @one_auth = "#{user}:#{Digest::SHA1.hexdigest(password)}"
            end

            if endpoint
                @one_endpoint=endpoint
            elsif ENV["ONE_XMLRPC"]
                @one_endpoint=ENV["ONE_XMLRPC"]
            else
                @one_endpoint="http://localhost:2633/RPC2"
            end

            @server=XMLRPC::Client.new2(@one_endpoint)
        end

        def call(action, *args)

            if XMLPARSER
                @server.set_parser(XMLRPC::XMLParser::XMLStreamParser.new)
            end

            begin
                response = @server.call_async("one."+action, @one_auth, *args)

                if response[0] == false
                    Error.new(response[1])
                else
                    response[1] #response[1..-1]
                end
            rescue Exception => e
                Error.new(e.message)
            end
        end
    end
end
