/* OpenCP Module Player
 * copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * GMIPlay ULTRASND.INI PAT format handler (reads GUS patches etc)
 *
 * revision history: (please note changes here)
 *  -sss050411 Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#include "config.h"
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "types.h"
#include "gmipat.h"
#include "gmiplay.h"
#include "binfile/binfpak.h"
#include "boot/psetting.h"
#include "stuff/compat.h"
#include "stuff/err.h"

static char midInstrumentPath[PATH_MAX+1];

static int loadpatchUltra(struct minstrument *ins,
                          uint8_t             program,
                          uint8_t            *sampused,
                          struct sampleinfo **smps,
                          uint16_t           *samplenum)
{
      	int retval;
	ins->sampnum=0;
	*ins->name=0;
	if (!midInstrumentPath[0])
	{
		FILE *f=pakfOpen(midInstrumentNames[program]);
		if (!f)
		{
			fprintf(stderr, "[ultradir] {CP.PAK}/%s not found\n", midInstrumentNames[program]);
			return errFileMiss;
		}
		fprintf(stderr, "[ultradir] loading {CP.PAK}/%s\n", midInstrumentNames[program]);
		retval=loadpatchPAT(fileno(f), ins, program, sampused, smps, samplenum);
		fclose(f);
	} else {
		int file;
		char path[PATH_MAX+NAME_MAX];
		snprintf(path, sizeof(path), "%s%s", midInstrumentPath, midInstrumentNames[program]);
		if ((file=open(path, O_RDONLY))<0)
		{
			fprintf(stderr, "[ultradir] '%s': %s\n", path, strerror(errno));
			return errFileMiss;
		}
		fprintf(stderr, "[ultradir] loading %s\n", path);
		retval=loadpatchPAT(file, ins, program, sampused, smps, samplenum);
		close(file);
	}
	if (retval)
		fprintf(stderr, "[ultradir] Invalid PAT file\n");
	return retval;
}

static int addpatchUltra( struct minstrument *ins,
                          uint8_t             program,
                          uint8_t             sn,
                          uint8_t             sampnum,
                          struct sampleinfo  *sip,
                          uint16_t           *samplenum)
{
	int retval;
	if (!midInstrumentPath[0])
	{
		FILE *f=pakfOpen(midInstrumentNames[program]);
		if (!f)
		{
			fprintf(stderr, "[ultradir] {CP.PAK}/%s not found\n", midInstrumentNames[program]);
			return errFileMiss;
		}
		fprintf(stderr, "[ultradir] loading {CP.PAK}/%s\n", midInstrumentNames[program]);
		retval=addpatchPAT(fileno(f), ins, program, sn, sampnum, sip, samplenum);
		fclose(f);
	} else {
		int file;
		char path[PATH_MAX+NAME_MAX];

		snprintf(path, sizeof(path), "%s%s", midInstrumentPath, midInstrumentNames[program]);
		if ((file=open(path, O_RDONLY))<0)
		{
			fprintf(stderr, "[ultradir] '%s': %s\n", path, strerror(errno));
			return errFileMiss;
		}
		fprintf(stderr, "[ultradir] loading %s\n", path);
		retval=addpatchPAT(file, ins, program, sn, sampnum, sip, samplenum);
		close(file);
	}
	if (retval)
		fprintf(stderr, "[ultradir] Invalid PAT file\n");
	return retval;
}

int midInitUltra(void)
{
	FILE *inifile;
	int i;
      	char path[PATH_MAX+1];
	char *buf;
	char *bp;
	char *bp2;
	char type;
	long len;
	const char *ipath;

	_midClose=0;

	if (!(ipath=getenv("ULTRADIR")))
		ipath=cfGetProfileString("midi", "ultradir", "");

	for (i=0; i<256; i++)
		midInstrumentNames[i][0]=0;

	snprintf(midInstrumentPath, sizeof(midInstrumentPath), "%s%s", ipath, strlen(ipath)?(ipath[strlen(ipath)-1]=='/'?"":"/"):"/");

	snprintf(path, sizeof(path), "%s%s", midInstrumentPath, "ULTRASND.INI");
	if ((inifile=fopen(path, "r")))
	{
		fprintf(stderr, "[ultradir] parsing %s\n", path);
		goto got_ultrasound_ini;
	}
	if ((inifile=pakfOpen("ULTRASND.INI")))
	{
		fprintf(stderr, "[ultradir] parsing {CP.DAT}/ULTRASND.INI");
		midInstrumentPath[0]=0;
		goto got_ultrasound_ini;
	}

	fprintf(stderr, "[ultradir] failed to locate ULTRASND.INI\n");
	return 0;

got_ultrasound_ini:

	fseek(inifile, 0, SEEK_END);
	len=ftell(inifile);
	fseek(inifile, 0, SEEK_SET);

	if (!(buf=calloc(len+1, 1)))
		return 0;
	fread(buf, len, 1, inifile);
  	buf[len]=0;
	fclose(inifile);

	*path=0;

	bp=buf;
	type=0;

	while (1)
	{
		int insnum;
		
		while (isspace(*bp))
			bp++;
		if (!*bp)
			break;

		if (*bp=='[')
		{
			if (!memicmp(bp, "[Melodic Bank 0]", 16))
				type=1;
			else
				if (!memicmp(bp, "[Drum Bank 0]", 13))
					type=2;
				else
					type=0;
		}

		if (!memicmp(bp, "PatchDir", 8))
		{
			while ((*bp!='=')&&*bp)
				bp++;
			if (*bp)
				bp++;
			while ((*bp==' ')||(*bp=='\t'))
				bp++;
			bp2=bp;
			while (!isspace(*bp2)&&*bp2)
				bp2++;
			memcpy(path, bp, bp2-bp);
			path[bp2-bp]=0;
			if (path[strlen(path)-1]!='/')
				strcat(path, "/");
		}
		
		if (!isdigit(*bp)||!type)
		{
			while (*bp&&(*bp!='\r')&&(*bp!='\n'))
				bp++;
			continue;
		}

		insnum=strtoul(bp, 0, 10)+((type==2)?128:0);
		while ((*bp!='=')&&*bp)
			bp++;
		if (*bp)
			bp++;
		while ((*bp==' ')||(*bp=='\t'))
			bp++;
		bp2=bp;
		while (!isspace(*bp2)&&*bp2)
			bp2++;

		if (insnum<256)
		{
			char *x=midInstrumentNames[insnum];
			strcpy(x+(bp2-bp), ".PAT");
			memcpy(x, bp, bp2-bp);
		}

		while (*bp&&(*bp!='\r')&&(*bp!='\n'))
			bp++;

	}
	free(buf);
	
	loadpatch = loadpatchUltra;
	addpatch = addpatchUltra;
	return 1;
}
