#ifndef _CDAUDIO_H
#define _CDAUDIO_H

struct cdStat
{
	int paused; /* boolean */
	int error;  /* boolean */
	int looped; /* boolean */
	uint32_t position;
	int speed;
};

extern int cdIsCDDrive(int fd);
extern void cdStop(int fd);
extern void cdRestart(int fd);
extern void cdRestartAt(int fd, unsigned long start);
extern void cdPause(int fd);
extern unsigned short cdGetTracks(int fd, unsigned long *starts, unsigned char *first, unsigned short maxtracks);
extern int cdPlay(int fd, unsigned long start, unsigned long len);
extern void cdGetStatus(int fd, struct cdStat *stat);
extern void cdSetSpeed(unsigned short sp);
extern void cdSetLoop(int loop);
extern void cdIdle(void);

#endif
