#ifndef VBUTTON_H
#define VBUTTON_H

#include <qpushbutton.h>
#include <qevent.h>

class VButton : public QPushButton
{
Q_OBJECT
public:
	VButton(QWidget *parent=0, const char *name=0);
	~VButton();
	void setKeyCode(unsigned int keycode);
	unsigned int getKeyCode();
	void setText(const QString& text);
	void setShiftText(const QString& text);
	void capsPressed(bool press);
	
	
	void reposition(int width, int height);
	void res();
	static double pw;
	static double ph;

private:
	int press;
	bool inrpt;

protected:
	unsigned int keycode;
	QString u;
	QString l;
	QRect orig_size;
    void timerEvent ( QTimerEvent * );

public slots:
	void sendKey();
	void shiftPressed(bool press);

protected slots:
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);

signals:
	void keyClick(unsigned int keycode);

};

#endif
