/***************************************************************************
                          idletimer.h  -  description
                             -------------------
    begin                : Tue Oct 22 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IDLETIMER_H
#define IDLETIMER_H

#include <qobject.h>

// Forward declarations
class CurrentAccount;
class XAutoLock;

/** Control the idle timer based on account settings.
  *@author Mike K. Bennett
  */

class IdleTimer : public QObject  {
   Q_OBJECT

  public:
    // The constructor
  	                 IdleTimer();
    // The destructor
  	                ~IdleTimer();

  private: // Private attributes
    // The user's account
    const CurrentAccount   *account_;
    // The idle detector
    XAutoLock       *watcher_;

  private slots: // Private slots
    // Echo the watcher's activity signal.
    void             slotActivity();
    // Echo the watcher's timeout. 
    void             slotTimeout();
    // Reset the watcher based on the account's settings.
    void             updateWatcher();

  signals: // Signals
    // Signal user activity when the watcher detects it.
    void             activity();
    // Signal user inactivity when the watcher detects it.
    void             timeout();
};

#endif
