/**
* Copyright 2005-2007 ECMWF
*
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "grib_api_internal.h"
/*
   This is used by make_class.pl

   START_CLASS_DEF
   CLASS      = accessor
   SUPER      = grib_accessor_class_gen
   IMPLEMENTS = get_native_type;init
   IMPLEMENTS = compare;unpack_string;value_count
   MEMBERS = const char* offset
   MEMBERS = const char* length
   END_CLASS_DEF

 */

/* START_CLASS_IMP */

/*

Don't edit anything between START_CLASS_IMP and END_CLASS_IMP
Instead edit values between START_CLASS_DEF and END_CLASS_DEF
or edit "accessor.class" and rerun ./make_class.pl

*/

static int  get_native_type(grib_accessor*);
static int unpack_string (grib_accessor*, char*, size_t *len);
static long value_count(grib_accessor*);
static void init(grib_accessor*,const long, grib_arguments* );
static void init_class(grib_accessor_class*);
static int compare(grib_accessor*, grib_accessor*);

typedef struct grib_accessor_md5 {
    grib_accessor          att;
/* Members defined in gen */
/* Members defined in md5 */
	const char* offset;
	const char* length;
} grib_accessor_md5;

extern grib_accessor_class* grib_accessor_class_gen;

static grib_accessor_class _grib_accessor_class_md5 = {
    &grib_accessor_class_gen,                      /* super                     */
    "md5",                      /* name                      */
    sizeof(grib_accessor_md5),  /* size                      */
    0,                           /* inited */
    &init_class,                 /* init_class */
    &init,                       /* init                      */
    0,                  /* post_init                      */
    0,                    /* free mem                       */
    0,                       /* describes himself         */
    0,                /* get length of section     */
    &value_count,                /* get number of values      */
    0,                 /* get number of bytes      */
    0,                /* get offset to bytes           */
    &get_native_type,            /* get native type               */
    0,                /* get sub_section                */
    0,               /* grib_pack procedures long      */
    0,               /* grib_pack procedures long      */
    0,                  /* grib_pack procedures long      */
    0,                /* grib_unpack procedures long    */
    0,                /* grib_pack procedures double    */
    0,              /* grib_unpack procedures double  */
    0,                /* grib_pack procedures string    */
    &unpack_string,              /* grib_unpack procedures string  */
    0,                 /* grib_pack procedures bytes     */
    0,               /* grib_unpack procedures bytes   */
    0,            /* pack_expression */
    0,              /* notify_change   */
    0,                /* update_size   */
    0,            /* preferred_size   */
    0,                    /* resize   */
    0,      /* nearest_smaller_value */
    0,                       /* next accessor    */
    &compare,                    /* compare vs. another accessor   */
    0,     /* unpack only ith value          */
    0,             		/* clear          */
};


grib_accessor_class* grib_accessor_class_md5 = &_grib_accessor_class_md5;


static void init_class(grib_accessor_class* c)
{
	c->dump	=	(*(c->super))->dump;
	c->next_offset	=	(*(c->super))->next_offset;
	c->byte_count	=	(*(c->super))->byte_count;
	c->byte_offset	=	(*(c->super))->byte_offset;
	c->sub_section	=	(*(c->super))->sub_section;
	c->pack_missing	=	(*(c->super))->pack_missing;
	c->is_missing	=	(*(c->super))->is_missing;
	c->pack_long	=	(*(c->super))->pack_long;
	c->unpack_long	=	(*(c->super))->unpack_long;
	c->pack_double	=	(*(c->super))->pack_double;
	c->unpack_double	=	(*(c->super))->unpack_double;
	c->pack_string	=	(*(c->super))->pack_string;
	c->pack_bytes	=	(*(c->super))->pack_bytes;
	c->unpack_bytes	=	(*(c->super))->unpack_bytes;
	c->pack_expression	=	(*(c->super))->pack_expression;
	c->notify_change	=	(*(c->super))->notify_change;
	c->update_size	=	(*(c->super))->update_size;
	c->preferred_size	=	(*(c->super))->preferred_size;
	c->resize	=	(*(c->super))->resize;
	c->nearest_smaller_value	=	(*(c->super))->nearest_smaller_value;
	c->next	=	(*(c->super))->next;
	c->unpack_double_element	=	(*(c->super))->unpack_double_element;
	c->clear	=	(*(c->super))->clear;
}
/* END_CLASS_IMP */

static void init(grib_accessor* a, const long len , grib_arguments* arg )
{
  grib_accessor_md5* self = (grib_accessor_md5*)a;
  int n=0;

  self->offset = grib_arguments_get_name(a->parent->h,arg,n++);
  self->length = grib_arguments_get_name(a->parent->h,arg,n++);
  a->length = 0;
  a->flags |= GRIB_ACCESSOR_FLAG_READ_ONLY;
  a->flags |= GRIB_ACCESSOR_FLAG_EDITION_SPECIFIC;

}

static int  get_native_type(grib_accessor* a){
  return GRIB_TYPE_BYTES;
}


static int compare(grib_accessor* a, grib_accessor* b) {
  int retval=GRIB_SUCCESS;

  size_t alen = (size_t)grib_value_count(a);
  size_t blen = (size_t)grib_value_count(b);

  if (alen != blen) return GRIB_COUNT_MISMATCH;

  return retval;
}

static int unpack_string(grib_accessor*a , char*  v, size_t *len){
  grib_accessor_md5* self = (grib_accessor_md5*)a;
  unsigned mess_len;
  unsigned char* mess;
  unsigned char* p;
  unsigned char digest[16];
  long offset,length;
  grib_string* blacklist=NULL;
  grib_accessor* b=NULL;
  int ret=0;
  char* s=NULL;
  int i=0;
  struct cvs_MD5Context md5c;

  if (*len <32 ) {
    grib_context_log(a->parent->h->context,GRIB_LOG_ERROR,"md5: array too small");
    return GRIB_ARRAY_TOO_SMALL;
  }
  
  if((ret = grib_get_long_internal(a->parent->h,self->offset,&offset))
      != GRIB_SUCCESS)
    return ret;
  if((ret = grib_get_long_internal(a->parent->h,self->length,&length))
      != GRIB_SUCCESS)
    return ret;

  
  mess=grib_context_malloc(a->parent->h->context,length);
  memcpy(mess,a->parent->h->buffer->data+offset,length);
  mess_len=length;

  blacklist=a->parent->h->context->blacklist;
  while (blacklist && blacklist->string) {
    
    b=grib_find_accessor(a->parent->h,blacklist->string);
    if (!b) return GRIB_NOT_FOUND;

    p=mess+b->offset-offset;
    for (i=0;i<b->length;i++) *(p++)=0;

    blacklist=blacklist->next;
  }

  cvs_MD5Init(&md5c);
  cvs_MD5Update(&md5c,mess,mess_len);
  cvs_MD5Final(digest,&md5c);

  s=v;
  for (i = 0; i < 16; i++)
  {
    sprintf (s,"%02x", (unsigned int) digest[i]);
    s+=2;
  }

  return ret;
}

static long value_count(grib_accessor* a) { return 16;}
