/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ColorWellButton
extends JButton {
    public static final String MODULE = "ColorWell";

    public ColorWellButton(Color color) {
        this.setIcon(new ColorWell(color));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.addActionListener(new ActionHandler());
    }

    public Color getSelectedColor() {
        return ((ColorWell)this.getIcon()).color;
    }

    public void setSelectedColor(Color color) {
        ((ColorWell)this.getIcon()).color = color;
        this.repaint();
    }

    private class ColorPickerDialog
    extends JDialog
    implements ActionListener {
        private JColorChooser chooser;
        private JButton ok;
        private JButton cancel;

        public ColorPickerDialog(Frame parent, String title, boolean modal) {
            super(parent, title, modal);
            this.init();
        }

        public ColorPickerDialog(Dialog parent, String title, boolean modal) {
            super(parent, title, modal);
            this.getContentPane().setLayout(new BorderLayout());
            this.init();
        }

        public void ok() {
            Color c = this.chooser.getColor();
            if (c != null) {
                ColorWellButton.this.setSelectedColor(c);
            }
            this.setVisible(false);
        }

        public void cancel() {
            this.setVisible(false);
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.ok) {
                this.ok();
            } else {
                this.cancel();
            }
        }

        private void init() {
            Color c = ColorWellButton.this.getSelectedColor();
            this.chooser = c == null ? new JColorChooser() : new JColorChooser(c);
            this.getContentPane().add("Center", this.chooser);
            Box buttons = new Box(0);
            buttons.add(Box.createGlue());
            this.ok = new JButton(GRI18n.getString("Common", "OK"));
            this.ok.addActionListener(this);
            buttons.add(this.ok);
            buttons.add(Box.createHorizontalStrut(6));
            this.getRootPane().setDefaultButton(this.ok);
            this.cancel = new JButton(GRI18n.getString("Common", "Cancel"));
            this.cancel.addActionListener(this);
            buttons.add(this.cancel);
            buttons.add(Box.createGlue());
            this.getContentPane().add("South", buttons);
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Frame parent = DialogUtil.findParentWindow(ColorWellButton.this);
            ColorPickerDialog dialog = parent != null ? new ColorPickerDialog(parent, GRI18n.getString(ColorWellButton.MODULE, "colorChooserTitle"), true) : new ColorPickerDialog(JOptionPane.getFrameForComponent(ColorWellButton.this), GRI18n.getString(ColorWellButton.MODULE, "colorChooserTitle"), true);
            dialog.pack();
            dialog.show();
        }
    }

    static class ColorWell
    implements Icon {
        Color color;

        ColorWell(Color color) {
            this.color = color;
        }

        public int getIconWidth() {
            return 35;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color == null) {
                return;
            }
            g.setColor(this.color);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(this.color.darker());
            g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

