/* -*- mode: C; c-file-style: "gnu" -*- */
/* dbus-glib.h GLib integration
 *
 * Copyright (C) 2002, 2003  CodeFactory AB
 * Copyright (C) 2003, 2004 Red Hat, Inc.
 *
 * Licensed under the Academic Free License version 2.1
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef DBUS_GLIB_H
#define DBUS_GLIB_H

#include <glib-object.h>
#include <dbus/dbus-protocol.h>
#include <dbus/dbus-shared.h>

G_BEGIN_DECLS

#define DBUS_INSIDE_DBUS_GLIB_H 1


/**
 * Convert to DBusConnection with dbus_g_connection_get_connection()
 */
typedef struct DBusGConnection DBusGConnection;
/**
 * Convert to DBusMessage with dbus_g_message_get_message()
 */
typedef struct DBusGMessage DBusGMessage;
/**
 * Deliberately not possible to convert to DBusPendingCall
 */
typedef struct DBusGPendingCall DBusGPendingCall;

void dbus_g_connection_flush (DBusGConnection *connection);

GQuark dbus_g_error_quark (void);
#define DBUS_GERROR dbus_g_error_quark ()

typedef enum
{
#include <dbus/dbus-glib-error-enum.h>    
} DBusGError;

void             dbus_g_thread_init (void);
DBusGConnection* dbus_g_bus_get     (DBusBusType   type,
                                     GError      **error);

typedef struct DBusGObjectInfo DBusGObjectInfo;
typedef struct DBusGMethodInfo DBusGMethodInfo;

typedef DBusHandlerResult (* DBusGMethodMarshaller) (DBusGConnection    *connection,
                                                     DBusGMessage       *message,
                                                     void               *user_data);

/**
 * Object typically generated by dbus-glib-tool that
 * stores a mapping from introspection data to a
 * function pointer for a C method to be invoked.
 */
struct DBusGMethodInfo
{
  GCallback                 function;    /**< C method to invoke */
  DBusGMethodMarshaller     marshaller;  /**< Marshaller to go DBusGMessage to C method */
  int                       data_offset; /**< Offset into the introspection data */
};

/**
 * Introspection data for a GObject, normally autogenerated by
 * a tool such as dbus-glib-tool.
 */
struct DBusGObjectInfo
{
  int   format_version;         /**< Allows us to change the rest of this struct
                                 *   by adding DBusGObjectInfo2, DBusGObjectInfo3, etc.
                                 */
  const DBusGMethodInfo *infos; /**< Array of method pointers */
  const unsigned char *data;    /**< Introspection data */
};

void dbus_g_object_class_install_info    (GObjectClass          *object_class,
                                          const DBusGObjectInfo *info);
void dbus_g_connection_register_g_object (DBusGConnection       *connection,
                                          const char            *at_path,
                                          GObject               *object);


typedef struct DBusGProxy       DBusGProxy;
typedef struct DBusGProxyClass  DBusGProxyClass;

#define DBUS_TYPE_G_PROXY              (dbus_g_proxy_get_type ())
#define DBUS_G_PROXY(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), DBUS_TYPE_G_PROXY, DBusGProxy))
#define DBUS_G_PROXY_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), DBUS_TYPE_G_PROXY, DBusGProxyClass))
#define DBUS_IS_G_PROXY(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), DBUS_TYPE_G_PROXY))
#define DBUS_IS_G_PROXY_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), DBUS_TYPE_G_PROXY))
#define DBUS_G_PROXY_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), DBUS_TYPE_G_PROXY, DBusGProxyClass))


GType             dbus_g_proxy_get_type              (void) G_GNUC_CONST;
DBusGProxy*       dbus_g_proxy_new_for_service       (DBusGConnection   *connection,
                                                      const char        *service_name,
                                                      const char        *path_name,
                                                      const char        *interface_name);
DBusGProxy*       dbus_g_proxy_new_for_service_owner (DBusGConnection   *connection,
                                                      const char        *service_name,
                                                      const char        *path_name,
                                                      const char        *interface_name,
                                                      GError           **error);
DBusGProxy*       dbus_g_proxy_new_for_peer          (DBusGConnection   *connection,
                                                      const char        *path_name,
                                                      const char        *interface_name);
void              dbus_g_proxy_connect_signal        (DBusGProxy        *proxy,
                                                      const char        *signal_name,
                                                      GCallback          handler,
                                                      void              *data,
                                                      GClosureNotify     free_data_func);
void              dbus_g_proxy_disconnect_signal     (DBusGProxy        *proxy,
                                                      const char        *signal_name,
                                                      GCallback          handler,
                                                      void              *data);
DBusGPendingCall* dbus_g_proxy_begin_call            (DBusGProxy        *proxy,
                                                      const char        *method,
                                                      int                first_arg_type,
                                                      ...);
gboolean          dbus_g_proxy_end_call              (DBusGProxy        *proxy,
                                                      DBusGPendingCall  *pending,
                                                      GError           **error,
                                                      int                first_arg_type,
                                                      ...);
void              dbus_g_proxy_call_no_reply         (DBusGProxy        *proxy,
                                                      const char        *method,
                                                      int                first_arg_type,
                                                      ...);


#undef DBUS_INSIDE_DBUS_GLIB_H

G_END_DECLS

#endif /* DBUS_GLIB_H */



