include(CMakeFindDependencyMacro)

# Boost is a required dependency
find_dependency(Boost REQUIRED)

# Was TTK built with optional dependencies?

if (ON)
  find_package(MPI REQUIRED)
endif()

if (ON)
  find_dependency(OpenMP REQUIRED)
endif()

if (ON AND 1)
  find_dependency(Qhull REQUIRED)
endif()

if (OFF)
  set(Torch_DIR "Torch_DIR-NOTFOUND" CACHE PATH "Use TTK Torch dir" FORCE)
  find_dependency(Torch REQUIRED Torch_DIR-NOTFOUND)
endif()

if (ON AND NOT ON)
  set(ZFP_DIR "/usr/lib/cmake/zfp" CACHE PATH "Use TTK ZFP dir" FORCE)
  find_dependency(ZFP REQUIRED /usr/lib/cmake/zfp)
endif()

if (ON AND NOT ON)
  find_dependency(ZLIB REQUIRED)
endif()

if (ON AND NOT ON)
  find_package(Python3 COMPONENTS Development NumPy)
endif()

# Include the actual targets for TTK Base
include("${CMAKE_CURRENT_LIST_DIR}/TTKBaseTargets.cmake")
