/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.performanceTesting.remoteDriver.compose;

import androidx.compose.ui.awt.ComposePanel;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import com.intellij.driver.model.RdTarget;
import com.intellij.driver.model.transport.Ref;
import com.intellij.performanceTesting.remoteDriver.compose.ComposeSemanticsNodeWrapper;
import com.intellij.performanceTesting.remoteDriver.compose.ComposeXpathDataModelExtensionKt;
import com.jetbrains.performancePlugin.jmxDriver.InvokerService;
import com.jetbrains.performancePlugin.remotedriver.xpath.XpathDataModelExtension;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.JewelComposePanelWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/performanceTesting/remoteDriver/compose/ComposeXpathDataModelExtension;", "Lcom/jetbrains/performancePlugin/remotedriver/xpath/XpathDataModelExtension;", "<init>", "()V", "isRemDevExtension", "", "()Z", "postProcessElement", "", "doc", "Lorg/w3c/dom/Document;", "component", "Ljava/awt/Component;", "element", "Lorg/w3c/dom/Element;", "parentElement", "traverseComposeTree", "node", "Landroidx/compose/ui/semantics/SemanticsNode;", "composePanel", "Landroidx/compose/ui/awt/ComposePanel;", "intellij.performanceTesting.remoteDriver.compose"})
@SourceDebugExtension(value={"SMAP\nComposeXpathDataModelExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeXpathDataModelExtension.kt\ncom/intellij/performanceTesting/remoteDriver/compose/ComposeXpathDataModelExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1869#2,2:194\n1869#2,2:196\n1869#2,2:198\n*S KotlinDebug\n*F\n+ 1 ComposeXpathDataModelExtension.kt\ncom/intellij/performanceTesting/remoteDriver/compose/ComposeXpathDataModelExtension\n*L\n92#1:194,2\n122#1:196,2\n185#1:198,2\n*E\n"})
public final class ComposeXpathDataModelExtension
implements XpathDataModelExtension {
    private final boolean isRemDevExtension;

    @Override
    public boolean isRemDevExtension() {
        return this.isRemDevExtension;
    }

    @Override
    public void postProcessElement(@NotNull Document doc, @NotNull Component component, @NotNull Element element, @NotNull Element parentElement) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)parentElement, (String)"parentElement");
        if (!(component instanceof JewelComposePanelWrapper)) {
            return;
        }
        ComposePanel composePanel = ((JewelComposePanelWrapper)component).getComposePanel();
        ComposeXpathDataModelExtensionKt.access$getWrapperCache$p().clear();
        try {
            Collection semanticsOwners = composePanel.getSemanticsOwners();
            Iterable $this$forEach$iv = semanticsOwners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SemanticsOwner owner = (SemanticsOwner)element$iv;
                boolean bl = false;
                this.traverseComposeTree(doc, element, owner.getRootSemanticsNode(), composePanel);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private final void traverseComposeTree(Document doc, Element parentElement, SemanticsNode node, ComposePanel composePanel) {
        StringBuilder stringBuilder;
        Element composeElement = doc.createElement("div");
        composeElement.setAttribute("class", "ComposeNode");
        composeElement.setAttribute("javaclass", "androidx.compose.ui.semantics.SemanticsNode");
        ComposeSemanticsNodeWrapper wrapperComponent = new ComposeSemanticsNodeWrapper(node, composePanel);
        composeElement.setUserData("component", wrapperComponent, null);
        Ref ref = InvokerService.Companion.getInstance().putReference(wrapperComponent);
        ComposeXpathDataModelExtensionKt.access$getWrapperCache$p().add(wrapperComponent);
        composeElement.setAttribute("refId", ref.id());
        composeElement.setAttribute("hashCode", String.valueOf(ref.identityHashCode()));
        composeElement.setAttribute("asString", ref.asString());
        RdTarget rdTarget = InvokerService.Companion.getInstance().getRdTarget();
        composeElement.setAttribute("rdTarget", rdTarget.toString());
        Object object = (Role)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getRole());
        if (object == null || (object = Role.toString-impl((int)object.unbox-impl())) == null) {
            object = "ComposeNode";
        }
        Object role = object;
        StringBuilder $this$traverseComposeTree_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List list = (List)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getText());
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotatedString text = (AnnotatedString)element$iv;
                boolean bl2 = false;
                if (((CharSequence)$this$traverseComposeTree_u24lambda_u240).length() > 0) {
                    $this$traverseComposeTree_u24lambda_u240.append(" || ");
                }
                $this$traverseComposeTree_u24lambda_u240.append(text.getText());
            }
        }
        String textContent = stringBuilder.toString();
        StringBuilder textNodeContent = new StringBuilder((String)role + ". ");
        if (((CharSequence)textContent).length() > 0) {
            composeElement.setAttribute("text", textContent);
            composeElement.setAttribute("visible_text", textContent);
            textNodeContent.append("text: '" + textContent + "'. ");
        }
        AnnotatedString annotatedString = (AnnotatedString)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getEditableText());
        if (annotatedString != null) {
            AnnotatedString editableText = annotatedString;
            boolean bl3 = false;
            composeElement.setAttribute("editabletext", editableText.getText());
            if (((CharSequence)textContent).length() == 0) {
                textNodeContent.append("editabletext: '" + editableText.getText() + "'. ");
            }
        }
        composeElement.appendChild(doc.createTextNode(textNodeContent.toString()));
        List list2 = (List)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getContentDescription());
        if (list2 != null) {
            List descriptions = list2;
            boolean bl4 = false;
            String contentDesc = CollectionsKt.joinToString$default((Iterable)descriptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            composeElement.setAttribute("contentdescription", contentDesc);
        }
        Role role2 = (Role)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getRole());
        if (role2 != null) {
            int role3 = role2.unbox-impl();
            boolean bl5 = false;
            composeElement.setAttribute("role", Role.toString-impl((int)role3));
        }
        String string = (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getTestTag());
        if (string != null) {
            String testTag = string;
            boolean bl6 = false;
            composeElement.setAttribute("testtag", testTag);
        }
        ToggleableState toggleableState = (ToggleableState)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getToggleableState());
        if (toggleableState != null) {
            ToggleableState state = toggleableState;
            boolean bl7 = false;
            composeElement.setAttribute("toggleablestate", state.toString());
        }
        Boolean bl8 = (Boolean)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getSelected());
        if (bl8 != null) {
            boolean selected = bl8;
            boolean bl9 = false;
            composeElement.setAttribute("selected", String.valueOf(selected));
        }
        Boolean bl10 = (Boolean)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getFocused());
        if (bl10 != null) {
            boolean focused = bl10;
            boolean bl11 = false;
            composeElement.setAttribute("focused", String.valueOf(focused));
        }
        Unit unit = (Unit)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getDisabled());
        if (unit != null) {
            Unit it = unit;
            boolean bl12 = false;
            composeElement.setAttribute("disabled", "true");
        }
        Unit unit2 = (Unit)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getHeading());
        if (unit2 != null) {
            Unit it = unit2;
            boolean bl13 = false;
            composeElement.setAttribute("heading", "true");
        }
        ProgressBarRangeInfo progressBarRangeInfo = (ProgressBarRangeInfo)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)node.getConfig(), (SemanticsPropertyKey)SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        if (progressBarRangeInfo != null) {
            ProgressBarRangeInfo progressInfo = progressBarRangeInfo;
            boolean bl14 = false;
            composeElement.setAttribute("progresscurrent", String.valueOf(progressInfo.getCurrent()));
            composeElement.setAttribute("progressrange", progressInfo.getRange().getStart() + "-" + progressInfo.getRange().getEndInclusive());
        }
        parentElement.appendChild(composeElement);
        Iterable $this$forEach$iv = node.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode child = (SemanticsNode)element$iv;
            boolean bl15 = false;
            Intrinsics.checkNotNull((Object)composeElement);
            this.traverseComposeTree(doc, composeElement, child, composePanel);
        }
    }
}

