/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface StorageUpdate {
    public static final StorageUpdate NOOP = new StorageUpdate(){

        @Override
        public boolean update() {
            return true;
        }

        public String toString() {
            return "NO_OP";
        }
    };

    public boolean update();

    public static StorageUpdate combine(StorageUpdate ... updates) {
        if (updates == null) {
            StorageUpdate.$$$reportNull$$$0(0);
        }
        return new CombinedStorageUpdate(updates);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/util/indexing/StorageUpdate", "combine"));
    }

    @ApiStatus.Internal
    public static class CombinedStorageUpdate
    implements StorageUpdate {
        @NotNull
        private final @NotNull StorageUpdate @NotNull [] updates;

        public CombinedStorageUpdate(StorageUpdate ... updates) {
            if (updates == null) {
                CombinedStorageUpdate.$$$reportNull$$$0(0);
            }
            if (updates.length == 0) {
                throw new IllegalArgumentException("updates must not be empty");
            }
            this.updates = updates;
        }

        @Override
        public boolean update() {
            for (StorageUpdate update : this.updates) {
                boolean successful = update.update();
                if (successful) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "CombinedUpdate" + Arrays.toString(this.updates);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/util/indexing/StorageUpdate$CombinedStorageUpdate", "<init>"));
        }
    }
}

