/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IgnoreFile
extends PsiFileImpl {
    @NotNull
    private final Language language;
    @NotNull
    private final ParserDefinition parserDefinition;
    @NotNull
    private final IgnoreFileType fileType;

    public IgnoreFile(@NotNull FileViewProvider viewProvider, @NotNull IgnoreFileType fileType) {
        if (viewProvider == null) {
            IgnoreFile.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            IgnoreFile.$$$reportNull$$$0(1);
        }
        super(viewProvider);
        this.fileType = fileType;
        this.language = IgnoreFile.findLanguage(fileType.getLanguage(), viewProvider);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.language);
        if (parserDefinition == null) {
            throw new RuntimeException("IgnoreFile: language.getParserDefinition() returned null for: " + String.valueOf(this.language));
        }
        this.parserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        this.init((IElementType)nodeType, (IElementType)nodeType);
    }

    private static Language findLanguage(Language baseLanguage, FileViewProvider viewProvider) {
        Set languages = viewProvider.getLanguages();
        for (Language actualLanguage : languages) {
            if (!actualLanguage.isKindOf(baseLanguage) || !(actualLanguage instanceof IgnoreLanguage)) continue;
            return actualLanguage;
        }
        throw new AssertionError((Object)("Language " + String.valueOf(baseLanguage) + " doesn't participate in view provider " + String.valueOf(viewProvider) + ": " + String.valueOf(new ArrayList(languages))));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            IgnoreFile.$$$reportNull$$$0(2);
        }
        visitor.visitFile((PsiFile)this);
    }

    @NotNull
    public final Language getLanguage() {
        Language language = this.language;
        if (language == null) {
            IgnoreFile.$$$reportNull$$$0(3);
        }
        return language;
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        ParserDefinition parserDefinition = this.parserDefinition;
        if (parserDefinition == null) {
            IgnoreFile.$$$reportNull$$$0(4);
        }
        return parserDefinition;
    }

    @NotNull
    public FileType getFileType() {
        IgnoreFileType ignoreFileType = this.fileType;
        if (ignoreFileType == null) {
            IgnoreFile.$$$reportNull$$$0(5);
        }
        return ignoreFileType;
    }

    public String toString() {
        return this.fileType.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/psi/IgnoreFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/psi/IgnoreFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

