/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class L33tSubDict
implements Iterable<Map<Character, Character>> {
    private final List<Map<Character, Character>> l33tSubDictionaries;

    L33tSubDict(Map<Character, List<Character>> table) {
        this.l33tSubDictionaries = this.buildSubDictionaries(table);
    }

    private List<Map<Character, Character>> buildSubDictionaries(Map<Character, List<Character>> table) {
        LinkedHashSet<List<String>> initialSubs = new LinkedHashSet<List<String>>();
        initialSubs.add(new ArrayList());
        Set<List<String>> allCombinations = this.generateCombinationsRecursively(table, table.keySet().iterator(), initialSubs);
        ArrayList<Map<Character, Character>> subDictionaries = new ArrayList<Map<Character, Character>>();
        for (List<String> combination : allCombinations) {
            HashMap<Character, Character> subDictionary = new HashMap<Character, Character>();
            for (CharSequence charSequence : combination) {
                subDictionary.put(Character.valueOf(charSequence.charAt(0)), Character.valueOf(charSequence.charAt(1)));
            }
            subDictionaries.add(subDictionary);
        }
        return subDictionaries;
    }

    private Set<List<String>> generateCombinationsRecursively(Map<Character, List<Character>> table, Iterator<Character> keysIterator, Set<List<String>> subs) {
        if (!keysIterator.hasNext()) {
            return subs;
        }
        Character key = keysIterator.next();
        LinkedHashSet<List<String>> nextSubs = new LinkedHashSet<List<String>>();
        for (Character l33tChr : table.get(key)) {
            for (List<String> sub : subs) {
                boolean found = false;
                for (int i = 0; i < sub.size(); ++i) {
                    if (sub.get(i).charAt(0) != l33tChr.charValue()) continue;
                    ArrayList<String> subAlternative = new ArrayList<String>(sub);
                    subAlternative.remove(i);
                    subAlternative.add(String.valueOf(new char[]{l33tChr.charValue(), key.charValue()}));
                    nextSubs.add(sub);
                    nextSubs.add(subAlternative);
                    found = true;
                    break;
                }
                if (found) continue;
                ArrayList<String> subExtension = new ArrayList<String>(sub);
                subExtension.add(String.valueOf(new char[]{l33tChr.charValue(), key.charValue()}));
                nextSubs.add(subExtension);
            }
        }
        return this.generateCombinationsRecursively(table, keysIterator, nextSubs);
    }

    @Override
    public Iterator<Map<Character, Character>> iterator() {
        return this.l33tSubDictionaries.iterator();
    }
}

