/*
 * Decompiled with CFR 0.152.
 */
package org.passay.entropy;

import org.passay.entropy.Entropy;

public class ShannonEntropy
implements Entropy {
    public static final int FIRST_PHASE_LENGTH = 1;
    public static final int SECOND_PHASE_LENGTH = 8;
    public static final int THIRD_PHASE_LENGTH = 20;
    public static final double FIRST_PHASE_BONUS = 4.0;
    public static final double SECOND_PHASE_BONUS = 2.0;
    public static final double THIRD_PHASE_BONUS = 1.5;
    public static final int[] SHANNON_DICTIONARY_SIEVE = new int[]{0, 0, 0, 4, 5, 6, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0};
    public static final int[] SHANNON_COMPOSITION_SIEVE = new int[]{0, 0, 0, 2, 3, 3, 5, 6};
    private final boolean hasDictionaryCheck;
    private final boolean hasCompositionCheck;
    private final int passwordSize;

    public ShannonEntropy(boolean dictionaryCheck, boolean compositionCheck, int pwordSize) {
        this.hasDictionaryCheck = dictionaryCheck;
        this.hasCompositionCheck = compositionCheck;
        this.passwordSize = pwordSize;
    }

    @Override
    public double estimate() {
        double shannonEntropy = 0.0;
        if (this.passwordSize > 0) {
            shannonEntropy += 4.0;
            if (this.passwordSize > 8) {
                shannonEntropy += 14.0;
                shannonEntropy = this.passwordSize > 20 ? (shannonEntropy += 18.0 + (double)(this.passwordSize - 20)) : (shannonEntropy += (double)(this.passwordSize - 8) * 1.5);
            } else {
                shannonEntropy += (double)(this.passwordSize - 1) * 2.0;
            }
            if (this.hasCompositionCheck) {
                shannonEntropy += (double)SHANNON_COMPOSITION_SIEVE[this.passwordSize > SHANNON_COMPOSITION_SIEVE.length ? SHANNON_COMPOSITION_SIEVE.length - 1 : this.passwordSize - 1];
            }
            if (this.hasDictionaryCheck) {
                shannonEntropy += (double)SHANNON_DICTIONARY_SIEVE[this.passwordSize > SHANNON_DICTIONARY_SIEVE.length ? SHANNON_DICTIONARY_SIEVE.length - 1 : this.passwordSize - 1];
            }
        }
        return shannonEntropy;
    }
}

