/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.ContentStreamProvider;

@SdkInternalApi
final class CrtRequestInputStreamAdapter
implements HttpRequestBodyStream {
    private static final int READ_BUFFER_SIZE = 16384;
    private final ContentStreamProvider provider;
    private volatile InputStream providerStream;
    private final byte[] readBuffer = new byte[16384];

    CrtRequestInputStreamAdapter(ContentStreamProvider provider) {
        this.provider = provider;
    }

    public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
        int read;
        try {
            int toRead;
            if (this.providerStream == null) {
                this.createNewStream();
            }
            if ((read = this.providerStream.read(this.readBuffer, 0, toRead = Math.min(16384, bodyBytesOut.remaining()))) > 0) {
                bodyBytesOut.put(this.readBuffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return read < 0;
    }

    public boolean resetPosition() {
        try {
            this.createNewStream();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return true;
    }

    private void createNewStream() throws IOException {
        if (this.providerStream != null) {
            this.providerStream.close();
        }
        this.providerStream = this.provider.newStream();
    }
}

