/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.geospatial.ip2geo.common.ParameterValidator;

public class PutDatasourceRequest
extends ActionRequest {
    @Generated
    private static final Logger log = LogManager.getLogger(PutDatasourceRequest.class);
    public static final ParseField ENDPOINT_FIELD = new ParseField("endpoint", new String[0]);
    public static final ParseField UPDATE_INTERVAL_IN_DAYS_FIELD = new ParseField("update_interval_in_days", new String[0]);
    private static final ParameterValidator VALIDATOR = new ParameterValidator();
    private String name;
    private String endpoint;
    private TimeValue updateInterval;
    public static final ObjectParser<PutDatasourceRequest, Void> PARSER = new ObjectParser("put_datasource");

    public PutDatasourceRequest(String name) {
        this.name = name;
    }

    public PutDatasourceRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.endpoint = in.readString();
        this.updateInterval = in.readTimeValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeString(this.endpoint);
        out.writeTimeValue(this.updateInterval);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException errors = new ActionRequestValidationException();
        List<String> errorMsgs = VALIDATOR.validateDatasourceName(this.name);
        if (!errorMsgs.isEmpty()) {
            errorMsgs.stream().forEach(msg -> errors.addValidationError(msg));
        }
        this.validateEndpoint(errors);
        this.validateUpdateInterval(errors);
        return errors.validationErrors().isEmpty() ? null : errors;
    }

    private void validateEndpoint(ActionRequestValidationException errors) {
        try {
            URL url = URI.create(this.endpoint).toURL();
            url.toURI();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            log.info("Invalid URL[{}] is provided", (Object)this.endpoint, (Object)e);
            errors.addValidationError("Invalid URL format is provided");
        }
    }

    private void validateUpdateInterval(ActionRequestValidationException errors) {
        if (this.updateInterval.compareTo(TimeValue.timeValueDays((long)1L)) < 0) {
            errors.addValidationError("Update interval should be equal to or larger than 1 day");
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public TimeValue getUpdateInterval() {
        return this.updateInterval;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setUpdateInterval(TimeValue updateInterval) {
        this.updateInterval = updateInterval;
    }

    static {
        PARSER.declareString((request, val) -> request.setEndpoint((String)val), ENDPOINT_FIELD);
        PARSER.declareLong((request, val) -> request.setUpdateInterval(TimeValue.timeValueDays((long)val)), UPDATE_INTERVAL_IN_DAYS_FIELD);
    }
}

