/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.indices.pollingingest.IngestionErrorStrategy;
import org.opensearch.indices.pollingingest.StreamPoller;

@ExperimentalApi
public class IngestionSource {
    private final String type;
    private final PointerInitReset pointerInitReset;
    private final IngestionErrorStrategy.ErrorStrategy errorStrategy;
    private final Map<String, Object> params;
    private final long maxPollSize;
    private final int pollTimeout;
    private int numProcessorThreads;
    private int blockingQueueSize;
    private final boolean allActiveIngestion;

    private IngestionSource(String type, PointerInitReset pointerInitReset, IngestionErrorStrategy.ErrorStrategy errorStrategy, Map<String, Object> params, long maxPollSize, int pollTimeout, int numProcessorThreads, int blockingQueueSize, boolean allActiveIngestion) {
        this.type = type;
        this.pointerInitReset = pointerInitReset;
        this.params = params;
        this.errorStrategy = errorStrategy;
        this.maxPollSize = maxPollSize;
        this.pollTimeout = pollTimeout;
        this.numProcessorThreads = numProcessorThreads;
        this.blockingQueueSize = blockingQueueSize;
        this.allActiveIngestion = allActiveIngestion;
    }

    public String getType() {
        return this.type;
    }

    public PointerInitReset getPointerInitReset() {
        return this.pointerInitReset;
    }

    public IngestionErrorStrategy.ErrorStrategy getErrorStrategy() {
        return this.errorStrategy;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public long getMaxPollSize() {
        return this.maxPollSize;
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public int getNumProcessorThreads() {
        return this.numProcessorThreads;
    }

    public int getBlockingQueueSize() {
        return this.blockingQueueSize;
    }

    public boolean isAllActiveIngestionEnabled() {
        return this.allActiveIngestion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestionSource ingestionSource = (IngestionSource)o;
        return Objects.equals(this.type, ingestionSource.type) && Objects.equals(this.pointerInitReset, ingestionSource.pointerInitReset) && Objects.equals((Object)this.errorStrategy, (Object)ingestionSource.errorStrategy) && Objects.equals(this.params, ingestionSource.params) && Objects.equals(this.maxPollSize, ingestionSource.maxPollSize) && Objects.equals(this.pollTimeout, ingestionSource.pollTimeout) && Objects.equals(this.numProcessorThreads, ingestionSource.numProcessorThreads) && Objects.equals(this.blockingQueueSize, ingestionSource.blockingQueueSize) && Objects.equals(this.allActiveIngestion, ingestionSource.allActiveIngestion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.pointerInitReset, this.params, this.errorStrategy, this.maxPollSize, this.pollTimeout, this.numProcessorThreads, this.blockingQueueSize, this.allActiveIngestion});
    }

    public String toString() {
        return "IngestionSource{type='" + this.type + "',pointer_init_reset='" + String.valueOf(this.pointerInitReset) + "',error_strategy='" + String.valueOf((Object)this.errorStrategy) + "', params=" + String.valueOf(this.params) + ", maxPollSize=" + this.maxPollSize + ", pollTimeout=" + this.pollTimeout + ", numProcessorThreads=" + this.numProcessorThreads + ", blockingQueueSize=" + this.blockingQueueSize + ", allActiveIngestion=" + this.allActiveIngestion + "}";
    }

    @ExperimentalApi
    public static class PointerInitReset {
        private final StreamPoller.ResetState type;
        private final String value;

        public PointerInitReset(StreamPoller.ResetState type, String value) {
            this.type = type;
            this.value = value;
        }

        public StreamPoller.ResetState getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PointerInitReset pointerInitReset = (PointerInitReset)o;
            return Objects.equals((Object)this.type, (Object)pointerInitReset.type) && Objects.equals(this.value, pointerInitReset.value);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.value});
        }

        public String toString() {
            return "PointerInitReset{type='" + String.valueOf((Object)this.type) + "', value=" + this.value + "}";
        }
    }

    @ExperimentalApi
    public static class Builder {
        private String type;
        private PointerInitReset pointerInitReset;
        private IngestionErrorStrategy.ErrorStrategy errorStrategy;
        private Map<String, Object> params;
        private long maxPollSize = IndexMetadata.INGESTION_SOURCE_MAX_POLL_SIZE.getDefault(Settings.EMPTY);
        private int pollTimeout = IndexMetadata.INGESTION_SOURCE_POLL_TIMEOUT.getDefault(Settings.EMPTY);
        private int numProcessorThreads = IndexMetadata.INGESTION_SOURCE_NUM_PROCESSOR_THREADS_SETTING.getDefault(Settings.EMPTY);
        private int blockingQueueSize = IndexMetadata.INGESTION_SOURCE_INTERNAL_QUEUE_SIZE_SETTING.getDefault(Settings.EMPTY);
        private boolean allActiveIngestion = IndexMetadata.INGESTION_SOURCE_ALL_ACTIVE_INGESTION_SETTING.getDefault(Settings.EMPTY);

        public Builder(String type) {
            this.type = type;
            this.params = new HashMap<String, Object>();
        }

        public Builder(IngestionSource ingestionSource) {
            this.type = ingestionSource.type;
            this.pointerInitReset = ingestionSource.pointerInitReset;
            this.errorStrategy = ingestionSource.errorStrategy;
            this.params = ingestionSource.params;
            this.blockingQueueSize = ingestionSource.blockingQueueSize;
            this.allActiveIngestion = ingestionSource.allActiveIngestion;
        }

        public Builder setPointerInitReset(PointerInitReset pointerInitReset) {
            this.pointerInitReset = pointerInitReset;
            return this;
        }

        public Builder setErrorStrategy(IngestionErrorStrategy.ErrorStrategy errorStrategy) {
            this.errorStrategy = errorStrategy;
            return this;
        }

        public Builder setParams(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public Builder setMaxPollSize(long maxPollSize) {
            this.maxPollSize = maxPollSize;
            return this;
        }

        public Builder addParam(String key, Object value) {
            this.params.put(key, value);
            return this;
        }

        public Builder setPollTimeout(int pollTimeout) {
            this.pollTimeout = pollTimeout;
            return this;
        }

        public Builder setNumProcessorThreads(int numProcessorThreads) {
            this.numProcessorThreads = numProcessorThreads;
            return this;
        }

        public Builder setBlockingQueueSize(int blockingQueueSize) {
            this.blockingQueueSize = blockingQueueSize;
            return this;
        }

        public Builder setAllActiveIngestion(boolean allActiveIngestion) {
            this.allActiveIngestion = allActiveIngestion;
            return this;
        }

        public IngestionSource build() {
            return new IngestionSource(this.type, this.pointerInitReset, this.errorStrategy, this.params, this.maxPollSize, this.pollTimeout, this.numProcessorThreads, this.blockingQueueSize, this.allActiveIngestion);
        }
    }
}

