/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.rest.action.admin.cluster.ClusterAdminTask;

public class CatShardsRequest
extends ClusterManagerNodeReadRequest<CatShardsRequest> {
    private String[] indices;
    private TimeValue cancelAfterTimeInterval;
    private PageParams pageParams = null;
    private boolean requestLimitCheckSupported;

    public CatShardsRequest() {
    }

    public CatShardsRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_2_18_0)) {
            this.indices = in.readStringArray();
            this.cancelAfterTimeInterval = in.readOptionalTimeValue();
            if (in.readBoolean()) {
                this.pageParams = new PageParams(in);
            }
            this.requestLimitCheckSupported = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
            if (this.indices == null) {
                out.writeVInt(0);
            } else {
                out.writeStringArray(this.indices);
            }
            out.writeOptionalTimeValue(this.cancelAfterTimeInterval);
            out.writeBoolean(this.pageParams != null);
            if (this.pageParams != null) {
                this.pageParams.writeTo(out);
            }
            out.writeBoolean(this.requestLimitCheckSupported);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public void setIndices(String[] indices) {
        this.indices = indices;
    }

    public String[] getIndices() {
        return this.indices;
    }

    public void setCancelAfterTimeInterval(TimeValue timeout) {
        this.cancelAfterTimeInterval = timeout;
    }

    public TimeValue getCancelAfterTimeInterval() {
        return this.cancelAfterTimeInterval;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setRequestLimitCheckSupported(boolean requestLimitCheckSupported) {
        this.requestLimitCheckSupported = requestLimitCheckSupported;
    }

    public boolean isRequestLimitCheckSupported() {
        return this.requestLimitCheckSupported;
    }

    @Override
    public ClusterAdminTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new ClusterAdminTask(id, type, action, parentTaskId, headers, this.cancelAfterTimeInterval);
    }
}

