/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamReduce<K, V>
implements KStreamAggProcessorSupplier<K, V, K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamReduce.class);
    private final String storeName;
    private final StoreFactory storeFactory;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    KStreamReduce(StoreFactory storeFactory, Reducer<V> reducer) {
        this.storeFactory = storeFactory;
        this.storeName = storeFactory.storeName();
        this.reducer = reducer;
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return Collections.singleton(new StoreFactory.FactoryWrappingStoreBuilder(this.storeFactory));
    }

    @Override
    public Processor<K, V, K, Change<V>> get() {
        return new KStreamReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableValueGetterSupplier<K, V>(){

            @Override
            public KTableValueGetter<K, V> get() {
                return new KStreamReduceValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamReduce.this.storeName};
            }
        };
    }

    private class KStreamReduceProcessor
    extends ContextualProcessor<K, V, K, Change<V>> {
        private KeyValueStoreWrapper<K, V> store;
        private TimestampedTupleForwarder<K, V> tupleForwarder;
        private Sensor droppedRecordsSensor;

        private KStreamReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext<K, Change<V>> context) {
            super.init(context);
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), (StreamsMetricsImpl)context.metrics());
            this.store = new KeyValueStoreWrapper(context, KStreamReduce.this.storeName);
            this.tupleForwarder = new TimestampedTupleForwarder(this.store.store(), context, new TimestampedCacheFlushListener(context), KStreamReduce.this.sendOldValues);
        }

        @Override
        public void process(Record<K, V> record) {
            long newTimestamp;
            Object newAgg;
            if (record.key() == null || record.value() == null) {
                if (this.context().recordMetadata().isPresent()) {
                    RecordMetadata recordMetadata = this.context().recordMetadata().get();
                    LOG.warn("Skipping record due to null key or value. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
                } else {
                    LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
                }
                this.droppedRecordsSensor.record();
                return;
            }
            ValueAndTimestamp oldAggAndTimestamp = this.store.get(record.key());
            Object oldAgg = ValueAndTimestamp.getValueOrNull(oldAggAndTimestamp);
            if (oldAgg == null) {
                newAgg = record.value();
                newTimestamp = record.timestamp();
            } else {
                newAgg = KStreamReduce.this.reducer.apply(oldAgg, record.value());
                newTimestamp = Math.max(record.timestamp(), oldAggAndTimestamp.timestamp());
            }
            long putReturnCode = this.store.put(record.key(), newAgg, newTimestamp);
            if (putReturnCode != Long.MIN_VALUE) {
                this.tupleForwarder.maybeForward(record.withValue(new Change(newAgg, KStreamReduce.this.sendOldValues ? oldAgg : null, putReturnCode == -1L)).withTimestamp(newTimestamp));
            }
        }
    }

    private class KStreamReduceValueGetter
    implements KTableValueGetter<K, V> {
        private KeyValueStoreWrapper<K, V> store;

        private KStreamReduceValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.store = new KeyValueStoreWrapper(context, KStreamReduce.this.storeName);
        }

        @Override
        public ValueAndTimestamp<V> get(K key) {
            return this.store.get(key);
        }

        @Override
        public ValueAndTimestamp<V> get(K key, long asOfTimestamp) {
            return this.store.get(key, asOfTimestamp);
        }

        @Override
        public boolean isVersioned() {
            return this.store.isVersionedStore();
        }
    }
}

