/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.ant;

import java.io.File;
import org.apache.tools.ant.Target;
import org.gradle.api.internal.ConfigurationCacheDegradation;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Gradle would require more information to cache this task")
public abstract class AntTarget
extends ConventionTask {
    private Target target;
    private File baseDir;

    public AntTarget() {
        ConfigurationCacheDegradation.requireDegradation(this, "Task is not compatible with the Configuration Cache");
    }

    @TaskAction
    protected void executeAntTarget() {
        File oldBaseDir = this.target.getProject().getBaseDir();
        this.target.getProject().setBaseDir(this.baseDir);
        try {
            this.target.performTasks();
        }
        finally {
            this.target.getProject().setBaseDir(oldBaseDir);
        }
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    @Internal
    @ToBeReplacedByLazyProperty
    public @Nullable String getDescription() {
        return this.target == null ? null : this.target.getDescription();
    }

    @Override
    public void setDescription(@Nullable String description) {
        if (this.target != null) {
            this.target.setDescription(description);
        }
    }
}

