/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBHandle;
import db.DBRecord;
import db.StringField;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointLocation;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.DBTraceObjectValueBehind;
import ghidra.trace.database.target.DBTraceObjectValueData;
import ghidra.trace.database.target.DBTraceObjectValueNode;
import ghidra.trace.database.target.DBTraceObjectValueRStarTree;
import ghidra.trace.database.target.DBTraceObjectValueWriteBehindCache;
import ghidra.trace.database.target.ImmutableValueShape;
import ghidra.trace.database.target.TraceObjectValueQuery;
import ghidra.trace.database.target.TraceObjectValueStorage;
import ghidra.trace.database.target.ValueSpace;
import ghidra.trace.database.target.visitors.SuccessorsRelativeVisitor;
import ghidra.trace.database.thread.DBTraceObjectThread;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.DuplicateKeyException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.trace.model.target.schema.BadSchemaException;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.target.schema.XmlSchemaContext;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.StreamUtils;
import ghidra.util.UnionAddressSetView;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.JDOMException;

public class DBTraceObjectManager
implements TraceObjectManager,
DBTraceManager {
    private static final int OBJECTS_CONTAINING_CACHE_SIZE = 100;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceObjectSchemaEntry> schemaStore;
    protected final DBCachedObjectStore<DBTraceObject> objectStore;
    protected final DBTraceObjectValueRStarTree valueTree;
    protected final DBTraceObjectValueRStarTree.DBTraceObjectValueMap valueMap;
    protected final DBTraceObjectValueWriteBehindCache valueWbCache;
    protected final DBCachedObjectIndex<KeyPath, DBTraceObject> objectsByPath;
    protected final Collection<TraceObject> objectsView;
    protected TraceObjectSchema rootSchema;
    protected final Map<ObjectsContainingKey, Collection<?>> objectsContainingCache = new LinkedHashMap<ObjectsContainingKey, Collection<?>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ObjectsContainingKey, Collection<?>> eldest) {
            return this.size() > 100;
        }
    };
    protected final Map<Class<? extends TraceObjectInterface>, Set<TraceObjectSchema>> schemasByInterface = new HashMap<Class<? extends TraceObjectInterface>, Set<TraceObjectSchema>>();

    public DBTraceObjectManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace) throws IOException, VersionException {
        this.lock = lock;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.schemaStore = factory.getOrCreateCachedStore("ObjectSchema", DBTraceObjectSchemaEntry.class, DBTraceObjectSchemaEntry::new, true);
        this.loadRootSchema();
        this.objectStore = factory.getOrCreateCachedStore("Objects", DBTraceObject.class, (s, r) -> new DBTraceObject(this, s, r), true);
        this.valueTree = new DBTraceObjectValueRStarTree(this, factory, "ObjectValue", ValueSpace.INSTANCE, DBTraceObjectValueData.class, DBTraceObjectValueNode.class, false, 50);
        this.valueMap = this.valueTree.asSpatialMap();
        this.objectsByPath = this.objectStore.getIndex(KeyPath.class, DBTraceObject.PATH_COLUMN);
        this.valueWbCache = new DBTraceObjectValueWriteBehindCache(this);
        this.objectsView = Collections.unmodifiableCollection(this.objectStore.asMap().values());
    }

    protected void loadRootSchema() {
        if (this.schemaStore.asMap().isEmpty()) {
            this.rootSchema = null;
            return;
        }
        assert (this.schemaStore.asMap().size() == 1);
        DBTraceObjectSchemaEntry schemaEntry = (DBTraceObjectSchemaEntry)this.schemaStore.getObjectAt(0L);
        this.rootSchema = schemaEntry.schema;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.objectStore.invalidateCache();
        this.valueTree.invalidateCache();
        this.schemaStore.invalidateCache();
        this.loadRootSchema();
        this.objectsContainingCache.clear();
        this.schemasByInterface.clear();
    }

    protected boolean checkMyObject(DBTraceObject object) {
        if (object.manager != this) {
            return false;
        }
        return this.objectStore.asMap().values().contains((Object)object);
    }

    protected DBTraceObject assertIsMine(TraceObject object) {
        if (!(object instanceof DBTraceObject)) {
            throw new IllegalArgumentException("Object " + String.valueOf(object) + " is not part of this trace");
        }
        DBTraceObject dbObject = (DBTraceObject)object;
        if (!this.checkMyObject(dbObject)) {
            throw new IllegalArgumentException("Object " + String.valueOf(object) + " is not part of this trace");
        }
        return dbObject;
    }

    protected Object validatePrimitive(Object value) {
        try {
            DBCachedObjectStoreFactory.PrimitiveCodec.getCodec(value.getClass());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot encode " + String.valueOf(value), e);
        }
        return value;
    }

    protected Object validateValue(Object value) {
        if (value instanceof TraceObject | value instanceof Address | value instanceof AddressRange) {
            return value;
        }
        return this.validatePrimitive(value);
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    protected void setSchema(TraceObjectSchema schema) {
        if (this.rootSchema != null) {
            throw new IllegalStateException("There is already a root object");
        }
        DBTraceObjectSchemaEntry schemaEntry = (DBTraceObjectSchemaEntry)this.schemaStore.create(0L);
        schemaEntry.set(schema);
        this.rootSchema = schema;
    }

    protected void emitValueCreated(DBTraceObject parent, DBTraceObjectValue entry) {
        if (parent == null) {
            return;
        }
        parent.emitEvents(new TraceChangeRecord<DBTraceObjectValue, Void>(TraceEvents.VALUE_CREATED, null, entry));
    }

    protected DBTraceObjectValueData doCreateValueData(Lifespan lifespan, DBTraceObject parent, String key, Object value) {
        DBTraceObjectValueData entry = (DBTraceObjectValueData)this.valueMap.put(new ImmutableValueShape(parent, value, key, lifespan), null);
        if (!(value instanceof DBTraceObject)) {
            entry.doSetPrimitive(value);
        }
        return entry;
    }

    protected DBTraceObjectValue doCreateValue(Lifespan lifespan, DBTraceObject parent, String key, Object value) {
        DBTraceObjectValue entry;
        DBTraceObjectValue dBTraceObjectValue = entry = parent == null ? this.doCreateValueData(lifespan, parent, key, value).getWrapper() : this.valueWbCache.doCreateValue(lifespan, parent, key, value).getWrapper();
        if (parent != null) {
            parent.notifyValueCreated(entry);
        }
        if (value instanceof DBTraceObject) {
            DBTraceObject child = (DBTraceObject)value;
            child.notifyParentValueCreated(entry);
        }
        this.invalidateObjectsContainingCache();
        this.emitValueCreated(parent, entry);
        return entry;
    }

    protected DBTraceObject doCreateObject(KeyPath path) {
        DBTraceObject obj = (DBTraceObject)this.objectsByPath.getOne((Object)path);
        if (obj != null) {
            return obj;
        }
        obj = (DBTraceObject)this.objectStore.create();
        obj.set(path);
        obj.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(TraceEvents.OBJECT_CREATED, null, obj));
        return obj;
    }

    protected DBTraceObject doGetObject(KeyPath path) {
        return (DBTraceObject)this.objectsByPath.getOne((Object)path);
    }

    @Override
    public DBTraceObject createObject(KeyPath path) {
        if (path.isRoot()) {
            throw new IllegalArgumentException("Cannot create non-root object with root path");
        }
        try (LockHold hold = this.trace.lockWrite();){
            if (this.rootSchema == null) {
                throw new IllegalStateException("No schema! Create the root object, first.");
            }
            DBTraceObject dBTraceObject = this.doCreateObject(path);
            return dBTraceObject;
        }
    }

    @Override
    public DBTraceObjectValue createRootObject(TraceObjectSchema schema) {
        try (LockHold hold = this.trace.lockWrite();){
            DBTraceObjectValueData data;
            TraceObjectValueStorage traceObjectValueStorage;
            this.setSchema(schema);
            DBTraceObject root = this.doCreateObject(KeyPath.of(new String[0]));
            assert (root.getKey() == 0L);
            DBTraceObjectValue val = this.doCreateValue(Lifespan.ALL, null, "", root);
            assert ((traceObjectValueStorage = val.getWrapped()) instanceof DBTraceObjectValueData && (data = (DBTraceObjectValueData)traceObjectValueStorage).getKey() == 0L);
            DBTraceObjectValue dBTraceObjectValue = val;
            return dBTraceObjectValue;
        }
    }

    @Override
    public TraceObjectSchema getRootSchema() {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectSchema traceObjectSchema = this.rootSchema;
            return traceObjectSchema;
        }
    }

    public DBTraceObjectValue getRootValue() {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObjectValueData data = (DBTraceObjectValueData)this.valueTree.getDataStore().getObjectAt(0L);
            DBTraceObjectValue dBTraceObjectValue = data == null ? null : data.getWrapper();
            return dBTraceObjectValue;
        }
    }

    @Override
    public DBTraceObject getRootObject() {
        return this.getObjectById(0L);
    }

    @Override
    public DBTraceObject getObjectById(long key) {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObject dBTraceObject = (DBTraceObject)this.objectStore.getObjectAt(key);
            return dBTraceObject;
        }
    }

    @Override
    public DBTraceObject getObjectByCanonicalPath(KeyPath path) {
        return (DBTraceObject)this.objectsByPath.getOne((Object)path);
    }

    public Stream<? extends DBTraceObject> getObjectsByPath(Lifespan span, KeyPath path) {
        DBTraceObject root = this.getRootObject();
        return this.getValuePaths(span, new PathPattern(path)).map(p -> p.getDestinationValue(root)).filter(DBTraceObject.class::isInstance).map(DBTraceObject.class::cast);
    }

    @Override
    public Stream<? extends TraceObjectValPath> getValuePaths(Lifespan span, PathFilter filter) {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObjectValue rootVal = this.getRootValue();
            if (rootVal == null) {
                Stream<TraceObjectValPath> stream = Stream.of(new TraceObjectValPath[0]);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = rootVal.doStreamVisitor(span, new SuccessorsRelativeVisitor(filter));
            return stream;
        }
    }

    public Stream<DBTraceObject> getAllObjects() {
        return this.objectStore.asMap().values().stream();
    }

    @Override
    public int getObjectCount() {
        return this.objectStore.getRecordCount();
    }

    public Stream<DBTraceObjectValue> getAllValues() {
        return Stream.concat(this.valueMap.values().stream().map(v -> v.getWrapper()), StreamUtils.lock((Lock)this.lock.readLock(), this.valueWbCache.streamAllValues().map(v -> v.getWrapper())));
    }

    protected Stream<DBTraceObjectValueData> streamValuesIntersectingData(Lifespan span, AddressRange range, String entryKey) {
        return this.valueMap.reduce(TraceObjectValueQuery.intersecting(entryKey != null ? entryKey : ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), entryKey != null ? entryKey : ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), span, range)).values().stream();
    }

    protected Stream<DBTraceObjectValueBehind> streamValuesIntersectingBehind(Lifespan span, AddressRange range, String entryKey) {
        return this.valueWbCache.streamValuesIntersecting(span, range, entryKey);
    }

    @Override
    public Collection<? extends TraceObjectValue> getValuesIntersecting(Lifespan span, AddressRange range, String entryKey) {
        return Stream.concat(this.streamValuesIntersectingData(span, range, entryKey).map(v -> v.getWrapper()), this.streamValuesIntersectingBehind(span, range, entryKey).map(v -> v.getWrapper())).toList();
    }

    protected Stream<DBTraceObjectValueData> streamValuesAtData(long snap, Address address, String entryKey) {
        return this.valueMap.reduce(TraceObjectValueQuery.at(entryKey, snap, address)).values().stream();
    }

    protected Stream<DBTraceObjectValueBehind> streamValuesAtBehind(long snap, Address address, String entryKey) {
        return this.valueWbCache.streamValuesAt(snap, address, entryKey);
    }

    public Collection<? extends TraceObjectValue> getValuesAt(long snap, Address address, String entryKey) {
        return Stream.concat(this.streamValuesAtData(snap, address, entryKey).map(v -> v.getWrapper()), this.streamValuesAtBehind(snap, address, entryKey).map(v -> v.getWrapper())).toList();
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryAllInterface(Lifespan span, Class<I> iface) {
        if (this.rootSchema == null) {
            throw new IllegalStateException("There is no schema. Create a root object.");
        }
        PathFilter filter = this.rootSchema.searchFor(iface, true);
        return this.getValuePaths(span, filter).filter(p -> {
            TraceObject object = p.getDestination(this.getRootObject());
            if (object == null) {
                Msg.error((Object)this, (Object)("NULL VALUE! " + String.valueOf(p.getLastEntry())));
                return false;
            }
            return true;
        }).map(p -> p.getDestination(this.getRootObject()).queryInterface(iface));
    }

    @Override
    public void cullDisconnectedObjects() {
        try (LockHold hold = this.trace.lockWrite();){
            for (DBTraceObject obj : this.objectStore.asMap().values()) {
                if (obj.doIsConnected()) continue;
                obj.delete();
            }
        }
    }

    @Override
    public void clear() {
        try (LockHold hold = this.trace.lockWrite();){
            this.valueMap.clear();
            this.valueWbCache.clear();
            this.objectStore.deleteAll();
            this.schemaStore.deleteAll();
            this.rootSchema = null;
            this.objectsContainingCache.clear();
            this.schemasByInterface.clear();
        }
    }

    protected void doDeleteObject(DBTraceObject object) {
        this.objectStore.delete((DBAnnotatedObject)object);
        object.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(TraceEvents.OBJECT_DELETED, null, object));
    }

    protected void doDeleteValue(DBTraceObjectValueData value) {
        this.valueTree.doDeleteEntry(value);
        this.invalidateObjectsContainingCache();
    }

    protected void doDeleteCachedValue(DBTraceObjectValueBehind value) {
        this.valueWbCache.remove(value);
        this.invalidateObjectsContainingCache();
    }

    public boolean hasSchema() {
        return this.rootSchema != null;
    }

    protected <I extends TraceObjectInterface> I doAddWithInterface(KeyPath path, Class<I> iface) {
        TraceObjectSchema schema = this.rootSchema.getSuccessorSchema(path);
        if (!schema.getInterfaces().contains(iface)) {
            throw new BadSchemaException("Schema " + String.valueOf(schema) + " at '" + String.valueOf(path) + "' does not provide interface " + iface.getSimpleName());
        }
        DBTraceObject obj = this.createObject(path);
        return obj.queryInterface(iface);
    }

    protected <I extends TraceObjectInterface> I doAddWithInterface(String path, Class<I> iface) {
        return this.doAddWithInterface(KeyPath.parse(path), iface);
    }

    public <I extends TraceObjectInterface> Collection<I> getAllObjects(Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.queryAllInterface(Lifespan.ALL, iface).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsByPath(String path, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.getObjectsByPath(Lifespan.ALL, KeyPath.parse(path)).map(o -> o.queryInterface(iface)).filter(i -> i != null).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> I getObjectByPath(long snap, String path, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            KeyPath parsed = KeyPath.parse(path);
            DBTraceObject object = this.getObjectByCanonicalPath(parsed);
            if (object != null) {
                I i = object.queryInterface(iface);
                return i;
            }
            TraceObjectInterface traceObjectInterface = this.getObjectsByPath(Lifespan.at(snap), parsed).findAny().map(o -> o.queryInterface(iface)).orElse(null);
            return (I)traceObjectInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateObjectsContainingCache() {
        Map<ObjectsContainingKey, Collection<?>> map = this.objectsContainingCache;
        synchronized (map) {
            this.objectsContainingCache.clear();
        }
    }

    protected Collection<? extends TraceObjectInterface> doGetObjectsContaining(ObjectsContainingKey key) {
        return this.getObjectsIntersecting(Lifespan.at(key.snap), (AddressRange)new AddressRangeImpl(key.address, key.address), key.key, key.iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I extends TraceObjectInterface> Collection<I> getObjectsContaining(long snap, Address address, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Map<ObjectsContainingKey, Collection<?>> map = this.objectsContainingCache;
            synchronized (map) {
                Collection collection = this.objectsContainingCache.computeIfAbsent(new ObjectsContainingKey(snap, address, key, iface), this::doGetObjectsContaining);
                return collection;
            }
        }
    }

    public <I extends TraceObjectInterface> I getObjectContaining(long snap, Address address, String key, Class<I> iface) {
        Collection<I> col = this.getObjectsContaining(snap, address, key, iface);
        if (col.isEmpty()) {
            return null;
        }
        return (I)((TraceObjectInterface)col.iterator().next());
    }

    protected Set<TraceObjectSchema> collectSchemasForInterface(Class<? extends TraceObjectInterface> iface) {
        if (this.rootSchema == null) {
            return Set.of();
        }
        HashSet<TraceObjectSchema> result = new HashSet<TraceObjectSchema>();
        for (TraceObjectSchema schema : this.rootSchema.getContext().getAllSchemas()) {
            if (!schema.getInterfaces().contains(iface)) continue;
            result.add(schema);
        }
        return Set.copyOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I extends TraceObjectInterface> Collection<I> getObjectsIntersecting(Lifespan lifespan, AddressRange range, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Set schemas;
            Map<Class<? extends TraceObjectInterface>, Set<TraceObjectSchema>> map = this.schemasByInterface;
            synchronized (map) {
                schemas = this.schemasByInterface.computeIfAbsent(iface, this::collectSchemasForInterface);
            }
            Map<String, List<TraceObjectSchema>> schemasByAliasTo = schemas.stream().collect(Collectors.groupingBy(s -> s.checkAliasedAttribute(key)));
            Collection collection = schemasByAliasTo.entrySet().stream().flatMap(ent -> this.getValuesIntersecting(lifespan, range, (String)ent.getKey()).stream().map(v -> v.getParent()).filter(o -> ((List)ent.getValue()).contains(o.getSchema()))).map(o -> o.queryInterface(iface)).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsAtSnap(long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.queryAllInterface(Lifespan.at(snap), iface).collect(Collectors.toSet());
            return collection;
        }
    }

    static <I extends TraceObjectInterface> boolean acceptValue(DBTraceObjectValue value, String key, Class<I> ifaceCls, Predicate<? super I> predicate) {
        if (!value.hasEntryKey(key)) {
            return false;
        }
        DBTraceObject parent = value.getParent();
        I iface = parent.queryInterface(ifaceCls);
        if (iface == null) {
            return false;
        }
        return predicate.test(iface);
    }

    public <I extends TraceObjectInterface> AddressSetView getObjectsAddressSet(long snap, String key, Class<I> ifaceCls, Predicate<? super I> predicate) {
        return new UnionAddressSetView(new AddressSetView[]{this.valueMap.getAddressSetView(Lifespan.at(snap), v -> DBTraceObjectManager.acceptValue(v.getWrapper(), key, ifaceCls, predicate)), this.valueWbCache.getObjectsAddressSet(snap, key, ifaceCls, predicate)});
    }

    public <I extends TraceObjectInterface> I getSuccessor(TraceObject seed, PathFilter filter, long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = seed.getSuccessors(Lifespan.at(snap), filter).map(p -> p.getDestination(seed).queryInterface(iface)).filter(i -> i != null).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public <I extends TraceObjectInterface> I getLatestSuccessor(TraceObject seed, KeyPath path, long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = seed.getOrderedSuccessors(Lifespan.toNow(snap), path, false).map(p -> p.getDestination(seed).queryInterface(iface)).filter(i -> i != null).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public TraceObjectBreakpointLocation addBreakpoint(String path, Lifespan lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        DBTraceObjectBreakpointLocation dBTraceObjectBreakpointLocation;
        block9: {
            KeyPath specPath = this.getRootSchema().searchForAncestor(TraceObjectBreakpointSpec.class, KeyPath.parse(path));
            if (specPath == null) {
                throw new IllegalStateException("The schema does not provide an implicit breakpoint specification on the given path.");
            }
            LockHold hold = this.trace.lockWrite();
            try {
                DBTraceObjectBreakpointLocation loc = (DBTraceObjectBreakpointLocation)this.doAddWithInterface(path, TraceObjectBreakpointLocation.class);
                loc.setName(lifespan, path);
                loc.setRange(lifespan, range);
                loc.setEnabled(lifespan, enabled);
                loc.setComment(lifespan, comment);
                TraceObjectBreakpointSpec spec = loc.getOrCreateSpecification();
                spec.setKinds(lifespan, kinds);
                loc.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                dBTraceObjectBreakpointLocation = loc;
                if (hold == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return dBTraceObjectBreakpointLocation;
    }

    public TraceObjectMemoryRegion addMemoryRegion(String path, Lifespan lifespan, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectMemoryRegion region = this.doAddWithInterface(path, TraceObjectMemoryRegion.class);
            region.setName(lifespan, path);
            region.setRange(lifespan, range);
            region.setFlags(lifespan, flags);
            region.getObject().insert(lifespan, TraceObject.ConflictResolution.TRUNCATE);
            TraceObjectMemoryRegion traceObjectMemoryRegion = region;
            return traceObjectMemoryRegion;
        }
    }

    public TraceObjectModule addModule(String path, String name, Lifespan lifespan, AddressRange range) throws DuplicateNameException {
        TraceObjectModule traceObjectModule;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectModule module = this.doAddWithInterface(path, TraceObjectModule.class);
                module.setName(lifespan, name);
                module.setRange(lifespan, range);
                module.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectModule = module;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectModule;
    }

    public TraceObjectSection addSection(String path, String name, Lifespan lifespan, AddressRange range) throws DuplicateNameException {
        TraceObjectSection traceObjectSection;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectSection section = this.doAddWithInterface(path, TraceObjectSection.class);
                section.setName(lifespan, name);
                section.setRange(lifespan, range);
                section.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectSection = section;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectSection;
    }

    public TraceObjectStack addStack(KeyPath path, long snap) {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectStack stack = this.doAddWithInterface(path, TraceObjectStack.class);
            stack.getObject().insert(Lifespan.at(snap), TraceObject.ConflictResolution.DENY);
            TraceObjectStack traceObjectStack = stack;
            return traceObjectStack;
        }
    }

    public TraceObjectStackFrame addStackFrame(KeyPath path, long snap) {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectStackFrame frame = this.doAddWithInterface(path, TraceObjectStackFrame.class);
            frame.getObject().insert(Lifespan.at(snap), TraceObject.ConflictResolution.DENY);
            TraceObjectStackFrame traceObjectStackFrame = frame;
            return traceObjectStackFrame;
        }
    }

    protected void checkDuplicateThread(String path, Lifespan lifespan) throws DuplicateNameException {
        DBTraceObject exists = this.getObjectByCanonicalPath(KeyPath.parse(path));
        if (exists == null) {
            return;
        }
        if (!exists.getLife().intersects(lifespan)) {
            return;
        }
        throw new DuplicateNameException("A thread having path '" + path + "' already exists within an overlapping snap");
    }

    public TraceObjectThread addThread(String path, String display, Lifespan lifespan) throws DuplicateNameException {
        TraceObjectThread traceObjectThread;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                this.checkDuplicateThread(path, lifespan);
                TraceObjectThread thread = this.doAddWithInterface(path, TraceObjectThread.class);
                thread.setName(lifespan.withMax(Lifespan.DOMAIN.lmax()), display);
                thread.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectThread = thread;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectThread;
    }

    public TraceThread assertMyThread(TraceThread thread) {
        if (!(thread instanceof DBTraceObjectThread)) {
            throw new AssertionError((Object)("Thread " + String.valueOf(thread) + " is not an object in this trace"));
        }
        DBTraceObjectThread dbThread = (DBTraceObjectThread)thread;
        if (!this.checkMyObject(dbThread.getObject())) {
            throw new AssertionError((Object)("Thread " + String.valueOf(thread) + " is not an object in this trace"));
        }
        return dbThread;
    }

    public void flushWbCaches() {
        this.valueWbCache.flush();
    }

    public void waitWbWorkers() {
        this.valueWbCache.waitWorkers();
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static final class DBTraceObjectSchemaEntry
    extends DBAnnotatedObject {
        public static final String TABLE_NAME = "ObjectSchema";
        static final String CONTEXT_COLUMN_NAME = "Context";
        static final String SCHEMA_COLUMN_NAME = "Schema";
        @DBAnnotatedColumn(value="Context")
        static DBObjectColumn CONTEXT_COLUMN;
        @DBAnnotatedColumn(value="Schema")
        static DBObjectColumn SCHEMA_COLUMN;
        @DBAnnotatedField(column="Context", codec=DBTraceObjectSchemaDBFieldCodec.class)
        private SchemaContext context;
        @DBAnnotatedField(column="Schema")
        private String schemaName;
        private TraceObjectSchema schema;

        public DBTraceObjectSchemaEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        protected void fresh(boolean created) throws IOException {
            if (created) {
                return;
            }
            this.schema = this.context.getSchema(new TraceObjectSchema.SchemaName(this.schemaName));
        }

        protected void set(TraceObjectSchema schema) {
            this.context = schema.getContext();
            this.schemaName = schema.getName().toString();
            this.update(CONTEXT_COLUMN, SCHEMA_COLUMN);
        }
    }

    record ObjectsContainingKey(long snap, Address address, String key, Class<? extends TraceObjectInterface> iface) {
    }

    public static class DBTraceObjectSchemaDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<SchemaContext, DBTraceObjectSchemaEntry, StringField> {
        public DBTraceObjectSchemaDBFieldCodec(Class<DBTraceObjectSchemaEntry> objectType, Field field, int column) {
            super(SchemaContext.class, objectType, StringField.class, field, column);
        }

        protected String encode(SchemaContext value) {
            return value == null ? null : XmlSchemaContext.serialize(value);
        }

        protected SchemaContext decode(String xml) {
            try {
                return xml == null ? null : XmlSchemaContext.deserialize(xml);
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("Invalid XML-encoded schema context");
            }
        }

        public void store(SchemaContext value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(DBTraceObjectSchemaEntry obj, DBRecord record) throws IllegalAccessException {
            record.setString(this.column, this.encode((SchemaContext)this.getValue(obj)));
        }

        protected void doLoad(DBTraceObjectSchemaEntry obj, DBRecord record) throws IllegalAccessException {
            this.setValue(obj, this.decode(record.getString(this.column)));
        }
    }
}

