/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.module.DBTraceModule;
import ghidra.trace.database.module.DBTraceModuleSpace;
import ghidra.trace.database.module.DBTraceSection;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceModuleManager
extends AbstractDBTraceSpaceBasedManager<DBTraceModuleSpace>
implements TraceModuleManager,
DBTraceDelegatingManager<DBTraceModuleSpace> {
    public static final String NAME = "Module";

    public DBTraceModuleManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, null);
        this.loadSpaces();
    }

    @Override
    public DBTraceModuleSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceModuleSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    protected DBTraceModuleSpace getForRegisterSpace(TraceThread thread, int frameLevel, boolean createIfAbsent) {
        throw new UnsupportedOperationException();
    }

    protected void checkModulePathConflicts(TraceModule ignore, String modulePath, Lifespan moduleLifespan) throws DuplicateNameException {
        for (TraceModule traceModule : this.doGetModulesByPath(modulePath)) {
            if (traceModule == ignore || !traceModule.isAlive(moduleLifespan)) continue;
            throw new DuplicateNameException("Module with path '" + modulePath + "' already exists within an overlapping snap");
        }
    }

    protected void checkSectionPathConflicts(DBTraceSection ignore, String sectionPath, Lifespan moduleLifespan) throws DuplicateNameException {
        Collection<? extends TraceSection> pathConflicts = this.doGetSectionsByPath(sectionPath);
        for (TraceSection traceSection : pathConflicts) {
            if (traceSection == ignore || !traceSection.getModule().isAlive(moduleLifespan)) continue;
            throw new DuplicateNameException("Section with path '" + sectionPath + "' already exists within an overlapping snap");
        }
    }

    @Override
    public TraceModule addModule(String modulePath, String moduleName, AddressRange range, Lifespan lifespan) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            TraceModule traceModule = this.doAddModule(modulePath, moduleName, range, lifespan);
            return traceModule;
        }
    }

    protected TraceModule doAddModule(String modulePath, String moduleName, AddressRange range, Lifespan lifespan) throws DuplicateNameException {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().addModule(modulePath, moduleName, lifespan, range);
        }
        this.checkModulePathConflicts(null, modulePath, lifespan);
        return (TraceModule)this.delegateWrite(range.getAddressSpace(), m -> m.doAddModule(modulePath, moduleName, range, lifespan));
    }

    protected Collection<? extends TraceModule> doGetModulesByPath(String modulePath) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsByPath(modulePath, TraceObjectModule.class);
        }
        return this.delegateCollection(this.memSpaces.values(), m -> m.doGetModulesByPath(modulePath));
    }

    @Override
    public Collection<? extends TraceModule> getModulesByPath(String modulePath) {
        return Collections.unmodifiableCollection(this.doGetModulesByPath(modulePath));
    }

    @Override
    public TraceModule getLoadedModuleByPath(long snap, String modulePath) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectByPath(snap, modulePath, TraceObjectModule.class);
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceModule traceModule = this.doGetModulesByPath(modulePath).stream().filter(m -> m.isValid(snap)).findAny().orElse(null);
            return traceModule;
        }
    }

    @Override
    public Collection<? extends TraceModule> getAllModules() {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getAllObjects(TraceObjectModule.class);
        }
        return this.delegateCollection(this.memSpaces.values(), m -> m.getAllModules());
    }

    @Override
    public Collection<? extends TraceModule> getLoadedModules(long snap) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsAtSnap(snap, TraceObjectModule.class);
        }
        return this.delegateCollection(this.memSpaces.values(), m -> m.getLoadedModules(snap));
    }

    @Override
    public Collection<? extends TraceModule> getModulesAt(long snap, Address address) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsContaining(snap, address, "_range", TraceObjectModule.class);
        }
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getModulesAt(snap, address), Set.of());
    }

    @Override
    public Collection<? extends TraceModule> getModulesIntersecting(Lifespan lifespan, AddressRange range) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsIntersecting(lifespan, range, "_range", TraceObjectModule.class);
        }
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getModulesIntersecting(lifespan, range), Set.of());
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public Collection<? extends TraceSection> getSectionsAt(long snap, Address address) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsContaining(snap, address, "_range", TraceObjectSection.class);
        }
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getSectionsAt(snap, address), Set.of());
    }

    @Override
    public Collection<? extends TraceSection> getSectionsIntersecting(Lifespan lifespan, AddressRange range) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsIntersecting(lifespan, range, "_range", TraceObjectSection.class);
        }
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getSectionsIntersecting(lifespan, range), Set.of());
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    protected DBTraceModuleSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceModuleSpace(this, space);
    }

    @Override
    protected DBTraceModuleSpace createRegisterSpace(AddressSpace space, TraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        throw new AssertionError();
    }

    protected DBTraceSection doAddSection(DBTraceModule module, String sectionPath, String sectionName, AddressRange range) throws DuplicateNameException {
        this.checkSectionPathConflicts(null, sectionPath, module.getLifespan());
        DBTraceSection nameConflicts = this.doGetSectionByName(module.getKey(), sectionName);
        if (nameConflicts != null) {
            throw new DuplicateNameException("Section with name '" + sectionName + "' already exists");
        }
        return (DBTraceSection)this.delegateWrite(range.getAddressSpace(), m -> m.doAddSection(module, sectionPath, sectionName, range));
    }

    @Override
    public Collection<? extends TraceSection> getAllSections() {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getAllObjects(TraceObjectSection.class);
        }
        return this.delegateCollection(this.memSpaces.values(), m -> m.getAllSections());
    }

    protected Collection<? extends DBTraceSection> doGetSectionsByModuleId(long key) {
        return this.delegateCollection(this.memSpaces.values(), m -> m.doGetSectionsByModuleId(key));
    }

    protected Collection<? extends TraceSection> doGetSectionsByPath(String sectionPath) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsByPath(sectionPath, TraceObjectSection.class);
        }
        return this.delegateCollection(this.memSpaces.values(), m -> m.doGetSectionsByPath(sectionPath));
    }

    @Override
    public Collection<? extends TraceSection> getSectionsByPath(String sectionPath) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Collection<? extends TraceSection> collection = Collections.unmodifiableCollection(this.doGetSectionsByPath(sectionPath));
            return collection;
        }
    }

    @Override
    public TraceSection getLoadedSectionByPath(long snap, String sectionPath) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectByPath(snap, sectionPath, TraceObjectSection.class);
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceSection traceSection = this.doGetSectionsByPath(sectionPath).stream().filter(s -> s.getModule().isValid(snap)).findAny().orElse(null);
            return traceSection;
        }
    }

    protected DBTraceSection doGetSectionByName(long moduleKey, String sectionName) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceSection dBTraceSection = (DBTraceSection)this.delegateFirst(this.memSpaces.values(), m -> m.doGetSectionByName(moduleKey, sectionName));
            return dBTraceSection;
        }
    }

    protected void doDeleteModule(DBTraceModule module) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceSection dBTraceSection : new ArrayList<DBTraceSection>(this.doGetSectionsByModuleId(module.getKey()))) {
                dBTraceSection.space.sectionMapSpace.deleteData(dBTraceSection);
            }
            module.space.moduleMapSpace.deleteData(module);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceModule, Void>(TraceEvents.MODULE_DELETED, null, module));
    }
}

