/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.program;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.graph.GraphDisplayBrokerListener;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.BlockModelServiceListener;
import ghidra.app.services.GoToService;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.graph.BlockFlowGraphType;
import ghidra.graph.CallGraphType;
import ghidra.graph.CodeFlowGraphType;
import ghidra.graph.ProgramGraphDisplayOptions;
import ghidra.graph.ProgramGraphType;
import ghidra.graph.program.BlockGraphTask;
import ghidra.graph.program.DataReferenceGraph;
import ghidra.graph.program.DataReferenceGraphTask;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Program graph generator", description="This plugin provides actions for creating and managing program graphs (block graphs and call graphs).Once a graph is created, it uses the currenly selected graph output to display or export the graph.  The plugin also provides event handling to facilitate interaction between the graph and the tool.", servicesRequired={GoToService.class, BlockModelService.class, GraphDisplayBroker.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class})
public class ProgramGraphPlugin
extends ProgramPlugin
implements OptionsChangeListener,
BlockModelServiceListener,
GraphDisplayBrokerListener {
    private static final String PLUGIN_NAME = "Program Graph";
    private static final String DEFAULT_BLOCK_MODEL_FOR_CALL_GRAPH = "Isolated Entry";
    private static final String OPTIONS_PREFIX = "Program Graph.";
    private static final String MAX_CODE_LINES_DISPLAYED = "Program Graph.Max Code Lines Displayed";
    private static final String REUSE_GRAPH = "Program Graph.Reuse Graph";
    private static final String GRAPH_ENTRY_POINT_NEXUS = "Program Graph.Graph Entry Point Nexus";
    private static final String FORCE_LOCATION_DISPLAY_OPTION = "Program Graph.Force Location Visible on Graph";
    private static final String MAX_DEPTH_OPTION = "Program Graph.Max Reference Depth";
    public static final String MENU_GRAPH = "&Graph";
    private BlockModelService blockModelService;
    private List<DockingAction> subUsingGraphActions = new ArrayList<DockingAction>();
    private ToggleDockingAction reuseGraphAction;
    private ToggleDockingAction appendGraphAction;
    private boolean reuseGraph = false;
    private boolean appendToGraph = false;
    private boolean graphEntryPointNexus = false;
    private int codeLimitPerBlock = 10;
    private int dataMaxDepth = 1;
    private ToggleDockingAction forceLocationVisibleAction;
    private GraphDisplayBroker broker;
    private GraphDisplayProvider defaultGraphService;

    public ProgramGraphPlugin(PluginTool tool) {
        super(tool);
        this.intializeOptions();
        this.registerProgramFlowGraphDisplayOptionsWithTool();
    }

    private void registerProgramFlowGraphDisplayOptionsWithTool() {
        new ProgramGraphDisplayOptions((ProgramGraphType)new BlockFlowGraphType(), this.tool);
    }

    private void intializeOptions() {
        HelpLocation help = new HelpLocation(this.getName(), "Graph_Option");
        ToolOptions options = this.tool.getOptions("Graph");
        options.registerOption(MAX_CODE_LINES_DISPLAYED, (Object)this.codeLimitPerBlock, help, "Specifies the maximum number of instructions to display in each graph node in a Code Flow Graph.");
        options.registerOption(REUSE_GRAPH, (Object)false, help, "Determines whether the graph will reuse the active graph window when displaying graphs.");
        options.registerOption(GRAPH_ENTRY_POINT_NEXUS, (Object)false, help, "Add a dummy node at the root of the graph and adds dummy edges to each node that has no incoming edges.");
        options.registerOption(FORCE_LOCATION_DISPLAY_OPTION, (Object)false, help, "Specifies whether or not graph displays should force the visible graph to pan and/or scale to ensure that focused locations are visible.");
        options.registerOption(MAX_DEPTH_OPTION, (Object)1, help, "Specifies max depth of data references to graph (0 for no limit)");
        this.setOptions((Options)options);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        options.setOptionsHelpLocation(new HelpLocation(this.getName(), "Graph_Option"));
    }

    protected void init() {
        this.broker = (GraphDisplayBroker)this.tool.getService(GraphDisplayBroker.class);
        this.broker.addGraphDisplayBrokerListener((GraphDisplayBrokerListener)this);
        this.defaultGraphService = this.broker.getDefaultGraphDisplayProvider();
        this.blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        this.blockModelService.addListener((BlockModelServiceListener)this);
        this.createActions();
    }

    public void dispose() {
        super.dispose();
        if (this.blockModelService != null) {
            this.blockModelService.removeListener((BlockModelServiceListener)this);
            this.blockModelService = null;
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.setOptions((Options)options);
    }

    private void setOptions(Options options) {
        this.codeLimitPerBlock = options.getInt(MAX_CODE_LINES_DISPLAYED, this.codeLimitPerBlock);
        this.graphEntryPointNexus = options.getBoolean(GRAPH_ENTRY_POINT_NEXUS, false);
        this.reuseGraph = options.getBoolean(REUSE_GRAPH, false);
        if (this.reuseGraphAction != null) {
            this.reuseGraphAction.setSelected(this.reuseGraph);
        }
        this.dataMaxDepth = options.getInt(MAX_DEPTH_OPTION, this.dataMaxDepth);
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Block Flow", this.getName()).menuPath(new String[]{MENU_GRAPH, "&Block Flow"})).menuGroup(MENU_GRAPH, "A")).onAction(c -> this.graphBlockFlow())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Code Flow", this.getName()).menuPath(new String[]{MENU_GRAPH, "C&ode Flow"})).menuGroup(MENU_GRAPH, "B")).onAction(c -> this.graphCodeFlow())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Calls Using Default Model", this.getName()).menuPath(new String[]{MENU_GRAPH, "&Calls"})).menuGroup(MENU_GRAPH, "C")).onAction(c -> this.createDefaultCallGraph())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.tool.setMenuGroup(new String[]{MENU_GRAPH, "Data"}, "Graph", "Data");
        HelpLocation helpLoc = new HelpLocation(this.getName(), "Data_Reference_Graph");
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph To/From Data References", this.getName()).menuPath(new String[]{MENU_GRAPH, "Data", "To/From &References"})).menuGroup(MENU_GRAPH, "Data")).helpLocation(helpLoc)).onAction(c -> this.graphDataReferences())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph To Data References", this.getName()).menuPath(new String[]{MENU_GRAPH, "Data", "&To References"})).menuGroup(MENU_GRAPH, "Data")).helpLocation(helpLoc)).onAction(c -> this.graphToDataReferences())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph From Data References", this.getName()).menuPath(new String[]{MENU_GRAPH, "Data", "&From References"})).menuGroup(MENU_GRAPH, "Data")).helpLocation(helpLoc)).onAction(c -> this.graphFromDataReferences())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.reuseGraphAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Reuse Graph", this.getName()).menuPath(new String[]{MENU_GRAPH, "Reuse Graph"})).menuGroup("Graph Options")).selected(this.reuseGraph).onAction(c -> {
            this.reuseGraph = this.reuseGraphAction.isSelected();
        })).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.appendGraphAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Append Graph", this.getName()).menuPath(new String[]{MENU_GRAPH, "Append Graph"})).menuGroup("Graph Options")).selected(false).onAction(c -> this.updateAppendAndReuseGraph())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.forceLocationVisibleAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Location in Graph", this.getName()).menuPath(new String[]{MENU_GRAPH, "Show Location"})).description("Tell the graph to pan/scale as need to keep location changes visible")).menuGroup("Graph Options")).onAction(c -> this.toggleForceLocationVisible())).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
        this.updateSubroutineActions();
    }

    private boolean canGraph(ActionContext context) {
        return this.currentProgram != null && this.defaultGraphService != null;
    }

    private void toggleForceLocationVisible() {
        ToolOptions options = this.tool.getOptions("Graph");
        options.setBoolean(FORCE_LOCATION_DISPLAY_OPTION, this.forceLocationVisibleAction.isSelected());
    }

    private void updateAppendAndReuseGraph() {
        this.appendToGraph = this.appendGraphAction.isSelected();
        if (this.appendToGraph && !this.reuseGraph) {
            this.reuseGraph = true;
            this.reuseGraphAction.setSelected(true);
        }
    }

    private void updateSubroutineActions() {
        for (DockingAction action : this.subUsingGraphActions) {
            this.tool.removeAction((DockingActionIf)action);
        }
        String[] subModels = this.blockModelService.getAvailableModelNames(2);
        if (subModels.length <= 1) {
            return;
        }
        HelpLocation helpLoc = new HelpLocation(this.getName(), "Graph_Calls_Using_Model");
        for (String blockModelName : subModels) {
            DockingAction action = this.buildGraphActionWithModel(blockModelName, helpLoc);
            this.subUsingGraphActions.add(action);
        }
        this.tool.setMenuGroup(new String[]{MENU_GRAPH, "Calls Using Model"}, "Graph", "C");
    }

    private DockingAction buildGraphActionWithModel(String blockModelName, HelpLocation helpLoc) {
        return (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Graph Calls using " + blockModelName, this.getName()).menuPath(new String[]{MENU_GRAPH, "Calls Using Model", blockModelName})).menuGroup(MENU_GRAPH, "C")).helpLocation(helpLoc)).onAction(c -> this.createCallGraphUsing(blockModelName))).enabledWhen(this::canGraph)).buildAndInstall((Tool)this.tool);
    }

    private void graphBlockFlow() {
        this.graph((ProgramGraphType)new BlockFlowGraphType(), this.blockModelService.getActiveBlockModelName());
    }

    private void graphCodeFlow() {
        this.graph((ProgramGraphType)new CodeFlowGraphType(), this.blockModelService.getActiveBlockModelName());
    }

    private void createDefaultCallGraph() {
        this.createCallGraphUsing(DEFAULT_BLOCK_MODEL_FOR_CALL_GRAPH);
    }

    private void createCallGraphUsing(String modelName) {
        this.graph((ProgramGraphType)new CallGraphType(), modelName);
    }

    private void graphDataReferences() {
        this.graphData(DataReferenceGraph.Directions.BOTH_WAYS);
    }

    private void graphToDataReferences() {
        this.graphData(DataReferenceGraph.Directions.TO_ONLY);
    }

    private void graphFromDataReferences() {
        this.graphData(DataReferenceGraph.Directions.FROM_ONLY);
    }

    private void graph(ProgramGraphType graphType, String modelName) {
        try {
            CodeBlockModel model = this.blockModelService.getNewModelByName(modelName, this.currentProgram, true);
            BlockGraphTask task = new BlockGraphTask(graphType, this.graphEntryPointNexus, this.reuseGraph, this.appendToGraph, this.tool, this.currentSelection, this.currentLocation, model, this.defaultGraphService);
            task.setCodeLimitPerBlock(this.codeLimitPerBlock);
            new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
        }
        catch (NotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error That Can't Happen", (Object)"Can't find a block model from a name that we got from the existing block models!");
        }
    }

    void graphData(DataReferenceGraph.Directions direction) {
        DataReferenceGraphTask task = new DataReferenceGraphTask(this.reuseGraph, this.appendToGraph, this.tool, this.currentSelection, this.currentLocation, this.defaultGraphService, this.dataMaxDepth, this.codeLimitPerBlock, direction);
        new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
    }

    String getProgramName() {
        return this.currentProgram != null ? this.currentProgram.getName() : null;
    }

    public void modelAdded(String modeName, int modelType) {
        if (modelType == 2) {
            this.updateSubroutineActions();
        }
    }

    public void modelRemoved(String modeName, int modelType) {
        if (modelType == 2) {
            this.updateSubroutineActions();
        }
    }

    public void providersChanged() {
        this.defaultGraphService = this.broker.getDefaultGraphDisplayProvider();
    }
}

