/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.mz;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.mz.MzRelocation;
import ghidra.app.util.bin.format.mz.OldDOSHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MzExecutable {
    private BinaryReader reader;
    private OldDOSHeader header;
    private List<MzRelocation> relocations = new ArrayList<MzRelocation>();

    public MzExecutable(ByteProvider provider) throws IOException {
        this.reader = new BinaryReader(provider, true);
        this.header = new OldDOSHeader(this.reader);
        this.reader.setPointerIndex(this.header.e_lfarlc());
        for (int i = 0; i < this.header.e_crlc(); ++i) {
            this.relocations.add(new MzRelocation(this.reader));
        }
    }

    public BinaryReader getBinaryReader() {
        return this.reader;
    }

    public OldDOSHeader getHeader() {
        return this.header;
    }

    public List<MzRelocation> getRelocations() {
        return this.relocations;
    }
}

