/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.util.classfinder.ClassSearcher;
import java.util.ArrayList;
import java.util.List;

public final class ElfRelocationHandlerFactory {
    public static final List<ElfRelocationHandler> getHandlers() {
        return new ArrayList<ElfRelocationHandler>(ClassSearcher.getInstances(ElfRelocationHandler.class));
    }

    public static final ElfRelocationHandler getHandler(ElfHeader elf) {
        for (ElfRelocationHandler handler : ElfRelocationHandlerFactory.getHandlers()) {
            if (!handler.canRelocate(elf)) continue;
            return handler;
        }
        return null;
    }
}

