/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import java.util.ArrayList;

class RangeBlock {
    private ArrayList<AddressRange> rangeList = new ArrayList();
    private ArrayList<MemoryBlock> blockList = new ArrayList();

    RangeBlock(AddressFactory af, Memory memory, AddressRange range) {
        AddressSet set = new AddressSet(range);
        while (!set.isEmpty()) {
            MemoryBlock block = memory.getBlock(set.getMinAddress());
            set.deleteRange(block.getStart(), block.getEnd());
            this.rangeList.add(range.intersect((AddressRange)new AddressRangeImpl(block.getStart(), block.getEnd())));
            this.blockList.add(block);
        }
    }

    AddressRange[] getRanges() {
        AddressRange[] ranges = new AddressRange[this.rangeList.size()];
        this.rangeList.toArray(ranges);
        return ranges;
    }

    MemoryBlock[] getBlocks() {
        MemoryBlock[] blocks = new MemoryBlock[this.rangeList.size()];
        this.blockList.toArray(blocks);
        return blocks;
    }
}

