/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.jad.JarDecompilerTask;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import utilities.util.FileUtilities;

public class JarDecompiler {
    private FSRL jarFile;
    private File outputDirectory;
    private MessageLog log = new MessageLog();

    public static boolean isJarFilename(String filename) {
        return "jar".equalsIgnoreCase(FilenameUtils.getExtension((String)filename));
    }

    public JarDecompiler(FSRL jarFile, File outputDirectory) {
        this.jarFile = jarFile;
        this.outputDirectory = outputDirectory;
    }

    public void decompile(TaskMonitor monitor) throws IOException, CancelledException {
        FileUtilities.checkedMkdirs((File)this.outputDirectory);
        monitor.setMessage("");
        this.unzip(monitor);
        if (monitor.isCancelled()) {
            return;
        }
        monitor.setMessage("");
        this.processListing(this.outputDirectory, monitor);
        monitor.setMessage("");
    }

    public MessageLog getLog() {
        return this.log;
    }

    private String getRelPath(File directory) {
        return directory.getPath().substring(this.outputDirectory.getPath().length());
    }

    private void processListing(File directory, TaskMonitor monitor) {
        Iterator iterator = FileUtils.iterateFilesAndDirs((File)directory, (IOFileFilter)FalseFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        while (iterator.hasNext()) {
            File dir = (File)iterator.next();
            JarDecompilerTask task = new JarDecompilerTask(dir, this.jarFile.getName() + ":" + this.getRelPath(dir));
            TaskLauncher.launch((Task)task);
        }
    }

    private void unzip(TaskMonitor monitor) throws ZipException, IOException, FileNotFoundException, CancelledException {
        FileSystemService fsService = FileSystemService.getInstance();
        try (GFileSystem fs = fsService.openFileSystemContainer(this.jarFile, monitor);){
            monitor.setIndeterminate(true);
            monitor.initialize(0L);
            for (GFile file : fs) {
                if (monitor.isCancelled()) {
                    break;
                }
                File outputFile = new File(this.outputDirectory.getAbsolutePath(), file.getPath());
                if (!FileUtilities.isPathContainedWithin((File)this.outputDirectory, (File)outputFile)) {
                    throw new IOException("Extracted file " + outputFile.getPath() + " would be outside of root destination directory: " + String.valueOf(this.outputDirectory));
                }
                FileUtilities.checkedMkdirs((File)outputFile.getParentFile());
                if (file.isDirectory()) continue;
                monitor.setMessage("Unzipping jar file... ");
                monitor.incrementProgress(1L);
                ByteProvider fileBP = fs.getByteProvider(file, monitor);
                try {
                    FSUtilities.copyByteProviderToFile((ByteProvider)fileBP, (File)outputFile, (TaskMonitor)monitor);
                }
                finally {
                    if (fileBP == null) continue;
                    fileBP.close();
                }
            }
        }
    }
}

