/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.tar;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.tar.TarFileSystemFactory;
import ghidra.file.formats.tar.TarMetadata;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

@FileSystemInfo(type="tar", description="TAR", priority=10, factory=TarFileSystemFactory.class)
public class TarFileSystem
extends AbstractFileSystem<TarMetadata> {
    private ByteProvider provider;
    private int fileCount;

    public TarFileSystem(FSRLRoot fsrl, ByteProvider provider, FileSystemService fsService) {
        super(fsrl, fsService);
        this.provider = provider;
    }

    ByteProvider getProvider() {
        return this.provider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void mount(TaskMonitor monitor) throws IOException, CancelledException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(this.provider.getInputStream(0L));){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tarInput.getNextTarEntry()) != null) {
                int fileNum;
                GFile newFile;
                monitor.setMessage(tarEntry.getName());
                monitor.checkCancelled();
                ++this.fileCount;
                String linkName = tarEntry.getLinkName();
                GFile gFile = newFile = !tarEntry.isSymbolicLink() ? this.fsIndex.storeFile(tarEntry.getName(), (long)this.fileCount, tarEntry.isDirectory(), tarEntry.getSize(), (Object)new TarMetadata(tarEntry, fileNum)) : this.fsIndex.storeSymlink(tarEntry.getName(), (long)this.fileCount, linkName, (long)linkName.length(), (Object)new TarMetadata(tarEntry, fileNum));
                if (tarEntry.isSymbolicLink() || tarEntry.getSize() >= 0x200000L) continue;
                ByteProvider bp = this.fsService.getDerivedByteProvider(this.fsFSRL.getContainer(), newFile.getFSRL(), newFile.getPath(), tarEntry.getSize(), () -> tarInput, monitor);
                try {
                    this.fsIndex.updateFSRL(newFile, newFile.getFSRL().withMD5(bp.getFSRL().getMD5()));
                }
                finally {
                    if (bp == null) continue;
                    bp.close();
                }
            }
            return;
        }
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndex.clear();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        TarMetadata tmd = (TarMetadata)this.fsIndex.getMetadata(file);
        if (tmd == null) {
            return FileAttributes.EMPTY;
        }
        TarArchiveEntry blob = tmd.tarArchiveEntry;
        return FileAttributes.of((FileAttribute[])new FileAttribute[]{FileAttribute.create((FileAttributeType)FileAttributeType.NAME_ATTR, (Object)blob.getName()), FileAttribute.create((FileAttributeType)FileAttributeType.SIZE_ATTR, (Object)blob.getSize()), FileAttribute.create((FileAttributeType)FileAttributeType.MODIFIED_DATE_ATTR, (Object)blob.getLastModifiedDate()), FileAttribute.create((FileAttributeType)FileAttributeType.FILE_TYPE_ATTR, (Object)this.tarToFileType(blob)), FileAttribute.create((FileAttributeType)FileAttributeType.USER_NAME_ATTR, (Object)blob.getUserName()), FileAttribute.create((FileAttributeType)FileAttributeType.GROUP_NAME_ATTR, (Object)blob.getGroupName()), FileAttribute.create((FileAttributeType)FileAttributeType.USER_ID_ATTR, (Object)blob.getLongUserId()), FileAttribute.create((FileAttributeType)FileAttributeType.GROUP_ID_ATTR, (Object)blob.getLongGroupId()), FileAttribute.create((FileAttributeType)FileAttributeType.UNIX_ACL_ATTR, (Object)blob.getMode()), blob.isSymbolicLink() ? FileAttribute.create((FileAttributeType)FileAttributeType.SYMLINK_DEST_ATTR, (Object)blob.getLinkName()) : null});
    }

    private FileType tarToFileType(TarArchiveEntry tae) {
        if (tae.isDirectory()) {
            return FileType.DIRECTORY;
        }
        if (tae.isSymbolicLink()) {
            return FileType.SYMBOLIC_LINK;
        }
        if (tae.isFile()) {
            return FileType.FILE;
        }
        return FileType.UNKNOWN;
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        GFile resolvedFile = this.fsIndex.resolveSymlinks(file);
        TarMetadata tmd = (TarMetadata)this.fsIndex.getMetadata(resolvedFile);
        if (tmd == null) {
            throw new IOException("Unknown file " + String.valueOf(file));
        }
        ByteProvider fileBP = this.fsService.getDerivedByteProvider(this.provider.getFSRL(), resolvedFile.getFSRL(), resolvedFile.getPath(), tmd.tarArchiveEntry.getSize(), () -> {
            TarArchiveEntry tarEntry;
            TarArchiveInputStream tarInput = new TarArchiveInputStream(this.provider.getInputStream(0L));
            int fileNum = 0;
            while ((tarEntry = tarInput.getNextTarEntry()) != null) {
                if (fileNum == tmd.fileNum) {
                    if (!tmd.tarArchiveEntry.getName().equals(tarEntry.getName())) {
                        throw new IOException("Mismatch between filenum and tarEntry for " + String.valueOf(resolvedFile));
                    }
                    return tarInput;
                }
                ++fileNum;
            }
            throw new IOException("Could not find requested file " + String.valueOf(resolvedFile));
        }, monitor);
        return fileBP;
    }
}

