/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.CodeUnitLocation;
import java.util.List;

public class LabelFieldLocation
extends CodeUnitLocation {
    private SymbolPath symbolPath;

    public LabelFieldLocation() {
    }

    public LabelFieldLocation(Program program, Address addr, int[] componentPath, String label, Namespace namespace, int row, int charOffset) {
        super(program, addr, componentPath, row, 0, charOffset);
        this.symbolPath = namespace == null || namespace.isGlobal() ? new SymbolPath(label) : new SymbolPath(new SymbolPath(namespace.getSymbol()), label);
    }

    public LabelFieldLocation(Program program, Address addr, String label) {
        this(program, addr, null, label, null, 0, 0);
    }

    public LabelFieldLocation(Program program, Address addr, String label, Namespace namespace, int row) {
        this(program, addr, null, label, namespace, row, 0);
    }

    public LabelFieldLocation(Symbol s) {
        this(s, 0, 0);
    }

    public LabelFieldLocation(Symbol s, int row, int charOffset) {
        this(s.getProgram(), s.getAddress(), null, s.getName(), s.getParentNamespace(), row, charOffset);
        if (s.getSymbolType() != SymbolType.LABEL && s.getSymbolType() != SymbolType.FUNCTION) {
            throw new IllegalArgumentException("Code symbol expected");
        }
    }

    public String getName() {
        return this.symbolPath.getName();
    }

    public Symbol getSymbol() {
        List<Symbol> symbols = NamespaceUtils.getSymbols(this.symbolPath, this.program);
        for (Symbol symbol : symbols) {
            if (!symbol.getAddress().equals(this.getAddress())) continue;
            return symbol;
        }
        return null;
    }

    public SymbolPath getSymbolPath() {
        return this.symbolPath;
    }

    @Override
    public String toString() {
        return super.toString() + ", Label = " + this.symbolPath.getPath();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.symbolPath.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelFieldLocation other = (LabelFieldLocation)obj;
        return this.symbolPath.equals(other.symbolPath);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putStrings("_SYMBOL_PATH", this.symbolPath.asArray());
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        String[] symbolPathArray = obj.getStrings("_SYMBOL_PATH", null);
        this.symbolPath = symbolPathArray == null ? new SymbolPath("") : new SymbolPath(symbolPathArray);
    }
}

