/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class VarnodeListSymbol
extends ValueSymbol {
    private VarnodeSymbol[] varnode_table;
    private boolean tableisfilled;

    public Collection<VarnodeSymbol> getVarnodeTable() {
        return Collections.unmodifiableList(Arrays.asList(this.varnode_table));
    }

    private void checkTableFill() {
        long min = this.getPatternValue().minValue();
        long max = this.getPatternValue().maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.varnode_table.length;
        for (int i = 0; i < this.varnode_table.length; ++i) {
            if (this.varnode_table[i] != null) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        long ind;
        if (!(this.tableisfilled || (ind = this.getPatternValue().getValue(walker)) >= 0L && ind < (long)this.varnode_table.length && this.varnode_table[(int)ind] != null)) {
            String errmsg = "Failed to resolve varnode <" + this.getName() + ">, index=" + ind;
            if (debug != null) {
                debug.append(errmsg + "\n");
            }
            throw new UnknownInstructionException(errmsg);
        }
        return null;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        VarnodeSymbol vnsym = this.varnode_table[ind];
        VarnodeData fix = vnsym.getFixedVarnode();
        hand.space = fix.space;
        hand.offset_space = null;
        hand.offset_offset = fix.offset;
        hand.size = fix.size;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        return this.varnode_table[ind].getName();
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        this.patval = (PatternValue)PatternExpression.decodeExpression(decoder, sleigh);
        ArrayList<VarnodeSymbol> varnodes = new ArrayList<VarnodeSymbol>();
        SymbolTable symtab = sleigh.getSymbolTable();
        while (decoder.peekElement() != 0) {
            int subel = decoder.openElement();
            if (subel == SlaFormat.ELEM_VAR.id()) {
                int id = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_ID);
                varnodes.add((VarnodeSymbol)symtab.findSymbol(id));
            } else {
                varnodes.add(null);
            }
            decoder.closeElement(subel);
        }
        this.varnode_table = new VarnodeSymbol[varnodes.size()];
        for (int i = 0; i < this.varnode_table.length; ++i) {
            this.varnode_table[i] = (VarnodeSymbol)varnodes.get(i);
        }
        this.checkTableFill();
        decoder.closeElement(SlaFormat.ELEM_VARLIST_SYM.id());
    }
}

