/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.unix;

import ghidra.pty.PtyChild;
import ghidra.pty.PtySession;
import ghidra.pty.local.LocalProcessPtySession;
import ghidra.pty.unix.PosixC;
import ghidra.pty.unix.UnixPtyEndpoint;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class UnixPtyChild
extends UnixPtyEndpoint
implements PtyChild {
    static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final String name;

    UnixPtyChild(PosixC.Ioctls ioctls, int fd, String name) {
        super(ioctls, fd);
        this.name = name;
    }

    @Override
    public String nullSession(Collection<PtyChild.TermMode> mode) {
        this.applyMode(mode);
        return this.name;
    }

    @Override
    public PtySession session(String[] args, Map<String, String> env, File workingDirectory, Collection<PtyChild.TermMode> mode) throws IOException {
        return this.sessionUsingJavaLeader(args, env, workingDirectory, mode);
    }

    protected PtySession sessionUsingJavaLeader(String[] args, Map<String, String> env, File workingDirectory, Collection<PtyChild.TermMode> mode) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>();
        String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        argsList.add(javaCommand);
        argsList.add("-cp");
        argsList.add(System.getProperty("java.class.path"));
        argsList.add(this.ioctls.leaderClass().getCanonicalName());
        argsList.add(this.name);
        argsList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argsList);
        if (env != null) {
            builder.environment().putAll(env);
        }
        if (workingDirectory != null) {
            builder.directory(workingDirectory);
        }
        builder.inheritIO();
        this.applyMode(mode);
        try {
            return new LocalProcessPtySession(builder.start(), this.name);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Could not start process with args " + Arrays.toString(args)), (Throwable)e);
            throw e;
        }
    }

    private void applyMode(Collection<PtyChild.TermMode> mode) {
        if (mode.contains(PtyChild.Echo.OFF)) {
            this.disableEcho();
        }
    }

    private void disableEcho() {
        PosixC.Termios.ByReference tmios = new PosixC.Termios.ByReference();
        LIB_POSIX.tcgetattr(this.fd, tmios);
        tmios.c_lflag &= 0xFFFFFFF7;
        LIB_POSIX.tcsetattr(this.fd, 0, tmios);
    }

    @Override
    public void setWindowSize(short cols, short rows) {
        PosixC.Winsize.ByReference ws = new PosixC.Winsize.ByReference();
        ws.ws_col = cols;
        ws.ws_row = rows;
        ws.write();
        try {
            PosixC.INSTANCE.ioctl(this.fd, this.ioctls.TIOCSWINSZ(), ws.getPointer());
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Could not set terminal window size: " + String.valueOf(e)));
        }
    }
}

