/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class MiniPdbReferenceMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4448;
    private long coffSection;
    private RecordNumber typeRecordNumber;
    private int moduleIndex;
    private boolean isLocal;
    private boolean isData;
    private boolean isUserDefinedType;
    private boolean isLabel;
    private boolean isConst;
    private String name;

    public MiniPdbReferenceMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        PdbByteReader unionReader = reader.getSubPdbByteReader(4);
        this.moduleIndex = reader.parseUnsignedShortVal();
        int flags = reader.parseUnsignedShortVal();
        this.processFlags(flags);
        if (this.isUserDefinedType) {
            this.typeRecordNumber = RecordNumber.parse(pdb, unionReader, RecordCategory.TYPE, 32);
        } else {
            this.coffSection = unionReader.parseLong();
        }
        this.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
    }

    @Override
    public int getPdbId() {
        return 4448;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: ", this.getSymbolTypeName()));
        if (this.isUserDefinedType) {
            builder.append(String.format("(UDT) moduleIndex = %04X, TypeInformation = %s, %s\n", this.moduleIndex, this.pdb.getTypeRecord(this.typeRecordNumber), this.name));
        } else {
            builder.append(String.format("(%s) moduleIndex = %04X, coffSection = %X, %s\n", this.getLabel(), this.moduleIndex, this.coffSection, this.name));
        }
    }

    @Override
    protected String getSymbolTypeName() {
        return "REF_MINIPDB";
    }

    private void processFlags(int flags) {
        this.isLocal = (flags & 1) == 1;
        this.isData = ((flags >>= 1) & 1) == 1;
        this.isUserDefinedType = ((flags >>= 1) & 1) == 1;
        this.isLabel = ((flags >>= 1) & 1) == 1;
        this.isConst = ((flags >>= 1) & 1) == 1;
    }

    private String getLabel() {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.isLocal ? "local" : "global");
        if (this.isData) {
            myBuilder.append(" data");
        } else if (this.isLabel) {
            myBuilder.append(" label");
        } else if (this.isConst) {
            myBuilder.append(" const");
        } else {
            myBuilder.append(" func");
        }
        return myBuilder.toString();
    }
}

