/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import ghidra.util.Msg;
import ghidra.util.exception.NoValueException;
import ghidra.util.graph.DepthFirstSearch;
import ghidra.util.graph.Edge;
import ghidra.util.graph.EdgeSet;
import ghidra.util.graph.GraphIterator;
import ghidra.util.graph.Vertex;
import ghidra.util.graph.VertexSet;
import ghidra.util.graph.attributes.Attribute;
import ghidra.util.graph.attributes.AttributeManager;
import ghidra.util.graph.attributes.DoubleAttribute;
import ghidra.util.graph.attributes.IntegerAttribute;
import ghidra.util.graph.attributes.LongAttribute;
import ghidra.util.graph.attributes.ObjectAttribute;
import ghidra.util.graph.attributes.StringAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

@Deprecated(since="10.2")
public class DirectedGraph {
    private final VertexSet vertices;
    private final EdgeSet edges;
    private final AttributeManager<Vertex> vertexAttributes;
    private final AttributeManager<Edge> edgeAttributes;

    public DirectedGraph(int vertexCapacity, int edgeCapacity) {
        this.vertices = new VertexSet(this, vertexCapacity);
        this.edges = new EdgeSet(this, edgeCapacity);
        this.vertexAttributes = new AttributeManager<Vertex>(this.vertices);
        this.edgeAttributes = new AttributeManager<Edge>(this.edges);
    }

    public DirectedGraph() {
        this(101, 101);
    }

    public int inValence(Vertex v) {
        int inv = 0;
        Edge e = this.vertices.getFirstIncomingEdge(v);
        while (e != null) {
            ++inv;
            e = this.edges.getNextEdgeWithSameTo(e);
        }
        return inv;
    }

    public int outValence(Vertex v) {
        int outv = 0;
        Edge e = this.vertices.getFirstOutgoingEdge(v);
        while (e != null) {
            ++outv;
            e = this.edges.getNextEdgeWithSameFrom(e);
        }
        return outv;
    }

    public int numLoops(Vertex v) {
        int loops = 0;
        Edge e = this.vertices.getFirstOutgoingEdge(v);
        while (e != null) {
            if (v.key() == e.to().key()) {
                ++loops;
            }
            e = this.edges.getNextEdgeWithSameFrom(e);
        }
        return loops;
    }

    public int valence(Vertex v) {
        return this.inValence(v) + this.outValence(v) - this.numLoops(v);
    }

    public EdgeSet edges() {
        return this.edges;
    }

    public Edge getEdgeWithKey(long key) {
        return this.edges.getKeyedObject(key);
    }

    public VertexSet vertices() {
        return this.vertices;
    }

    public Vertex getVertexWithKey(long key) {
        return this.vertices.getKeyedObject(key);
    }

    public Set<Vertex> getChildren(Vertex v) {
        HashSet<Vertex> children = new HashSet<Vertex>();
        Edge e = this.vertices.getFirstOutgoingEdge(v);
        while (e != null) {
            children.add(e.to());
            e = this.edges.getNextEdgeWithSameFrom(e);
        }
        return children;
    }

    public Set<Edge> getOutgoingEdges(Vertex v) {
        HashSet<Edge> outgoingEdges = new HashSet<Edge>();
        Edge e = this.vertices.getFirstOutgoingEdge(v);
        while (e != null) {
            outgoingEdges.add(e);
            e = this.edges.getNextEdgeWithSameFrom(e);
        }
        return outgoingEdges;
    }

    public Set<Vertex> getParents(Vertex v) {
        HashSet<Vertex> parents = new HashSet<Vertex>();
        Edge e = this.vertices.getFirstIncomingEdge(v);
        while (e != null) {
            parents.add(e.from());
            e = this.edges.getNextEdgeWithSameTo(e);
        }
        return parents;
    }

    public Set<Edge> getIncomingEdges(Vertex v) {
        HashSet<Edge> incomingEdges = new HashSet<Edge>();
        Edge e = this.vertices.getFirstIncomingEdge(v);
        while (e != null) {
            incomingEdges.add(e);
            e = this.edges.getNextEdgeWithSameTo(e);
        }
        return incomingEdges;
    }

    public Set<Vertex> getChildren(Set<Vertex> vs) {
        HashSet<Vertex> children = new HashSet<Vertex>();
        for (Vertex v : vs) {
            Edge e = this.vertices.getFirstOutgoingEdge(v);
            while (e != null) {
                children.add(e.to());
                e = this.edges.getNextEdgeWithSameFrom(e);
            }
        }
        return children;
    }

    public Set<Vertex> getParents(Set<Vertex> vs) {
        HashSet<Vertex> parents = new HashSet<Vertex>();
        for (Vertex v : vs) {
            Edge e = this.vertices.getFirstIncomingEdge(v);
            while (e != null) {
                parents.add(e.from());
                e = this.edges.getNextEdgeWithSameTo(e);
            }
        }
        return parents;
    }

    public Set<Vertex> getDescendants(Vertex v) {
        HashSet<Vertex> seeds = new HashSet<Vertex>(11);
        seeds.add(v);
        HashSet<Vertex> descendants = new HashSet<Vertex>(this.vertices.size() / 20);
        HashSet<Vertex> newSeeds = new HashSet<Vertex>();
        descendants.add(v);
        while (!seeds.isEmpty()) {
            newSeeds.clear();
            for (Vertex vertex : seeds) {
                Edge e = this.vertices.getFirstOutgoingEdge(vertex);
                while (e != null) {
                    Vertex child = e.to();
                    if (descendants.add(child)) {
                        newSeeds.add(child);
                    }
                    e = this.edges.getNextEdgeWithSameFrom(e);
                }
            }
            seeds.clear();
            seeds.addAll(newSeeds);
        }
        return descendants;
    }

    public Edge[] incomingEdges(Vertex v) {
        int n = this.inValence(v);
        Edge[] answer = new Edge[n];
        Edge e = this.vertices.getFirstIncomingEdge(v);
        for (int i = 0; i < n; ++i) {
            answer[i] = e;
            e = this.edges.getNextEdgeWithSameTo(e);
        }
        return answer;
    }

    public Edge[] outgoingEdges(Vertex v) {
        int n = this.outValence(v);
        Edge[] answer = new Edge[n];
        Edge e = this.vertices.getFirstOutgoingEdge(v);
        for (int i = 0; i < n; ++i) {
            answer[i] = e;
            e = this.edges.getNextEdgeWithSameFrom(e);
        }
        return answer;
    }

    public Edge[] selfEdges(Vertex v) {
        int n = this.numLoops(v);
        Edge[] answer = new Edge[n];
        Edge e = this.vertices.getFirstOutgoingEdge(v);
        int i = 0;
        while (e != null) {
            if (v.equals(e.to())) {
                answer[i++] = e;
            }
            e = this.edges.getNextEdgeWithSameFrom(e);
        }
        return answer;
    }

    public Vertex[] verticesUnreachableFromSources() {
        Set<Vertex> reachable = this.getDescendants(this.getSources());
        Set<Vertex> unreachable = this.vertices.toSet();
        unreachable.removeAll(reachable);
        return unreachable.toArray(new Vertex[unreachable.size()]);
    }

    public Set<Vertex> getDescendants(Vertex[] seedVertices) {
        HashSet<Vertex> descendants = new HashSet<Vertex>(2 * seedVertices.length);
        HashSet<Vertex> pending = new HashSet<Vertex>(seedVertices.length);
        HashSet<Vertex> newlyPending = new HashSet<Vertex>(seedVertices.length);
        for (Vertex seedVertice : seedVertices) {
            pending.add(seedVertice);
        }
        while (!pending.isEmpty()) {
            Iterator iter = pending.iterator();
            while (iter.hasNext()) {
                Vertex parent = (Vertex)iter.next();
                Edge edge = this.vertices.getFirstOutgoingEdge(parent);
                descendants.add(parent);
                iter.remove();
                while (edge != null) {
                    Vertex child = edge.to();
                    if (!descendants.contains(child)) {
                        newlyPending.add(child);
                    }
                    edge = this.edges.getNextEdgeWithSameFrom(edge);
                }
            }
            pending.addAll(newlyPending);
            newlyPending.clear();
        }
        return descendants;
    }

    public Set<Vertex> getAncestors(Vertex v) {
        HashSet<Vertex> seeds = new HashSet<Vertex>(11);
        seeds.add(v);
        HashSet<Vertex> ancestors = new HashSet<Vertex>(this.numVertices() / 20);
        HashSet<Vertex> newSeeds = new HashSet<Vertex>();
        ancestors.add(v);
        while (!seeds.isEmpty()) {
            newSeeds.clear();
            for (Vertex vertex : seeds) {
                Edge e = this.vertices.getFirstIncomingEdge(vertex);
                while (e != null) {
                    Vertex parent = e.from();
                    if (ancestors.add(parent)) {
                        newSeeds.add(parent);
                    }
                    e = this.edges.getNextEdgeWithSameTo(e);
                }
            }
            seeds.clear();
            seeds.addAll(newSeeds);
        }
        ancestors.add(v);
        return ancestors;
    }

    public GraphIterator<Edge> edgeIterator() {
        return this.edges.iterator();
    }

    public GraphIterator<Vertex> vertexIterator() {
        return this.vertices.iterator();
    }

    public double inDegree(Vertex v) {
        return this.inValence(v);
    }

    public double outDegree(Vertex v) {
        return this.outValence(v);
    }

    public double loopDegree(Vertex v) {
        return this.numLoops(v);
    }

    public double degree(Vertex v) {
        return this.valence(v);
    }

    public boolean containsAsSubgraph(DirectedGraph g) {
        boolean test = true;
        GraphIterator<Edge> ei = g.edgeIterator();
        while (ei.hasNext() && test) {
            test = this.contains(ei.next());
        }
        GraphIterator<Vertex> vi = g.vertices.iterator();
        while (vi.hasNext() && test) {
            test = this.contains(vi.next());
        }
        return test;
    }

    public Set<Vertex>[] assignVerticesToStrongComponents() {
        DepthFirstSearch dfsa = new DepthFirstSearch(this, this.getSources(), true, true, false);
        DepthFirstSearch dfsb = new DepthFirstSearch(this, dfsa.topologicalSort(), true, false, true);
        HashSet<Vertex> sccSeeds = new HashSet<Vertex>(dfsb.seedsUsed());
        Set[] sccVertices = new Set[sccSeeds.size()];
        Vertex[] finishOrder = dfsb.topologicalSort();
        int n = finishOrder.length;
        int j = 0;
        for (int i = 0; i < sccSeeds.size(); ++i) {
            sccVertices[i] = new HashSet(1);
            do {
                sccVertices[i].add(finishOrder[j++]);
            } while (j < n && !sccSeeds.contains(finishOrder[j]));
        }
        return sccVertices;
    }

    public Vector<Vertex> getEntryPoints() {
        Vertex[] sources = this.vertices().getSources();
        TreeSet<Vertex> entryPointSet = new TreeSet<Vertex>();
        Vector<Vertex> entryPoints = new Vector<Vertex>(sources.length);
        for (Vertex source : sources) {
            entryPointSet.add(source);
        }
        Set<Vertex> descendantsOfSources = this.getDescendants(sources);
        Set<Vertex> nonDescendants = this.vertices().toSet();
        nonDescendants.removeAll(descendantsOfSources);
        if (nonDescendants.size() > 0) {
            Vertex v = null;
            Vertex[] nonDescendantVertices = nonDescendants.toArray(new Vertex[0]);
            DirectedGraph g = this.inducedSubgraph(nonDescendantVertices);
            Set<Vertex>[] strongComponents = g.assignVerticesToStrongComponents();
            int n = strongComponents.length;
            for (int i = 0; i < n; ++i) {
                Iterator<Vertex> iter = strongComponents[i].iterator();
                if (!iter.hasNext()) continue;
                Vertex u = iter.next();
                Set<Vertex> parents = this.getParents(u);
                while (iter.hasNext()) {
                    v = iter.next();
                    parents.addAll(this.getParents(v));
                    if (v.key() >= u.key()) continue;
                    u = v;
                }
                if (!strongComponents[i].containsAll(parents)) continue;
                entryPointSet.add(u);
            }
        }
        Iterator iter = entryPointSet.iterator();
        while (iter.hasNext()) {
            entryPoints.add(0, (Vertex)iter.next());
        }
        return entryPoints;
    }

    public Set<Vertex> getVertices() {
        return this.vertices().toSet();
    }

    public Vertex[] getVertexArray() {
        return this.vertices.toArray();
    }

    public Set<Edge> getEdges() {
        return this.edges().toSet();
    }

    public Edge[] getEdgeArray() {
        return this.edges.toArray();
    }

    public int numVertices() {
        return this.vertices().size();
    }

    public int numEdges() {
        return this.edges().size();
    }

    public boolean add(Vertex v) {
        return this.vertices().add(v);
    }

    public boolean add(Edge e) {
        return this.edges().add(e);
    }

    public boolean remove(Vertex v) {
        return this.vertices().remove(v);
    }

    public boolean remove(Edge e) {
        return this.edges().remove(e);
    }

    public boolean contains(Vertex v) {
        return this.vertices().contains(v);
    }

    public boolean contains(Edge e) {
        return this.edges().contains(e);
    }

    public int numSinks() {
        return this.vertices().numSinks();
    }

    public int numSources() {
        return this.vertices().numSources();
    }

    public Vertex[] getSources() {
        return this.vertices().getSources();
    }

    public Vertex[] getSinks() {
        return this.vertices().getSinks();
    }

    public Set<Vertex> getVerticesInContainingComponent(Vertex v) {
        HashSet<Vertex> verticesInComponent = new HashSet<Vertex>();
        HashSet<Vertex> toDo = new HashSet<Vertex>();
        HashSet<Vertex> toDoNext = new HashSet<Vertex>();
        toDo.add(v);
        while (!toDo.isEmpty()) {
            Set<Vertex> neighborhood = this.getNeighborhood(toDo);
            for (Vertex u : neighborhood) {
                if (verticesInComponent.contains(u) || toDo.contains(u)) continue;
                toDoNext.add(u);
                verticesInComponent.add(u);
            }
            toDo.clear();
            toDo.addAll(toDoNext);
            toDoNext.clear();
        }
        return verticesInComponent;
    }

    public DirectedGraph getComponentContaining(Vertex v) {
        Vertex[] verts = this.getVerticesInContainingComponent(v).toArray(new Vertex[0]);
        return this.inducedSubgraph(verts);
    }

    public DirectedGraph[] getComponents() {
        HashSet<Vertex> accountedFor = new HashSet<Vertex>(this.numVertices());
        HashSet<Vertex> toDo = new HashSet<Vertex>(this.numVertices());
        ArrayList<DirectedGraph> components = new ArrayList<DirectedGraph>();
        GraphIterator<Vertex> vertIter = this.vertexIterator();
        while (vertIter.hasNext()) {
            Vertex v = vertIter.next();
            if (accountedFor.contains(v)) continue;
            DirectedGraph g = new DirectedGraph();
            toDo.add(v);
            while (!toDo.isEmpty()) {
                Edge e;
                int i;
                Iterator iter = toDo.iterator();
                if (!iter.hasNext()) continue;
                Vertex u = (Vertex)iter.next();
                g.add(u);
                accountedFor.add(u);
                Edge[] incomingEdges = this.incomingEdges(u);
                for (i = 0; i < incomingEdges.length; ++i) {
                    e = incomingEdges[i];
                    g.add(e);
                    if (accountedFor.contains(e.from())) continue;
                    toDo.add(e.from());
                }
                Edge[] outgoingEdges = this.outgoingEdges(u);
                for (i = 0; i < outgoingEdges.length; ++i) {
                    e = outgoingEdges[i];
                    g.add(e);
                    if (accountedFor.contains(e.to())) continue;
                    toDo.add(e.to());
                }
                Edge[] selfEdges = this.selfEdges(u);
                for (i = 0; i < selfEdges.length; ++i) {
                    e = selfEdges[i];
                    g.add(e);
                }
                toDo.remove(u);
            }
            components.add(g);
        }
        return components.toArray(new DirectedGraph[0]);
    }

    public void intersectionWith(DirectedGraph otherGraph) {
        GraphIterator<Vertex> vi = otherGraph.vertices.iterator();
        while (vi.hasNext()) {
            Vertex v = vi.next();
            if (this.contains(v)) continue;
            vi.remove();
        }
        GraphIterator<Edge> ei = otherGraph.edgeIterator();
        while (ei.hasNext()) {
            Edge e = ei.next();
            if (this.contains(e)) continue;
            ei.remove();
        }
    }

    public void unionWith(DirectedGraph otherGraph) {
        GraphIterator<Vertex> vi = otherGraph.vertexIterator();
        while (vi.hasNext()) {
            this.add(vi.next());
        }
        GraphIterator<Edge> ei = otherGraph.edgeIterator();
        while (ei.hasNext()) {
            this.add(ei.next());
        }
    }

    public DirectedGraph descendantsGraph(Vertex[] seeds) {
        Vertex[] descendants = this.getDescendants(seeds).toArray(new Vertex[0]);
        return this.inducedSubgraph(descendants);
    }

    public DirectedGraph inducedSubgraph(Vertex[] vertexSet) {
        DirectedGraph newGraph = new DirectedGraph(vertexSet.length, this.numEdges());
        for (Vertex element : vertexSet) {
            if (!this.contains(element)) continue;
            newGraph.add(element);
        }
        GraphIterator<Edge> ei = this.edgeIterator();
        while (ei.hasNext()) {
            Edge e = ei.next();
            if (!newGraph.contains(e.from()) || !newGraph.contains(e.to())) continue;
            newGraph.add(e);
        }
        return newGraph;
    }

    public Set<Vertex> getNeighborhood(Vertex v) {
        Set<Vertex> neighborhood = this.getChildren(v);
        neighborhood.addAll(this.getParents(v));
        neighborhood.add(v);
        return neighborhood;
    }

    public Set<Vertex> getNeighborhood(Set<Vertex> vs) {
        HashSet<Vertex> neighborhood = new HashSet<Vertex>(2 * vs.size());
        Iterator<Vertex> iter = vs.iterator();
        while (iter.hasNext()) {
            neighborhood.addAll(this.getNeighborhood(iter.next()));
        }
        return neighborhood;
    }

    public Object getReferent(Vertex v) {
        return v.referent();
    }

    public IntegerAttribute<Vertex> getLevels() {
        IntegerAttribute<Vertex> levels = new IntegerAttribute<Vertex>("Levels", this.vertices());
        DepthFirstSearch dfs = new DepthFirstSearch(this, this.getSources(), true, true, false);
        Vertex[] topologicalSort = dfs.topologicalSort();
        int numVertices = this.numVertices();
        try {
            int i;
            for (i = 0; i < numVertices; ++i) {
                levels.setValue(topologicalSort[i], -1);
            }
            for (i = 0; i < numVertices; ++i) {
                Vertex v = topologicalSort[i];
                Set<Vertex> parents = this.getParents(v);
                int maxParentLevel = -1;
                for (Vertex parent : parents) {
                    if (levels.getValue(parent) <= maxParentLevel) continue;
                    maxParentLevel = levels.getValue(parent);
                }
                levels.setValue(v, maxParentLevel + 1);
            }
        }
        catch (NoValueException exc) {
            Msg.error((Object)this, (Object)"Bad set/get in getLevels()");
        }
        return levels;
    }

    public IntegerAttribute<Vertex> complexityDepth() {
        IntegerAttribute complexityDepth;
        if (this.vertexAttributes.hasAttributeNamed("ComplexityDepth")) {
            complexityDepth = (IntegerAttribute)this.vertexAttributes.getAttribute("ComplexityDepth");
            complexityDepth.clear();
        } else {
            complexityDepth = (IntegerAttribute)this.vertexAttributes.createAttribute("ComplexityDepth", "INTEGER_TYPE");
        }
        DepthFirstSearch dfs = new DepthFirstSearch(this, this.getSources(), true, true, false);
        Vertex[] topologicalSort = dfs.topologicalSort();
        int numVertices = this.numVertices();
        int maximumLevel = -1;
        try {
            int i;
            for (i = 0; i < numVertices; ++i) {
                complexityDepth.setValue(topologicalSort[i], -1);
            }
            for (i = numVertices - 1; i >= 0; --i) {
                Vertex v = topologicalSort[i];
                Set<Vertex> children = this.getChildren(v);
                int maxChildLevel = -1;
                for (Vertex child : children) {
                    if (complexityDepth.getValue(child) <= maxChildLevel) continue;
                    maxChildLevel = complexityDepth.getValue(child);
                }
                complexityDepth.setValue(v, maxChildLevel + 1);
                if (maxChildLevel + 1 <= maximumLevel) continue;
                maximumLevel = maxChildLevel + 1;
            }
        }
        catch (NoValueException exc) {
            Msg.error((Object)this, (Object)"Bad get/set in complexityDepth()");
        }
        return complexityDepth;
    }

    public Edge[] getEdges(Vertex from, Vertex to) {
        Set<Edge> outgoingEdges = this.getOutgoingEdges(from);
        Iterator<Edge> iter = outgoingEdges.iterator();
        while (iter.hasNext()) {
            Edge e = iter.next();
            if (e.to() == to) continue;
            iter.remove();
        }
        return outgoingEdges.toArray(new Edge[0]);
    }

    public boolean areRelatedAs(Vertex parent, Vertex child) {
        Set<Edge> outgoingEdges = this.getOutgoingEdges(parent);
        for (Edge e : outgoingEdges) {
            if (e.to() != child) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.edges.clear();
        this.vertices.clear();
        this.edgeAttributes.clear();
        this.vertexAttributes.clear();
    }

    public AttributeManager<Vertex> vertexAttributes() {
        return this.vertexAttributes;
    }

    public AttributeManager<Edge> edgeAttributes() {
        return this.edgeAttributes;
    }

    public Vertex[] getVerticesHavingReferent(Object o) {
        int cnt = 0;
        if (o == null) {
            return new Vertex[0];
        }
        Vertex[] temp = new Vertex[this.numVertices()];
        GraphIterator<Vertex> iter = this.vertexIterator();
        while (iter.hasNext()) {
            Vertex v = iter.next();
            if (v.referent() == null || !v.referent().equals(o)) continue;
            temp[cnt++] = v;
        }
        Vertex[] ans = new Vertex[cnt];
        System.arraycopy(temp, 0, ans, 0, cnt);
        return ans;
    }

    public DirectedGraph copy() {
        DirectedGraph copy = new DirectedGraph(this.numVertices(), this.numEdges());
        this.copyAll(copy);
        return copy;
    }

    protected void copyAll(DirectedGraph copy) {
        GraphIterator<Vertex> iter1 = this.vertexIterator();
        while (iter1.hasNext()) {
            Vertex v = iter1.next();
            copy.add(v);
        }
        this.CopyVertexAttributes(copy);
        GraphIterator<Edge> iter2 = this.edgeIterator();
        while (iter2.hasNext()) {
            Edge e = iter2.next();
            copy.add(e);
        }
        this.CopyEdgeAttributes(copy);
    }

    private void CopyEdgeAttributes(DirectedGraph copy) {
        AttributeManager<Edge> attm = this.edgeAttributes;
        AttributeManager<Edge> copyManager = copy.edgeAttributes();
        String[] names = attm.getAttributeNames();
        ArrayList<Attribute<Edge>> attrs = new ArrayList<Attribute<Edge>>(names.length);
        for (String name : names) {
            attrs.add(attm.getAttribute(name));
        }
        for (int i = 0; i < names.length; ++i) {
            Edge v;
            GraphIterator<Edge> iter;
            Attribute dattrCopy;
            Attribute attribute = (Attribute)attrs.get(i);
            if (attribute instanceof DoubleAttribute) {
                DoubleAttribute dattr = (DoubleAttribute)attribute;
                dattrCopy = (DoubleAttribute)copyManager.createAttribute(names[i], "DOUBLE_TYPE");
                iter = this.edgeIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    try {
                        ((DoubleAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                    }
                    catch (NoValueException noValueException) {}
                }
                continue;
            }
            if (attribute instanceof IntegerAttribute) {
                IntegerAttribute dattr = (IntegerAttribute)attribute;
                dattrCopy = (IntegerAttribute)copyManager.createAttribute(names[i], "INTEGER_TYPE");
                iter = this.edgeIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    try {
                        ((IntegerAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                    }
                    catch (NoValueException noValueException) {}
                }
                continue;
            }
            if (attribute instanceof LongAttribute) {
                LongAttribute dattr = (LongAttribute)attribute;
                dattrCopy = (LongAttribute)copyManager.createAttribute(names[i], "LONG_TYPE");
                iter = this.edgeIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    try {
                        ((LongAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                    }
                    catch (NoValueException noValueException) {}
                }
                continue;
            }
            if (attribute instanceof ObjectAttribute) {
                ObjectAttribute dattr = (ObjectAttribute)attribute;
                dattrCopy = (ObjectAttribute)copyManager.createAttribute(names[i], "OBJECT_TYPE");
                iter = this.edgeIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    ((ObjectAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                }
                continue;
            }
            if (!(attribute instanceof StringAttribute)) continue;
            StringAttribute dattr = (StringAttribute)attribute;
            dattrCopy = (StringAttribute)copyManager.createAttribute(names[i], "STRING_TYPE");
            iter = this.edgeIterator();
            while (iter.hasNext()) {
                v = iter.next();
                ((StringAttribute)dattrCopy).setValue(v, dattr.getValue(v));
            }
        }
    }

    private void CopyVertexAttributes(DirectedGraph copy) {
        AttributeManager<Vertex> attm = this.vertexAttributes;
        AttributeManager<Vertex> copyManager = copy.vertexAttributes();
        String[] names = attm.getAttributeNames();
        ArrayList<Attribute<Vertex>> attrs = new ArrayList<Attribute<Vertex>>();
        for (String name : names) {
            attrs.add(attm.getAttribute(name));
        }
        for (int i = 0; i < names.length; ++i) {
            Vertex v;
            GraphIterator<Vertex> iter;
            Attribute dattrCopy;
            Attribute attribute = (Attribute)attrs.get(i);
            if (attribute instanceof DoubleAttribute) {
                DoubleAttribute dattr = (DoubleAttribute)attribute;
                dattrCopy = (DoubleAttribute)copyManager.createAttribute(names[i], "DOUBLE_TYPE");
                iter = this.vertexIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    try {
                        ((DoubleAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                    }
                    catch (NoValueException noValueException) {}
                }
                continue;
            }
            if (attribute instanceof IntegerAttribute) {
                IntegerAttribute dattr = (IntegerAttribute)attribute;
                dattrCopy = (IntegerAttribute)copyManager.createAttribute(names[i], "INTEGER_TYPE");
                iter = this.vertexIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    try {
                        ((IntegerAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                    }
                    catch (NoValueException noValueException) {}
                }
                continue;
            }
            if (attribute instanceof LongAttribute) {
                LongAttribute dattr = (LongAttribute)attribute;
                dattrCopy = (LongAttribute)copyManager.createAttribute(names[i], "LONG_TYPE");
                iter = this.vertexIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    try {
                        ((LongAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                    }
                    catch (NoValueException noValueException) {}
                }
                continue;
            }
            if (attribute instanceof ObjectAttribute) {
                ObjectAttribute dattr = (ObjectAttribute)attribute;
                dattrCopy = (ObjectAttribute)copyManager.createAttribute(names[i], "OBJECT_TYPE");
                iter = this.vertexIterator();
                while (iter.hasNext()) {
                    v = iter.next();
                    ((ObjectAttribute)dattrCopy).setValue(v, dattr.getValue(v));
                }
                continue;
            }
            if (!(attribute instanceof StringAttribute)) continue;
            StringAttribute dattr = (StringAttribute)attribute;
            dattrCopy = (StringAttribute)copyManager.createAttribute(names[i], "STRING_TYPE");
            iter = this.vertexIterator();
            while (iter.hasNext()) {
                v = iter.next();
                ((StringAttribute)dattrCopy).setValue(v, dattr.getValue(v));
            }
        }
    }

    protected void copyVertex(Vertex node, DirectedGraph other) {
        this.add(node);
        if (other != null) {
            this.copyVertexAttributeValues(node, other);
        }
    }

    protected void copyEdge(Edge e, DirectedGraph other) {
        Vertex srcVtx = e.from();
        Vertex dstVtx = e.to();
        Edge newe = new Edge(srcVtx, dstVtx);
        this.add(newe);
        this.copyEdgeAttributeValues(newe, e, other);
    }

    protected void copyEdgeAttributeValues(Edge newe, Edge e, DirectedGraph other) {
        String[] vamNames;
        AttributeManager<Edge> aman = other.edgeAttributes();
        for (String vamName : vamNames = aman.getAttributeNames()) {
            Object o;
            ObjectAttribute att = (ObjectAttribute)aman.getAttribute(vamName);
            if (!this.edgeAttributes().hasAttributeNamed(vamName)) {
                this.edgeAttributes().createAttribute(vamName, att.attributeType());
            }
            if ((o = other.getEdgeProperty(vamName, e)) == null) continue;
            this.setEdgeProperty(vamName, newe, o);
        }
    }

    public DirectedGraph join(DirectedGraph other) {
        GraphIterator<Vertex> nodes = other.vertices().iterator();
        while (nodes.hasNext()) {
            Vertex vert = nodes.next();
            this.copyVertex(vert, other);
        }
        GraphIterator<Edge> ei = other.edgeIterator();
        while (ei.hasNext()) {
            Edge e = ei.next();
            this.copyEdge(e, other);
        }
        return this;
    }

    protected void copyVertexAttributeValues(Vertex vert, DirectedGraph other) {
        String[] vamNames;
        AttributeManager<Vertex> aman = other.vertexAttributes();
        for (String vamName : vamNames = aman.getAttributeNames()) {
            Object o;
            ObjectAttribute att = (ObjectAttribute)aman.getAttribute(vamName);
            if (!this.vertexAttributes().hasAttributeNamed(vamName)) {
                this.vertexAttributes().createAttribute(vamName, att.attributeType());
            }
            if ((o = other.getVertexProperty(vamName, vert)) == null) continue;
            this.setVertexProperty(vamName, vert, o);
        }
    }

    protected void setEdgeProperty(String propName, Edge e, Object prop) {
        ObjectAttribute<Edge> attrib = this.getEdgeAttribute(propName);
        attrib.setValue(e, prop);
    }

    protected Object getEdgeProperty(String propName, Edge e) {
        ObjectAttribute<Edge> attrib = this.getEdgeAttribute(propName);
        Object o = attrib.getValue(e);
        return o;
    }

    protected void setVertexProperty(String propName, Vertex v, Object prop) {
        ObjectAttribute<Vertex> attrib = this.getVertexAttribute(propName);
        attrib.setValue(v, prop);
    }

    protected Object getVertexProperty(String propName, Vertex v) {
        ObjectAttribute<Vertex> attrib = this.getVertexAttribute(propName);
        return attrib.getValue(v);
    }

    protected ObjectAttribute<Edge> getEdgeAttribute(String attribName) {
        AttributeManager<Edge> am = this.edgeAttributes();
        Attribute<Edge> attrib = am.getAttribute(attribName);
        if (attrib == null) {
            attrib = this.edgeAttributes().createAttribute(attribName, "OBJECT_TYPE");
            Msg.debug((Object)this, (Object)("creating edge property: " + attribName));
        }
        return (ObjectAttribute)attrib;
    }

    protected ObjectAttribute<Vertex> getVertexAttribute(String attribName) {
        AttributeManager<Vertex> am = this.vertexAttributes();
        Attribute<Vertex> attrib = am.getAttribute(attribName);
        if (attrib == null) {
            attrib = this.vertexAttributes().createAttribute(attribName, "OBJECT_TYPE");
        }
        return (ObjectAttribute)attrib;
    }

    public static Set<?> verts2referentSet(Collection<Vertex> verts) {
        HashSet<Object> s = new HashSet<Object>();
        for (Vertex vert : verts) {
            s.add(vert.referent());
        }
        return s;
    }
}

