/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.RedBlackEntry;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import org.apache.commons.collections4.iterators.EmptyListIterator;

public class RedBlackTree<K extends Comparable<K>, V>
implements Iterable<RedBlackEntry<K, V>> {
    private RedBlackEntry<K, V> root;
    private int size;
    private int modCount = 0;
    private RedBlackEntry<K, V> maxEntry;
    private RedBlackEntry<K, V> minEntry;

    public int size() {
        return this.size;
    }

    public boolean containsKey(K key) {
        RedBlackEntry<K, V> node = this.getNode(key);
        return node != null;
    }

    public RedBlackEntry<K, V> getFirst() {
        return this.minEntry;
    }

    public RedBlackEntry<K, V> getLast() {
        return this.maxEntry;
    }

    public RedBlackEntry<K, V> getEntryLessThanEqual(K key) {
        RedBlackEntry<K, V> bestNode = null;
        RedBlackEntry<K, V> node = this.root;
        while (node != null) {
            int result = key.compareTo((Comparable)((Comparable)node.key));
            if (result == 0) {
                return node;
            }
            if (result < 0) {
                node = node.left;
                continue;
            }
            bestNode = node;
            node = node.right;
        }
        return bestNode;
    }

    public RedBlackEntry<K, V> getEntryGreaterThanEqual(K key) {
        RedBlackEntry<K, V> bestNode = null;
        RedBlackEntry<K, V> node = this.root;
        while (node != null) {
            int result = key.compareTo((Comparable)((Comparable)node.key));
            if (result == 0) {
                return node;
            }
            if (result < 0) {
                bestNode = node;
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return bestNode;
    }

    public V put(K key, V value) {
        RedBlackEntry<K, V> node = this.getOrCreateEntry(key);
        V oldValue = node.getValue();
        node.setValue(value);
        return oldValue;
    }

    public RedBlackEntry<K, V> getOrCreateEntry(K key) {
        if (this.root == null) {
            ++this.size;
            ++this.modCount;
            this.root = new RedBlackEntry<K, Object>(key, null, null);
            this.maxEntry = this.root;
            this.minEntry = this.root;
            return this.root;
        }
        if (key.compareTo((Comparable)((Comparable)this.maxEntry.key)) > 0) {
            ++this.size;
            ++this.modCount;
            RedBlackEntry<K, Object> newNode = new RedBlackEntry<K, Object>(key, null, this.maxEntry);
            this.maxEntry.right = newNode;
            this.maxEntry = newNode;
            this.fixAfterInsertion(this.maxEntry);
            return newNode;
        }
        RedBlackEntry<K, V> node = this.root;
        while (true) {
            int comp;
            if ((comp = key.compareTo((Comparable)((Comparable)node.key))) == 0) {
                return node;
            }
            if (comp < 0) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                ++this.size;
                ++this.modCount;
                RedBlackEntry<K, Object> newNode = new RedBlackEntry<K, Object>(key, null, node);
                node.left = newNode;
                if (node == this.minEntry) {
                    this.minEntry = newNode;
                }
                this.fixAfterInsertion(node.left);
                return newNode;
            }
            if (node.right == null) break;
            node = node.right;
        }
        ++this.size;
        ++this.modCount;
        RedBlackEntry<K, Object> newNode = new RedBlackEntry<K, Object>(key, null, node);
        node.right = newNode;
        if (node == this.maxEntry) {
            this.maxEntry = newNode;
        }
        this.fixAfterInsertion(node.right);
        return newNode;
    }

    public RedBlackEntry<K, V> getEntry(K key) {
        return this.getNode(key);
    }

    private RedBlackEntry<K, V> getNode(K key) {
        RedBlackEntry<K, V> node = this.getEntryLessThanEqual(key);
        if (node != null && ((Comparable)node.getKey()).equals(key)) {
            return node;
        }
        return null;
    }

    public V remove(K key) {
        RedBlackEntry<K, V> node = this.getNode(key);
        if (node == null) {
            return null;
        }
        Object value = node.value;
        this.deleteEntry(node);
        return value;
    }

    public void removeNode(RedBlackEntry<K, V> node) {
        this.deleteEntry(node);
    }

    public void removeAll() {
        this.size = 0;
        ++this.modCount;
        this.root = null;
        this.maxEntry = null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public ListIterator<RedBlackEntry<K, V>> iterator() {
        return new RedBlackTreeIterator(true);
    }

    public ListIterator<RedBlackEntry<K, V>> iterator(boolean forward) {
        return new RedBlackTreeIterator(forward);
    }

    public ListIterator<RedBlackEntry<K, V>> iterator(RedBlackEntry<K, V> firstEntry, boolean forward) {
        if (firstEntry == null) {
            return EmptyListIterator.INSTANCE;
        }
        return new RedBlackTreeIterator(firstEntry, forward);
    }

    public ListIterator<RedBlackEntry<K, V>> iterator(K key, boolean forward) {
        RedBlackEntry<K, V> entry = forward ? this.getEntryGreaterThanEqual(key) : this.getEntryLessThanEqual(key);
        return new RedBlackTreeIterator(entry, forward);
    }

    private static <K, V> RedBlackEntry.NodeColor colorOf(RedBlackEntry<K, V> p) {
        return p == null ? RedBlackEntry.NodeColor.BLACK : p.color;
    }

    private static <K, V> RedBlackEntry<K, V> parentOf(RedBlackEntry<K, V> p) {
        return p == null ? null : p.parent;
    }

    private static <K, V> void setColor(RedBlackEntry<K, V> p, RedBlackEntry.NodeColor c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> RedBlackEntry<K, V> leftOf(RedBlackEntry<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> RedBlackEntry<K, V> rightOf(RedBlackEntry<K, V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(RedBlackEntry<K, V> p) {
        RedBlackEntry r = p.right;
        p.right = r.left;
        if (r.left != null) {
            r.left.parent = p;
        }
        r.parent = p.parent;
        if (p.parent == null) {
            this.root = r;
        } else if (p.parent.left == p) {
            p.parent.left = r;
        } else {
            p.parent.right = r;
        }
        r.left = p;
        p.parent = r;
    }

    private void rotateRight(RedBlackEntry<K, V> p) {
        RedBlackEntry l = p.left;
        p.left = l.right;
        if (l.right != null) {
            l.right.parent = p;
        }
        l.parent = p.parent;
        if (p.parent == null) {
            this.root = l;
        } else if (p.parent.right == p) {
            p.parent.right = l;
        } else {
            p.parent.left = l;
        }
        l.right = p;
        p.parent = l;
    }

    private void fixAfterInsertion(RedBlackEntry<K, V> x) {
        x.color = RedBlackEntry.NodeColor.RED;
        while (x != null && x != this.root && x.parent.color == RedBlackEntry.NodeColor.RED) {
            RedBlackEntry<K, V> y;
            if (RedBlackTree.parentOf(x) == RedBlackTree.leftOf(RedBlackTree.parentOf(RedBlackTree.parentOf(x)))) {
                y = RedBlackTree.rightOf(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
                if (RedBlackTree.colorOf(y) == RedBlackEntry.NodeColor.RED) {
                    RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.BLACK);
                    RedBlackTree.setColor(y, RedBlackEntry.NodeColor.BLACK);
                    RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackEntry.NodeColor.RED);
                    x = RedBlackTree.parentOf(RedBlackTree.parentOf(x));
                    continue;
                }
                if (x == RedBlackTree.rightOf(RedBlackTree.parentOf(x))) {
                    x = RedBlackTree.parentOf(x);
                    this.rotateLeft(x);
                }
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackEntry.NodeColor.RED);
                if (RedBlackTree.parentOf(RedBlackTree.parentOf(x)) == null) continue;
                this.rotateRight(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
                continue;
            }
            y = RedBlackTree.leftOf(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
            if (RedBlackTree.colorOf(y) == RedBlackEntry.NodeColor.RED) {
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.BLACK);
                RedBlackTree.setColor(y, RedBlackEntry.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackEntry.NodeColor.RED);
                x = RedBlackTree.parentOf(RedBlackTree.parentOf(x));
                continue;
            }
            if (x == RedBlackTree.leftOf(RedBlackTree.parentOf(x))) {
                x = RedBlackTree.parentOf(x);
                this.rotateRight(x);
            }
            RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.BLACK);
            RedBlackTree.setColor(RedBlackTree.parentOf(RedBlackTree.parentOf(x)), RedBlackEntry.NodeColor.RED);
            if (RedBlackTree.parentOf(RedBlackTree.parentOf(x)) == null) continue;
            this.rotateLeft(RedBlackTree.parentOf(RedBlackTree.parentOf(x)));
        }
        this.root.color = RedBlackEntry.NodeColor.BLACK;
    }

    public void deleteEntry(RedBlackEntry<K, V> p) {
        RedBlackEntry replacement;
        ++this.modCount;
        --this.size;
        if (p == this.minEntry) {
            this.minEntry = p.getSuccessor();
        }
        if (p == this.maxEntry) {
            this.maxEntry = p.getPredecessor();
        }
        if (p.left != null && p.right != null) {
            RedBlackEntry<K, V> node = p.getSuccessor();
            this.swapPosition(node, p);
        }
        RedBlackEntry redBlackEntry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p.isLeftChild()) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color == RedBlackEntry.NodeColor.BLACK) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color == RedBlackEntry.NodeColor.BLACK) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p.isLeftChild()) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
        p.color = null;
    }

    private void fixAfterDeletion(RedBlackEntry<K, V> x) {
        while (x != this.root && RedBlackTree.colorOf(x) == RedBlackEntry.NodeColor.BLACK) {
            RedBlackEntry<K, V> sib;
            if (x == RedBlackTree.leftOf(RedBlackTree.parentOf(x))) {
                sib = RedBlackTree.rightOf(RedBlackTree.parentOf(x));
                if (RedBlackTree.colorOf(sib) == RedBlackEntry.NodeColor.RED) {
                    RedBlackTree.setColor(sib, RedBlackEntry.NodeColor.BLACK);
                    RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.RED);
                    this.rotateLeft(RedBlackTree.parentOf(x));
                    sib = RedBlackTree.rightOf(RedBlackTree.parentOf(x));
                }
                if (RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) == RedBlackEntry.NodeColor.BLACK && RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) == RedBlackEntry.NodeColor.BLACK) {
                    RedBlackTree.setColor(sib, RedBlackEntry.NodeColor.RED);
                    x = RedBlackTree.parentOf(x);
                    continue;
                }
                if (RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) == RedBlackEntry.NodeColor.BLACK) {
                    RedBlackTree.setColor(RedBlackTree.leftOf(sib), RedBlackEntry.NodeColor.BLACK);
                    RedBlackTree.setColor(sib, RedBlackEntry.NodeColor.RED);
                    this.rotateRight(sib);
                    sib = RedBlackTree.rightOf(RedBlackTree.parentOf(x));
                }
                RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOf(x)));
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.rightOf(sib), RedBlackEntry.NodeColor.BLACK);
                this.rotateLeft(RedBlackTree.parentOf(x));
                x = this.root;
                continue;
            }
            sib = RedBlackTree.leftOf(RedBlackTree.parentOf(x));
            if (RedBlackTree.colorOf(sib) == RedBlackEntry.NodeColor.RED) {
                RedBlackTree.setColor(sib, RedBlackEntry.NodeColor.BLACK);
                RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.RED);
                this.rotateRight(RedBlackTree.parentOf(x));
                sib = RedBlackTree.leftOf(RedBlackTree.parentOf(x));
            }
            if (RedBlackTree.colorOf(RedBlackTree.rightOf(sib)) == RedBlackEntry.NodeColor.BLACK && RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) == RedBlackEntry.NodeColor.BLACK) {
                RedBlackTree.setColor(sib, RedBlackEntry.NodeColor.RED);
                x = RedBlackTree.parentOf(x);
                continue;
            }
            if (RedBlackTree.colorOf(RedBlackTree.leftOf(sib)) == RedBlackEntry.NodeColor.BLACK) {
                RedBlackTree.setColor(RedBlackTree.rightOf(sib), RedBlackEntry.NodeColor.BLACK);
                RedBlackTree.setColor(sib, RedBlackEntry.NodeColor.RED);
                this.rotateLeft(sib);
                sib = RedBlackTree.leftOf(RedBlackTree.parentOf(x));
            }
            RedBlackTree.setColor(sib, RedBlackTree.colorOf(RedBlackTree.parentOf(x)));
            RedBlackTree.setColor(RedBlackTree.parentOf(x), RedBlackEntry.NodeColor.BLACK);
            RedBlackTree.setColor(RedBlackTree.leftOf(sib), RedBlackEntry.NodeColor.BLACK);
            this.rotateRight(RedBlackTree.parentOf(x));
            x = this.root;
        }
        RedBlackTree.setColor(x, RedBlackEntry.NodeColor.BLACK);
    }

    private void swapPosition(RedBlackEntry<K, V> x, RedBlackEntry<K, V> y) {
        boolean yWasLeftChild;
        RedBlackEntry px = x.parent;
        RedBlackEntry lx = x.left;
        RedBlackEntry rx = x.right;
        RedBlackEntry py = y.parent;
        RedBlackEntry ly = y.left;
        RedBlackEntry ry = y.right;
        boolean xWasLeftChild = px != null && x == px.left;
        boolean bl = yWasLeftChild = py != null && y == py.left;
        if (x == py) {
            x.parent = y;
            if (yWasLeftChild) {
                y.left = x;
                y.right = rx;
            } else {
                y.right = x;
                y.left = lx;
            }
        } else {
            x.parent = py;
            if (py != null) {
                if (yWasLeftChild) {
                    py.left = x;
                } else {
                    py.right = x;
                }
            }
            y.left = lx;
            y.right = rx;
        }
        if (y == px) {
            y.parent = x;
            if (xWasLeftChild) {
                x.left = y;
                x.right = ry;
            } else {
                x.right = y;
                x.left = ly;
            }
        } else {
            y.parent = px;
            if (px != null) {
                if (xWasLeftChild) {
                    px.left = y;
                } else {
                    px.right = y;
                }
            }
            x.left = ly;
            x.right = ry;
        }
        if (x.left != null) {
            x.left.parent = x;
        }
        if (x.right != null) {
            x.right.parent = x;
        }
        if (y.left != null) {
            y.left.parent = y;
        }
        if (y.right != null) {
            y.right.parent = y;
        }
        RedBlackEntry.NodeColor c = x.color;
        x.color = y.color;
        y.color = c;
        if (this.root == x) {
            this.root = y;
        } else if (this.root == y) {
            this.root = x;
        }
    }

    private class RedBlackTreeIterator
    implements ListIterator<RedBlackEntry<K, V>> {
        private RedBlackEntry<K, V> nextNode;
        private RedBlackEntry<K, V> previousNode;
        private RedBlackEntry<K, V> lastReturnedNode;
        private final boolean forward;
        private int expectedModCount;

        RedBlackTreeIterator(boolean forward) {
            this.expectedModCount = RedBlackTree.this.modCount;
            this.forward = forward;
            if (!RedBlackTree.this.isEmpty()) {
                this.nextNode = forward ? RedBlackTree.this.getFirst() : RedBlackTree.this.getLast();
                this.previousNode = null;
            }
        }

        RedBlackTreeIterator(RedBlackEntry<K, V> firstNode, boolean forward) {
            this.expectedModCount = RedBlackTree.this.modCount;
            this.forward = forward;
            this.nextNode = firstNode;
            this.previousNode = firstNode != null ? (forward ? this.nextNode.getPredecessor() : this.nextNode.getSuccessor()) : (forward ? RedBlackTree.this.getLast() : RedBlackTree.this.getFirst());
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.previousNode != null;
        }

        @Override
        public RedBlackEntry<K, V> next() {
            if (RedBlackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextNode == null) {
                return null;
            }
            this.lastReturnedNode = this.nextNode;
            this.previousNode = this.nextNode;
            this.nextNode = this.forward ? this.nextNode.getSuccessor() : this.nextNode.getPredecessor();
            return this.lastReturnedNode;
        }

        @Override
        public RedBlackEntry<K, V> previous() {
            if (RedBlackTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.previousNode == null) {
                return null;
            }
            this.lastReturnedNode = this.previousNode;
            this.nextNode = this.previousNode;
            this.previousNode = this.forward ? this.previousNode.getPredecessor() : this.previousNode.getSuccessor();
            return this.lastReturnedNode;
        }

        @Override
        public void remove() {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException("next has not been called or remove has already been called");
            }
            RedBlackTree.this.deleteEntry(this.lastReturnedNode);
            this.previousNode = this.nextNode != null ? (this.forward ? this.nextNode.getPredecessor() : this.nextNode.getSuccessor()) : (this.forward ? RedBlackTree.this.getLast() : RedBlackTree.this.getFirst());
            this.lastReturnedNode = null;
            this.expectedModCount = RedBlackTree.this.modCount;
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(RedBlackEntry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(RedBlackEntry<K, V> e) {
            throw new UnsupportedOperationException();
        }
    }
}

