/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeFactory;

public class ClangTypeToken
extends ClangToken {
    private DataType datatype = null;

    public ClangTypeToken(ClangNode par) {
        super(par);
    }

    @Override
    public boolean isVariableRef() {
        return this.Parent() instanceof ClangVariableDecl;
    }

    public DataType getDataType() {
        return this.datatype;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        long id = 0L;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_ID.id()) continue;
            id = decoder.readUnsignedInteger();
            break;
        }
        decoder.rewindAttributes();
        super.decode(decoder, pfactory);
        this.datatype = pfactory.getDataTypeManager().findBaseType(this.getText(), id);
    }
}

