/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.Field;
import db.LongField;
import db.Schema;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class SchemaBuilder {
    private int version = 0;
    private String keyFieldName = "Key";
    private Class<? extends Field> keyFieldClass = LongField.class;
    private final List<String> fieldNames = new ArrayList<String>();
    private final List<Class<? extends Field>> fieldClasses = new ArrayList<Class<? extends Field>>();
    private final List<Integer> sparseColumns = new ArrayList<Integer>();

    public static int[] toIntArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static int getColumnIndex(Schema schema, String name) {
        return ArrayUtils.indexOf((Object[])schema.getFieldNames(), (Object)name);
    }

    public SchemaBuilder version(int version) {
        this.version = version;
        return this;
    }

    public SchemaBuilder keyField(String name, Class<? extends Field> cls) {
        this.keyFieldName = name;
        this.keyFieldClass = cls;
        return this;
    }

    public SchemaBuilder field(String name, Class<? extends Field> cls, boolean sparse) {
        int index = this.fieldCount();
        this.fieldNames.add(name);
        this.fieldClasses.add(cls);
        if (sparse) {
            this.sparseColumns.add(index);
        }
        return this;
    }

    public SchemaBuilder field(String name, Class<? extends Field> cls) {
        return this.field(name, cls, false);
    }

    public int fieldCount() {
        return this.fieldNames.size();
    }

    public Schema build() {
        return new Schema(this.version, this.keyFieldClass, this.keyFieldName, this.fieldClasses.toArray(new Class[this.fieldClasses.size()]), this.fieldNames.toArray(new String[this.fieldNames.size()]), SchemaBuilder.toIntArray(this.sparseColumns));
    }
}

