/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

public class MDCharacterIterator {
    public static final char DONE = '\uffff';
    private String string;
    private int index;

    public MDCharacterIterator(String str) {
        this.string = str;
    }

    public String getString() {
        return this.string;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.string.length();
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.string.length()) {
            throw new IllegalArgumentException();
        }
        this.index = index;
    }

    public boolean hasNext() {
        return this.index < this.string.length() - 1;
    }

    public char peek() {
        try {
            return this.string.charAt(this.index);
        }
        catch (IndexOutOfBoundsException e) {
            return '\uffff';
        }
    }

    public char peek(int lookAhead) {
        try {
            return this.string.charAt(this.index + lookAhead);
        }
        catch (IndexOutOfBoundsException e) {
            return '\uffff';
        }
    }

    public char next() {
        try {
            return this.string.charAt(++this.index);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = this.string.length();
            return '\uffff';
        }
    }

    public char getAndIncrement() {
        try {
            return this.string.charAt(this.index++);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = this.string.length();
            return '\uffff';
        }
    }

    public void increment() {
        ++this.index;
    }

    public void increment(int count) {
        this.index += count;
    }

    public char previous() {
        try {
            return this.string.charAt(--this.index);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = 0;
            return '\uffff';
        }
    }

    public boolean positionStartsWith(String substring) {
        return this.string.regionMatches(this.index, substring, 0, substring.length());
    }
}

