/* -----------------------------------------------------------------------------
 *
 * (c) The GHC Team, 2008-2009
 *
 * Initialization of the Static Pointer Table
 *
 * Do not #include this file directly: #include "Rts.h" instead.
 *
 * To understand the structure of the RTS headers, see the wiki:
 *   https://gitlab.haskell.org/ghc/ghc/wikis/commentary/source-tree/includes
 *
 * -------------------------------------------------------------------------- */

#pragma once

/** Inserts an entry in the Static Pointer Table.
 *
 * The key is a fingerprint computed from the static pointer and the spe_closure
 * is a pointer to the closure defining the table entry.
 *
 * A stable pointer to the closure is made to prevent it from being garbage
 * collected while the entry exists on the table.
 *
 * This function is called from the code generated by
 * compiler/deSugar/StaticPtrTable.sptInitCode
 *
 * */
void hs_spt_insert (StgWord64 key[2],void* spe_closure);

/** Inserts an entry for a StgTablePtr in the Static Pointer Table.
 *
 * This function is called from the GHCi interpreter to insert
 * SPT entries for bytecode objects.
 *
 * */
void hs_spt_insert_stableptr(StgWord64 key[2], StgStablePtr *entry);

/** Removes an entry from the Static Pointer Table.
 *
 * This function is called from the code generated by
 * compiler/deSugar/StaticPtrTable.sptInitCode
 *
 * */
void hs_spt_remove (StgWord64 key[2]);
