/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.Map;
import org.apache.fop.util.text.IfFieldPart;
import org.apache.fop.utils.text.AdvancedMessageFormat;

public class EqualsFieldPart
extends IfFieldPart {
    private String equalsValue;

    public EqualsFieldPart(String fieldName, String values) {
        super(fieldName, values);
    }

    @Override
    protected void parseValues(String values) {
        String[] parts = AdvancedMessageFormat.COMMA_SEPARATOR_REGEX.split(values, 3);
        this.equalsValue = parts[0];
        if (parts.length == 1) {
            throw new IllegalArgumentException("'equals' format must have at least 2 parameters");
        }
        if (parts.length == 3) {
            this.ifValue = AdvancedMessageFormat.unescapeComma(parts[1]);
            this.elseValue = AdvancedMessageFormat.unescapeComma(parts[2]);
        } else {
            this.ifValue = AdvancedMessageFormat.unescapeComma(parts[1]);
        }
    }

    @Override
    protected boolean isTrue(Map params) {
        Object obj = params.get(this.fieldName);
        if (obj != null) {
            return String.valueOf(obj).equals(this.equalsValue);
        }
        return false;
    }

    @Override
    public String toString() {
        return "{" + this.fieldName + ", equals " + this.equalsValue + "}";
    }

    public static class Factory
    implements AdvancedMessageFormat.PartFactory {
        @Override
        public AdvancedMessageFormat.Part newPart(String fieldName, String values) {
            return new EqualsFieldPart(fieldName, values);
        }

        @Override
        public String getFormat() {
            return "equals";
        }
    }
}

