/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.create.view.ForceOption;
import net.sf.jsqlparser.statement.create.view.TemporaryOption;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class CreateViewValidator
extends AbstractValidator<CreateView> {
    @Override
    public void validate(CreateView createView) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.createView);
            this.validateFeature(c, createView.isOrReplace(), Feature.createOrReplaceView);
            this.validateFeature(c, !ForceOption.NONE.equals((Object)createView.getForce()), Feature.createViewForce);
            this.validateFeature(c, !TemporaryOption.NONE.equals((Object)createView.getTemporary()), Feature.createViewTemporary);
            this.validateFeature(c, createView.isMaterialized(), Feature.createViewMaterialized);
            this.validateName(c, NamedObject.view, createView.getView().getFullyQualifiedName(), false, new NamedObject[0]);
            this.validateFeature(c, createView.getViewCommentOptions() != null, Feature.createViewWithComment);
        }
        SelectValidator v = this.getValidator(SelectValidator.class);
        Select select = createView.getSelect();
        select.accept(v, null);
    }
}

