/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;

class CacheUtils {
    CacheUtils() {
    }

    @Deprecated
    public static <T> boolean eq(T s1, T s2) {
        return Objects.equals(s1, s2);
    }

    @Deprecated
    public static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public static int pluginHashCode(Plugin plugin) {
        int hash2 = 17;
        hash2 = hash2 * 31 + Objects.hashCode(plugin.getGroupId());
        hash2 = hash2 * 31 + Objects.hashCode(plugin.getArtifactId());
        hash2 = hash2 * 31 + Objects.hashCode(plugin.getVersion());
        hash2 = hash2 * 31 + (plugin.isExtensions() ? 1 : 0);
        for (Dependency dependency : plugin.getDependencies()) {
            hash2 = hash2 * 31 + Objects.hashCode(dependency.getGroupId());
            hash2 = hash2 * 31 + Objects.hashCode(dependency.getArtifactId());
            hash2 = hash2 * 31 + Objects.hashCode(dependency.getVersion());
            hash2 = hash2 * 31 + Objects.hashCode(dependency.getType());
            hash2 = hash2 * 31 + Objects.hashCode(dependency.getClassifier());
            hash2 = hash2 * 31 + Objects.hashCode(dependency.getScope());
            for (Exclusion exclusion : dependency.getExclusions()) {
                hash2 = hash2 * 31 + Objects.hashCode(exclusion.getGroupId());
                hash2 = hash2 * 31 + Objects.hashCode(exclusion.getArtifactId());
            }
        }
        return hash2;
    }

    public static boolean pluginEquals(Plugin a, Plugin b) {
        return Objects.equals(a.getArtifactId(), b.getArtifactId()) && Objects.equals(a.getGroupId(), b.getGroupId()) && Objects.equals(a.getVersion(), b.getVersion()) && a.isExtensions() == b.isExtensions() && CacheUtils.dependenciesEquals(a.getDependencies(), b.getDependencies());
    }

    private static boolean dependenciesEquals(List<Dependency> a, List<Dependency> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Dependency> aI = a.iterator();
        Iterator<Dependency> bI = b.iterator();
        while (aI.hasNext()) {
            boolean r;
            Dependency aD = aI.next();
            Dependency bD = bI.next();
            boolean bl = r = Objects.equals(aD.getGroupId(), bD.getGroupId()) && Objects.equals(aD.getArtifactId(), bD.getArtifactId()) && Objects.equals(aD.getVersion(), bD.getVersion()) && Objects.equals(aD.getType(), bD.getType()) && Objects.equals(aD.getClassifier(), bD.getClassifier()) && Objects.equals(aD.getScope(), bD.getScope());
            if (r &= CacheUtils.exclusionsEquals(aD.getExclusions(), bD.getExclusions())) continue;
            return false;
        }
        return true;
    }

    private static boolean exclusionsEquals(List<Exclusion> a, List<Exclusion> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Exclusion> aI = a.iterator();
        Iterator<Exclusion> bI = b.iterator();
        while (aI.hasNext()) {
            Exclusion aD = aI.next();
            Exclusion bD = bI.next();
            boolean r = Objects.equals(aD.getGroupId(), bD.getGroupId()) && Objects.equals(aD.getArtifactId(), bD.getArtifactId());
            if (r) continue;
            return false;
        }
        return true;
    }
}

