﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/kendra/Kendra_EXPORTS.h>
#include <aws/kendra/model/DataSourceToIndexFieldMapping.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace kendra {
namespace Model {

/**
 * <p>Provides the configuration information for processing attachments to
 * Salesforce standard objects.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/SalesforceStandardObjectAttachmentConfiguration">AWS
 * API Reference</a></p>
 */
class SalesforceStandardObjectAttachmentConfiguration {
 public:
  AWS_KENDRA_API SalesforceStandardObjectAttachmentConfiguration() = default;
  AWS_KENDRA_API SalesforceStandardObjectAttachmentConfiguration(Aws::Utils::Json::JsonView jsonValue);
  AWS_KENDRA_API SalesforceStandardObjectAttachmentConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_KENDRA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the field used for the document title.</p>
   */
  inline const Aws::String& GetDocumentTitleFieldName() const { return m_documentTitleFieldName; }
  inline bool DocumentTitleFieldNameHasBeenSet() const { return m_documentTitleFieldNameHasBeenSet; }
  template <typename DocumentTitleFieldNameT = Aws::String>
  void SetDocumentTitleFieldName(DocumentTitleFieldNameT&& value) {
    m_documentTitleFieldNameHasBeenSet = true;
    m_documentTitleFieldName = std::forward<DocumentTitleFieldNameT>(value);
  }
  template <typename DocumentTitleFieldNameT = Aws::String>
  SalesforceStandardObjectAttachmentConfiguration& WithDocumentTitleFieldName(DocumentTitleFieldNameT&& value) {
    SetDocumentTitleFieldName(std::forward<DocumentTitleFieldNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>One or more objects that map fields in attachments to Amazon Kendra index
   * fields.</p>
   */
  inline const Aws::Vector<DataSourceToIndexFieldMapping>& GetFieldMappings() const { return m_fieldMappings; }
  inline bool FieldMappingsHasBeenSet() const { return m_fieldMappingsHasBeenSet; }
  template <typename FieldMappingsT = Aws::Vector<DataSourceToIndexFieldMapping>>
  void SetFieldMappings(FieldMappingsT&& value) {
    m_fieldMappingsHasBeenSet = true;
    m_fieldMappings = std::forward<FieldMappingsT>(value);
  }
  template <typename FieldMappingsT = Aws::Vector<DataSourceToIndexFieldMapping>>
  SalesforceStandardObjectAttachmentConfiguration& WithFieldMappings(FieldMappingsT&& value) {
    SetFieldMappings(std::forward<FieldMappingsT>(value));
    return *this;
  }
  template <typename FieldMappingsT = DataSourceToIndexFieldMapping>
  SalesforceStandardObjectAttachmentConfiguration& AddFieldMappings(FieldMappingsT&& value) {
    m_fieldMappingsHasBeenSet = true;
    m_fieldMappings.emplace_back(std::forward<FieldMappingsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_documentTitleFieldName;

  Aws::Vector<DataSourceToIndexFieldMapping> m_fieldMappings;
  bool m_documentTitleFieldNameHasBeenSet = false;
  bool m_fieldMappingsHasBeenSet = false;
};

}  // namespace Model
}  // namespace kendra
}  // namespace Aws
