untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVeyd+XfqVhPA9965HLHgEsRbuYXN2EuWtUBctkUcHXfSbSFAJVumJ5dcSWoJfe4qKLVamF/CcQMl27lG5oxKKQ0=

OpenBSD 7.7 errata 022, February 27, 2026:

sysctl requests blocked by pledge(2) create a diagnostic message which
races inside pty(4) and possibly crashes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 022_pledge_sysctl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_pledge.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_pledge.c,v
diff -u -p -u -r1.323.4.1 kern_pledge.c
--- sys/kern/kern_pledge.c	29 Jun 2025 13:58:43 -0000	1.323.4.1
+++ sys/kern/kern_pledge.c	19 Feb 2026 16:36:30 -0000
@@ -802,9 +802,7 @@ pledge_sendfd(struct proc *p, struct fil
 int
 pledge_sysctl(struct proc *p, int miblen, int *mib, void *new)
 {
-	char	buf[80];
 	uint64_t pledge;
-	int	i;
 
 	if ((p->p_p->ps_flags & PS_PLEDGE) == 0)
 		return (0);
@@ -996,14 +994,6 @@ pledge_sysctl(struct proc *p, int miblen
 	    mib[0] == CTL_MACHDEP && mib[1] == CPU_ID_AA64ISAR1)
 		return (0);
 #endif /* CPU_ID_AA64ISAR1 */
-
-	snprintf(buf, sizeof(buf), "%s(%d): pledge sysctl %d:",
-	    p->p_p->ps_comm, p->p_p->ps_pid, miblen);
-	for (i = 0; i < miblen; i++) {
-		char *s = buf + strlen(buf);
-		snprintf(s, sizeof(buf) - (s - buf), " %d", mib[i]);
-	}
-	uprintf("%s\n", buf);
 
 	return pledge_fail(p, EINVAL, 0);
 }
