/*
 * Copyright © 2023 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 */

#include "dev/intel_wa.h"
#include "dev/intel_device_info.h"
#include "util/bitset.h"

void intel_device_info_init_was(struct intel_device_info *devinfo)
{
   switch(devinfo->platform) {
      case INTEL_PLATFORM_EHL:
         BITSET_SET(devinfo->workarounds, INTEL_WA_220579888);
         BITSET_SET(devinfo->workarounds, INTEL_WA_220981846);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1305770284);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1306055483);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1306463417);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406306137);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406614636);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406697149);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406950495);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407240128);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407685933);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408908852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1805811773);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1805992985);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201039848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010013414);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22010893396);
         break;
      case INTEL_PLATFORM_ICL:
         BITSET_SET(devinfo->workarounds, INTEL_WA_220579888);
         BITSET_SET(devinfo->workarounds, INTEL_WA_220981846);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1305770284);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1306055483);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1306463417);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1405586840);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406306137);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406614636);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406697149);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406740894);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406756463);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406950495);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407240128);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407685933);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408908852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604366864);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1805811773);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1805992985);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806068545);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806230709);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201039848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2204296706);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010013414);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22010893396);
         break;
      case INTEL_PLATFORM_ADL:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406337848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407528679);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408224581);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408264532);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409392000);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409600907);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1508744258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1606932921);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607156449);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607854226);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607956946);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806527549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806565034);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808121037);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808850743);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201730850);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010013414);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010017096);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010840176);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010915640);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013111325);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014617373);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018126777);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011107343);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011163337);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011448509);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014912113);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013889147);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020603990);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         break;
      case INTEL_PLATFORM_DG1:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406337848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406583956);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406600135);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406600136);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406600213);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407528679);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407552235);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407876251);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408224581);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408264532);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408767742);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409392000);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409600907);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1504617628);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1508744258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604601757);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1606932921);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607446692);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607610283);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607794140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607854226);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607956946);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806527549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806565034);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808121037);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808850743);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201730850);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010017096);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010840176);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010915640);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013111325);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014617373);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018126777);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011107343);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011163337);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011448509);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014912113);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013889147);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020603990);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022502561);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012751911);
         break;
      case INTEL_PLATFORM_RKL:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406337848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406609750);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407528679);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408264532);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409600907);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1508744258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1606932921);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607610283);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607854226);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607956946);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806527549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806565034);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808121037);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808850743);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201730850);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010017096);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010840176);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010915640);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013111325);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014617373);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018126777);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011107343);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011163337);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011448509);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014912113);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013889147);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020603990);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         break;
      case INTEL_PLATFORM_RPL:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406337848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407528679);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408224581);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408264532);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409392000);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409600907);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1508744258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1606932921);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607156449);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607854226);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607956946);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806527549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806565034);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808121037);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808850743);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201730850);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010013414);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010017096);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010840176);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010915640);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013111325);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014617373);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018126777);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011107343);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011163337);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011448509);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014912113);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013889147);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020603990);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         break;
      case INTEL_PLATFORM_TGL:
         switch(intel_device_info_wa_stepping(devinfo)) {
            case INTEL_STEPPING_A0:
               BITSET_SET(devinfo->workarounds, INTEL_WA_1607794140);
               break;
            case INTEL_STEPPING_A1:
               BITSET_SET(devinfo->workarounds, INTEL_WA_1607794140);
               break;
            case INTEL_STEPPING_B0:
               BITSET_SET(devinfo->workarounds, INTEL_WA_1607794140);
               break;
            default:
               break;
         }
         BITSET_SET(devinfo->workarounds, INTEL_WA_1207137018);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406337848);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406583956);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406600135);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406600136);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1406600213);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407528679);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407552235);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1407876251);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408224581);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1408264532);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409392000);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1409600907);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1504617628);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1508744258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604061319);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1604601757);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1606932921);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607446692);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607610283);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607854226);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1607956946);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806527549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1806565034);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808121037);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1808850743);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_2201730850);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010017096);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010840176);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010915640);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013111325);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014617373);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018126777);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011107343);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011163337);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011448509);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014912113);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013889147);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020603990);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022502561);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012751911);
         break;
      case INTEL_PLATFORM_ARL_U:
         switch(intel_device_info_wa_stepping(devinfo)) {
            case INTEL_STEPPING_A0:
               BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14017240301);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14017245111);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
               BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
               BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
               BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
               break;
            case INTEL_STEPPING_A1:
               BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14017240301);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14017245111);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
               BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
               BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
               BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
               break;
            default:
               break;
         }
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019124575);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_ATSM_G10:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010638130);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010656390);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14011273609);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012688258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015907227);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011411144);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011627967);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011773973);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012201914);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22011440098);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012699309);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013045878);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013073587);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014344549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_ATSM_G11:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012688258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015907227);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017987365);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011411144);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011627967);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011773973);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013000631);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018038193);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012201914);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22011440098);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012640676);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013073587);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014344549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_DG2_G10:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010638130);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010656390);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14011273609);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012688258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015907227);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011411144);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011627967);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011773973);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012201914);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22011440098);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012699309);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013045878);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013073587);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014344549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_DG2_G11:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012688258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015907227);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017987365);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011411144);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011627967);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011773973);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013000631);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018038193);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012201914);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22011440098);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012640676);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013073587);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014344549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_DG2_G12:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_1809626530);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14010755945);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012437816);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14012688258);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14013672992);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014097488);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014414195);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014595444);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014851047);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015055625);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015420481);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015782607);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015907227);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011411144);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011627967);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16011773973);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012775297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013063087);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16013994831);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014390852);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16014538804);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012201914);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18012660806);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019110168);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18019816803);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18020335297);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22011440098);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012699309);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22012766191);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013045878);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013073587);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22013689345);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014344549);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22014412737);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_MTL_H:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019124575);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_MTL_U:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1509820217);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015360517);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015868140);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019124575);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_15011116421);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018063123);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022330953);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_ARL_H:
         BITSET_SET(devinfo->workarounds, INTEL_WA_1606932921);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014063774);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14014176256);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14015907227);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016712196);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016829365);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017468336);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019074860);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16017463599);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18013179988);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18022508906);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18023881693);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22015614752);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018402687);
         break;
      case INTEL_PLATFORM_BMG:
         BITSET_SET(devinfo->workarounds, INTEL_WA_14016407139);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017715663);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017794102);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018117913);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018283232);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018443005);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018471104);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019708328);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019857787);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14020375314);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14021821874);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022215759);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022483228);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022484703);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022954250);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012383669);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018610683);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16020916187);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16021021469);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16021232440);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16022013154);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18033639465);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18035690555);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18037648410);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18038669374);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18038825448);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18039014283);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18039438632);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18040209780);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22016140776);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22017182272);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018390030);
         break;
      case INTEL_PLATFORM_LNL:
         switch(intel_device_info_wa_stepping(devinfo)) {
            case INTEL_STEPPING_A0:
               BITSET_SET(devinfo->workarounds, INTEL_WA_13010473643);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14019039974);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14019570772);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14019957668);
               BITSET_SET(devinfo->workarounds, INTEL_WA_15012495196);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16020183090);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16020916187);
               break;
            case INTEL_STEPPING_A1:
               BITSET_SET(devinfo->workarounds, INTEL_WA_13010473643);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14019570772);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14019957668);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16020183090);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16020916187);
               break;
            default:
               break;
         }
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017715663);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14017794102);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018117913);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018283232);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018443005);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018471104);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018813551);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14018912822);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019166699);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019708328);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14019857787);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14020375314);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022215759);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022484703);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16012383669);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16018610683);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16021021469);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16021232440);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16022013154);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16022973223);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18033639465);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18035690555);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18037648410);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18038825448);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18039014283);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18039438632);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22016140776);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22017182272);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22018390030);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22019537964);
         break;
      case INTEL_PLATFORM_PTL:
         switch(intel_device_info_wa_stepping(devinfo)) {
            case INTEL_STEPPING_A0:
               BITSET_SET(devinfo->workarounds, INTEL_WA_14021821874);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14022484703);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14022977266);
               BITSET_SET(devinfo->workarounds, INTEL_WA_15016637646);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16024792527);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18039014283);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18040209780);
               break;
            case INTEL_STEPPING_A1:
               BITSET_SET(devinfo->workarounds, INTEL_WA_14021821874);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14022484703);
               BITSET_SET(devinfo->workarounds, INTEL_WA_14022977266);
               BITSET_SET(devinfo->workarounds, INTEL_WA_15016637646);
               BITSET_SET(devinfo->workarounds, INTEL_WA_16024792527);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18039014283);
               BITSET_SET(devinfo->workarounds, INTEL_WA_18040209780);
               break;
            default:
               break;
         }
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022215759);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14022863161);
         BITSET_SET(devinfo->workarounds, INTEL_WA_14023061436);
         BITSET_SET(devinfo->workarounds, INTEL_WA_16025326720);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18035690555);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18037648410);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18038825448);
         BITSET_SET(devinfo->workarounds, INTEL_WA_18039438632);
         BITSET_SET(devinfo->workarounds, INTEL_WA_22016140776);
         break;
      default:
         /* unsupported platform */
         break;
   };
}
