/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssMaxWidth
extends org.w3c.css.properties.css.CssMaxWidth {
    public static final CssIdent[] allowed_values;
    public static final String fit_content_func = "fit-content";

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssMaxWidth() {
        this.value = initial;
    }

    public CssMaxWidth(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        this.value = CssMaxWidth.parseMaxWidth(ac, expression, this);
    }

    public CssMaxWidth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public static CssValue parseMaxWidth(ApplContext ac, CssExpression expression, CssProperty caller) throws InvalidParamException {
        CssValue val = expression.getValue();
        CssValue v = null;
        switch (val.getType()) {
            case 5: {
                val.getCheckableValue().checkEqualsZero(ac, caller);
                v = val;
                break;
            }
            case 4: 
            case 6: {
                CssCheckableValue length = val.getCheckableValue();
                length.checkPositiveness(ac, caller);
                v = val;
                break;
            }
            case 11: {
                v = CssMaxWidth.parseFunctionValue(ac, val, caller);
                break;
            }
            case 0: {
                CssIdent id = val.getIdent();
                if (CssIdent.isCssWide(id) || CssMaxWidth.getAllowedIdent(id) != null) {
                    v = val;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", expression.getValue(), caller.getPropertyName(), ac);
            }
        }
        expression.next();
        return v;
    }

    protected static CssValue parseFunctionValue(ApplContext ac, CssValue value, CssProperty caller) throws InvalidParamException {
        CssFunction function = value.getFunction();
        if (!fit_content_func.equalsIgnoreCase(function.getName())) {
            throw new InvalidParamException("value", value.toString(), caller.getPropertyName(), ac);
        }
        CssExpression expression = function.getParameters();
        if (expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 5: {
                val.getCheckableValue().checkEqualsZero(ac, caller);
                break;
            }
            case 4: 
            case 6: {
                CssCheckableValue l = val.getCheckableValue();
                l.checkPositiveness(ac, caller);
                break;
            }
            default: {
                throw new InvalidParamException("value", expression.getValue(), caller.getPropertyName(), ac);
            }
        }
        return value;
    }

    static {
        String[] _allowed_values = new String[]{"none", "max-content", "min-content", "stretch", fit_content_func, "contain"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssMaxWidth.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

