/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PSKKeyExchangeModesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKKeyExchangeModesExtensionParser
extends ExtensionParser<PSKKeyExchangeModesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PSKKeyExchangeModesExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(PSKKeyExchangeModesExtensionMessage msg) {
        LOGGER.debug("Parsing PSKKeyExchangeModesExtensionMessage");
        this.parseExchangeModesListLength(msg);
        this.parseExchangeModesBytes(msg);
        msg.setKeyExchangeModesConfig((byte[])msg.getKeyExchangeModesListBytes().getValue());
    }

    @Override
    protected PSKKeyExchangeModesExtensionMessage createExtensionMessage() {
        return new PSKKeyExchangeModesExtensionMessage();
    }

    private void parseExchangeModesListLength(PSKKeyExchangeModesExtensionMessage msg) {
        msg.setKeyExchangeModesListLength(this.parseIntField(1));
        LOGGER.debug("PSKKeyModesList length:" + msg.getKeyExchangeModesListLength().getValue());
    }

    private void parseExchangeModesBytes(PSKKeyExchangeModesExtensionMessage msg) {
        msg.setKeyExchangeModesListBytes(this.parseByteArrayField((Integer)msg.getKeyExchangeModesListLength().getValue()));
        LOGGER.debug("PSKKeyModesList bytes:" + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getKeyExchangeModesListBytes().getValue())));
    }
}

