/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public enum CompressionMethod {
    NULL(0),
    DEFLATE(1),
    LZS(64);

    private byte value;
    private static final Map<Byte, CompressionMethod> MAP;

    private CompressionMethod(byte value) {
        this.value = value;
    }

    public static CompressionMethod getCompressionMethod(byte value) {
        return MAP.get(value);
    }

    public static List<CompressionMethod> getCompressionMethods(byte[] values) {
        LinkedList<CompressionMethod> compressionMethods = new LinkedList<CompressionMethod>();
        for (int i = 0; i < values.length; ++i) {
            compressionMethods.add(CompressionMethod.getCompressionMethod(values[i]));
        }
        return compressionMethods;
    }

    public byte getValue() {
        return this.value;
    }

    public static CompressionMethod getRandom(Random random) {
        CompressionMethod c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (CompressionMethod)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    static {
        MAP = new HashMap<Byte, CompressionMethod>();
        for (CompressionMethod cm : CompressionMethod.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

