// This code is automatically generated. DO NOT MODIFY.
//
// Instead, modify `crates/stdarch-gen-arm/spec/` and run the following command to re-generate this file:
//
// ```
// cargo run --bin=stdarch-gen-arm -- crates/stdarch-gen-arm/spec
// ```
#![allow(improper_ctypes)]

#[cfg(test)]
use stdarch_test::assert_instr;

use super::*;

#[doc = "CRC32-C single round checksum for quad words (64 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32cd)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(crc32cx))]
#[stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")]
pub fn __crc32cd(crc: u32, data: u64) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32cx"
        )]
        fn ___crc32cd(crc: u32, data: u64) -> u32;
    }
    unsafe { ___crc32cd(crc, data) }
}
#[doc = "CRC32 single round checksum for quad words (64 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32d)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(crc32x))]
#[stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")]
pub fn __crc32d(crc: u32, data: u64) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32x"
        )]
        fn ___crc32d(crc: u32, data: u64) -> u32;
    }
    unsafe { ___crc32d(crc, data) }
}
#[doc = "Signed Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sabal2))]
pub fn vabal_high_s8(a: int16x8_t, b: int8x16_t, c: int8x16_t) -> int16x8_t {
    unsafe {
        let d: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let e: int8x8_t = simd_shuffle!(c, c, [8, 9, 10, 11, 12, 13, 14, 15]);
        let f: int8x8_t = vabd_s8(d, e);
        let f: uint8x8_t = simd_cast(f);
        simd_add(a, simd_cast(f))
    }
}
#[doc = "Signed Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sabal2))]
pub fn vabal_high_s16(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    unsafe {
        let d: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let e: int16x4_t = simd_shuffle!(c, c, [4, 5, 6, 7]);
        let f: int16x4_t = vabd_s16(d, e);
        let f: uint16x4_t = simd_cast(f);
        simd_add(a, simd_cast(f))
    }
}
#[doc = "Signed Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sabal2))]
pub fn vabal_high_s32(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    unsafe {
        let d: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        let e: int32x2_t = simd_shuffle!(c, c, [2, 3]);
        let f: int32x2_t = vabd_s32(d, e);
        let f: uint32x2_t = simd_cast(f);
        simd_add(a, simd_cast(f))
    }
}
#[doc = "Unsigned Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(uabal2))]
pub fn vabal_high_u8(a: uint16x8_t, b: uint8x16_t, c: uint8x16_t) -> uint16x8_t {
    unsafe {
        let d: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let e: uint8x8_t = simd_shuffle!(c, c, [8, 9, 10, 11, 12, 13, 14, 15]);
        let f: uint8x8_t = vabd_u8(d, e);
        simd_add(a, simd_cast(f))
    }
}
#[doc = "Unsigned Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(uabal2))]
pub fn vabal_high_u16(a: uint32x4_t, b: uint16x8_t, c: uint16x8_t) -> uint32x4_t {
    unsafe {
        let d: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let e: uint16x4_t = simd_shuffle!(c, c, [4, 5, 6, 7]);
        let f: uint16x4_t = vabd_u16(d, e);
        simd_add(a, simd_cast(f))
    }
}
#[doc = "Unsigned Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(uabal2))]
pub fn vabal_high_u32(a: uint64x2_t, b: uint32x4_t, c: uint32x4_t) -> uint64x2_t {
    unsafe {
        let d: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        let e: uint32x2_t = simd_shuffle!(c, c, [2, 3]);
        let f: uint32x2_t = vabd_u32(d, e);
        simd_add(a, simd_cast(f))
    }
}
#[doc = "Absolute difference between the arguments of Floating"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fabd))]
pub fn vabd_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fabd.v1f64"
        )]
        fn _vabd_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t;
    }
    unsafe { _vabd_f64(a, b) }
}
#[doc = "Absolute difference between the arguments of Floating"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fabd))]
pub fn vabdq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fabd.v2f64"
        )]
        fn _vabdq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vabdq_f64(a, b) }
}
#[doc = "Floating-point absolute difference"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fabd))]
pub fn vabdd_f64(a: f64, b: f64) -> f64 {
    unsafe { simd_extract!(vabd_f64(vdup_n_f64(a), vdup_n_f64(b)), 0) }
}
#[doc = "Floating-point absolute difference"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabds_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fabd))]
pub fn vabds_f32(a: f32, b: f32) -> f32 {
    unsafe { simd_extract!(vabd_f32(vdup_n_f32(a), vdup_n_f32(b)), 0) }
}
#[doc = "Floating-point absolute difference"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fabd))]
pub fn vabdh_f16(a: f16, b: f16) -> f16 {
    unsafe { simd_extract!(vabd_f16(vdup_n_f16(a), vdup_n_f16(b)), 0) }
}
#[doc = "Signed Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sabdl2))]
pub fn vabdl_high_s16(a: int16x8_t, b: int16x8_t) -> int32x4_t {
    unsafe {
        let c: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let d: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let e: uint16x4_t = simd_cast(vabd_s16(c, d));
        simd_cast(e)
    }
}
#[doc = "Signed Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sabdl2))]
pub fn vabdl_high_s32(a: int32x4_t, b: int32x4_t) -> int64x2_t {
    unsafe {
        let c: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let d: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        let e: uint32x2_t = simd_cast(vabd_s32(c, d));
        simd_cast(e)
    }
}
#[doc = "Signed Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sabdl2))]
pub fn vabdl_high_s8(a: int8x16_t, b: int8x16_t) -> int16x8_t {
    unsafe {
        let c: int8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let d: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let e: uint8x8_t = simd_cast(vabd_s8(c, d));
        simd_cast(e)
    }
}
#[doc = "Unsigned Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uabdl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vabdl_high_u8(a: uint8x16_t, b: uint8x16_t) -> uint16x8_t {
    unsafe {
        let c: uint8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let d: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        simd_cast(vabd_u8(c, d))
    }
}
#[doc = "Unsigned Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uabdl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vabdl_high_u16(a: uint16x8_t, b: uint16x8_t) -> uint32x4_t {
    unsafe {
        let c: uint16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let d: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        simd_cast(vabd_u16(c, d))
    }
}
#[doc = "Unsigned Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uabdl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vabdl_high_u32(a: uint32x4_t, b: uint32x4_t) -> uint64x2_t {
    unsafe {
        let c: uint32x2_t = simd_shuffle!(a, a, [2, 3]);
        let d: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        simd_cast(vabd_u32(c, d))
    }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fabs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vabs_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_fabs(a) }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fabs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vabsq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_fabs(a) }
}
#[doc = "Absolute Value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(abs))]
pub fn vabs_s64(a: int64x1_t) -> int64x1_t {
    unsafe {
        let neg: int64x1_t = simd_neg(a);
        let mask: int64x1_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute Value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(abs))]
pub fn vabsq_s64(a: int64x2_t) -> int64x2_t {
    unsafe {
        let neg: int64x2_t = simd_neg(a);
        let mask: int64x2_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute Value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(abs))]
pub fn vabsd_s64(a: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.abs.i64"
        )]
        fn _vabsd_s64(a: i64) -> i64;
    }
    unsafe { _vabsd_s64(a) }
}
#[doc = "Add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vaddd_s64(a: i64, b: i64) -> i64 {
    a.wrapping_add(b)
}
#[doc = "Add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vaddd_u64(a: u64, b: u64) -> u64 {
    a.wrapping_add(b)
}
#[doc = "Signed Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlv_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(saddlv))]
pub fn vaddlv_s16(a: int16x4_t) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.saddlv.i32.v4i16"
        )]
        fn _vaddlv_s16(a: int16x4_t) -> i32;
    }
    unsafe { _vaddlv_s16(a) }
}
#[doc = "Signed Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlvq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(saddlv))]
pub fn vaddlvq_s16(a: int16x8_t) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.saddlv.i32.v8i16"
        )]
        fn _vaddlvq_s16(a: int16x8_t) -> i32;
    }
    unsafe { _vaddlvq_s16(a) }
}
#[doc = "Signed Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlvq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(saddlv))]
pub fn vaddlvq_s32(a: int32x4_t) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.saddlv.i64.v4i32"
        )]
        fn _vaddlvq_s32(a: int32x4_t) -> i64;
    }
    unsafe { _vaddlvq_s32(a) }
}
#[doc = "Signed Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlv_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(saddlp))]
pub fn vaddlv_s32(a: int32x2_t) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.saddlv.i64.v2i32"
        )]
        fn _vaddlv_s32(a: int32x2_t) -> i64;
    }
    unsafe { _vaddlv_s32(a) }
}
#[doc = "Signed Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlv_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(saddlv))]
pub fn vaddlv_s8(a: int8x8_t) -> i16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.saddlv.i32.v8i8"
        )]
        fn _vaddlv_s8(a: int8x8_t) -> i32;
    }
    unsafe { _vaddlv_s8(a) as i16 }
}
#[doc = "Signed Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlvq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(saddlv))]
pub fn vaddlvq_s8(a: int8x16_t) -> i16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.saddlv.i32.v16i8"
        )]
        fn _vaddlvq_s8(a: int8x16_t) -> i32;
    }
    unsafe { _vaddlvq_s8(a) as i16 }
}
#[doc = "Unsigned Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlv_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uaddlv))]
pub fn vaddlv_u16(a: uint16x4_t) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uaddlv.i32.v4i16"
        )]
        fn _vaddlv_u16(a: uint16x4_t) -> u32;
    }
    unsafe { _vaddlv_u16(a) }
}
#[doc = "Unsigned Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlvq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uaddlv))]
pub fn vaddlvq_u16(a: uint16x8_t) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uaddlv.i32.v8i16"
        )]
        fn _vaddlvq_u16(a: uint16x8_t) -> u32;
    }
    unsafe { _vaddlvq_u16(a) }
}
#[doc = "Unsigned Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlvq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uaddlv))]
pub fn vaddlvq_u32(a: uint32x4_t) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uaddlv.i64.v4i32"
        )]
        fn _vaddlvq_u32(a: uint32x4_t) -> u64;
    }
    unsafe { _vaddlvq_u32(a) }
}
#[doc = "Unsigned Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlv_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uaddlp))]
pub fn vaddlv_u32(a: uint32x2_t) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uaddlv.i64.v2i32"
        )]
        fn _vaddlv_u32(a: uint32x2_t) -> u64;
    }
    unsafe { _vaddlv_u32(a) }
}
#[doc = "Unsigned Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlv_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uaddlv))]
pub fn vaddlv_u8(a: uint8x8_t) -> u16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uaddlv.i32.v8i8"
        )]
        fn _vaddlv_u8(a: uint8x8_t) -> i32;
    }
    unsafe { _vaddlv_u8(a) as u16 }
}
#[doc = "Unsigned Add Long across Vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddlvq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uaddlv))]
pub fn vaddlvq_u8(a: uint8x16_t) -> u16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uaddlv.i32.v16i8"
        )]
        fn _vaddlvq_u8(a: uint8x16_t) -> i32;
    }
    unsafe { _vaddlvq_u8(a) as u16 }
}
#[doc = "Floating-point add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(faddp))]
pub fn vaddv_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.faddv.f32.v2f32"
        )]
        fn _vaddv_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vaddv_f32(a) }
}
#[doc = "Floating-point add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(faddp))]
pub fn vaddvq_f32(a: float32x4_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.faddv.f32.v4f32"
        )]
        fn _vaddvq_f32(a: float32x4_t) -> f32;
    }
    unsafe { _vaddvq_f32(a) }
}
#[doc = "Floating-point add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(faddp))]
pub fn vaddvq_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.faddv.f64.v2f64"
        )]
        fn _vaddvq_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vaddvq_f64(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vaddv_s32(a: int32x2_t) -> i32 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddv_s8(a: int8x8_t) -> i8 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddvq_s8(a: int8x16_t) -> i8 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddv_s16(a: int16x4_t) -> i16 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddvq_s16(a: int16x8_t) -> i16 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddvq_s32(a: int32x4_t) -> i32 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vaddv_u32(a: uint32x2_t) -> u32 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddv_u8(a: uint8x8_t) -> u8 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddvq_u8(a: uint8x16_t) -> u8 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddv_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddv_u16(a: uint16x4_t) -> u16 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddvq_u16(a: uint16x8_t) -> u16 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addv))]
pub fn vaddvq_u32(a: uint32x4_t) -> u32 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vaddvq_s64(a: int64x2_t) -> i64 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddvq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vaddvq_u64(a: uint64x2_t) -> u64 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Multi-vector floating-point absolute maximum"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vamax_f32)"]
#[inline]
#[target_feature(enable = "neon,faminmax")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "faminmax", issue = "137933")]
pub fn vamax_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.famax.v2f32"
        )]
        fn _vamax_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vamax_f32(a, b) }
}
#[doc = "Multi-vector floating-point absolute maximum"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vamaxq_f32)"]
#[inline]
#[target_feature(enable = "neon,faminmax")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "faminmax", issue = "137933")]
pub fn vamaxq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.famax.v4f32"
        )]
        fn _vamaxq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vamaxq_f32(a, b) }
}
#[doc = "Multi-vector floating-point absolute maximum"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vamaxq_f64)"]
#[inline]
#[target_feature(enable = "neon,faminmax")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "faminmax", issue = "137933")]
pub fn vamaxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.famax.v2f64"
        )]
        fn _vamaxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vamaxq_f64(a, b) }
}
#[doc = "Multi-vector floating-point absolute minimum"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vamin_f32)"]
#[inline]
#[target_feature(enable = "neon,faminmax")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "faminmax", issue = "137933")]
pub fn vamin_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.famin.v2f32"
        )]
        fn _vamin_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vamin_f32(a, b) }
}
#[doc = "Multi-vector floating-point absolute minimum"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaminq_f32)"]
#[inline]
#[target_feature(enable = "neon,faminmax")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "faminmax", issue = "137933")]
pub fn vaminq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.famin.v4f32"
        )]
        fn _vaminq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vaminq_f32(a, b) }
}
#[doc = "Multi-vector floating-point absolute minimum"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaminq_f64)"]
#[inline]
#[target_feature(enable = "neon,faminmax")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "faminmax", issue = "137933")]
pub fn vaminq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.famin.v2f64"
        )]
        fn _vaminq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vaminq_f64(a, b) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_s8)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_s8(a: int8x16_t, b: int8x16_t, c: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxs.v16i8"
        )]
        fn _vbcaxq_s8(a: int8x16_t, b: int8x16_t, c: int8x16_t) -> int8x16_t;
    }
    unsafe { _vbcaxq_s8(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_s16)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxs.v8i16"
        )]
        fn _vbcaxq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t;
    }
    unsafe { _vbcaxq_s16(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_s32)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxs.v4i32"
        )]
        fn _vbcaxq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t;
    }
    unsafe { _vbcaxq_s32(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_s64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_s64(a: int64x2_t, b: int64x2_t, c: int64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxs.v2i64"
        )]
        fn _vbcaxq_s64(a: int64x2_t, b: int64x2_t, c: int64x2_t) -> int64x2_t;
    }
    unsafe { _vbcaxq_s64(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_u8)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxu.v16i8"
        )]
        fn _vbcaxq_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vbcaxq_u8(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_u16)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_u16(a: uint16x8_t, b: uint16x8_t, c: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxu.v8i16"
        )]
        fn _vbcaxq_u16(a: uint16x8_t, b: uint16x8_t, c: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _vbcaxq_u16(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_u32)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxu.v4i32"
        )]
        fn _vbcaxq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vbcaxq_u32(a, b, c) }
}
#[doc = "Bit clear and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbcaxq_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(bcax))]
pub fn vbcaxq_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.bcaxu.v2i64"
        )]
        fn _vbcaxq_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _vbcaxq_u64(a, b, c) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcadd_rot270_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fcma"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcadd_rot270_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot270.v4f16"
        )]
        fn _vcadd_rot270_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vcadd_rot270_f16(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaddq_rot270_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fcma"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcaddq_rot270_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot270.v8f16"
        )]
        fn _vcaddq_rot270_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vcaddq_rot270_f16(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcadd_rot270_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcadd_rot270_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot270.v2f32"
        )]
        fn _vcadd_rot270_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vcadd_rot270_f32(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaddq_rot270_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcaddq_rot270_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot270.v4f32"
        )]
        fn _vcaddq_rot270_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vcaddq_rot270_f32(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaddq_rot270_f64)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcaddq_rot270_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot270.v2f64"
        )]
        fn _vcaddq_rot270_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vcaddq_rot270_f64(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcadd_rot90_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fcma"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcadd_rot90_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot90.v4f16"
        )]
        fn _vcadd_rot90_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vcadd_rot90_f16(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaddq_rot90_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fcma"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcaddq_rot90_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot90.v8f16"
        )]
        fn _vcaddq_rot90_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vcaddq_rot90_f16(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcadd_rot90_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcadd_rot90_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot90.v2f32"
        )]
        fn _vcadd_rot90_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vcadd_rot90_f32(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaddq_rot90_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcaddq_rot90_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot90.v4f32"
        )]
        fn _vcaddq_rot90_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vcaddq_rot90_f32(a, b) }
}
#[doc = "Floating-point complex add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaddq_rot90_f64)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcadd))]
pub fn vcaddq_rot90_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcadd.rot90.v2f64"
        )]
        fn _vcaddq_rot90_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vcaddq_rot90_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcage_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcage_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.v1i64.v1f64"
        )]
        fn _vcage_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcage_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcageq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcageq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.v2i64.v2f64"
        )]
        fn _vcageq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcageq_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaged_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcaged_f64(a: f64, b: f64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.i64.f64"
        )]
        fn _vcaged_f64(a: f64, b: f64) -> u64;
    }
    unsafe { _vcaged_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcages_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcages_f32(a: f32, b: f32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.i32.f32"
        )]
        fn _vcages_f32(a: f32, b: f32) -> u32;
    }
    unsafe { _vcages_f32(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcageh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(facge))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcageh_f16(a: f16, b: f16) -> u16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.i32.f16"
        )]
        fn _vcageh_f16(a: f16, b: f16) -> i32;
    }
    unsafe { _vcageh_f16(a, b) as u16 }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagt_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcagt_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.v1i64.v1f64"
        )]
        fn _vcagt_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcagt_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagtq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcagtq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.v2i64.v2f64"
        )]
        fn _vcagtq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcagtq_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagtd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcagtd_f64(a: f64, b: f64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.i64.f64"
        )]
        fn _vcagtd_f64(a: f64, b: f64) -> u64;
    }
    unsafe { _vcagtd_f64(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagts_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcagts_f32(a: f32, b: f32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.i32.f32"
        )]
        fn _vcagts_f32(a: f32, b: f32) -> u32;
    }
    unsafe { _vcagts_f32(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagth_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(facgt))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcagth_f16(a: f16, b: f16) -> u16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.i32.f16"
        )]
        fn _vcagth_f16(a: f16, b: f16) -> i32;
    }
    unsafe { _vcagth_f16(a, b) as u16 }
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcale_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcale_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    vcage_f64(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaleq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcaleq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    vcageq_f64(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaled_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcaled_f64(a: f64, b: f64) -> u64 {
    vcaged_f64(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcales_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcales_f32(a: f32, b: f32) -> u32 {
    vcages_f32(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaleh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(facge))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcaleh_f16(a: f16, b: f16) -> u16 {
    vcageh_f16(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcalt_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcalt_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    vcagt_f64(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaltq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcaltq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    vcagtq_f64(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaltd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcaltd_f64(a: f64, b: f64) -> u64 {
    vcagtd_f64(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcalts_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(facgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcalts_f32(a: f32, b: f32) -> u32 {
    vcagts_f32(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcalth_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(facgt))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcalth_f16(a: f16, b: f16) -> u16 {
    vcagth_f16(b, a)
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceq_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceq_s64(a: int64x1_t, b: int64x1_t) -> uint64x1_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqq_s64(a: int64x2_t, b: int64x2_t) -> uint64x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceq_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceq_p64(a: poly64x1_t, b: poly64x1_t) -> uint64x1_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqq_p64(a: poly64x2_t, b: poly64x2_t) -> uint64x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqd_f64(a: f64, b: f64) -> u64 {
    unsafe { simd_extract!(vceq_f64(vdup_n_f64(a), vdup_n_f64(b)), 0) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqs_f32(a: f32, b: f32) -> u32 {
    unsafe { simd_extract!(vceq_f32(vdup_n_f32(a), vdup_n_f32(b)), 0) }
}
#[doc = "Compare bitwise equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqd_s64(a: i64, b: i64) -> u64 {
    unsafe { transmute(vceq_s64(transmute(a), transmute(b))) }
}
#[doc = "Compare bitwise equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqd_u64(a: u64, b: u64) -> u64 {
    unsafe { transmute(vceq_u64(transmute(a), transmute(b))) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vceqh_f16(a: f16, b: f16) -> u16 {
    unsafe { simd_extract!(vceq_f16(vdup_n_f16(a), vdup_n_f16(b)), 0) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmeq))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vceqz_f16(a: float16x4_t) -> uint16x4_t {
    let b: f16x4 = f16x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmeq))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vceqzq_f16(a: float16x8_t) -> uint16x8_t {
    let b: f16x8 = f16x8::new(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_f32(a: float32x2_t) -> uint32x2_t {
    let b: f32x2 = f32x2::new(0.0, 0.0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_f32(a: float32x4_t) -> uint32x4_t {
    let b: f32x4 = f32x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_f64(a: float64x1_t) -> uint64x1_t {
    let b: f64 = 0.0;
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_f64(a: float64x2_t) -> uint64x2_t {
    let b: f64x2 = f64x2::new(0.0, 0.0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_s8(a: int8x8_t) -> uint8x8_t {
    let b: i8x8 = i8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_s8(a: int8x16_t) -> uint8x16_t {
    let b: i8x16 = i8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_s16(a: int16x4_t) -> uint16x4_t {
    let b: i16x4 = i16x4::new(0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_s16(a: int16x8_t) -> uint16x8_t {
    let b: i16x8 = i16x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_s32(a: int32x2_t) -> uint32x2_t {
    let b: i32x2 = i32x2::new(0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_s32(a: int32x4_t) -> uint32x4_t {
    let b: i32x4 = i32x4::new(0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_s64(a: int64x1_t) -> uint64x1_t {
    let b: i64x1 = i64x1::new(0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_s64(a: int64x2_t) -> uint64x2_t {
    let b: i64x2 = i64x2::new(0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_p8(a: poly8x8_t) -> uint8x8_t {
    let b: i8x8 = i8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_p8(a: poly8x16_t) -> uint8x16_t {
    let b: i8x16 = i8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_p64(a: poly64x1_t) -> uint64x1_t {
    let b: i64x1 = i64x1::new(0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Signed compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_p64(a: poly64x2_t) -> uint64x2_t {
    let b: i64x2 = i64x2::new(0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_u8(a: uint8x8_t) -> uint8x8_t {
    let b: u8x8 = u8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_u8(a: uint8x16_t) -> uint8x16_t {
    let b: u8x16 = u8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_u16(a: uint16x4_t) -> uint16x4_t {
    let b: u16x4 = u16x4::new(0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_u16(a: uint16x8_t) -> uint16x8_t {
    let b: u16x8 = u16x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_u32(a: uint32x2_t) -> uint32x2_t {
    let b: u32x2 = u32x2::new(0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_u32(a: uint32x4_t) -> uint32x4_t {
    let b: u32x4 = u32x4::new(0, 0, 0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqz_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqz_u64(a: uint64x1_t) -> uint64x1_t {
    let b: u64x1 = u64x1::new(0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Unsigned compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmeq))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzq_u64(a: uint64x2_t) -> uint64x2_t {
    let b: u64x2 = u64x2::new(0, 0);
    unsafe { simd_eq(a, transmute(b)) }
}
#[doc = "Compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzd_s64(a: i64) -> u64 {
    unsafe { transmute(vceqz_s64(transmute(a))) }
}
#[doc = "Compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzd_u64(a: u64) -> u64 {
    unsafe { transmute(vceqz_u64(transmute(a))) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vceqzh_f16(a: f16) -> u16 {
    unsafe { simd_extract!(vceqz_f16(vdup_n_f16(a)), 0) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzs_f32(a: f32) -> u32 {
    unsafe { simd_extract!(vceqz_f32(vdup_n_f32(a)), 0) }
}
#[doc = "Floating-point compare bitwise equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqzd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vceqzd_f64(a: f64) -> u64 {
    unsafe { simd_extract!(vceqz_f64(vdup_n_f64(a)), 0) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcge_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgeq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcge_s64(a: int64x1_t, b: int64x1_t) -> uint64x1_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgeq_s64(a: int64x2_t, b: int64x2_t) -> uint64x2_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcge_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgeq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcged_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcged_f64(a: f64, b: f64) -> u64 {
    unsafe { simd_extract!(vcge_f64(vdup_n_f64(a), vdup_n_f64(b)), 0) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcges_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcges_f32(a: f32, b: f32) -> u32 {
    unsafe { simd_extract!(vcge_f32(vdup_n_f32(a), vdup_n_f32(b)), 0) }
}
#[doc = "Compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcged_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcged_s64(a: i64, b: i64) -> u64 {
    unsafe { transmute(vcge_s64(transmute(a), transmute(b))) }
}
#[doc = "Compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcged_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcged_u64(a: u64, b: u64) -> u64 {
    unsafe { transmute(vcge_u64(transmute(a), transmute(b))) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcgeh_f16(a: f16, b: f16) -> u16 {
    unsafe { simd_extract!(vcge_f16(vdup_n_f16(a), vdup_n_f16(b)), 0) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgez_f32(a: float32x2_t) -> uint32x2_t {
    let b: f32x2 = f32x2::new(0.0, 0.0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezq_f32(a: float32x4_t) -> uint32x4_t {
    let b: f32x4 = f32x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgez_f64(a: float64x1_t) -> uint64x1_t {
    let b: f64 = 0.0;
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezq_f64(a: float64x2_t) -> uint64x2_t {
    let b: f64x2 = f64x2::new(0.0, 0.0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgez_s8(a: int8x8_t) -> uint8x8_t {
    let b: i8x8 = i8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezq_s8(a: int8x16_t) -> uint8x16_t {
    let b: i8x16 = i8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgez_s16(a: int16x4_t) -> uint16x4_t {
    let b: i16x4 = i16x4::new(0, 0, 0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezq_s16(a: int16x8_t) -> uint16x8_t {
    let b: i16x8 = i16x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgez_s32(a: int32x2_t) -> uint32x2_t {
    let b: i32x2 = i32x2::new(0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezq_s32(a: int32x4_t) -> uint32x4_t {
    let b: i32x4 = i32x4::new(0, 0, 0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgez_s64(a: int64x1_t) -> uint64x1_t {
    let b: i64x1 = i64x1::new(0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezq_s64(a: int64x2_t) -> uint64x2_t {
    let b: i64x2 = i64x2::new(0, 0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezd_f64(a: f64) -> u64 {
    unsafe { simd_extract!(vcgez_f64(vdup_n_f64(a)), 0) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezs_f32(a: f32) -> u32 {
    unsafe { simd_extract!(vcgez_f32(vdup_n_f32(a)), 0) }
}
#[doc = "Compare signed greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgezd_s64(a: i64) -> u64 {
    unsafe { transmute(vcgez_s64(transmute(a))) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcgezh_f16(a: f16) -> u16 {
    unsafe { simd_extract!(vcgez_f16(vdup_n_f16(a)), 0) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgt_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgt_s64(a: int64x1_t, b: int64x1_t) -> uint64x1_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtq_s64(a: int64x2_t, b: int64x2_t) -> uint64x2_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhi))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgt_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhi))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtd_f64(a: f64, b: f64) -> u64 {
    unsafe { simd_extract!(vcgt_f64(vdup_n_f64(a), vdup_n_f64(b)), 0) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgts_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgts_f32(a: f32, b: f32) -> u32 {
    unsafe { simd_extract!(vcgt_f32(vdup_n_f32(a), vdup_n_f32(b)), 0) }
}
#[doc = "Compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtd_s64(a: i64, b: i64) -> u64 {
    unsafe { transmute(vcgt_s64(transmute(a), transmute(b))) }
}
#[doc = "Compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtd_u64(a: u64, b: u64) -> u64 {
    unsafe { transmute(vcgt_u64(transmute(a), transmute(b))) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgth_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcgth_f16(a: f16, b: f16) -> u16 {
    unsafe { simd_extract!(vcgt_f16(vdup_n_f16(a), vdup_n_f16(b)), 0) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtz_f32(a: float32x2_t) -> uint32x2_t {
    let b: f32x2 = f32x2::new(0.0, 0.0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzq_f32(a: float32x4_t) -> uint32x4_t {
    let b: f32x4 = f32x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtz_f64(a: float64x1_t) -> uint64x1_t {
    let b: f64 = 0.0;
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzq_f64(a: float64x2_t) -> uint64x2_t {
    let b: f64x2 = f64x2::new(0.0, 0.0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtz_s8(a: int8x8_t) -> uint8x8_t {
    let b: i8x8 = i8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzq_s8(a: int8x16_t) -> uint8x16_t {
    let b: i8x16 = i8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtz_s16(a: int16x4_t) -> uint16x4_t {
    let b: i16x4 = i16x4::new(0, 0, 0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzq_s16(a: int16x8_t) -> uint16x8_t {
    let b: i16x8 = i16x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtz_s32(a: int32x2_t) -> uint32x2_t {
    let b: i32x2 = i32x2::new(0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzq_s32(a: int32x4_t) -> uint32x4_t {
    let b: i32x4 = i32x4::new(0, 0, 0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtz_s64(a: int64x1_t) -> uint64x1_t {
    let b: i64x1 = i64x1::new(0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzq_s64(a: int64x2_t) -> uint64x2_t {
    let b: i64x2 = i64x2::new(0, 0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzd_f64(a: f64) -> u64 {
    unsafe { simd_extract!(vcgtz_f64(vdup_n_f64(a)), 0) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzs_f32(a: f32) -> u32 {
    unsafe { simd_extract!(vcgtz_f32(vdup_n_f32(a)), 0) }
}
#[doc = "Compare signed greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcgtzd_s64(a: i64) -> u64 {
    unsafe { transmute(vcgtz_s64(transmute(a))) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcgtzh_f16(a: f16) -> u16 {
    unsafe { simd_extract!(vcgtz_f16(vdup_n_f16(a)), 0) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcle_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcleq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcle_s64(a: int64x1_t, b: int64x1_t) -> uint64x1_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmge))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcleq_s64(a: int64x2_t, b: int64x2_t) -> uint64x2_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcle_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcleq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcled_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcled_f64(a: f64, b: f64) -> u64 {
    unsafe { simd_extract!(vcle_f64(vdup_n_f64(a), vdup_n_f64(b)), 0) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcles_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcles_f32(a: f32, b: f32) -> u32 {
    unsafe { simd_extract!(vcle_f32(vdup_n_f32(a), vdup_n_f32(b)), 0) }
}
#[doc = "Compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcled_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcled_u64(a: u64, b: u64) -> u64 {
    unsafe { transmute(vcle_u64(transmute(a), transmute(b))) }
}
#[doc = "Compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcled_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcled_s64(a: i64, b: i64) -> u64 {
    unsafe { transmute(vcle_s64(transmute(a), transmute(b))) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcleh_f16(a: f16, b: f16) -> u16 {
    unsafe { simd_extract!(vcle_f16(vdup_n_f16(a), vdup_n_f16(b)), 0) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclez_f32(a: float32x2_t) -> uint32x2_t {
    let b: f32x2 = f32x2::new(0.0, 0.0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezq_f32(a: float32x4_t) -> uint32x4_t {
    let b: f32x4 = f32x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclez_f64(a: float64x1_t) -> uint64x1_t {
    let b: f64 = 0.0;
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezq_f64(a: float64x2_t) -> uint64x2_t {
    let b: f64x2 = f64x2::new(0.0, 0.0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclez_s8(a: int8x8_t) -> uint8x8_t {
    let b: i8x8 = i8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezq_s8(a: int8x16_t) -> uint8x16_t {
    let b: i8x16 = i8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclez_s16(a: int16x4_t) -> uint16x4_t {
    let b: i16x4 = i16x4::new(0, 0, 0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezq_s16(a: int16x8_t) -> uint16x8_t {
    let b: i16x8 = i16x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclez_s32(a: int32x2_t) -> uint32x2_t {
    let b: i32x2 = i32x2::new(0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezq_s32(a: int32x4_t) -> uint32x4_t {
    let b: i32x4 = i32x4::new(0, 0, 0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclez_s64(a: int64x1_t) -> uint64x1_t {
    let b: i64x1 = i64x1::new(0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Compare signed less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmle))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezq_s64(a: int64x2_t) -> uint64x2_t {
    let b: i64x2 = i64x2::new(0, 0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezd_f64(a: f64) -> u64 {
    unsafe { simd_extract!(vclez_f64(vdup_n_f64(a)), 0) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezs_f32(a: f32) -> u32 {
    unsafe { simd_extract!(vclez_f32(vdup_n_f32(a)), 0) }
}
#[doc = "Compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclezd_s64(a: i64) -> u64 {
    unsafe { transmute(vclez_s64(transmute(a))) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vclezh_f16(a: f16) -> u16 {
    unsafe { simd_extract!(vclez_f16(vdup_n_f16(a)), 0) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclt_f64(a: float64x1_t, b: float64x1_t) -> uint64x1_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltq_f64(a: float64x2_t, b: float64x2_t) -> uint64x2_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclt_s64(a: int64x1_t, b: int64x1_t) -> uint64x1_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmgt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltq_s64(a: int64x2_t, b: int64x2_t) -> uint64x2_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhi))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclt_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmhi))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltd_u64(a: u64, b: u64) -> u64 {
    unsafe { transmute(vclt_u64(transmute(a), transmute(b))) }
}
#[doc = "Compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltd_s64(a: i64, b: i64) -> u64 {
    unsafe { transmute(vclt_s64(transmute(a), transmute(b))) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclth_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vclth_f16(a: f16, b: f16) -> u16 {
    unsafe { simd_extract!(vclt_f16(vdup_n_f16(a), vdup_n_f16(b)), 0) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclts_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vclts_f32(a: f32, b: f32) -> u32 {
    unsafe { simd_extract!(vclt_f32(vdup_n_f32(a), vdup_n_f32(b)), 0) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltd_f64(a: f64, b: f64) -> u64 {
    unsafe { simd_extract!(vclt_f64(vdup_n_f64(a), vdup_n_f64(b)), 0) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltz_f32(a: float32x2_t) -> uint32x2_t {
    let b: f32x2 = f32x2::new(0.0, 0.0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzq_f32(a: float32x4_t) -> uint32x4_t {
    let b: f32x4 = f32x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltz_f64(a: float64x1_t) -> uint64x1_t {
    let b: f64 = 0.0;
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzq_f64(a: float64x2_t) -> uint64x2_t {
    let b: f64x2 = f64x2::new(0.0, 0.0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltz_s8(a: int8x8_t) -> uint8x8_t {
    let b: i8x8 = i8x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzq_s8(a: int8x16_t) -> uint8x16_t {
    let b: i8x16 = i8x16::new(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltz_s16(a: int16x4_t) -> uint16x4_t {
    let b: i16x4 = i16x4::new(0, 0, 0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzq_s16(a: int16x8_t) -> uint16x8_t {
    let b: i16x8 = i16x8::new(0, 0, 0, 0, 0, 0, 0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltz_s32(a: int32x2_t) -> uint32x2_t {
    let b: i32x2 = i32x2::new(0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzq_s32(a: int32x4_t) -> uint32x4_t {
    let b: i32x4 = i32x4::new(0, 0, 0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltz_s64(a: int64x1_t) -> uint64x1_t {
    let b: i64x1 = i64x1::new(0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Compare signed less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(cmlt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzq_s64(a: int64x2_t) -> uint64x2_t {
    let b: i64x2 = i64x2::new(0, 0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzd_f64(a: f64) -> u64 {
    unsafe { simd_extract!(vcltz_f64(vdup_n_f64(a)), 0) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzs_f32(a: f32) -> u32 {
    unsafe { simd_extract!(vcltz_f32(vdup_n_f32(a)), 0) }
}
#[doc = "Compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(asr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcltzd_s64(a: i64) -> u64 {
    unsafe { transmute(vcltz_s64(transmute(a))) }
}
#[doc = "Floating-point compare less than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcmp))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcltzh_f16(a: f16) -> u16 {
    unsafe { simd_extract!(vcltz_f16(vdup_n_f16(a)), 0) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot0.v4f16"
        )]
        fn _vcmla_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t;
    }
    unsafe { _vcmla_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot0.v8f16"
        )]
        fn _vcmlaq_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t;
    }
    unsafe { _vcmlaq_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot0.v2f32"
        )]
        fn _vcmla_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t;
    }
    unsafe { _vcmla_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot0.v4f32"
        )]
        fn _vcmlaq_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t;
    }
    unsafe { _vcmlaq_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_f64)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot0.v2f64"
        )]
        fn _vcmlaq_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t;
    }
    unsafe { _vcmlaq_f64(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_lane_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x4_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_lane_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x4_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_lane_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x2_t,
) -> float32x2_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_lane_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x2_t,
) -> float32x4_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_laneq_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x8_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_laneq_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x8_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_laneq_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_laneq_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot180_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_rot180_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot180.v4f16"
        )]
        fn _vcmla_rot180_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t;
    }
    unsafe { _vcmla_rot180_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot180_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot180.v8f16"
        )]
        fn _vcmlaq_rot180_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t;
    }
    unsafe { _vcmlaq_rot180_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot180_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_rot180_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot180.v2f32"
        )]
        fn _vcmla_rot180_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t;
    }
    unsafe { _vcmla_rot180_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot180_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot180.v4f32"
        )]
        fn _vcmlaq_rot180_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t;
    }
    unsafe { _vcmlaq_rot180_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_f64)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot180_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot180.v2f64"
        )]
        fn _vcmlaq_rot180_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t;
    }
    unsafe { _vcmlaq_rot180_f64(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot180_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_rot180_lane_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x4_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_rot180_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_rot180_lane_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x4_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot180_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot180_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_rot180_lane_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x2_t,
) -> float32x2_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_rot180_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_rot180_lane_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x2_t,
) -> float32x4_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot180_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot180_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_rot180_laneq_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x8_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_rot180_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_rot180_laneq_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x8_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot180_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot180_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_rot180_laneq_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_rot180_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot180_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_rot180_laneq_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot180_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot270_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_rot270_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot270.v4f16"
        )]
        fn _vcmla_rot270_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t;
    }
    unsafe { _vcmla_rot270_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot270_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot270.v8f16"
        )]
        fn _vcmlaq_rot270_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t;
    }
    unsafe { _vcmlaq_rot270_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot270_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_rot270_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot270.v2f32"
        )]
        fn _vcmla_rot270_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t;
    }
    unsafe { _vcmla_rot270_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot270_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot270.v4f32"
        )]
        fn _vcmlaq_rot270_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t;
    }
    unsafe { _vcmlaq_rot270_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_f64)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot270_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot270.v2f64"
        )]
        fn _vcmlaq_rot270_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t;
    }
    unsafe { _vcmlaq_rot270_f64(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot270_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_rot270_lane_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x4_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_rot270_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_rot270_lane_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x4_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot270_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot270_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_rot270_lane_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x2_t,
) -> float32x2_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_rot270_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_rot270_lane_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x2_t,
) -> float32x4_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot270_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot270_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_rot270_laneq_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x8_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_rot270_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_rot270_laneq_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x8_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot270_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot270_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_rot270_laneq_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_rot270_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot270_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_rot270_laneq_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot270_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot90_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_rot90_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot90.v4f16"
        )]
        fn _vcmla_rot90_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t;
    }
    unsafe { _vcmla_rot90_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot90_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot90.v8f16"
        )]
        fn _vcmlaq_rot90_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t;
    }
    unsafe { _vcmlaq_rot90_f16(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot90_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmla_rot90_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot90.v2f32"
        )]
        fn _vcmla_rot90_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t;
    }
    unsafe { _vcmla_rot90_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot90_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot90.v4f32"
        )]
        fn _vcmlaq_rot90_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t;
    }
    unsafe { _vcmlaq_rot90_f32(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_f64)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
#[cfg_attr(test, assert_instr(fcmla))]
pub fn vcmlaq_rot90_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcmla.rot90.v2f64"
        )]
        fn _vcmlaq_rot90_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t;
    }
    unsafe { _vcmlaq_rot90_f64(a, b, c) }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot90_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_rot90_lane_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x4_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_rot90_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_lane_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_rot90_lane_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x4_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot90_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot90_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_rot90_lane_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x2_t,
) -> float32x2_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_rot90_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_lane_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_rot90_lane_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x2_t,
) -> float32x4_t {
    static_assert!(LANE == 0);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot90_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot90_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmla_rot90_laneq_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x8_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmla_rot90_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcmlaq_rot90_laneq_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x8_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: float16x8_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot90_f16(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmla_rot90_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmla_rot90_laneq_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x2_t = simd_shuffle!(c, c, [2 * LANE as u32, 2 * LANE as u32 + 1]);
        vcmla_rot90_f32(a, b, c)
    }
}
#[doc = "Floating-point complex multiply accumulate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcmlaq_rot90_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon,fcma")]
#[cfg_attr(test, assert_instr(fcmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_fcma", issue = "117222")]
pub fn vcmlaq_rot90_laneq_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: float32x4_t = simd_shuffle!(
            c,
            c,
            [
                2 * LANE as u32,
                2 * LANE as u32 + 1,
                2 * LANE as u32,
                2 * LANE as u32 + 1
            ]
        );
        vcmlaq_rot90_f32(a, b, c)
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_f32<const LANE1: i32, const LANE2: i32>(
    a: float32x2_t,
    b: float32x2_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_s8<const LANE1: i32, const LANE2: i32>(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 3);
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_s16<const LANE1: i32, const LANE2: i32>(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 2);
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_s32<const LANE1: i32, const LANE2: i32>(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_u8<const LANE1: i32, const LANE2: i32>(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 3);
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_u16<const LANE1: i32, const LANE2: i32>(
    a: uint16x4_t,
    b: uint16x4_t,
) -> uint16x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 2);
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_u32<const LANE1: i32, const LANE2: i32>(
    a: uint32x2_t,
    b: uint32x2_t,
) -> uint32x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_p8<const LANE1: i32, const LANE2: i32>(a: poly8x8_t, b: poly8x8_t) -> poly8x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 3);
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_lane_p16<const LANE1: i32, const LANE2: i32>(
    a: poly16x4_t,
    b: poly16x4_t,
) -> poly16x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 2);
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_f32<const LANE1: i32, const LANE2: i32>(
    a: float32x2_t,
    b: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 2);
    let a: float32x4_t = unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_s8<const LANE1: i32, const LANE2: i32>(a: int8x8_t, b: int8x16_t) -> int8x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 4);
    let a: int8x16_t =
        unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) };
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [16 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 16 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 16 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 16 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 16 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 16 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 16 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 16 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_s16<const LANE1: i32, const LANE2: i32>(
    a: int16x4_t,
    b: int16x8_t,
) -> int16x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 3);
    let a: int16x8_t = unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7]) };
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_s32<const LANE1: i32, const LANE2: i32>(
    a: int32x2_t,
    b: int32x4_t,
) -> int32x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 2);
    let a: int32x4_t = unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_u8<const LANE1: i32, const LANE2: i32>(
    a: uint8x8_t,
    b: uint8x16_t,
) -> uint8x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 4);
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) };
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [16 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 16 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 16 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 16 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 16 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 16 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 16 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 16 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_u16<const LANE1: i32, const LANE2: i32>(
    a: uint16x4_t,
    b: uint16x8_t,
) -> uint16x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 3);
    let a: uint16x8_t = unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7]) };
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_u32<const LANE1: i32, const LANE2: i32>(
    a: uint32x2_t,
    b: uint32x4_t,
) -> uint32x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 2);
    let a: uint32x4_t = unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_p8<const LANE1: i32, const LANE2: i32>(
    a: poly8x8_t,
    b: poly8x16_t,
) -> poly8x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 4);
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) };
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [16 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 16 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 16 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 16 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 16 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 16 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 16 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 16 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopy_laneq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopy_laneq_p16<const LANE1: i32, const LANE2: i32>(
    a: poly16x4_t,
    b: poly16x8_t,
) -> poly16x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 3);
    let a: poly16x8_t = unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7]) };
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 1, LANE2 = 0))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_f32<const LANE1: i32, const LANE2: i32>(
    a: float32x4_t,
    b: float32x2_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 1);
    let b: float32x4_t = unsafe { simd_shuffle!(b, b, [0, 1, 2, 3]) };
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 1, LANE2 = 0))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_f64<const LANE1: i32, const LANE2: i32>(
    a: float64x2_t,
    b: float64x1_t,
) -> float64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert!(LANE2 == 0);
    let b: float64x2_t = unsafe { simd_shuffle!(b, b, [0, 1]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 1, LANE2 = 0))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_s64<const LANE1: i32, const LANE2: i32>(
    a: int64x2_t,
    b: int64x1_t,
) -> int64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert!(LANE2 == 0);
    let b: int64x2_t = unsafe { simd_shuffle!(b, b, [0, 1]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 1, LANE2 = 0))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_u64<const LANE1: i32, const LANE2: i32>(
    a: uint64x2_t,
    b: uint64x1_t,
) -> uint64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert!(LANE2 == 0);
    let b: uint64x2_t = unsafe { simd_shuffle!(b, b, [0, 1]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 1, LANE2 = 0))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_p64<const LANE1: i32, const LANE2: i32>(
    a: poly64x2_t,
    b: poly64x1_t,
) -> poly64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert!(LANE2 == 0);
    let b: poly64x2_t = unsafe { simd_shuffle!(b, b, [0, 1]) };
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_s8<const LANE1: i32, const LANE2: i32>(a: int8x16_t, b: int8x8_t) -> int8x16_t {
    static_assert_uimm_bits!(LANE1, 4);
    static_assert_uimm_bits!(LANE2, 3);
    let b: int8x16_t =
        unsafe { simd_shuffle!(b, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) };
    unsafe {
        match LANE1 & 0b1111 {
            0 => simd_shuffle!(
                a,
                b,
                [
                    16 + LANE2 as u32,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            1 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    16 + LANE2 as u32,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    16 + LANE2 as u32,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    16 + LANE2 as u32,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    16 + LANE2 as u32,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    16 + LANE2 as u32,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    16 + LANE2 as u32,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    16 + LANE2 as u32,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    16 + LANE2 as u32,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    16 + LANE2 as u32,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    16 + LANE2 as u32,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    16 + LANE2 as u32,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    16 + LANE2 as u32,
                    13,
                    14,
                    15
                ]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    16 + LANE2 as u32,
                    14,
                    15
                ]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    16 + LANE2 as u32,
                    15
                ]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    16 + LANE2 as u32
                ]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_s16<const LANE1: i32, const LANE2: i32>(
    a: int16x8_t,
    b: int16x4_t,
) -> int16x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 2);
    let b: int16x8_t = unsafe { simd_shuffle!(b, b, [0, 1, 2, 3, 4, 5, 6, 7]) };
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_s32<const LANE1: i32, const LANE2: i32>(
    a: int32x4_t,
    b: int32x2_t,
) -> int32x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 1);
    let b: int32x4_t = unsafe { simd_shuffle!(b, b, [0, 1, 2, 3]) };
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_u8<const LANE1: i32, const LANE2: i32>(
    a: uint8x16_t,
    b: uint8x8_t,
) -> uint8x16_t {
    static_assert_uimm_bits!(LANE1, 4);
    static_assert_uimm_bits!(LANE2, 3);
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) };
    unsafe {
        match LANE1 & 0b1111 {
            0 => simd_shuffle!(
                a,
                b,
                [
                    16 + LANE2 as u32,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            1 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    16 + LANE2 as u32,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    16 + LANE2 as u32,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    16 + LANE2 as u32,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    16 + LANE2 as u32,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    16 + LANE2 as u32,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    16 + LANE2 as u32,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    16 + LANE2 as u32,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    16 + LANE2 as u32,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    16 + LANE2 as u32,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    16 + LANE2 as u32,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    16 + LANE2 as u32,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    16 + LANE2 as u32,
                    13,
                    14,
                    15
                ]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    16 + LANE2 as u32,
                    14,
                    15
                ]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    16 + LANE2 as u32,
                    15
                ]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    16 + LANE2 as u32
                ]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_u16<const LANE1: i32, const LANE2: i32>(
    a: uint16x8_t,
    b: uint16x4_t,
) -> uint16x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 2);
    let b: uint16x8_t = unsafe { simd_shuffle!(b, b, [0, 1, 2, 3, 4, 5, 6, 7]) };
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_u32<const LANE1: i32, const LANE2: i32>(
    a: uint32x4_t,
    b: uint32x2_t,
) -> uint32x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 1);
    let b: uint32x4_t = unsafe { simd_shuffle!(b, b, [0, 1, 2, 3]) };
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_p8<const LANE1: i32, const LANE2: i32>(
    a: poly8x16_t,
    b: poly8x8_t,
) -> poly8x16_t {
    static_assert_uimm_bits!(LANE1, 4);
    static_assert_uimm_bits!(LANE2, 3);
    let b: poly8x16_t =
        unsafe { simd_shuffle!(b, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) };
    unsafe {
        match LANE1 & 0b1111 {
            0 => simd_shuffle!(
                a,
                b,
                [
                    16 + LANE2 as u32,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            1 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    16 + LANE2 as u32,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    16 + LANE2 as u32,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    16 + LANE2 as u32,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    16 + LANE2 as u32,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    16 + LANE2 as u32,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    16 + LANE2 as u32,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    16 + LANE2 as u32,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    16 + LANE2 as u32,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    16 + LANE2 as u32,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    16 + LANE2 as u32,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    16 + LANE2 as u32,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    16 + LANE2 as u32,
                    13,
                    14,
                    15
                ]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    16 + LANE2 as u32,
                    14,
                    15
                ]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    16 + LANE2 as u32,
                    15
                ]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    16 + LANE2 as u32
                ]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_lane_p16<const LANE1: i32, const LANE2: i32>(
    a: poly16x8_t,
    b: poly16x4_t,
) -> poly16x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 2);
    let b: poly16x8_t = unsafe { simd_shuffle!(b, b, [0, 1, 2, 3, 4, 5, 6, 7]) };
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_f32<const LANE1: i32, const LANE2: i32>(
    a: float32x4_t,
    b: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 2);
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_f64<const LANE1: i32, const LANE2: i32>(
    a: float64x2_t,
    b: float64x2_t,
) -> float64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_s8<const LANE1: i32, const LANE2: i32>(
    a: int8x16_t,
    b: int8x16_t,
) -> int8x16_t {
    static_assert_uimm_bits!(LANE1, 4);
    static_assert_uimm_bits!(LANE2, 4);
    unsafe {
        match LANE1 & 0b1111 {
            0 => simd_shuffle!(
                a,
                b,
                [
                    16 + LANE2 as u32,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            1 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    16 + LANE2 as u32,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    16 + LANE2 as u32,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    16 + LANE2 as u32,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    16 + LANE2 as u32,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    16 + LANE2 as u32,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    16 + LANE2 as u32,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    16 + LANE2 as u32,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    16 + LANE2 as u32,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    16 + LANE2 as u32,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    16 + LANE2 as u32,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    16 + LANE2 as u32,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    16 + LANE2 as u32,
                    13,
                    14,
                    15
                ]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    16 + LANE2 as u32,
                    14,
                    15
                ]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    16 + LANE2 as u32,
                    15
                ]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    16 + LANE2 as u32
                ]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_s16<const LANE1: i32, const LANE2: i32>(
    a: int16x8_t,
    b: int16x8_t,
) -> int16x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 3);
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_s32<const LANE1: i32, const LANE2: i32>(
    a: int32x4_t,
    b: int32x4_t,
) -> int32x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 2);
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_s64<const LANE1: i32, const LANE2: i32>(
    a: int64x2_t,
    b: int64x2_t,
) -> int64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_u8<const LANE1: i32, const LANE2: i32>(
    a: uint8x16_t,
    b: uint8x16_t,
) -> uint8x16_t {
    static_assert_uimm_bits!(LANE1, 4);
    static_assert_uimm_bits!(LANE2, 4);
    unsafe {
        match LANE1 & 0b1111 {
            0 => simd_shuffle!(
                a,
                b,
                [
                    16 + LANE2 as u32,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            1 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    16 + LANE2 as u32,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    16 + LANE2 as u32,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    16 + LANE2 as u32,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    16 + LANE2 as u32,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    16 + LANE2 as u32,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    16 + LANE2 as u32,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    16 + LANE2 as u32,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    16 + LANE2 as u32,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    16 + LANE2 as u32,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    16 + LANE2 as u32,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    16 + LANE2 as u32,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    16 + LANE2 as u32,
                    13,
                    14,
                    15
                ]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    16 + LANE2 as u32,
                    14,
                    15
                ]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    16 + LANE2 as u32,
                    15
                ]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    16 + LANE2 as u32
                ]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_u16<const LANE1: i32, const LANE2: i32>(
    a: uint16x8_t,
    b: uint16x8_t,
) -> uint16x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 3);
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_u32<const LANE1: i32, const LANE2: i32>(
    a: uint32x4_t,
    b: uint32x4_t,
) -> uint32x4_t {
    static_assert_uimm_bits!(LANE1, 2);
    static_assert_uimm_bits!(LANE2, 2);
    unsafe {
        match LANE1 & 0b11 {
            0 => simd_shuffle!(a, b, [4 + LANE2 as u32, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [0, 4 + LANE2 as u32, 2, 3]),
            2 => simd_shuffle!(a, b, [0, 1, 4 + LANE2 as u32, 3]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 4 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_u64<const LANE1: i32, const LANE2: i32>(
    a: uint64x2_t,
    b: uint64x2_t,
) -> uint64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_p8<const LANE1: i32, const LANE2: i32>(
    a: poly8x16_t,
    b: poly8x16_t,
) -> poly8x16_t {
    static_assert_uimm_bits!(LANE1, 4);
    static_assert_uimm_bits!(LANE2, 4);
    unsafe {
        match LANE1 & 0b1111 {
            0 => simd_shuffle!(
                a,
                b,
                [
                    16 + LANE2 as u32,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            1 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    16 + LANE2 as u32,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    16 + LANE2 as u32,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    16 + LANE2 as u32,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    16 + LANE2 as u32,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    16 + LANE2 as u32,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    16 + LANE2 as u32,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    16 + LANE2 as u32,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    16 + LANE2 as u32,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    16 + LANE2 as u32,
                    10,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    16 + LANE2 as u32,
                    11,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    16 + LANE2 as u32,
                    12,
                    13,
                    14,
                    15
                ]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    16 + LANE2 as u32,
                    13,
                    14,
                    15
                ]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    16 + LANE2 as u32,
                    14,
                    15
                ]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    16 + LANE2 as u32,
                    15
                ]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [
                    0,
                    1,
                    2,
                    3,
                    4,
                    5,
                    6,
                    7,
                    8,
                    9,
                    10,
                    11,
                    12,
                    13,
                    14,
                    16 + LANE2 as u32
                ]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_p16<const LANE1: i32, const LANE2: i32>(
    a: poly16x8_t,
    b: poly16x8_t,
) -> poly16x8_t {
    static_assert_uimm_bits!(LANE1, 3);
    static_assert_uimm_bits!(LANE2, 3);
    unsafe {
        match LANE1 & 0b111 {
            0 => simd_shuffle!(a, b, [8 + LANE2 as u32, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [0, 8 + LANE2 as u32, 2, 3, 4, 5, 6, 7]),
            2 => simd_shuffle!(a, b, [0, 1, 8 + LANE2 as u32, 3, 4, 5, 6, 7]),
            3 => simd_shuffle!(a, b, [0, 1, 2, 8 + LANE2 as u32, 4, 5, 6, 7]),
            4 => simd_shuffle!(a, b, [0, 1, 2, 3, 8 + LANE2 as u32, 5, 6, 7]),
            5 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 8 + LANE2 as u32, 6, 7]),
            6 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 8 + LANE2 as u32, 7]),
            7 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 8 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcopyq_laneq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(mov, LANE1 = 0, LANE2 = 1))]
#[rustc_legacy_const_generics(1, 3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcopyq_laneq_p64<const LANE1: i32, const LANE2: i32>(
    a: poly64x2_t,
    b: poly64x2_t,
) -> poly64x2_t {
    static_assert_uimm_bits!(LANE1, 1);
    static_assert_uimm_bits!(LANE2, 1);
    unsafe {
        match LANE1 & 0b1 {
            0 => simd_shuffle!(a, b, [2 + LANE2 as u32, 1]),
            1 => simd_shuffle!(a, b, [0, 2 + LANE2 as u32]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcreate_f64(a: u64) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Floating-point convert"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f32_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_f32_f64(a: float64x2_t) -> float32x2_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to higher precision long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f64_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_f64_f32(a: float32x2_t) -> float64x2_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_f64_s64(a: int64x1_t) -> float64x1_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_f64_s64(a: int64x2_t) -> float64x2_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_f64_u64(a: uint64x1_t) -> float64x1_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_f64_u64(a: uint64x2_t) -> float64x2_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to lower precision"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_high_f16_f32)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtn2))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvt_high_f16_f32(a: float16x4_t, b: float32x4_t) -> float16x8_t {
    vcombine_f16(a, vcvt_f16_f32(b))
}
#[doc = "Floating-point convert to higher precision"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_high_f32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtl2))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvt_high_f32_f16(a: float16x8_t) -> float32x4_t {
    vcvt_f32_f16(vget_high_f16(a))
}
#[doc = "Floating-point convert to lower precision narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_high_f32_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_high_f32_f64(a: float32x2_t, b: float64x2_t) -> float32x4_t {
    unsafe { simd_shuffle!(a, simd_cast(b), [0, 1, 2, 3]) }
}
#[doc = "Floating-point convert to higher precision long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_high_f64_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_high_f64_f32(a: float32x4_t) -> float64x2_t {
    unsafe {
        let b: float32x2_t = simd_shuffle!(a, a, [2, 3]);
        simd_cast(b)
    }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_f64_s64<const N: i32>(a: int64x1_t) -> float64x1_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.v1f64.v1i64"
        )]
        fn _vcvt_n_f64_s64(a: int64x1_t, n: i32) -> float64x1_t;
    }
    unsafe { _vcvt_n_f64_s64(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_f64_s64<const N: i32>(a: int64x2_t) -> float64x2_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.v2f64.v2i64"
        )]
        fn _vcvtq_n_f64_s64(a: int64x2_t, n: i32) -> float64x2_t;
    }
    unsafe { _vcvtq_n_f64_s64(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_f64_u64<const N: i32>(a: uint64x1_t) -> float64x1_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.v1f64.v1i64"
        )]
        fn _vcvt_n_f64_u64(a: uint64x1_t, n: i32) -> float64x1_t;
    }
    unsafe { _vcvt_n_f64_u64(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_f64_u64<const N: i32>(a: uint64x2_t) -> float64x2_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.v2f64.v2i64"
        )]
        fn _vcvtq_n_f64_u64(a: uint64x2_t, n: i32) -> float64x2_t;
    }
    unsafe { _vcvtq_n_f64_u64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_s64_f64<const N: i32>(a: float64x1_t) -> int64x1_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.v1i64.v1f64"
        )]
        fn _vcvt_n_s64_f64(a: float64x1_t, n: i32) -> int64x1_t;
    }
    unsafe { _vcvt_n_s64_f64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_s64_f64<const N: i32>(a: float64x2_t) -> int64x2_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.v2i64.v2f64"
        )]
        fn _vcvtq_n_s64_f64(a: float64x2_t, n: i32) -> int64x2_t;
    }
    unsafe { _vcvtq_n_s64_f64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_u64_f64<const N: i32>(a: float64x1_t) -> uint64x1_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.v1i64.v1f64"
        )]
        fn _vcvt_n_u64_f64(a: float64x1_t, n: i32) -> uint64x1_t;
    }
    unsafe { _vcvt_n_u64_f64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_u64_f64<const N: i32>(a: float64x2_t) -> uint64x2_t {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.v2i64.v2f64"
        )]
        fn _vcvtq_n_u64_f64(a: float64x2_t, n: i32) -> uint64x2_t;
    }
    unsafe { _vcvtq_n_u64_f64(a, N) }
}
#[doc = "Floating-point convert to signed fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_s64_f64(a: float64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptosi.sat.v1i64.v1f64"
        )]
        fn _vcvt_s64_f64(a: float64x1_t) -> int64x1_t;
    }
    unsafe { _vcvt_s64_f64(a) }
}
#[doc = "Floating-point convert to signed fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_s64_f64(a: float64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptosi.sat.v2i64.v2f64"
        )]
        fn _vcvtq_s64_f64(a: float64x2_t) -> int64x2_t;
    }
    unsafe { _vcvtq_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_u64_f64(a: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptoui.sat.v1i64.v1f64"
        )]
        fn _vcvt_u64_f64(a: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcvt_u64_f64(a) }
}
#[doc = "Floating-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_u64_f64(a: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptoui.sat.v2i64.v2f64"
        )]
        fn _vcvtq_u64_f64(a: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcvtq_u64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvta_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtas))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvta_s16_f16(a: float16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.v4i16.v4f16"
        )]
        fn _vcvta_s16_f16(a: float16x4_t) -> int16x4_t;
    }
    unsafe { _vcvta_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtaq_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtas))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtaq_s16_f16(a: float16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.v8i16.v8f16"
        )]
        fn _vcvtaq_s16_f16(a: float16x8_t) -> int16x8_t;
    }
    unsafe { _vcvtaq_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvta_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtas))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvta_s32_f32(a: float32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.v2i32.v2f32"
        )]
        fn _vcvta_s32_f32(a: float32x2_t) -> int32x2_t;
    }
    unsafe { _vcvta_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtaq_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtas))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtaq_s32_f32(a: float32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.v4i32.v4f32"
        )]
        fn _vcvtaq_s32_f32(a: float32x4_t) -> int32x4_t;
    }
    unsafe { _vcvtaq_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvta_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtas))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvta_s64_f64(a: float64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.v1i64.v1f64"
        )]
        fn _vcvta_s64_f64(a: float64x1_t) -> int64x1_t;
    }
    unsafe { _vcvta_s64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtaq_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtas))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtaq_s64_f64(a: float64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.v2i64.v2f64"
        )]
        fn _vcvtaq_s64_f64(a: float64x2_t) -> int64x2_t;
    }
    unsafe { _vcvtaq_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvta_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtau))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvta_u16_f16(a: float16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.v4i16.v4f16"
        )]
        fn _vcvta_u16_f16(a: float16x4_t) -> uint16x4_t;
    }
    unsafe { _vcvta_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtaq_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtau))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtaq_u16_f16(a: float16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.v8i16.v8f16"
        )]
        fn _vcvtaq_u16_f16(a: float16x8_t) -> uint16x8_t;
    }
    unsafe { _vcvtaq_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvta_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtau))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvta_u32_f32(a: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.v2i32.v2f32"
        )]
        fn _vcvta_u32_f32(a: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcvta_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtaq_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtau))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtaq_u32_f32(a: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.v4i32.v4f32"
        )]
        fn _vcvtaq_u32_f32(a: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcvtaq_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvta_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtau))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvta_u64_f64(a: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.v1i64.v1f64"
        )]
        fn _vcvta_u64_f64(a: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcvta_u64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtaq_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtau))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtaq_u64_f64(a: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.v2i64.v2f64"
        )]
        fn _vcvtaq_u64_f64(a: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcvtaq_u64_f64(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtah_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtas))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtah_s16_f16(a: f16) -> i16 {
    vcvtah_s32_f16(a) as i16
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtah_s32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtas))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtah_s32_f16(a: f16) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.i32.f16"
        )]
        fn _vcvtah_s32_f16(a: f16) -> i32;
    }
    unsafe { _vcvtah_s32_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtah_s64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtas))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtah_s64_f16(a: f16) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.i64.f16"
        )]
        fn _vcvtah_s64_f16(a: f16) -> i64;
    }
    unsafe { _vcvtah_s64_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtah_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtau))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtah_u16_f16(a: f16) -> u16 {
    vcvtah_u32_f16(a) as u16
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtah_u32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtau))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtah_u32_f16(a: f16) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.i32.f16"
        )]
        fn _vcvtah_u32_f16(a: f16) -> u32;
    }
    unsafe { _vcvtah_u32_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtah_u64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtau))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtah_u64_f16(a: f16) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.i64.f16"
        )]
        fn _vcvtah_u64_f16(a: f16) -> u64;
    }
    unsafe { _vcvtah_u64_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtas_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtas))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtas_s32_f32(a: f32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.i32.f32"
        )]
        fn _vcvtas_s32_f32(a: f32) -> i32;
    }
    unsafe { _vcvtas_s32_f32(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtad_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtas))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtad_s64_f64(a: f64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtas.i64.f64"
        )]
        fn _vcvtad_s64_f64(a: f64) -> i64;
    }
    unsafe { _vcvtad_s64_f64(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtas_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtau))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtas_u32_f32(a: f32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.i32.f32"
        )]
        fn _vcvtas_u32_f32(a: f32) -> u32;
    }
    unsafe { _vcvtas_u32_f32(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtad_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtau))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtad_u64_f64(a: f64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtau.i64.f64"
        )]
        fn _vcvtad_u64_f64(a: f64) -> u64;
    }
    unsafe { _vcvtad_u64_f64(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_f64_s64(a: i64) -> f64 {
    a as f64
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_f32_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_f32_s32(a: i32) -> f32 {
    a as f32
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_f16_s16)"]
#[inline]
#[cfg_attr(test, assert_instr(scvtf))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_f16_s16(a: i16) -> f16 {
    a as f16
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_f16_s32)"]
#[inline]
#[cfg_attr(test, assert_instr(scvtf))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_f16_s32(a: i32) -> f16 {
    a as f16
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_f16_s64)"]
#[inline]
#[cfg_attr(test, assert_instr(scvtf))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_f16_s64(a: i64) -> f16 {
    a as f16
}
#[doc = "Unsigned fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_f16_u16)"]
#[inline]
#[cfg_attr(test, assert_instr(ucvtf))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_f16_u16(a: u16) -> f16 {
    a as f16
}
#[doc = "Unsigned fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_f16_u32)"]
#[inline]
#[cfg_attr(test, assert_instr(ucvtf))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_f16_u32(a: u32) -> f16 {
    a as f16
}
#[doc = "Unsigned fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_f16_u64)"]
#[inline]
#[cfg_attr(test, assert_instr(ucvtf))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_f16_u64(a: u64) -> f16 {
    a as f16
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_f16_s16)"]
#[inline]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_f16_s16<const N: i32>(a: i16) -> f16 {
    static_assert!(N >= 1 && N <= 16);
    vcvth_n_f16_s32::<N>(a as i32)
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_f16_s32)"]
#[inline]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_f16_s32<const N: i32>(a: i32) -> f16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.f16.i32"
        )]
        fn _vcvth_n_f16_s32(a: i32, n: i32) -> f16;
    }
    unsafe { _vcvth_n_f16_s32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_f16_s64)"]
#[inline]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_f16_s64<const N: i32>(a: i64) -> f16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.f16.i64"
        )]
        fn _vcvth_n_f16_s64(a: i64, n: i32) -> f16;
    }
    unsafe { _vcvth_n_f16_s64(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_f16_u16)"]
#[inline]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_f16_u16<const N: i32>(a: u16) -> f16 {
    static_assert!(N >= 1 && N <= 16);
    vcvth_n_f16_u32::<N>(a as u32)
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_f16_u32)"]
#[inline]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_f16_u32<const N: i32>(a: u32) -> f16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.f16.i32"
        )]
        fn _vcvth_n_f16_u32(a: u32, n: i32) -> f16;
    }
    unsafe { _vcvth_n_f16_u32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_f16_u64)"]
#[inline]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_f16_u64<const N: i32>(a: u64) -> f16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.f16.i64"
        )]
        fn _vcvth_n_f16_u64(a: u64, n: i32) -> f16;
    }
    unsafe { _vcvth_n_f16_u64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_s16_f16<const N: i32>(a: f16) -> i16 {
    static_assert!(N >= 1 && N <= 16);
    vcvth_n_s32_f16::<N>(a) as i16
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_s32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_s32_f16<const N: i32>(a: f16) -> i32 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.i32.f16"
        )]
        fn _vcvth_n_s32_f16(a: f16, n: i32) -> i32;
    }
    unsafe { _vcvth_n_s32_f16(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_s64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_s64_f16<const N: i32>(a: f16) -> i64 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.i64.f16"
        )]
        fn _vcvth_n_s64_f16(a: f16, n: i32) -> i64;
    }
    unsafe { _vcvth_n_s64_f16(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_u16_f16<const N: i32>(a: f16) -> u16 {
    static_assert!(N >= 1 && N <= 16);
    vcvth_n_u32_f16::<N>(a) as u16
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_u32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_u32_f16<const N: i32>(a: f16) -> u32 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.i32.f16"
        )]
        fn _vcvth_n_u32_f16(a: f16, n: i32) -> u32;
    }
    unsafe { _vcvth_n_u32_f16(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_n_u64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_n_u64_f16<const N: i32>(a: f16) -> u64 {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.i64.f16"
        )]
        fn _vcvth_n_u64_f16(a: f16, n: i32) -> u64;
    }
    unsafe { _vcvth_n_u64_f16(a, N) }
}
#[doc = "Floating-point convert to signed fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_s16_f16(a: f16) -> i16 {
    a as i16
}
#[doc = "Floating-point convert to signed fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_s32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_s32_f16(a: f16) -> i32 {
    a as i32
}
#[doc = "Floating-point convert to signed fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_s64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_s64_f16(a: f16) -> i64 {
    a as i64
}
#[doc = "Floating-point convert to unsigned fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_u16_f16(a: f16) -> u16 {
    a as u16
}
#[doc = "Floating-point convert to unsigned fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_u32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_u32_f16(a: f16) -> u32 {
    a as u32
}
#[doc = "Floating-point convert to unsigned fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvth_u64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvth_u64_f16(a: f16) -> u64 {
    a as u64
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtm_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtms))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtm_s16_f16(a: float16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.v4i16.v4f16"
        )]
        fn _vcvtm_s16_f16(a: float16x4_t) -> int16x4_t;
    }
    unsafe { _vcvtm_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmq_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtms))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmq_s16_f16(a: float16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.v8i16.v8f16"
        )]
        fn _vcvtmq_s16_f16(a: float16x8_t) -> int16x8_t;
    }
    unsafe { _vcvtmq_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtm_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtms))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtm_s32_f32(a: float32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.v2i32.v2f32"
        )]
        fn _vcvtm_s32_f32(a: float32x2_t) -> int32x2_t;
    }
    unsafe { _vcvtm_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmq_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtms))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtmq_s32_f32(a: float32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.v4i32.v4f32"
        )]
        fn _vcvtmq_s32_f32(a: float32x4_t) -> int32x4_t;
    }
    unsafe { _vcvtmq_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtm_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtms))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtm_s64_f64(a: float64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.v1i64.v1f64"
        )]
        fn _vcvtm_s64_f64(a: float64x1_t) -> int64x1_t;
    }
    unsafe { _vcvtm_s64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmq_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtms))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtmq_s64_f64(a: float64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.v2i64.v2f64"
        )]
        fn _vcvtmq_s64_f64(a: float64x2_t) -> int64x2_t;
    }
    unsafe { _vcvtmq_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtm_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtm_u16_f16(a: float16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.v4i16.v4f16"
        )]
        fn _vcvtm_u16_f16(a: float16x4_t) -> uint16x4_t;
    }
    unsafe { _vcvtm_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmq_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmq_u16_f16(a: float16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.v8i16.v8f16"
        )]
        fn _vcvtmq_u16_f16(a: float16x8_t) -> uint16x8_t;
    }
    unsafe { _vcvtmq_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtm_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtm_u32_f32(a: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.v2i32.v2f32"
        )]
        fn _vcvtm_u32_f32(a: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcvtm_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmq_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtmq_u32_f32(a: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.v4i32.v4f32"
        )]
        fn _vcvtmq_u32_f32(a: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcvtmq_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtm_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtm_u64_f64(a: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.v1i64.v1f64"
        )]
        fn _vcvtm_u64_f64(a: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcvtm_u64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmq_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtmq_u64_f64(a: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.v2i64.v2f64"
        )]
        fn _vcvtmq_u64_f64(a: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcvtmq_u64_f64(a) }
}
#[doc = "Floating-point convert to integer, rounding towards minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmh_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtms))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmh_s16_f16(a: f16) -> i16 {
    vcvtmh_s32_f16(a) as i16
}
#[doc = "Floating-point convert to integer, rounding towards minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmh_s32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtms))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmh_s32_f16(a: f16) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.i32.f16"
        )]
        fn _vcvtmh_s32_f16(a: f16) -> i32;
    }
    unsafe { _vcvtmh_s32_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding towards minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmh_s64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtms))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmh_s64_f16(a: f16) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.i64.f16"
        )]
        fn _vcvtmh_s64_f16(a: f16) -> i64;
    }
    unsafe { _vcvtmh_s64_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding towards minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmh_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmh_u16_f16(a: f16) -> u16 {
    vcvtmh_u32_f16(a) as u16
}
#[doc = "Floating-point convert to unsigned integer, rounding towards minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmh_u32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmh_u32_f16(a: f16) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.i32.f16"
        )]
        fn _vcvtmh_u32_f16(a: f16) -> u32;
    }
    unsafe { _vcvtmh_u32_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding towards minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmh_u64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtmh_u64_f16(a: f16) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.i64.f16"
        )]
        fn _vcvtmh_u64_f16(a: f16) -> u64;
    }
    unsafe { _vcvtmh_u64_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtms_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtms))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtms_s32_f32(a: f32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.i32.f32"
        )]
        fn _vcvtms_s32_f32(a: f32) -> i32;
    }
    unsafe { _vcvtms_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmd_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtms))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtmd_s64_f64(a: f64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtms.i64.f64"
        )]
        fn _vcvtmd_s64_f64(a: f64) -> i64;
    }
    unsafe { _vcvtmd_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtms_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtms_u32_f32(a: f32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.i32.f32"
        )]
        fn _vcvtms_u32_f32(a: f32) -> u32;
    }
    unsafe { _vcvtms_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtmd_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtmu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtmd_u64_f64(a: f64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtmu.i64.f64"
        )]
        fn _vcvtmd_u64_f64(a: f64) -> u64;
    }
    unsafe { _vcvtmd_u64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtn_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtns))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtn_s16_f16(a: float16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.v4i16.v4f16"
        )]
        fn _vcvtn_s16_f16(a: float16x4_t) -> int16x4_t;
    }
    unsafe { _vcvtn_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnq_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtns))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnq_s16_f16(a: float16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.v8i16.v8f16"
        )]
        fn _vcvtnq_s16_f16(a: float16x8_t) -> int16x8_t;
    }
    unsafe { _vcvtnq_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtn_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtns))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtn_s32_f32(a: float32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.v2i32.v2f32"
        )]
        fn _vcvtn_s32_f32(a: float32x2_t) -> int32x2_t;
    }
    unsafe { _vcvtn_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnq_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtns))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtnq_s32_f32(a: float32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.v4i32.v4f32"
        )]
        fn _vcvtnq_s32_f32(a: float32x4_t) -> int32x4_t;
    }
    unsafe { _vcvtnq_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtn_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtns))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtn_s64_f64(a: float64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.v1i64.v1f64"
        )]
        fn _vcvtn_s64_f64(a: float64x1_t) -> int64x1_t;
    }
    unsafe { _vcvtn_s64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnq_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtns))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtnq_s64_f64(a: float64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.v2i64.v2f64"
        )]
        fn _vcvtnq_s64_f64(a: float64x2_t) -> int64x2_t;
    }
    unsafe { _vcvtnq_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtn_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtn_u16_f16(a: float16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.v4i16.v4f16"
        )]
        fn _vcvtn_u16_f16(a: float16x4_t) -> uint16x4_t;
    }
    unsafe { _vcvtn_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnq_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnq_u16_f16(a: float16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.v8i16.v8f16"
        )]
        fn _vcvtnq_u16_f16(a: float16x8_t) -> uint16x8_t;
    }
    unsafe { _vcvtnq_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtn_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtn_u32_f32(a: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.v2i32.v2f32"
        )]
        fn _vcvtn_u32_f32(a: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcvtn_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnq_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtnq_u32_f32(a: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.v4i32.v4f32"
        )]
        fn _vcvtnq_u32_f32(a: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcvtnq_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtn_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtn_u64_f64(a: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.v1i64.v1f64"
        )]
        fn _vcvtn_u64_f64(a: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcvtn_u64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnq_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtnq_u64_f64(a: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.v2i64.v2f64"
        )]
        fn _vcvtnq_u64_f64(a: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcvtnq_u64_f64(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnh_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtns))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnh_s16_f16(a: f16) -> i16 {
    vcvtnh_s32_f16(a) as i16
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnh_s32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtns))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnh_s32_f16(a: f16) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.i32.f16"
        )]
        fn _vcvtnh_s32_f16(a: f16) -> i32;
    }
    unsafe { _vcvtnh_s32_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnh_s64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtns))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnh_s64_f16(a: f16) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.i64.f16"
        )]
        fn _vcvtnh_s64_f16(a: f16) -> i64;
    }
    unsafe { _vcvtnh_s64_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnh_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnh_u16_f16(a: f16) -> u16 {
    vcvtnh_u32_f16(a) as u16
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnh_u32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnh_u32_f16(a: f16) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.i32.f16"
        )]
        fn _vcvtnh_u32_f16(a: f16) -> u32;
    }
    unsafe { _vcvtnh_u32_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnh_u64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtnh_u64_f16(a: f16) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.i64.f16"
        )]
        fn _vcvtnh_u64_f16(a: f16) -> u64;
    }
    unsafe { _vcvtnh_u64_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtns_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtns))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtns_s32_f32(a: f32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.i32.f32"
        )]
        fn _vcvtns_s32_f32(a: f32) -> i32;
    }
    unsafe { _vcvtns_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnd_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtns))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtnd_s64_f64(a: f64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtns.i64.f64"
        )]
        fn _vcvtnd_s64_f64(a: f64) -> i64;
    }
    unsafe { _vcvtnd_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtns_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtns_u32_f32(a: f32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.i32.f32"
        )]
        fn _vcvtns_u32_f32(a: f32) -> u32;
    }
    unsafe { _vcvtns_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtnd_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtnu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtnd_u64_f64(a: f64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtnu.i64.f64"
        )]
        fn _vcvtnd_u64_f64(a: f64) -> u64;
    }
    unsafe { _vcvtnd_u64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtp_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtps))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtp_s16_f16(a: float16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.v4i16.v4f16"
        )]
        fn _vcvtp_s16_f16(a: float16x4_t) -> int16x4_t;
    }
    unsafe { _vcvtp_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpq_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtps))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtpq_s16_f16(a: float16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.v8i16.v8f16"
        )]
        fn _vcvtpq_s16_f16(a: float16x8_t) -> int16x8_t;
    }
    unsafe { _vcvtpq_s16_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtp_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtp_s32_f32(a: float32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.v2i32.v2f32"
        )]
        fn _vcvtp_s32_f32(a: float32x2_t) -> int32x2_t;
    }
    unsafe { _vcvtp_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpq_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtpq_s32_f32(a: float32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.v4i32.v4f32"
        )]
        fn _vcvtpq_s32_f32(a: float32x4_t) -> int32x4_t;
    }
    unsafe { _vcvtpq_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtp_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtp_s64_f64(a: float64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.v1i64.v1f64"
        )]
        fn _vcvtp_s64_f64(a: float64x1_t) -> int64x1_t;
    }
    unsafe { _vcvtp_s64_f64(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpq_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtpq_s64_f64(a: float64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.v2i64.v2f64"
        )]
        fn _vcvtpq_s64_f64(a: float64x2_t) -> int64x2_t;
    }
    unsafe { _vcvtpq_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtp_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtp_u16_f16(a: float16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.v4i16.v4f16"
        )]
        fn _vcvtp_u16_f16(a: float16x4_t) -> uint16x4_t;
    }
    unsafe { _vcvtp_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpq_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtpq_u16_f16(a: float16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.v8i16.v8f16"
        )]
        fn _vcvtpq_u16_f16(a: float16x8_t) -> uint16x8_t;
    }
    unsafe { _vcvtpq_u16_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtp_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtp_u32_f32(a: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.v2i32.v2f32"
        )]
        fn _vcvtp_u32_f32(a: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcvtp_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpq_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtpq_u32_f32(a: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.v4i32.v4f32"
        )]
        fn _vcvtpq_u32_f32(a: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcvtpq_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtp_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtp_u64_f64(a: float64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.v1i64.v1f64"
        )]
        fn _vcvtp_u64_f64(a: float64x1_t) -> uint64x1_t;
    }
    unsafe { _vcvtp_u64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpq_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtpq_u64_f64(a: float64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.v2i64.v2f64"
        )]
        fn _vcvtpq_u64_f64(a: float64x2_t) -> uint64x2_t;
    }
    unsafe { _vcvtpq_u64_f64(a) }
}
#[doc = "Floating-point convert to integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtph_s16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtps))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtph_s16_f16(a: f16) -> i16 {
    vcvtph_s32_f16(a) as i16
}
#[doc = "Floating-point convert to integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtph_s32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtps))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtph_s32_f16(a: f16) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.i32.f16"
        )]
        fn _vcvtph_s32_f16(a: f16) -> i32;
    }
    unsafe { _vcvtph_s32_f16(a) }
}
#[doc = "Floating-point convert to integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtph_s64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtps))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtph_s64_f16(a: f16) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.i64.f16"
        )]
        fn _vcvtph_s64_f16(a: f16) -> i64;
    }
    unsafe { _vcvtph_s64_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtph_u16_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtph_u16_f16(a: f16) -> u16 {
    vcvtph_u32_f16(a) as u16
}
#[doc = "Floating-point convert to unsigned integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtph_u32_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtph_u32_f16(a: f16) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.i32.f16"
        )]
        fn _vcvtph_u32_f16(a: f16) -> u32;
    }
    unsafe { _vcvtph_u32_f16(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding to plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtph_u64_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vcvtph_u64_f16(a: f16) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.i64.f16"
        )]
        fn _vcvtph_u64_f16(a: f16) -> u64;
    }
    unsafe { _vcvtph_u64_f16(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtps_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtps_s32_f32(a: f32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.i32.f32"
        )]
        fn _vcvtps_s32_f32(a: f32) -> i32;
    }
    unsafe { _vcvtps_s32_f32(a) }
}
#[doc = "Floating-point convert to signed integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpd_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtpd_s64_f64(a: f64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtps.i64.f64"
        )]
        fn _vcvtpd_s64_f64(a: f64) -> i64;
    }
    unsafe { _vcvtpd_s64_f64(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtps_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtps_u32_f32(a: f32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.i32.f32"
        )]
        fn _vcvtps_u32_f32(a: f32) -> u32;
    }
    unsafe { _vcvtps_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned integer, rounding toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtpd_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtpu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtpd_u64_f64(a: f64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtpu.i64.f64"
        )]
        fn _vcvtpd_u64_f64(a: f64) -> u64;
    }
    unsafe { _vcvtpd_u64_f64(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_f32_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_f32_u32(a: u32) -> f32 {
    a as f32
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_f64_u64(a: u64) -> f64 {
    a as f64
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_n_f32_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_n_f32_s32<const N: i32>(a: i32) -> f32 {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.f32.i32"
        )]
        fn _vcvts_n_f32_s32(a: i32, n: i32) -> f32;
    }
    unsafe { _vcvts_n_f32_s32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_n_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_n_f64_s64<const N: i32>(a: i64) -> f64 {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.f64.i64"
        )]
        fn _vcvtd_n_f64_s64(a: i64, n: i32) -> f64;
    }
    unsafe { _vcvtd_n_f64_s64(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_n_f32_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_n_f32_u32<const N: i32>(a: u32) -> f32 {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.f32.i32"
        )]
        fn _vcvts_n_f32_u32(a: u32, n: i32) -> f32;
    }
    unsafe { _vcvts_n_f32_u32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_n_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_n_f64_u64<const N: i32>(a: u64) -> f64 {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.f64.i64"
        )]
        fn _vcvtd_n_f64_u64(a: u64, n: i32) -> f64;
    }
    unsafe { _vcvtd_n_f64_u64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_n_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_n_s32_f32<const N: i32>(a: f32) -> i32 {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.i32.f32"
        )]
        fn _vcvts_n_s32_f32(a: f32, n: i32) -> i32;
    }
    unsafe { _vcvts_n_s32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_n_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_n_s64_f64<const N: i32>(a: f64) -> i64 {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.i64.f64"
        )]
        fn _vcvtd_n_s64_f64(a: f64, n: i32) -> i64;
    }
    unsafe { _vcvtd_n_s64_f64(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_n_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_n_u32_f32<const N: i32>(a: f32) -> u32 {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.i32.f32"
        )]
        fn _vcvts_n_u32_f32(a: f32, n: i32) -> u32;
    }
    unsafe { _vcvts_n_u32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_n_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_n_u64_f64<const N: i32>(a: f64) -> u64 {
    static_assert!(N >= 1 && N <= 64);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.i64.f64"
        )]
        fn _vcvtd_n_u64_f64(a: f64, n: i32) -> u64;
    }
    unsafe { _vcvtd_n_u64_f64(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_s32_f32(a: f32) -> i32 {
    a as i32
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzs))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_s64_f64(a: f64) -> i64 {
    a as i64
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvts_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvts_u32_f32(a: f32) -> u32 {
    a as u32
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtd_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtzu))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtd_u64_f64(a: f64) -> u64 {
    a as u64
}
#[doc = "Floating-point convert to lower precision narrow, rounding to odd"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtx_f32_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtxn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtx_f32_f64(a: float64x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fcvtxn.v2f32.v2f64"
        )]
        fn _vcvtx_f32_f64(a: float64x2_t) -> float32x2_t;
    }
    unsafe { _vcvtx_f32_f64(a) }
}
#[doc = "Floating-point convert to lower precision narrow, rounding to odd"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtx_high_f32_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtxn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtx_high_f32_f64(a: float32x2_t, b: float64x2_t) -> float32x4_t {
    unsafe { simd_shuffle!(a, vcvtx_f32_f64(b), [0, 1, 2, 3]) }
}
#[doc = "Floating-point convert to lower precision narrow, rounding to odd"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtxd_f32_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fcvtxn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtxd_f32_f64(a: f64) -> f32 {
    unsafe { simd_extract!(vcvtx_f32_f64(vdupq_n_f64(a)), 0) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdiv_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fdiv))]
pub fn vdiv_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe { simd_div(a, b) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdivq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fdiv))]
pub fn vdivq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe { simd_div(a, b) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdiv_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fdiv))]
pub fn vdiv_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe { simd_div(a, b) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdivq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fdiv))]
pub fn vdivq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe { simd_div(a, b) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdiv_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fdiv))]
pub fn vdiv_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe { simd_div(a, b) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdivq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fdiv))]
pub fn vdivq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe { simd_div(a, b) }
}
#[doc = "Divide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdivh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vdivh_f16(a: f16, b: f16) -> f16 {
    a / b
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(test, assert_instr(sdot, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_dotprod", issue = "117224")]
pub fn vdot_laneq_s32<const LANE: i32>(a: int32x2_t, b: int8x8_t, c: int8x16_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int32x4_t = transmute(c);
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vdot_s32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(test, assert_instr(sdot, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_dotprod", issue = "117224")]
pub fn vdotq_laneq_s32<const LANE: i32>(a: int32x4_t, b: int8x16_t, c: int8x16_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int32x4_t = transmute(c);
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vdotq_s32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(test, assert_instr(udot, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_dotprod", issue = "117224")]
pub fn vdot_laneq_u32<const LANE: i32>(a: uint32x2_t, b: uint8x8_t, c: uint8x16_t) -> uint32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: uint32x4_t = transmute(c);
        let c: uint32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vdot_u32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(test, assert_instr(udot, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_dotprod", issue = "117224")]
pub fn vdotq_laneq_u32<const LANE: i32>(a: uint32x4_t, b: uint8x16_t, c: uint8x16_t) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: uint32x4_t = transmute(c);
        let c: uint32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vdotq_u32(a, b, transmute(c))
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdup_lane_f64<const N: i32>(a: float64x1_t) -> float64x1_t {
    static_assert!(N == 0);
    a
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdup_lane_p64<const N: i32>(a: poly64x1_t) -> poly64x1_t {
    static_assert!(N == 0);
    a
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdup_laneq_f64<const N: i32>(a: float64x2_t) -> float64x1_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { transmute::<f64, _>(simd_extract!(a, N as u32)) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdup_laneq_p64<const N: i32>(a: poly64x2_t) -> poly64x1_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { transmute::<u64, _>(simd_extract!(a, N as u32)) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupb_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupb_lane_s8<const N: i32>(a: int8x8_t) -> i8 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vduph_laneq_s16<const N: i32>(a: int16x8_t) -> i16 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupb_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupb_lane_u8<const N: i32>(a: uint8x8_t) -> u8 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vduph_laneq_u16<const N: i32>(a: uint16x8_t) -> u16 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupb_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupb_lane_p8<const N: i32>(a: poly8x8_t) -> p8 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_laneq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vduph_laneq_p16<const N: i32>(a: poly16x8_t) -> p16 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Extract an element from a vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupb_laneq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 8))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupb_laneq_s8<const N: i32>(a: int8x16_t) -> i8 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Extract an element from a vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupb_laneq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 8))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupb_laneq_u8<const N: i32>(a: uint8x16_t) -> u8 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Extract an element from a vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupb_laneq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 8))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupb_laneq_p8<const N: i32>(a: poly8x16_t) -> p8 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupd_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupd_lane_f64<const N: i32>(a: float64x1_t) -> f64 {
    static_assert!(N == 0);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupd_lane_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupd_lane_s64<const N: i32>(a: int64x1_t) -> i64 {
    static_assert!(N == 0);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupd_lane_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupd_lane_u64<const N: i32>(a: uint64x1_t) -> u64 {
    static_assert!(N == 0);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vduph_lane_f16<const N: i32>(a: float16x4_t) -> f16 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Extract an element from a vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(nop, N = 4))]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vduph_laneq_f16<const N: i32>(a: float16x8_t) -> f16 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(dup, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupq_lane_f64<const N: i32>(a: float64x1_t) -> float64x2_t {
    static_assert!(N == 0);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(dup, N = 0))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupq_lane_p64<const N: i32>(a: poly64x1_t) -> poly64x2_t {
    static_assert!(N == 0);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(dup, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupq_laneq_f64<const N: i32>(a: float64x2_t) -> float64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(dup, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupq_laneq_p64<const N: i32>(a: poly64x2_t) -> poly64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdups_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdups_lane_f32<const N: i32>(a: float32x2_t) -> f32 {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupd_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupd_laneq_f64<const N: i32>(a: float64x2_t) -> f64 {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdups_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdups_lane_s32<const N: i32>(a: int32x2_t) -> i32 {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupd_laneq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupd_laneq_s64<const N: i32>(a: int64x2_t) -> i64 {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdups_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdups_lane_u32<const N: i32>(a: uint32x2_t) -> u32 {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupd_laneq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 1))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdupd_laneq_u64<const N: i32>(a: uint64x2_t) -> u64 {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdups_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdups_laneq_f32<const N: i32>(a: float32x4_t) -> f32 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vduph_lane_s16<const N: i32>(a: int16x4_t) -> i16 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdups_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdups_laneq_s32<const N: i32>(a: int32x4_t) -> i32 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vduph_lane_u16<const N: i32>(a: uint16x4_t) -> u16 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdups_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vdups_laneq_u32<const N: i32>(a: uint32x4_t) -> u32 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vduph_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vduph_lane_p16<const N: i32>(a: poly16x4_t) -> p16 {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_extract!(a, N as u32) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_s8)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_s8(a: int8x16_t, b: int8x16_t, c: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3s.v16i8"
        )]
        fn _veor3q_s8(a: int8x16_t, b: int8x16_t, c: int8x16_t) -> int8x16_t;
    }
    unsafe { _veor3q_s8(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_s16)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3s.v8i16"
        )]
        fn _veor3q_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t;
    }
    unsafe { _veor3q_s16(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_s32)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3s.v4i32"
        )]
        fn _veor3q_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t;
    }
    unsafe { _veor3q_s32(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_s64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_s64(a: int64x2_t, b: int64x2_t, c: int64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3s.v2i64"
        )]
        fn _veor3q_s64(a: int64x2_t, b: int64x2_t, c: int64x2_t) -> int64x2_t;
    }
    unsafe { _veor3q_s64(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_u8)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3u.v16i8"
        )]
        fn _veor3q_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _veor3q_u8(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_u16)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_u16(a: uint16x8_t, b: uint16x8_t, c: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3u.v8i16"
        )]
        fn _veor3q_u16(a: uint16x8_t, b: uint16x8_t, c: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _veor3q_u16(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_u32)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3u.v4i32"
        )]
        fn _veor3q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _veor3q_u32(a, b, c) }
}
#[doc = "Three-way exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor3q_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
#[cfg_attr(test, assert_instr(eor3))]
pub fn veor3q_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.eor3u.v2i64"
        )]
        fn _veor3q_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _veor3q_u64(a, b, c) }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ext, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vextq_f64<const N: i32>(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ext, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vextq_p64<const N: i32>(a: poly64x2_t, b: poly64x2_t) -> poly64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmadd))]
pub fn vfma_f64(a: float64x1_t, b: float64x1_t, c: float64x1_t) -> float64x1_t {
    unsafe { simd_fma(b, c, a) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfma_lane_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x4_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfma_f16(a, b, vdup_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfma_laneq_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x8_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfma_f16(a, b, vdup_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmaq_lane_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x4_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmaq_f16(a, b, vdupq_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmaq_laneq_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x8_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmaq_f16(a, b, vdupq_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfma_lane_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x2_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfma_f32(a, b, vdup_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfma_laneq_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfma_f32(a, b, vdup_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmaq_lane_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x2_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfmaq_f32(a, b, vdupq_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmaq_laneq_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmaq_f32(a, b, vdupq_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmaq_laneq_f64<const LANE: i32>(
    a: float64x2_t,
    b: float64x2_t,
    c: float64x2_t,
) -> float64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfmaq_f64(a, b, vdupq_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfma_lane_f64<const LANE: i32>(
    a: float64x1_t,
    b: float64x1_t,
    c: float64x1_t,
) -> float64x1_t {
    static_assert!(LANE == 0);
    unsafe { vfma_f64(a, b, vdup_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfma_laneq_f64<const LANE: i32>(
    a: float64x1_t,
    b: float64x1_t,
    c: float64x2_t,
) -> float64x1_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfma_f64(a, b, vdup_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract from accumulator."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_n_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmla))]
pub fn vfma_n_f16(a: float16x4_t, b: float16x4_t, c: f16) -> float16x4_t {
    vfma_f16(a, b, vdup_n_f16(c))
}
#[doc = "Floating-point fused Multiply-Subtract from accumulator."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_n_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmla))]
pub fn vfmaq_n_f16(a: float16x8_t, b: float16x8_t, c: f16) -> float16x8_t {
    vfmaq_f16(a, b, vdupq_n_f16(c))
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_n_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmadd))]
pub fn vfma_n_f64(a: float64x1_t, b: float64x1_t, c: f64) -> float64x1_t {
    vfma_f64(a, b, vdup_n_f64(c))
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmad_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmad_lane_f64<const LANE: i32>(a: f64, b: f64, c: float64x1_t) -> f64 {
    static_assert!(LANE == 0);
    unsafe {
        let c: f64 = simd_extract!(c, LANE as u32);
        fmaf64(b, c, a)
    }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmah_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmadd))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmah_f16(a: f16, b: f16, c: f16) -> f16 {
    unsafe { fmaf16(b, c, a) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmah_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmah_lane_f16<const LANE: i32>(a: f16, b: f16, v: float16x4_t) -> f16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: f16 = simd_extract!(v, LANE as u32);
        vfmah_f16(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmah_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmah_laneq_f16<const LANE: i32>(a: f16, b: f16, v: float16x8_t) -> f16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let c: f16 = simd_extract!(v, LANE as u32);
        vfmah_f16(a, b, c)
    }
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmla))]
pub fn vfmaq_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe { simd_fma(b, c, a) }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmla, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmaq_lane_f64<const LANE: i32>(
    a: float64x2_t,
    b: float64x2_t,
    c: float64x1_t,
) -> float64x2_t {
    static_assert!(LANE == 0);
    unsafe { vfmaq_f64(a, b, vdupq_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_n_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmla))]
pub fn vfmaq_n_f64(a: float64x2_t, b: float64x2_t, c: f64) -> float64x2_t {
    vfmaq_f64(a, b, vdupq_n_f64(c))
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmas_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmas_lane_f32<const LANE: i32>(a: f32, b: f32, c: float32x2_t) -> f32 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: f32 = simd_extract!(c, LANE as u32);
        fmaf32(b, c, a)
    }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmas_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmas_laneq_f32<const LANE: i32>(a: f32, b: f32, c: float32x4_t) -> f32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: f32 = simd_extract!(c, LANE as u32);
        fmaf32(b, c, a)
    }
}
#[doc = "Floating-point fused multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmad_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmadd, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmad_laneq_f64<const LANE: i32>(a: f64, b: f64, c: float64x2_t) -> f64 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: f64 = simd_extract!(c, LANE as u32);
        fmaf64(b, c, a)
    }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlal_high_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlal2))]
pub fn vfmlal_high_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlal2.v2f32.v4f16"
        )]
        fn _vfmlal_high_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t;
    }
    unsafe { _vfmlal_high_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlalq_high_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlal2))]
pub fn vfmlalq_high_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlal2.v4f32.v8f16"
        )]
        fn _vfmlalq_high_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t;
    }
    unsafe { _vfmlalq_high_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlal_lane_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlal_lane_high_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlal_high_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlal_laneq_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlal_laneq_high_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x8_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlal_high_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlalq_lane_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlalq_lane_high_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlalq_high_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlalq_laneq_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlalq_laneq_high_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x8_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlalq_high_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlal_lane_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlal_lane_low_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlal_low_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlal_laneq_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlal_laneq_low_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x8_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlal_low_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlalq_lane_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlalq_lane_low_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlalq_low_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlalq_laneq_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlal, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlalq_laneq_low_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x8_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlalq_low_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlal_low_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlal))]
pub fn vfmlal_low_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlal.v2f32.v4f16"
        )]
        fn _vfmlal_low_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t;
    }
    unsafe { _vfmlal_low_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Add Long to accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlalq_low_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlal))]
pub fn vfmlalq_low_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlal.v4f32.v8f16"
        )]
        fn _vfmlalq_low_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t;
    }
    unsafe { _vfmlalq_low_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlsl_high_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlsl2))]
pub fn vfmlsl_high_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlsl2.v2f32.v4f16"
        )]
        fn _vfmlsl_high_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t;
    }
    unsafe { _vfmlsl_high_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlslq_high_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlsl2))]
pub fn vfmlslq_high_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlsl2.v4f32.v8f16"
        )]
        fn _vfmlslq_high_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t;
    }
    unsafe { _vfmlslq_high_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlsl_lane_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlsl_lane_high_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlsl_high_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlsl_laneq_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlsl_laneq_high_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x8_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlsl_high_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlslq_lane_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlslq_lane_high_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlslq_high_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlslq_laneq_high_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl2, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlslq_laneq_high_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x8_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlslq_high_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlsl_lane_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlsl_lane_low_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlsl_low_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlsl_laneq_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlsl_laneq_low_f16<const LANE: i32>(
    r: float32x2_t,
    a: float16x4_t,
    b: float16x8_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlsl_low_f16(r, a, vdup_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlslq_lane_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlslq_lane_low_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmlslq_low_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (by element)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlslq_laneq_low_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmlsl, LANE = 0))]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmlslq_laneq_low_f16<const LANE: i32>(
    r: float32x4_t,
    a: float16x8_t,
    b: float16x8_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmlslq_low_f16(r, a, vdupq_n_f16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlsl_low_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlsl))]
pub fn vfmlsl_low_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlsl.v2f32.v4f16"
        )]
        fn _vfmlsl_low_f16(r: float32x2_t, a: float16x4_t, b: float16x4_t) -> float32x2_t;
    }
    unsafe { _vfmlsl_low_f16(r, a, b) }
}
#[doc = "Floating-point fused Multiply-Subtract Long from accumulator (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmlslq_low_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(not(target_arch = "arm"), target_feature(enable = "fhm"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmlsl))]
pub fn vfmlslq_low_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmlsl.v4f32.v8f16"
        )]
        fn _vfmlslq_low_f16(r: float32x4_t, a: float16x8_t, b: float16x8_t) -> float32x4_t;
    }
    unsafe { _vfmlslq_low_f16(r, a, b) }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfms_f64(a: float64x1_t, b: float64x1_t, c: float64x1_t) -> float64x1_t {
    unsafe {
        let b: float64x1_t = simd_neg(b);
        vfma_f64(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfms_lane_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x4_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfms_f16(a, b, vdup_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfms_laneq_f16<const LANE: i32>(
    a: float16x4_t,
    b: float16x4_t,
    c: float16x8_t,
) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfms_f16(a, b, vdup_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmsq_lane_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x4_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmsq_f16(a, b, vdupq_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmsq_laneq_f16<const LANE: i32>(
    a: float16x8_t,
    b: float16x8_t,
    c: float16x8_t,
) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vfmsq_f16(a, b, vdupq_n_f16(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfms_lane_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x2_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfms_f32(a, b, vdup_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfms_laneq_f32<const LANE: i32>(
    a: float32x2_t,
    b: float32x2_t,
    c: float32x4_t,
) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfms_f32(a, b, vdup_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsq_lane_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x2_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfmsq_f32(a, b, vdupq_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsq_laneq_f32<const LANE: i32>(
    a: float32x4_t,
    b: float32x4_t,
    c: float32x4_t,
) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vfmsq_f32(a, b, vdupq_n_f32(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsq_laneq_f64<const LANE: i32>(
    a: float64x2_t,
    b: float64x2_t,
    c: float64x2_t,
) -> float64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfmsq_f64(a, b, vdupq_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfms_lane_f64<const LANE: i32>(
    a: float64x1_t,
    b: float64x1_t,
    c: float64x1_t,
) -> float64x1_t {
    static_assert!(LANE == 0);
    unsafe { vfms_f64(a, b, vdup_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfms_laneq_f64<const LANE: i32>(
    a: float64x1_t,
    b: float64x1_t,
    c: float64x2_t,
) -> float64x1_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vfms_f64(a, b, vdup_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-Subtract from accumulator."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_n_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmls))]
pub fn vfms_n_f16(a: float16x4_t, b: float16x4_t, c: f16) -> float16x4_t {
    vfms_f16(a, b, vdup_n_f16(c))
}
#[doc = "Floating-point fused Multiply-Subtract from accumulator."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_n_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmls))]
pub fn vfmsq_n_f16(a: float16x8_t, b: float16x8_t, c: f16) -> float16x8_t {
    vfmsq_f16(a, b, vdupq_n_f16(c))
}
#[doc = "Floating-point fused Multiply-subtract to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_n_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfms_n_f64(a: float64x1_t, b: float64x1_t, c: f64) -> float64x1_t {
    vfms_f64(a, b, vdup_n_f64(c))
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmsub))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmsh_f16(a: f16, b: f16, c: f16) -> f16 {
    vfmah_f16(a, -b, c)
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsh_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmsh_lane_f16<const LANE: i32>(a: f16, b: f16, v: float16x4_t) -> f16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: f16 = simd_extract!(v, LANE as u32);
        vfmsh_f16(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsh_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vfmsh_laneq_f16<const LANE: i32>(a: f16, b: f16, v: float16x8_t) -> f16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let c: f16 = simd_extract!(v, LANE as u32);
        vfmsh_f16(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsq_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe {
        let b: float64x2_t = simd_neg(b);
        vfmaq_f64(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsq_lane_f64<const LANE: i32>(
    a: float64x2_t,
    b: float64x2_t,
    c: float64x1_t,
) -> float64x2_t {
    static_assert!(LANE == 0);
    unsafe { vfmsq_f64(a, b, vdupq_n_f64(simd_extract!(c, LANE as u32))) }
}
#[doc = "Floating-point fused Multiply-subtract to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_n_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmls))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsq_n_f64(a: float64x2_t, b: float64x2_t, c: f64) -> float64x2_t {
    vfmsq_f64(a, b, vdupq_n_f64(c))
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmss_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmss_lane_f32<const LANE: i32>(a: f32, b: f32, c: float32x2_t) -> f32 {
    vfmas_lane_f32::<LANE>(a, -b, c)
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmss_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmss_laneq_f32<const LANE: i32>(a: f32, b: f32, c: float32x4_t) -> f32 {
    vfmas_laneq_f32::<LANE>(a, -b, c)
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsd_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsd_lane_f64<const LANE: i32>(a: f64, b: f64, c: float64x1_t) -> f64 {
    vfmad_lane_f64::<LANE>(a, -b, c)
}
#[doc = "Floating-point fused multiply-subtract to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsd_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmsub, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vfmsd_laneq_f64<const LANE: i32>(a: f64, b: f64, c: float64x2_t) -> f64 {
    vfmad_laneq_f64::<LANE>(a, -b, c)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(test, assert_instr(ldr))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub unsafe fn vld1_f16(ptr: *const f16) -> float16x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(test, assert_instr(ldr))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub unsafe fn vld1q_f16(ptr: *const f16) -> float16x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_f32(ptr: *const f32) -> float32x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_f32(ptr: *const f32) -> float32x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_f64(ptr: *const f64) -> float64x1_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_f64(ptr: *const f64) -> float64x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_s8(ptr: *const i8) -> int8x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_s8(ptr: *const i8) -> int8x16_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_s16(ptr: *const i16) -> int16x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_s16(ptr: *const i16) -> int16x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_s32(ptr: *const i32) -> int32x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_s32(ptr: *const i32) -> int32x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_s64(ptr: *const i64) -> int64x1_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_s64(ptr: *const i64) -> int64x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_u8(ptr: *const u8) -> uint8x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_u8(ptr: *const u8) -> uint8x16_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_u16(ptr: *const u16) -> uint16x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_u16(ptr: *const u16) -> uint16x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_u32(ptr: *const u32) -> uint32x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_u32(ptr: *const u32) -> uint32x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_u64(ptr: *const u64) -> uint64x1_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_u64(ptr: *const u64) -> uint64x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_p8(ptr: *const p8) -> poly8x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_p8(ptr: *const p8) -> poly8x16_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_p16(ptr: *const p16) -> poly16x4_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_p16(ptr: *const p16) -> poly16x8_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1_p64(ptr: *const p64) -> poly64x1_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ldr))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld1q_p64(ptr: *const p64) -> poly64x2_t {
    crate::ptr::read_unaligned(ptr.cast())
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld1))]
pub unsafe fn vld1_f64_x2(a: *const f64) -> float64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v1f64.p0"
        )]
        fn _vld1_f64_x2(a: *const f64) -> float64x1x2_t;
    }
    _vld1_f64_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld1))]
pub unsafe fn vld1_f64_x3(a: *const f64) -> float64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v1f64.p0"
        )]
        fn _vld1_f64_x3(a: *const f64) -> float64x1x3_t;
    }
    _vld1_f64_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld1))]
pub unsafe fn vld1_f64_x4(a: *const f64) -> float64x1x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v1f64.p0"
        )]
        fn _vld1_f64_x4(a: *const f64) -> float64x1x4_t;
    }
    _vld1_f64_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld1))]
pub unsafe fn vld1q_f64_x2(a: *const f64) -> float64x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v2f64.p0"
        )]
        fn _vld1q_f64_x2(a: *const f64) -> float64x2x2_t;
    }
    _vld1q_f64_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld1))]
pub unsafe fn vld1q_f64_x3(a: *const f64) -> float64x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v2f64.p0"
        )]
        fn _vld1q_f64_x3(a: *const f64) -> float64x2x3_t;
    }
    _vld1q_f64_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld1))]
pub unsafe fn vld1q_f64_x4(a: *const f64) -> float64x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v2f64.p0"
        )]
        fn _vld1q_f64_x4(a: *const f64) -> float64x2x4_t;
    }
    _vld1q_f64_x4(a)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2_dup_f64(a: *const f64) -> float64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v1f64.p0"
        )]
        fn _vld2_dup_f64(ptr: *const f64) -> float64x1x2_t;
    }
    _vld2_dup_f64(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_f64(a: *const f64) -> float64x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v2f64.p0"
        )]
        fn _vld2q_dup_f64(ptr: *const f64) -> float64x2x2_t;
    }
    _vld2q_dup_f64(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_s64(a: *const i64) -> int64x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v2i64.p0"
        )]
        fn _vld2q_dup_s64(ptr: *const i64) -> int64x2x2_t;
    }
    _vld2q_dup_s64(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld2_f64(a: *const f64) -> float64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v1f64.p0"
        )]
        fn _vld2_f64(ptr: *const float64x1_t) -> float64x1x2_t;
    }
    _vld2_f64(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_f64<const LANE: i32>(a: *const f64, b: float64x1x2_t) -> float64x1x2_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v1f64.p0"
        )]
        fn _vld2_lane_f64(a: float64x1_t, b: float64x1_t, n: i64, ptr: *const i8) -> float64x1x2_t;
    }
    _vld2_lane_f64(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_s64<const LANE: i32>(a: *const i64, b: int64x1x2_t) -> int64x1x2_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v1i64.p0"
        )]
        fn _vld2_lane_s64(a: int64x1_t, b: int64x1_t, n: i64, ptr: *const i8) -> int64x1x2_t;
    }
    _vld2_lane_s64(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_p64<const LANE: i32>(a: *const p64, b: poly64x1x2_t) -> poly64x1x2_t {
    static_assert!(LANE == 0);
    transmute(vld2_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_u64<const LANE: i32>(a: *const u64, b: uint64x1x2_t) -> uint64x1x2_t {
    static_assert!(LANE == 0);
    transmute(vld2_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_p64(a: *const p64) -> poly64x2x2_t {
    transmute(vld2q_dup_s64(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_p64(a: *const p64) -> poly64x2x2_t {
    let mut ret_val: poly64x2x2_t = transmute(vld2q_dup_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_u64(a: *const u64) -> uint64x2x2_t {
    transmute(vld2q_dup_s64(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_u64(a: *const u64) -> uint64x2x2_t {
    let mut ret_val: uint64x2x2_t = transmute(vld2q_dup_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_f64(a: *const f64) -> float64x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v2f64.p0"
        )]
        fn _vld2q_f64(ptr: *const float64x2_t) -> float64x2x2_t;
    }
    _vld2q_f64(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_s64(a: *const i64) -> int64x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v2i64.p0"
        )]
        fn _vld2q_s64(ptr: *const int64x2_t) -> int64x2x2_t;
    }
    _vld2q_s64(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_f64<const LANE: i32>(a: *const f64, b: float64x2x2_t) -> float64x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v2f64.p0"
        )]
        fn _vld2q_lane_f64(a: float64x2_t, b: float64x2_t, n: i64, ptr: *const i8)
            -> float64x2x2_t;
    }
    _vld2q_lane_f64(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_s8<const LANE: i32>(a: *const i8, b: int8x16x2_t) -> int8x16x2_t {
    static_assert_uimm_bits!(LANE, 4);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v16i8.p0"
        )]
        fn _vld2q_lane_s8(a: int8x16_t, b: int8x16_t, n: i64, ptr: *const i8) -> int8x16x2_t;
    }
    _vld2q_lane_s8(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_s64<const LANE: i32>(a: *const i64, b: int64x2x2_t) -> int64x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v2i64.p0"
        )]
        fn _vld2q_lane_s64(a: int64x2_t, b: int64x2_t, n: i64, ptr: *const i8) -> int64x2x2_t;
    }
    _vld2q_lane_s64(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_p64<const LANE: i32>(a: *const p64, b: poly64x2x2_t) -> poly64x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld2q_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_u8<const LANE: i32>(a: *const u8, b: uint8x16x2_t) -> uint8x16x2_t {
    static_assert_uimm_bits!(LANE, 4);
    transmute(vld2q_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_u64<const LANE: i32>(a: *const u64, b: uint64x2x2_t) -> uint64x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld2q_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_p8<const LANE: i32>(a: *const p8, b: poly8x16x2_t) -> poly8x16x2_t {
    static_assert_uimm_bits!(LANE, 4);
    transmute(vld2q_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_p64(a: *const p64) -> poly64x2x2_t {
    transmute(vld2q_s64(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_p64(a: *const p64) -> poly64x2x2_t {
    let mut ret_val: poly64x2x2_t = transmute(vld2q_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_u64(a: *const u64) -> uint64x2x2_t {
    transmute(vld2q_s64(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_u64(a: *const u64) -> uint64x2x2_t {
    let mut ret_val: uint64x2x2_t = transmute(vld2q_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3_dup_f64(a: *const f64) -> float64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v1f64.p0"
        )]
        fn _vld3_dup_f64(ptr: *const f64) -> float64x1x3_t;
    }
    _vld3_dup_f64(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_f64(a: *const f64) -> float64x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v2f64.p0"
        )]
        fn _vld3q_dup_f64(ptr: *const f64) -> float64x2x3_t;
    }
    _vld3q_dup_f64(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_s64(a: *const i64) -> int64x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v2i64.p0"
        )]
        fn _vld3q_dup_s64(ptr: *const i64) -> int64x2x3_t;
    }
    _vld3q_dup_s64(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld3_f64(a: *const f64) -> float64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v1f64.p0"
        )]
        fn _vld3_f64(ptr: *const float64x1_t) -> float64x1x3_t;
    }
    _vld3_f64(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_f64<const LANE: i32>(a: *const f64, b: float64x1x3_t) -> float64x1x3_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v1f64.p0"
        )]
        fn _vld3_lane_f64(
            a: float64x1_t,
            b: float64x1_t,
            c: float64x1_t,
            n: i64,
            ptr: *const i8,
        ) -> float64x1x3_t;
    }
    _vld3_lane_f64(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_p64<const LANE: i32>(a: *const p64, b: poly64x1x3_t) -> poly64x1x3_t {
    static_assert!(LANE == 0);
    transmute(vld3_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_s64<const LANE: i32>(a: *const i64, b: int64x1x3_t) -> int64x1x3_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v1i64.p0"
        )]
        fn _vld3_lane_s64(
            a: int64x1_t,
            b: int64x1_t,
            c: int64x1_t,
            n: i64,
            ptr: *const i8,
        ) -> int64x1x3_t;
    }
    _vld3_lane_s64(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_u64<const LANE: i32>(a: *const u64, b: uint64x1x3_t) -> uint64x1x3_t {
    static_assert!(LANE == 0);
    transmute(vld3_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_p64(a: *const p64) -> poly64x2x3_t {
    transmute(vld3q_dup_s64(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_p64(a: *const p64) -> poly64x2x3_t {
    let mut ret_val: poly64x2x3_t = transmute(vld3q_dup_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_u64(a: *const u64) -> uint64x2x3_t {
    transmute(vld3q_dup_s64(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_u64(a: *const u64) -> uint64x2x3_t {
    let mut ret_val: uint64x2x3_t = transmute(vld3q_dup_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_f64(a: *const f64) -> float64x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v2f64.p0"
        )]
        fn _vld3q_f64(ptr: *const float64x2_t) -> float64x2x3_t;
    }
    _vld3q_f64(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_s64(a: *const i64) -> int64x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v2i64.p0"
        )]
        fn _vld3q_s64(ptr: *const int64x2_t) -> int64x2x3_t;
    }
    _vld3q_s64(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_f64<const LANE: i32>(a: *const f64, b: float64x2x3_t) -> float64x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v2f64.p0"
        )]
        fn _vld3q_lane_f64(
            a: float64x2_t,
            b: float64x2_t,
            c: float64x2_t,
            n: i64,
            ptr: *const i8,
        ) -> float64x2x3_t;
    }
    _vld3q_lane_f64(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_p64<const LANE: i32>(a: *const p64, b: poly64x2x3_t) -> poly64x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld3q_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_s8<const LANE: i32>(a: *const i8, b: int8x16x3_t) -> int8x16x3_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v16i8.p0"
        )]
        fn _vld3q_lane_s8(
            a: int8x16_t,
            b: int8x16_t,
            c: int8x16_t,
            n: i64,
            ptr: *const i8,
        ) -> int8x16x3_t;
    }
    _vld3q_lane_s8(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_s64<const LANE: i32>(a: *const i64, b: int64x2x3_t) -> int64x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v2i64.p0"
        )]
        fn _vld3q_lane_s64(
            a: int64x2_t,
            b: int64x2_t,
            c: int64x2_t,
            n: i64,
            ptr: *const i8,
        ) -> int64x2x3_t;
    }
    _vld3q_lane_s64(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_u8<const LANE: i32>(a: *const u8, b: uint8x16x3_t) -> uint8x16x3_t {
    static_assert_uimm_bits!(LANE, 4);
    transmute(vld3q_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_u64<const LANE: i32>(a: *const u64, b: uint64x2x3_t) -> uint64x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld3q_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_p8<const LANE: i32>(a: *const p8, b: poly8x16x3_t) -> poly8x16x3_t {
    static_assert_uimm_bits!(LANE, 4);
    transmute(vld3q_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_p64(a: *const p64) -> poly64x2x3_t {
    transmute(vld3q_s64(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_p64(a: *const p64) -> poly64x2x3_t {
    let mut ret_val: poly64x2x3_t = transmute(vld3q_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_u64(a: *const u64) -> uint64x2x3_t {
    transmute(vld3q_s64(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_u64(a: *const u64) -> uint64x2x3_t {
    let mut ret_val: uint64x2x3_t = transmute(vld3q_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_dup_f64(a: *const f64) -> float64x1x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v1f64.p0"
        )]
        fn _vld4_dup_f64(ptr: *const f64) -> float64x1x4_t;
    }
    _vld4_dup_f64(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_f64(a: *const f64) -> float64x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v2f64.p0"
        )]
        fn _vld4q_dup_f64(ptr: *const f64) -> float64x2x4_t;
    }
    _vld4q_dup_f64(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_s64(a: *const i64) -> int64x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v2i64.p0"
        )]
        fn _vld4q_dup_s64(ptr: *const i64) -> int64x2x4_t;
    }
    _vld4q_dup_s64(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld4_f64(a: *const f64) -> float64x1x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v1f64.p0"
        )]
        fn _vld4_f64(ptr: *const float64x1_t) -> float64x1x4_t;
    }
    _vld4_f64(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_lane_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_lane_f64<const LANE: i32>(a: *const f64, b: float64x1x4_t) -> float64x1x4_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4lane.v1f64.p0"
        )]
        fn _vld4_lane_f64(
            a: float64x1_t,
            b: float64x1_t,
            c: float64x1_t,
            d: float64x1_t,
            n: i64,
            ptr: *const i8,
        ) -> float64x1x4_t;
    }
    _vld4_lane_f64(b.0, b.1, b.2, b.3, LANE as i64, a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_lane_s64<const LANE: i32>(a: *const i64, b: int64x1x4_t) -> int64x1x4_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4lane.v1i64.p0"
        )]
        fn _vld4_lane_s64(
            a: int64x1_t,
            b: int64x1_t,
            c: int64x1_t,
            d: int64x1_t,
            n: i64,
            ptr: *const i8,
        ) -> int64x1x4_t;
    }
    _vld4_lane_s64(b.0, b.1, b.2, b.3, LANE as i64, a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_lane_p64<const LANE: i32>(a: *const p64, b: poly64x1x4_t) -> poly64x1x4_t {
    static_assert!(LANE == 0);
    transmute(vld4_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_lane_u64<const LANE: i32>(a: *const u64, b: uint64x1x4_t) -> uint64x1x4_t {
    static_assert!(LANE == 0);
    transmute(vld4_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_p64(a: *const p64) -> poly64x2x4_t {
    transmute(vld4q_dup_s64(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_p64(a: *const p64) -> poly64x2x4_t {
    let mut ret_val: poly64x2x4_t = transmute(vld4q_dup_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_u64(a: *const u64) -> uint64x2x4_t {
    transmute(vld4q_dup_s64(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_u64(a: *const u64) -> uint64x2x4_t {
    let mut ret_val: uint64x2x4_t = transmute(vld4q_dup_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_f64(a: *const f64) -> float64x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v2f64.p0"
        )]
        fn _vld4q_f64(ptr: *const float64x2_t) -> float64x2x4_t;
    }
    _vld4q_f64(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_s64(a: *const i64) -> int64x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v2i64.p0"
        )]
        fn _vld4q_s64(ptr: *const int64x2_t) -> int64x2x4_t;
    }
    _vld4q_s64(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_f64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_f64<const LANE: i32>(a: *const f64, b: float64x2x4_t) -> float64x2x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4lane.v2f64.p0"
        )]
        fn _vld4q_lane_f64(
            a: float64x2_t,
            b: float64x2_t,
            c: float64x2_t,
            d: float64x2_t,
            n: i64,
            ptr: *const i8,
        ) -> float64x2x4_t;
    }
    _vld4q_lane_f64(b.0, b.1, b.2, b.3, LANE as i64, a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_s8<const LANE: i32>(a: *const i8, b: int8x16x4_t) -> int8x16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4lane.v16i8.p0"
        )]
        fn _vld4q_lane_s8(
            a: int8x16_t,
            b: int8x16_t,
            c: int8x16_t,
            d: int8x16_t,
            n: i64,
            ptr: *const i8,
        ) -> int8x16x4_t;
    }
    _vld4q_lane_s8(b.0, b.1, b.2, b.3, LANE as i64, a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_s64<const LANE: i32>(a: *const i64, b: int64x2x4_t) -> int64x2x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4lane.v2i64.p0"
        )]
        fn _vld4q_lane_s64(
            a: int64x2_t,
            b: int64x2_t,
            c: int64x2_t,
            d: int64x2_t,
            n: i64,
            ptr: *const i8,
        ) -> int64x2x4_t;
    }
    _vld4q_lane_s64(b.0, b.1, b.2, b.3, LANE as i64, a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_p64<const LANE: i32>(a: *const p64, b: poly64x2x4_t) -> poly64x2x4_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld4q_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_u8<const LANE: i32>(a: *const u8, b: uint8x16x4_t) -> uint8x16x4_t {
    static_assert_uimm_bits!(LANE, 4);
    transmute(vld4q_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_u64<const LANE: i32>(a: *const u64, b: uint64x2x4_t) -> uint64x2x4_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld4q_lane_s64::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ld4, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_lane_p8<const LANE: i32>(a: *const p8, b: poly8x16x4_t) -> poly8x16x4_t {
    static_assert_uimm_bits!(LANE, 4);
    transmute(vld4q_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_p64(a: *const p64) -> poly64x2x4_t {
    transmute(vld4q_s64(transmute(a)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_p64(a: *const p64) -> poly64x2x4_t {
    let mut ret_val: poly64x2x4_t = transmute(vld4q_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_u64(a: *const u64) -> uint64x2x4_t {
    transmute(vld4q_s64(transmute(a)))
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_u64(a: *const u64) -> uint64x2x4_t {
    let mut ret_val: uint64x2x4_t = transmute(vld4q_s64(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2_lane_s8<const LANE: i32>(a: int8x8_t, b: uint8x8_t) -> int8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti2.lane.v16i8.v8i8"
        )]
        fn _vluti2_lane_s8(a: int8x8_t, b: uint8x8_t, n: i32) -> int8x16_t;
    }
    _vluti2_lane_s8(a, b, LANE)
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2q_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2q_lane_s8<const LANE: i32>(a: int8x16_t, b: uint8x8_t) -> int8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti2.lane.v16i8.v16i8"
        )]
        fn _vluti2q_lane_s8(a: int8x16_t, b: uint8x8_t, n: i32) -> int8x16_t;
    }
    _vluti2q_lane_s8(a, b, LANE)
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2_lane_s16<const LANE: i32>(a: int16x4_t, b: uint8x8_t) -> int16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti2.lane.v8i16.v4i16"
        )]
        fn _vluti2_lane_s16(a: int16x4_t, b: uint8x8_t, n: i32) -> int16x8_t;
    }
    _vluti2_lane_s16(a, b, LANE)
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2q_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2q_lane_s16<const LANE: i32>(a: int16x8_t, b: uint8x8_t) -> int16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti2.lane.v8i16.v8i16"
        )]
        fn _vluti2q_lane_s16(a: int16x8_t, b: uint8x8_t, n: i32) -> int16x8_t;
    }
    _vluti2q_lane_s16(a, b, LANE)
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2_lane_u8<const LANE: i32>(a: uint8x8_t, b: uint8x8_t) -> uint8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti2_lane_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2q_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2q_lane_u8<const LANE: i32>(a: uint8x16_t, b: uint8x8_t) -> uint8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti2q_lane_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2_lane_u16<const LANE: i32>(a: uint16x4_t, b: uint8x8_t) -> uint16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti2_lane_s16::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2q_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2q_lane_u16<const LANE: i32>(a: uint16x8_t, b: uint8x8_t) -> uint16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti2q_lane_s16::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2_lane_p8<const LANE: i32>(a: poly8x8_t, b: uint8x8_t) -> poly8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti2_lane_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2q_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2q_lane_p8<const LANE: i32>(a: poly8x16_t, b: uint8x8_t) -> poly8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti2q_lane_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2_lane_p16<const LANE: i32>(a: poly16x4_t, b: uint8x8_t) -> poly16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti2_lane_s16::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 2-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti2q_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 1))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti2q_lane_p16<const LANE: i32>(a: poly16x8_t, b: uint8x8_t) -> poly16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti2q_lane_s16::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_f16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut,fp16")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_f16_x2<const LANE: i32>(a: float16x8x2_t, b: uint8x8_t) -> float16x8_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti4q_lane_s16_x2::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_u16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_u16_x2<const LANE: i32>(a: uint16x8x2_t, b: uint8x8_t) -> uint16x8_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti4q_lane_s16_x2::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_p16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_p16_x2<const LANE: i32>(a: poly16x8x2_t, b: uint8x8_t) -> poly16x8_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti4q_lane_s16_x2::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_s16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_s16_x2<const LANE: i32>(a: int16x8x2_t, b: uint8x8_t) -> int16x8_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti4q.lane.x2.v8i16"
        )]
        fn _vluti4q_lane_s16_x2(a: int16x8_t, a: int16x8_t, b: uint8x8_t, n: i32) -> int16x8_t;
    }
    _vluti4q_lane_s16_x2(a.0, a.1, b, LANE)
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_s8<const LANE: i32>(a: int8x16_t, b: uint8x8_t) -> int8x16_t {
    static_assert!(LANE == 0);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti4q.lane.v8i8"
        )]
        fn _vluti4q_lane_s8(a: int8x16_t, b: uint8x8_t, n: i32) -> int8x16_t;
    }
    _vluti4q_lane_s8(a, b, LANE)
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_u8<const LANE: i32>(a: uint8x16_t, b: uint8x8_t) -> uint8x16_t {
    static_assert!(LANE == 0);
    transmute(vluti4q_lane_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_lane_p8<const LANE: i32>(a: poly8x16_t, b: uint8x8_t) -> poly8x16_t {
    static_assert!(LANE == 0);
    transmute(vluti4q_lane_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_f16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut,fp16")]
#[cfg_attr(test, assert_instr(nop, LANE = 3))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_f16_x2<const LANE: i32>(
    a: float16x8x2_t,
    b: uint8x16_t,
) -> float16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti4q_laneq_s16_x2::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_u16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 3))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_u16_x2<const LANE: i32>(a: uint16x8x2_t, b: uint8x16_t) -> uint16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti4q_laneq_s16_x2::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_p16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 3))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_p16_x2<const LANE: i32>(a: poly16x8x2_t, b: uint8x16_t) -> poly16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    transmute(vluti4q_laneq_s16_x2::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_s16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 3))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_s16_x2<const LANE: i32>(a: int16x8x2_t, b: uint8x16_t) -> int16x8_t {
    static_assert!(LANE >= 0 && LANE <= 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti4q.laneq.x2.v8i16"
        )]
        fn _vluti4q_laneq_s16_x2(a: int16x8_t, b: int16x8_t, c: uint8x16_t, n: i32) -> int16x8_t;
    }
    _vluti4q_laneq_s16_x2(a.0, a.1, b, LANE)
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_s8<const LANE: i32>(a: int8x16_t, b: uint8x16_t) -> int8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vluti4q.laneq.v16i8"
        )]
        fn _vluti4q_laneq_s8(a: int8x16_t, b: uint8x16_t, n: i32) -> int8x16_t;
    }
    _vluti4q_laneq_s8(a, b, LANE)
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_u8<const LANE: i32>(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti4q_laneq_s8::<LANE>(transmute(a), b))
}
#[doc = "Lookup table read with 4-bit indices"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vluti4q_laneq_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,lut")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[unstable(feature = "stdarch_neon_feat_lut", issue = "138050")]
#[rustc_legacy_const_generics(2)]
pub unsafe fn vluti4q_laneq_p8<const LANE: i32>(a: poly8x16_t, b: uint8x16_t) -> poly8x16_t {
    static_assert!(LANE >= 0 && LANE <= 1);
    transmute(vluti4q_laneq_s8::<LANE>(transmute(a), b))
}
#[doc = "Maximum (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmax_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmax))]
pub fn vmax_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmax.v1f64"
        )]
        fn _vmax_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t;
    }
    unsafe { _vmax_f64(a, b) }
}
#[doc = "Maximum (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmax))]
pub fn vmaxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmax.v2f64"
        )]
        fn _vmaxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vmaxq_f64(a, b) }
}
#[doc = "Maximum (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmax))]
pub fn vmaxh_f16(a: f16, b: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmax.f16"
        )]
        fn _vmaxh_f16(a: f16, b: f16) -> f16;
    }
    unsafe { _vmaxh_f16(a, b) }
}
#[doc = "Floating-point Maximum Number (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnm_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxnm))]
pub fn vmaxnm_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe { simd_fmax(a, b) }
}
#[doc = "Floating-point Maximum Number (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxnm))]
pub fn vmaxnmq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe { simd_fmax(a, b) }
}
#[doc = "Floating-point Maximum Number"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxnm))]
pub fn vmaxnmh_f16(a: f16, b: f16) -> f16 {
    f16::max(a, b)
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmv_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxnmv))]
pub fn vmaxnmv_f16(a: float16x4_t) -> f16 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmvq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxnmv))]
pub fn vmaxnmvq_f16(a: float16x8_t) -> f16 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmv_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
pub fn vmaxnmv_f32(a: float32x2_t) -> f32 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmvq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
pub fn vmaxnmvq_f64(a: float64x2_t) -> f64 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxnmvq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxnmv))]
pub fn vmaxnmvq_f32(a: float32x4_t) -> f32 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxv))]
pub fn vmaxv_f16(a: float16x4_t) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f16.v4f16"
        )]
        fn _vmaxv_f16(a: float16x4_t) -> f16;
    }
    unsafe { _vmaxv_f16(a) }
}
#[doc = "Floating-point maximum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxv))]
pub fn vmaxvq_f16(a: float16x8_t) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f16.v8f16"
        )]
        fn _vmaxvq_f16(a: float16x8_t) -> f16;
    }
    unsafe { _vmaxvq_f16(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vmaxv_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f32.v2f32"
        )]
        fn _vmaxv_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vmaxv_f32(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxv))]
pub fn vmaxvq_f32(a: float32x4_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f32.v4f32"
        )]
        fn _vmaxvq_f32(a: float32x4_t) -> f32;
    }
    unsafe { _vmaxvq_f32(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vmaxvq_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f64.v2f64"
        )]
        fn _vmaxvq_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vmaxvq_f64(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxv))]
pub fn vmaxv_s8(a: int8x8_t) -> i8 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxv))]
pub fn vmaxvq_s8(a: int8x16_t) -> i8 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxv))]
pub fn vmaxv_s16(a: int16x4_t) -> i16 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxv))]
pub fn vmaxvq_s16(a: int16x8_t) -> i16 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxp))]
pub fn vmaxv_s32(a: int32x2_t) -> i32 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxv))]
pub fn vmaxvq_s32(a: int32x4_t) -> i32 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxv))]
pub fn vmaxv_u8(a: uint8x8_t) -> u8 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxv))]
pub fn vmaxvq_u8(a: uint8x16_t) -> u8 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxv))]
pub fn vmaxv_u16(a: uint16x4_t) -> u16 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxv))]
pub fn vmaxvq_u16(a: uint16x8_t) -> u16 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxv_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxp))]
pub fn vmaxv_u32(a: uint32x2_t) -> u32 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Horizontal vector max."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmaxvq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxv))]
pub fn vmaxvq_u32(a: uint32x4_t) -> u32 {
    unsafe { simd_reduce_max(a) }
}
#[doc = "Minimum (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmin_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmin))]
pub fn vmin_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmin.v1f64"
        )]
        fn _vmin_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t;
    }
    unsafe { _vmin_f64(a, b) }
}
#[doc = "Minimum (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmin))]
pub fn vminq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmin.v2f64"
        )]
        fn _vminq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vminq_f64(a, b) }
}
#[doc = "Minimum (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmin))]
pub fn vminh_f16(a: f16, b: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmin.f16"
        )]
        fn _vminh_f16(a: f16, b: f16) -> f16;
    }
    unsafe { _vminh_f16(a, b) }
}
#[doc = "Floating-point Minimum Number (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnm_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminnm))]
pub fn vminnm_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe { simd_fmin(a, b) }
}
#[doc = "Floating-point Minimum Number (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminnm))]
pub fn vminnmq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe { simd_fmin(a, b) }
}
#[doc = "Floating-point Minimum Number"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminnm))]
pub fn vminnmh_f16(a: f16, b: f16) -> f16 {
    f16::min(a, b)
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmv_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminnmv))]
pub fn vminnmv_f16(a: float16x4_t) -> f16 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmvq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminnmv))]
pub fn vminnmvq_f16(a: float16x8_t) -> f16 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmv_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vminnmv_f32(a: float32x2_t) -> f32 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmvq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vminnmvq_f64(a: float64x2_t) -> f64 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminnmvq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmv))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vminnmvq_f32(a: float32x4_t) -> f32 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminv))]
pub fn vminv_f16(a: float16x4_t) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f16.v4f16"
        )]
        fn _vminv_f16(a: float16x4_t) -> f16;
    }
    unsafe { _vminv_f16(a) }
}
#[doc = "Floating-point minimum number across vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminv))]
pub fn vminvq_f16(a: float16x8_t) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f16.v8f16"
        )]
        fn _vminvq_f16(a: float16x8_t) -> f16;
    }
    unsafe { _vminvq_f16(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vminv_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f32.v2f32"
        )]
        fn _vminv_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vminv_f32(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminv))]
pub fn vminvq_f32(a: float32x4_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f32.v4f32"
        )]
        fn _vminvq_f32(a: float32x4_t) -> f32;
    }
    unsafe { _vminvq_f32(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vminvq_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f64.v2f64"
        )]
        fn _vminvq_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vminvq_f64(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminv))]
pub fn vminv_s8(a: int8x8_t) -> i8 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminv))]
pub fn vminvq_s8(a: int8x16_t) -> i8 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminv))]
pub fn vminv_s16(a: int16x4_t) -> i16 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminv))]
pub fn vminvq_s16(a: int16x8_t) -> i16 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminp))]
pub fn vminv_s32(a: int32x2_t) -> i32 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminv))]
pub fn vminvq_s32(a: int32x4_t) -> i32 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminv))]
pub fn vminv_u8(a: uint8x8_t) -> u8 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminv))]
pub fn vminvq_u8(a: uint8x16_t) -> u8 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminv))]
pub fn vminv_u16(a: uint16x4_t) -> u16 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminv))]
pub fn vminvq_u16(a: uint16x8_t) -> u16 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminv_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminp))]
pub fn vminv_u32(a: uint32x2_t) -> u32 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Horizontal vector min."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vminvq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminv))]
pub fn vminvq_u32(a: uint32x4_t) -> u32 {
    unsafe { simd_reduce_min(a) }
}
#[doc = "Floating-point multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmla_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmla_f64(a: float64x1_t, b: float64x1_t, c: float64x1_t) -> float64x1_t {
    unsafe { simd_add(a, simd_mul(b, c)) }
}
#[doc = "Floating-point multiply-add to accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlaq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlaq_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe { simd_add(a, simd_mul(b, c)) }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_lane_s16<const LANE: i32>(a: int32x4_t, b: int16x8_t, c: int16x4_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlal_high_s16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_laneq_s16<const LANE: i32>(
    a: int32x4_t,
    b: int16x8_t,
    c: int16x8_t,
) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmlal_high_s16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_lane_s32<const LANE: i32>(a: int64x2_t, b: int32x4_t, c: int32x2_t) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmlal_high_s32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_laneq_s32<const LANE: i32>(
    a: int64x2_t,
    b: int32x4_t,
    c: int32x4_t,
) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlal_high_s32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_lane_u16<const LANE: i32>(
    a: uint32x4_t,
    b: uint16x8_t,
    c: uint16x4_t,
) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlal_high_u16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_laneq_u16<const LANE: i32>(
    a: uint32x4_t,
    b: uint16x8_t,
    c: uint16x8_t,
) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmlal_high_u16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_lane_u32<const LANE: i32>(
    a: uint64x2_t,
    b: uint32x4_t,
    c: uint32x2_t,
) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmlal_high_u32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_laneq_u32<const LANE: i32>(
    a: uint64x2_t,
    b: uint32x4_t,
    c: uint32x4_t,
) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlal_high_u32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_n_s16(a: int32x4_t, b: int16x8_t, c: i16) -> int32x4_t {
    vmlal_high_s16(a, b, vdupq_n_s16(c))
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_n_s32(a: int64x2_t, b: int32x4_t, c: i32) -> int64x2_t {
    vmlal_high_s32(a, b, vdupq_n_s32(c))
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_n_u16(a: uint32x4_t, b: uint16x8_t, c: u16) -> uint32x4_t {
    vmlal_high_u16(a, b, vdupq_n_u16(c))
}
#[doc = "Multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_n_u32(a: uint64x2_t, b: uint32x4_t, c: u32) -> uint64x2_t {
    vmlal_high_u32(a, b, vdupq_n_u32(c))
}
#[doc = "Signed multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_s8(a: int16x8_t, b: int8x16_t, c: int8x16_t) -> int16x8_t {
    unsafe {
        let b: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let c: int8x8_t = simd_shuffle!(c, c, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmlal_s8(a, b, c)
    }
}
#[doc = "Signed multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_s16(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    unsafe {
        let b: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let c: int16x4_t = simd_shuffle!(c, c, [4, 5, 6, 7]);
        vmlal_s16(a, b, c)
    }
}
#[doc = "Signed multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_s32(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    unsafe {
        let b: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        let c: int32x2_t = simd_shuffle!(c, c, [2, 3]);
        vmlal_s32(a, b, c)
    }
}
#[doc = "Unsigned multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_u8(a: uint16x8_t, b: uint8x16_t, c: uint8x16_t) -> uint16x8_t {
    unsafe {
        let b: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let c: uint8x8_t = simd_shuffle!(c, c, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmlal_u8(a, b, c)
    }
}
#[doc = "Unsigned multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_u16(a: uint32x4_t, b: uint16x8_t, c: uint16x8_t) -> uint32x4_t {
    unsafe {
        let b: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let c: uint16x4_t = simd_shuffle!(c, c, [4, 5, 6, 7]);
        vmlal_u16(a, b, c)
    }
}
#[doc = "Unsigned multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlal_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlal_high_u32(a: uint64x2_t, b: uint32x4_t, c: uint32x4_t) -> uint64x2_t {
    unsafe {
        let b: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        let c: uint32x2_t = simd_shuffle!(c, c, [2, 3]);
        vmlal_u32(a, b, c)
    }
}
#[doc = "Floating-point multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmls_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmls_f64(a: float64x1_t, b: float64x1_t, c: float64x1_t) -> float64x1_t {
    unsafe { simd_sub(a, simd_mul(b, c)) }
}
#[doc = "Floating-point multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsq_f64(a: float64x2_t, b: float64x2_t, c: float64x2_t) -> float64x2_t {
    unsafe { simd_sub(a, simd_mul(b, c)) }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_lane_s16<const LANE: i32>(a: int32x4_t, b: int16x8_t, c: int16x4_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlsl_high_s16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_laneq_s16<const LANE: i32>(
    a: int32x4_t,
    b: int16x8_t,
    c: int16x8_t,
) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmlsl_high_s16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_lane_s32<const LANE: i32>(a: int64x2_t, b: int32x4_t, c: int32x2_t) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmlsl_high_s32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_laneq_s32<const LANE: i32>(
    a: int64x2_t,
    b: int32x4_t,
    c: int32x4_t,
) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlsl_high_s32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_lane_u16<const LANE: i32>(
    a: uint32x4_t,
    b: uint16x8_t,
    c: uint16x4_t,
) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlsl_high_u16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_laneq_u16<const LANE: i32>(
    a: uint32x4_t,
    b: uint16x8_t,
    c: uint16x8_t,
) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmlsl_high_u16(
            a,
            b,
            simd_shuffle!(
                c,
                c,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_lane_u32<const LANE: i32>(
    a: uint64x2_t,
    b: uint32x4_t,
    c: uint32x2_t,
) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmlsl_high_u32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_laneq_u32<const LANE: i32>(
    a: uint64x2_t,
    b: uint32x4_t,
    c: uint32x4_t,
) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmlsl_high_u32(
            a,
            b,
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_n_s16(a: int32x4_t, b: int16x8_t, c: i16) -> int32x4_t {
    vmlsl_high_s16(a, b, vdupq_n_s16(c))
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_n_s32(a: int64x2_t, b: int32x4_t, c: i32) -> int64x2_t {
    vmlsl_high_s32(a, b, vdupq_n_s32(c))
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_n_u16(a: uint32x4_t, b: uint16x8_t, c: u16) -> uint32x4_t {
    vmlsl_high_u16(a, b, vdupq_n_u16(c))
}
#[doc = "Multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_n_u32(a: uint64x2_t, b: uint32x4_t, c: u32) -> uint64x2_t {
    vmlsl_high_u32(a, b, vdupq_n_u32(c))
}
#[doc = "Signed multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_s8(a: int16x8_t, b: int8x16_t, c: int8x16_t) -> int16x8_t {
    unsafe {
        let b: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let c: int8x8_t = simd_shuffle!(c, c, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmlsl_s8(a, b, c)
    }
}
#[doc = "Signed multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_s16(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    unsafe {
        let b: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let c: int16x4_t = simd_shuffle!(c, c, [4, 5, 6, 7]);
        vmlsl_s16(a, b, c)
    }
}
#[doc = "Signed multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_s32(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    unsafe {
        let b: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        let c: int32x2_t = simd_shuffle!(c, c, [2, 3]);
        vmlsl_s32(a, b, c)
    }
}
#[doc = "Unsigned multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_u8(a: uint16x8_t, b: uint8x16_t, c: uint8x16_t) -> uint16x8_t {
    unsafe {
        let b: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let c: uint8x8_t = simd_shuffle!(c, c, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmlsl_u8(a, b, c)
    }
}
#[doc = "Unsigned multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_u16(a: uint32x4_t, b: uint16x8_t, c: uint16x8_t) -> uint32x4_t {
    unsafe {
        let b: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let c: uint16x4_t = simd_shuffle!(c, c, [4, 5, 6, 7]);
        vmlsl_u16(a, b, c)
    }
}
#[doc = "Unsigned multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmlsl_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmlsl_high_u32(a: uint64x2_t, b: uint32x4_t, c: uint32x4_t) -> uint64x2_t {
    unsafe {
        let b: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        let c: uint32x2_t = simd_shuffle!(c, c, [2, 3]);
        vmlsl_u32(a, b, c)
    }
}
#[doc = "Vector move"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovl_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sxtl2))]
pub fn vmovl_high_s8(a: int8x16_t) -> int16x8_t {
    unsafe {
        let a: int8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmovl_s8(a)
    }
}
#[doc = "Vector move"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovl_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sxtl2))]
pub fn vmovl_high_s16(a: int16x8_t) -> int32x4_t {
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        vmovl_s16(a)
    }
}
#[doc = "Vector move"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovl_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sxtl2))]
pub fn vmovl_high_s32(a: int32x4_t) -> int64x2_t {
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        vmovl_s32(a)
    }
}
#[doc = "Vector move"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovl_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uxtl2))]
pub fn vmovl_high_u8(a: uint8x16_t) -> uint16x8_t {
    unsafe {
        let a: uint8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmovl_u8(a)
    }
}
#[doc = "Vector move"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovl_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uxtl2))]
pub fn vmovl_high_u16(a: uint16x8_t) -> uint32x4_t {
    unsafe {
        let a: uint16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        vmovl_u16(a)
    }
}
#[doc = "Vector move"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovl_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uxtl2))]
pub fn vmovl_high_u32(a: uint32x4_t) -> uint64x2_t {
    unsafe {
        let a: uint32x2_t = simd_shuffle!(a, a, [2, 3]);
        vmovl_u32(a)
    }
}
#[doc = "Extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovn_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(xtn2))]
pub fn vmovn_high_s16(a: int8x8_t, b: int16x8_t) -> int8x16_t {
    unsafe {
        let c: int8x8_t = simd_cast(b);
        simd_shuffle!(a, c, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
    }
}
#[doc = "Extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovn_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(xtn2))]
pub fn vmovn_high_s32(a: int16x4_t, b: int32x4_t) -> int16x8_t {
    unsafe {
        let c: int16x4_t = simd_cast(b);
        simd_shuffle!(a, c, [0, 1, 2, 3, 4, 5, 6, 7])
    }
}
#[doc = "Extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovn_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(xtn2))]
pub fn vmovn_high_s64(a: int32x2_t, b: int64x2_t) -> int32x4_t {
    unsafe {
        let c: int32x2_t = simd_cast(b);
        simd_shuffle!(a, c, [0, 1, 2, 3])
    }
}
#[doc = "Extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovn_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(xtn2))]
pub fn vmovn_high_u16(a: uint8x8_t, b: uint16x8_t) -> uint8x16_t {
    unsafe {
        let c: uint8x8_t = simd_cast(b);
        simd_shuffle!(a, c, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
    }
}
#[doc = "Extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovn_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(xtn2))]
pub fn vmovn_high_u32(a: uint16x4_t, b: uint32x4_t) -> uint16x8_t {
    unsafe {
        let c: uint16x4_t = simd_cast(b);
        simd_shuffle!(a, c, [0, 1, 2, 3, 4, 5, 6, 7])
    }
}
#[doc = "Extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmovn_high_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(xtn2))]
pub fn vmovn_high_u64(a: uint32x2_t, b: uint64x2_t) -> uint32x4_t {
    unsafe {
        let c: uint32x2_t = simd_cast(b);
        simd_shuffle!(a, c, [0, 1, 2, 3])
    }
}
#[doc = "Multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmul_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmul))]
pub fn vmul_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe { simd_mul(a, b) }
}
#[doc = "Multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmul))]
pub fn vmulq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe { simd_mul(a, b) }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmul_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmul_lane_f64<const LANE: i32>(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    static_assert!(LANE == 0);
    unsafe { simd_mul(a, transmute::<f64, _>(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmul_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmul_laneq_f16<const LANE: i32>(a: float16x4_t, b: float16x8_t) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        simd_mul(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulq_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulq_laneq_f16<const LANE: i32>(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        simd_mul(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmul_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmul_laneq_f64<const LANE: i32>(a: float64x1_t, b: float64x2_t) -> float64x1_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { simd_mul(a, transmute::<f64, _>(simd_extract!(b, LANE as u32))) }
}
#[doc = "Vector multiply by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmul_n_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmul_n_f64(a: float64x1_t, b: f64) -> float64x1_t {
    unsafe { simd_mul(a, vdup_n_f64(b)) }
}
#[doc = "Vector multiply by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulq_n_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulq_n_f64(a: float64x2_t, b: f64) -> float64x2_t {
    unsafe { simd_mul(a, vdupq_n_f64(b)) }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmuld_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmuld_lane_f64<const LANE: i32>(a: f64, b: float64x1_t) -> f64 {
    static_assert!(LANE == 0);
    unsafe {
        let b: f64 = simd_extract!(b, LANE as u32);
        a * b
    }
}
#[doc = "Add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vmulh_f16(a: f16, b: f16) -> f16 {
    a * b
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulh_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulh_lane_f16<const LANE: i32>(a: f16, b: float16x4_t) -> f16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let b: f16 = simd_extract!(b, LANE as u32);
        a * b
    }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulh_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulh_laneq_f16<const LANE: i32>(a: f16, b: float16x8_t) -> f16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let b: f16 = simd_extract!(b, LANE as u32);
        a * b
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_lane_s16<const LANE: i32>(a: int16x8_t, b: int16x4_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmull_high_s16(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_laneq_s16<const LANE: i32>(a: int16x8_t, b: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmull_high_s16(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_lane_s32<const LANE: i32>(a: int32x4_t, b: int32x2_t) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmull_high_s32(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_laneq_s32<const LANE: i32>(a: int32x4_t, b: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmull_high_s32(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_lane_u16<const LANE: i32>(a: uint16x8_t, b: uint16x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmull_high_u16(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_laneq_u16<const LANE: i32>(a: uint16x8_t, b: uint16x8_t) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmull_high_u16(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_lane_u32<const LANE: i32>(a: uint32x4_t, b: uint32x2_t) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmull_high_u32(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umull2, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_laneq_u32<const LANE: i32>(a: uint32x4_t, b: uint32x4_t) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmull_high_u32(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_n_s16(a: int16x8_t, b: i16) -> int32x4_t {
    vmull_high_s16(a, vdupq_n_s16(b))
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(smull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_n_s32(a: int32x4_t, b: i32) -> int64x2_t {
    vmull_high_s32(a, vdupq_n_s32(b))
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_n_u16(a: uint16x8_t, b: u16) -> uint32x4_t {
    vmull_high_u16(a, vdupq_n_u16(b))
}
#[doc = "Multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(umull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmull_high_n_u32(a: uint32x4_t, b: u32) -> uint64x2_t {
    vmull_high_u32(a, vdupq_n_u32(b))
}
#[doc = "Polynomial multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_p64)"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(pmull2))]
pub fn vmull_high_p64(a: poly64x2_t, b: poly64x2_t) -> p128 {
    unsafe { vmull_p64(simd_extract!(a, 1), simd_extract!(b, 1)) }
}
#[doc = "Polynomial multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(pmull2))]
pub fn vmull_high_p8(a: poly8x16_t, b: poly8x16_t) -> poly16x8_t {
    unsafe {
        let a: poly8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: poly8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmull_p8(a, b)
    }
}
#[doc = "Signed multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smull2))]
pub fn vmull_high_s8(a: int8x16_t, b: int8x16_t) -> int16x8_t {
    unsafe {
        let a: int8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmull_s8(a, b)
    }
}
#[doc = "Signed multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smull2))]
pub fn vmull_high_s16(a: int16x8_t, b: int16x8_t) -> int32x4_t {
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        vmull_s16(a, b)
    }
}
#[doc = "Signed multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smull2))]
pub fn vmull_high_s32(a: int32x4_t, b: int32x4_t) -> int64x2_t {
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        vmull_s32(a, b)
    }
}
#[doc = "Unsigned multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umull2))]
pub fn vmull_high_u8(a: uint8x16_t, b: uint8x16_t) -> uint16x8_t {
    unsafe {
        let a: uint8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        vmull_u8(a, b)
    }
}
#[doc = "Unsigned multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umull2))]
pub fn vmull_high_u16(a: uint16x8_t, b: uint16x8_t) -> uint32x4_t {
    unsafe {
        let a: uint16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        vmull_u16(a, b)
    }
}
#[doc = "Unsigned multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umull2))]
pub fn vmull_high_u32(a: uint32x4_t, b: uint32x4_t) -> uint64x2_t {
    unsafe {
        let a: uint32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        vmull_u32(a, b)
    }
}
#[doc = "Polynomial multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmull_p64)"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(pmull))]
pub fn vmull_p64(a: p64, b: p64) -> p128 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.pmull64"
        )]
        fn _vmull_p64(a: p64, b: p64) -> int8x16_t;
    }
    unsafe { transmute(_vmull_p64(a, b)) }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulq_lane_f64<const LANE: i32>(a: float64x2_t, b: float64x1_t) -> float64x2_t {
    static_assert!(LANE == 0);
    unsafe { simd_mul(a, simd_shuffle!(b, b, [LANE as u32, LANE as u32])) }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulq_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulq_laneq_f64<const LANE: i32>(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { simd_mul(a, simd_shuffle!(b, b, [LANE as u32, LANE as u32])) }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmuls_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmuls_lane_f32<const LANE: i32>(a: f32, b: float32x2_t) -> f32 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let b: f32 = simd_extract!(b, LANE as u32);
        a * b
    }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmuls_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmuls_laneq_f32<const LANE: i32>(a: f32, b: float32x4_t) -> f32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let b: f32 = simd_extract!(b, LANE as u32);
        a * b
    }
}
#[doc = "Floating-point multiply"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmuld_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmul, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmuld_laneq_f64<const LANE: i32>(a: f64, b: float64x2_t) -> f64 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let b: f64 = simd_extract!(b, LANE as u32);
        a * b
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulx_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.v4f16"
        )]
        fn _vmulx_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vmulx_f16(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulxq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.v8f16"
        )]
        fn _vmulxq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vmulxq_f16(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulx_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.v2f32"
        )]
        fn _vmulx_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vmulx_f32(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulxq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.v4f32"
        )]
        fn _vmulxq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vmulxq_f32(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulx_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.v1f64"
        )]
        fn _vmulx_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t;
    }
    unsafe { _vmulx_f64(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.v2f64"
        )]
        fn _vmulxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vmulxq_f64(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulx_lane_f16<const LANE: i32>(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmulx_f16(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulx_laneq_f16<const LANE: i32>(a: float16x4_t, b: float16x8_t) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmulx_f16(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulxq_lane_f16<const LANE: i32>(a: float16x8_t, b: float16x4_t) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmulxq_f16(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulxq_laneq_f16<const LANE: i32>(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        vmulxq_f16(
            a,
            simd_shuffle!(
                b,
                b,
                [
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32,
                    LANE as u32
                ]
            ),
        )
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulx_lane_f32<const LANE: i32>(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vmulx_f32(a, simd_shuffle!(b, b, [LANE as u32, LANE as u32])) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulx_laneq_f32<const LANE: i32>(a: float32x2_t, b: float32x4_t) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vmulx_f32(a, simd_shuffle!(b, b, [LANE as u32, LANE as u32])) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxq_lane_f32<const LANE: i32>(a: float32x4_t, b: float32x2_t) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        vmulxq_f32(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxq_laneq_f32<const LANE: i32>(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        vmulxq_f32(
            a,
            simd_shuffle!(b, b, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]),
        )
    }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxq_laneq_f64<const LANE: i32>(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vmulxq_f64(a, simd_shuffle!(b, b, [LANE as u32, LANE as u32])) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulx_lane_f64<const LANE: i32>(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    static_assert!(LANE == 0);
    unsafe { vmulx_f64(a, transmute::<f64, _>(simd_extract!(b, LANE as u32))) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulx_laneq_f64<const LANE: i32>(a: float64x1_t, b: float64x2_t) -> float64x1_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vmulx_f64(a, transmute::<f64, _>(simd_extract!(b, LANE as u32))) }
}
#[doc = "Vector multiply by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulx_n_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulx_n_f16(a: float16x4_t, b: f16) -> float16x4_t {
    vmulx_f16(a, vdup_n_f16(b))
}
#[doc = "Vector multiply by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_n_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulxq_n_f16(a: float16x8_t, b: f16) -> float16x8_t {
    vmulxq_f16(a, vdupq_n_f16(b))
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulxd_f64(a: f64, b: f64) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.f64"
        )]
        fn _vmulxd_f64(a: f64, b: f64) -> f64;
    }
    unsafe { _vmulxd_f64(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulxs_f32(a: f32, b: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.f32"
        )]
        fn _vmulxs_f32(a: f32, b: f32) -> f32;
    }
    unsafe { _vmulxs_f32(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxd_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxd_lane_f64<const LANE: i32>(a: f64, b: float64x1_t) -> f64 {
    static_assert!(LANE == 0);
    unsafe { vmulxd_f64(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxd_laneq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxd_laneq_f64<const LANE: i32>(a: f64, b: float64x2_t) -> f64 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vmulxd_f64(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxs_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxs_lane_f32<const LANE: i32>(a: f32, b: float32x2_t) -> f32 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vmulxs_f32(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxs_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxs_laneq_f32<const LANE: i32>(a: f32, b: float32x4_t) -> f32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vmulxs_f32(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmulx))]
pub fn vmulxh_f16(a: f16, b: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmulx.f16"
        )]
        fn _vmulxh_f16(a: f16, b: f16) -> f16;
    }
    unsafe { _vmulxh_f16(a, b) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxh_lane_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulxh_lane_f16<const LANE: i32>(a: f16, b: float16x4_t) -> f16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vmulxh_f16(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxh_laneq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vmulxh_laneq_f16<const LANE: i32>(a: f16, b: float16x8_t) -> f16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vmulxh_f16(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Floating-point multiply extended"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vmulxq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmulx, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vmulxq_lane_f64<const LANE: i32>(a: float64x2_t, b: float64x1_t) -> float64x2_t {
    static_assert!(LANE == 0);
    unsafe { vmulxq_f64(a, simd_shuffle!(b, b, [LANE as u32, LANE as u32])) }
}
#[doc = "Negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vneg_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fneg))]
pub fn vneg_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_neg(a) }
}
#[doc = "Negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vnegq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fneg))]
pub fn vnegq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_neg(a) }
}
#[doc = "Negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vneg_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(neg))]
pub fn vneg_s64(a: int64x1_t) -> int64x1_t {
    unsafe { simd_neg(a) }
}
#[doc = "Negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vnegq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(neg))]
pub fn vnegq_s64(a: int64x2_t) -> int64x2_t {
    unsafe { simd_neg(a) }
}
#[doc = "Negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vnegd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(neg))]
pub fn vnegd_s64(a: i64) -> i64 {
    a.wrapping_neg()
}
#[doc = "Negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vnegh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fneg))]
pub fn vnegh_f16(a: f16) -> f16 {
    -a
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vpaddd_f64(a: float64x2_t) -> f64 {
    unsafe {
        let a1: f64 = simd_extract!(a, 0);
        let a2: f64 = simd_extract!(a, 1);
        a1 + a2
    }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpadds_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vpadds_f32(a: float32x2_t) -> f32 {
    unsafe {
        let a1: f32 = simd_extract!(a, 0);
        let a2: f32 = simd_extract!(a, 1);
        a1 + a2
    }
}
#[doc = "Add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddd_s64(a: int64x2_t) -> i64 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddd_u64(a: uint64x2_t) -> u64 {
    unsafe { simd_reduce_add_unordered(a) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(faddp))]
pub fn vpaddq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.faddp.v8f16"
        )]
        fn _vpaddq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vpaddq_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(faddp))]
pub fn vpaddq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.faddp.v4f32"
        )]
        fn _vpaddq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vpaddq_f32(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(faddp))]
pub fn vpaddq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.faddp.v2f64"
        )]
        fn _vpaddq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vpaddq_f64(a, b) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.addp.v16i8"
        )]
        fn _vpaddq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t;
    }
    unsafe { _vpaddq_s8(a, b) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.addp.v8i16"
        )]
        fn _vpaddq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t;
    }
    unsafe { _vpaddq_s16(a, b) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.addp.v4i32"
        )]
        fn _vpaddq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t;
    }
    unsafe { _vpaddq_s32(a, b) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_s64(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.addp.v2i64"
        )]
        fn _vpaddq_s64(a: int64x2_t, b: int64x2_t) -> int64x2_t;
    }
    unsafe { _vpaddq_s64(a, b) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vpaddq_s8(transmute(a), transmute(b))) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vpaddq_s8(transmute(a), transmute(b)));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { transmute(vpaddq_s16(transmute(a), transmute(b))) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    let a: uint16x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    let b: uint16x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint16x8_t = transmute(vpaddq_s16(transmute(a), transmute(b)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { transmute(vpaddq_s32(transmute(a), transmute(b))) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    let a: uint32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    let b: uint32x4_t = unsafe { simd_shuffle!(b, b, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint32x4_t = transmute(vpaddq_s32(transmute(a), transmute(b)));
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { transmute(vpaddq_s64(transmute(a), transmute(b))) }
}
#[doc = "Add Pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpaddq_u64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(addp))]
pub fn vpaddq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    let a: uint64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    let b: uint64x2_t = unsafe { simd_shuffle!(b, b, [1, 0]) };
    unsafe {
        let ret_val: uint64x2_t = transmute(vpaddq_s64(transmute(a), transmute(b)));
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmax_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vpmax_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxp.v4f16"
        )]
        fn _vpmax_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vpmax_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vpmaxq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxp.v8f16"
        )]
        fn _vpmaxq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vpmaxq_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnm_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
pub fn vpmaxnm_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmp.v4f16"
        )]
        fn _vpmaxnm_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vpmaxnm_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnmq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
pub fn vpmaxnmq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmp.v8f16"
        )]
        fn _vpmaxnmq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vpmaxnmq_f16(a, b) }
}
#[doc = "Floating-point Maximum Number Pairwise (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnm_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpmaxnm_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmp.v2f32"
        )]
        fn _vpmaxnm_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vpmaxnm_f32(a, b) }
}
#[doc = "Floating-point Maximum Number Pairwise (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnmq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpmaxnmq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmp.v4f32"
        )]
        fn _vpmaxnmq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vpmaxnmq_f32(a, b) }
}
#[doc = "Floating-point Maximum Number Pairwise (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnmq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpmaxnmq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmp.v2f64"
        )]
        fn _vpmaxnmq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vpmaxnmq_f64(a, b) }
}
#[doc = "Floating-point maximum number pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnmqd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpmaxnmqd_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmv.f64.v2f64"
        )]
        fn _vpmaxnmqd_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vpmaxnmqd_f64(a) }
}
#[doc = "Floating-point maximum number pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxnms_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fmaxnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpmaxnms_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxnmv.f32.v2f32"
        )]
        fn _vpmaxnms_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vpmaxnms_f32(a) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vpmaxq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxp.v4f32"
        )]
        fn _vpmaxq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vpmaxq_f32(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vpmaxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxp.v2f64"
        )]
        fn _vpmaxq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vpmaxq_f64(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxp))]
pub fn vpmaxq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.smaxp.v16i8"
        )]
        fn _vpmaxq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t;
    }
    unsafe { _vpmaxq_s8(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxp))]
pub fn vpmaxq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.smaxp.v8i16"
        )]
        fn _vpmaxq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t;
    }
    unsafe { _vpmaxq_s16(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(smaxp))]
pub fn vpmaxq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.smaxp.v4i32"
        )]
        fn _vpmaxq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t;
    }
    unsafe { _vpmaxq_s32(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxp))]
pub fn vpmaxq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.umaxp.v16i8"
        )]
        fn _vpmaxq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vpmaxq_u8(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxp))]
pub fn vpmaxq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.umaxp.v8i16"
        )]
        fn _vpmaxq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _vpmaxq_u16(a, b) }
}
#[doc = "Folding maximum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(umaxp))]
pub fn vpmaxq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.umaxp.v4i32"
        )]
        fn _vpmaxq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vpmaxq_u32(a, b) }
}
#[doc = "Floating-point maximum pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxqd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vpmaxqd_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f64.v2f64"
        )]
        fn _vpmaxqd_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vpmaxqd_f64(a) }
}
#[doc = "Floating-point maximum pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmaxs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fmaxp))]
pub fn vpmaxs_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fmaxv.f32.v2f32"
        )]
        fn _vpmaxs_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vpmaxs_f32(a) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmin_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vpmin_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminp.v4f16"
        )]
        fn _vpmin_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vpmin_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vpminq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminp.v8f16"
        )]
        fn _vpminq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vpminq_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnm_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminnmp))]
pub fn vpminnm_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmp.v4f16"
        )]
        fn _vpminnm_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vpminnm_f16(a, b) }
}
#[doc = "Floating-point add pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnmq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fminnmp))]
pub fn vpminnmq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmp.v8f16"
        )]
        fn _vpminnmq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vpminnmq_f16(a, b) }
}
#[doc = "Floating-point Minimum Number Pairwise (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnm_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpminnm_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmp.v2f32"
        )]
        fn _vpminnm_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vpminnm_f32(a, b) }
}
#[doc = "Floating-point Minimum Number Pairwise (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnmq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpminnmq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmp.v4f32"
        )]
        fn _vpminnmq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vpminnmq_f32(a, b) }
}
#[doc = "Floating-point Minimum Number Pairwise (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnmq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpminnmq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmp.v2f64"
        )]
        fn _vpminnmq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vpminnmq_f64(a, b) }
}
#[doc = "Floating-point minimum number pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnmqd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpminnmqd_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmv.f64.v2f64"
        )]
        fn _vpminnmqd_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vpminnmqd_f64(a) }
}
#[doc = "Floating-point minimum number pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminnms_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fminnmp))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vpminnms_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminnmv.f32.v2f32"
        )]
        fn _vpminnms_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vpminnms_f32(a) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vpminq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminp.v4f32"
        )]
        fn _vpminq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vpminq_f32(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vpminq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminp.v2f64"
        )]
        fn _vpminq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vpminq_f64(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminp))]
pub fn vpminq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sminp.v16i8"
        )]
        fn _vpminq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t;
    }
    unsafe { _vpminq_s8(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminp))]
pub fn vpminq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sminp.v8i16"
        )]
        fn _vpminq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t;
    }
    unsafe { _vpminq_s16(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sminp))]
pub fn vpminq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sminp.v4i32"
        )]
        fn _vpminq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t;
    }
    unsafe { _vpminq_s32(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminp))]
pub fn vpminq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uminp.v16i8"
        )]
        fn _vpminq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vpminq_u8(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminp))]
pub fn vpminq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uminp.v8i16"
        )]
        fn _vpminq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _vpminq_u16(a, b) }
}
#[doc = "Folding minimum of adjacent pairs"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uminp))]
pub fn vpminq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uminp.v4i32"
        )]
        fn _vpminq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vpminq_u32(a, b) }
}
#[doc = "Floating-point minimum pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpminqd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vpminqd_f64(a: float64x2_t) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f64.v2f64"
        )]
        fn _vpminqd_f64(a: float64x2_t) -> f64;
    }
    unsafe { _vpminqd_f64(a) }
}
#[doc = "Floating-point minimum pairwise"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vpmins_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(fminp))]
pub fn vpmins_f32(a: float32x2_t) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fminv.f32.v2f32"
        )]
        fn _vpmins_f32(a: float32x2_t) -> f32;
    }
    unsafe { _vpmins_f32(a) }
}
#[doc = "Signed saturating Absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqabs_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sqabs))]
pub fn vqabs_s64(a: int64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqabs.v1i64"
        )]
        fn _vqabs_s64(a: int64x1_t) -> int64x1_t;
    }
    unsafe { _vqabs_s64(a) }
}
#[doc = "Signed saturating Absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqabsq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sqabs))]
pub fn vqabsq_s64(a: int64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqabs.v2i64"
        )]
        fn _vqabsq_s64(a: int64x2_t) -> int64x2_t;
    }
    unsafe { _vqabsq_s64(a) }
}
#[doc = "Signed saturating absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqabsb_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sqabs))]
pub fn vqabsb_s8(a: i8) -> i8 {
    unsafe { simd_extract!(vqabs_s8(vdup_n_s8(a)), 0) }
}
#[doc = "Signed saturating absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqabsh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sqabs))]
pub fn vqabsh_s16(a: i16) -> i16 {
    unsafe { simd_extract!(vqabs_s16(vdup_n_s16(a)), 0) }
}
#[doc = "Signed saturating absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqabss_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sqabs))]
pub fn vqabss_s32(a: i32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqabs.i32"
        )]
        fn _vqabss_s32(a: i32) -> i32;
    }
    unsafe { _vqabss_s32(a) }
}
#[doc = "Signed saturating absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqabsd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sqabs))]
pub fn vqabsd_s64(a: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqabs.i64"
        )]
        fn _vqabsd_s64(a: i64) -> i64;
    }
    unsafe { _vqabsd_s64(a) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqaddb_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqadd))]
pub fn vqaddb_s8(a: i8, b: i8) -> i8 {
    let a: int8x8_t = vdup_n_s8(a);
    let b: int8x8_t = vdup_n_s8(b);
    unsafe { simd_extract!(vqadd_s8(a, b), 0) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqaddh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqadd))]
pub fn vqaddh_s16(a: i16, b: i16) -> i16 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    unsafe { simd_extract!(vqadd_s16(a, b), 0) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqaddb_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqadd))]
pub fn vqaddb_u8(a: u8, b: u8) -> u8 {
    let a: uint8x8_t = vdup_n_u8(a);
    let b: uint8x8_t = vdup_n_u8(b);
    unsafe { simd_extract!(vqadd_u8(a, b), 0) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqaddh_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqadd))]
pub fn vqaddh_u16(a: u16, b: u16) -> u16 {
    let a: uint16x4_t = vdup_n_u16(a);
    let b: uint16x4_t = vdup_n_u16(b);
    unsafe { simd_extract!(vqadd_u16(a, b), 0) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqadds_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqadd))]
pub fn vqadds_s32(a: i32, b: i32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqadd.i32"
        )]
        fn _vqadds_s32(a: i32, b: i32) -> i32;
    }
    unsafe { _vqadds_s32(a, b) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqaddd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqadd))]
pub fn vqaddd_s64(a: i64, b: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqadd.i64"
        )]
        fn _vqaddd_s64(a: i64, b: i64) -> i64;
    }
    unsafe { _vqaddd_s64(a, b) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqadds_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqadd))]
pub fn vqadds_u32(a: u32, b: u32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqadd.i32"
        )]
        fn _vqadds_u32(a: u32, b: u32) -> u32;
    }
    unsafe { _vqadds_u32(a, b) }
}
#[doc = "Saturating add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqaddd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqadd))]
pub fn vqaddd_u64(a: u64, b: u64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqadd.i64"
        )]
        fn _vqaddd_u64(a: u64, b: u64) -> u64;
    }
    unsafe { _vqaddd_u64(a, b) }
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_lane_s16<const N: i32>(a: int32x4_t, b: int16x8_t, c: int16x4_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 2);
    vqaddq_s32(a, vqdmull_high_lane_s16::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_laneq_s16<const N: i32>(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 3);
    vqaddq_s32(a, vqdmull_high_laneq_s16::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_lane_s32<const N: i32>(a: int64x2_t, b: int32x4_t, c: int32x2_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 1);
    vqaddq_s64(a, vqdmull_high_lane_s32::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_laneq_s32<const N: i32>(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 2);
    vqaddq_s64(a, vqdmull_high_laneq_s32::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_n_s16(a: int32x4_t, b: int16x8_t, c: i16) -> int32x4_t {
    vqaddq_s32(a, vqdmull_high_n_s16(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_s16(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    vqaddq_s32(a, vqdmull_high_s16(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_n_s32(a: int64x2_t, b: int32x4_t, c: i32) -> int64x2_t {
    vqaddq_s64(a, vqdmull_high_n_s32(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_high_s32(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    vqaddq_s64(a, vqdmull_high_s32(b, c))
}
#[doc = "Vector widening saturating doubling multiply accumulate with scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal, N = 2))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_laneq_s16<const N: i32>(a: int32x4_t, b: int16x4_t, c: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 3);
    vqaddq_s32(a, vqdmull_laneq_s16::<N>(b, c))
}
#[doc = "Vector widening saturating doubling multiply accumulate with scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlal_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlal_laneq_s32<const N: i32>(a: int64x2_t, b: int32x2_t, c: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 2);
    vqaddq_s64(a, vqdmull_laneq_s32::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlalh_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlalh_lane_s16<const LANE: i32>(a: i32, b: i16, c: int16x4_t) -> i32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqdmlalh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlalh_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlalh_laneq_s16<const LANE: i32>(a: i32, b: i16, c: int16x8_t) -> i32 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vqdmlalh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlals_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlals_lane_s32<const LANE: i32>(a: i64, b: i32, c: int32x2_t) -> i64 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqdmlals_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlals_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlals_laneq_s32<const LANE: i32>(a: i64, b: i32, c: int32x4_t) -> i64 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqdmlals_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlalh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlalh_s16(a: i32, b: i16, c: i16) -> i32 {
    let x: int32x4_t = vqdmull_s16(vdup_n_s16(b), vdup_n_s16(c));
    unsafe { vqadds_s32(a, simd_extract!(x, 0)) }
}
#[doc = "Signed saturating doubling multiply-add long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlals_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlal))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlals_s32(a: i64, b: i32, c: i32) -> i64 {
    let x: i64 = vqaddd_s64(a, vqdmulls_s32(b, c));
    x
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_lane_s16<const N: i32>(a: int32x4_t, b: int16x8_t, c: int16x4_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 2);
    vqsubq_s32(a, vqdmull_high_lane_s16::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_laneq_s16<const N: i32>(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 3);
    vqsubq_s32(a, vqdmull_high_laneq_s16::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_lane_s32<const N: i32>(a: int64x2_t, b: int32x4_t, c: int32x2_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 1);
    vqsubq_s64(a, vqdmull_high_lane_s32::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_laneq_s32<const N: i32>(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 2);
    vqsubq_s64(a, vqdmull_high_laneq_s32::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_n_s16(a: int32x4_t, b: int16x8_t, c: i16) -> int32x4_t {
    vqsubq_s32(a, vqdmull_high_n_s16(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_s16(a: int32x4_t, b: int16x8_t, c: int16x8_t) -> int32x4_t {
    vqsubq_s32(a, vqdmull_high_s16(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_n_s32(a: int64x2_t, b: int32x4_t, c: i32) -> int64x2_t {
    vqsubq_s64(a, vqdmull_high_n_s32(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_high_s32(a: int64x2_t, b: int32x4_t, c: int32x4_t) -> int64x2_t {
    vqsubq_s64(a, vqdmull_high_s32(b, c))
}
#[doc = "Vector widening saturating doubling multiply subtract with scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl, N = 2))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_laneq_s16<const N: i32>(a: int32x4_t, b: int16x4_t, c: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 3);
    vqsubq_s32(a, vqdmull_laneq_s16::<N>(b, c))
}
#[doc = "Vector widening saturating doubling multiply subtract with scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsl_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl, N = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsl_laneq_s32<const N: i32>(a: int64x2_t, b: int32x2_t, c: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 2);
    vqsubq_s64(a, vqdmull_laneq_s32::<N>(b, c))
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlslh_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlslh_lane_s16<const LANE: i32>(a: i32, b: i16, c: int16x4_t) -> i32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqdmlslh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlslh_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlslh_laneq_s16<const LANE: i32>(a: i32, b: i16, c: int16x8_t) -> i32 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vqdmlslh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsls_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsls_lane_s32<const LANE: i32>(a: i64, b: i32, c: int32x2_t) -> i64 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqdmlsls_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsls_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl, LANE = 0))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsls_laneq_s32<const LANE: i32>(a: i64, b: i32, c: int32x4_t) -> i64 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqdmlsls_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlslh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlslh_s16(a: i32, b: i16, c: i16) -> i32 {
    let x: int32x4_t = vqdmull_s16(vdup_n_s16(b), vdup_n_s16(c));
    unsafe { vqsubs_s32(a, simd_extract!(x, 0)) }
}
#[doc = "Signed saturating doubling multiply-subtract long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmlsls_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmlsl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmlsls_s32(a: i64, b: i32, c: i32) -> i64 {
    let x: i64 = vqsubd_s64(a, vqdmulls_s32(b, c));
    x
}
#[doc = "Vector saturating doubling multiply high by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulh_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulh_lane_s16<const LANE: i32>(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqdmulh_s16(a, vdup_n_s16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Vector saturating doubling multiply high by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhq_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhq_lane_s16<const LANE: i32>(a: int16x8_t, b: int16x4_t) -> int16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqdmulhq_s16(a, vdupq_n_s16(simd_extract!(b, LANE as u32))) }
}
#[doc = "Vector saturating doubling multiply high by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulh_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulh_lane_s32<const LANE: i32>(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqdmulh_s32(a, vdup_n_s32(simd_extract!(b, LANE as u32))) }
}
#[doc = "Vector saturating doubling multiply high by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhq_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhq_lane_s32<const LANE: i32>(a: int32x4_t, b: int32x2_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqdmulhq_s32(a, vdupq_n_s32(simd_extract!(b, LANE as u32))) }
}
#[doc = "Signed saturating doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhh_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhh_lane_s16<const N: i32>(a: i16, b: int16x4_t) -> i16 {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let b: i16 = simd_extract!(b, N as u32);
        vqdmulhh_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhh_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhh_laneq_s16<const N: i32>(a: i16, b: int16x8_t) -> i16 {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        let b: i16 = simd_extract!(b, N as u32);
        vqdmulhh_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhh_s16(a: i16, b: i16) -> i16 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    unsafe { simd_extract!(vqdmulh_s16(a, b), 0) }
}
#[doc = "Signed saturating doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhs_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhs_s32(a: i32, b: i32) -> i32 {
    let a: int32x2_t = vdup_n_s32(a);
    let b: int32x2_t = vdup_n_s32(b);
    unsafe { simd_extract!(vqdmulh_s32(a, b), 0) }
}
#[doc = "Signed saturating doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhs_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhs_lane_s32<const N: i32>(a: i32, b: int32x2_t) -> i32 {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        let b: i32 = simd_extract!(b, N as u32);
        vqdmulhs_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulhs_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmulh, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulhs_laneq_s32<const N: i32>(a: i32, b: int32x4_t) -> i32 {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let b: i32 = simd_extract!(b, N as u32);
        vqdmulhs_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_lane_s16<const N: i32>(a: int16x8_t, b: int16x4_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: int16x4_t = simd_shuffle!(b, b, [N as u32, N as u32, N as u32, N as u32]);
        vqdmull_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_laneq_s32<const N: i32>(a: int32x4_t, b: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: int32x2_t = simd_shuffle!(b, b, [N as u32, N as u32]);
        vqdmull_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_lane_s32<const N: i32>(a: int32x4_t, b: int32x2_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: int32x2_t = simd_shuffle!(b, b, [N as u32, N as u32]);
        vqdmull_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2, N = 4))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_laneq_s16<const N: i32>(a: int16x8_t, b: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: int16x4_t = simd_shuffle!(b, b, [N as u32, N as u32, N as u32, N as u32]);
        vqdmull_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_n_s16(a: int16x8_t, b: i16) -> int32x4_t {
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: int16x4_t = vdup_n_s16(b);
        vqdmull_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_n_s32(a: int32x4_t, b: i32) -> int64x2_t {
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: int32x2_t = vdup_n_s32(b);
        vqdmull_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_s16(a: int16x8_t, b: int16x8_t) -> int32x4_t {
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        vqdmull_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_high_s32(a: int32x4_t, b: int32x4_t) -> int64x2_t {
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        vqdmull_s32(a, b)
    }
}
#[doc = "Vector saturating doubling long multiply by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull, N = 4))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_laneq_s16<const N: i32>(a: int16x4_t, b: int16x8_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        let b: int16x4_t = simd_shuffle!(b, b, [N as u32, N as u32, N as u32, N as u32]);
        vqdmull_s16(a, b)
    }
}
#[doc = "Vector saturating doubling long multiply by scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmull_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmull_laneq_s32<const N: i32>(a: int32x2_t, b: int32x4_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let b: int32x2_t = simd_shuffle!(b, b, [N as u32, N as u32]);
        vqdmull_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmullh_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmullh_lane_s16<const N: i32>(a: i16, b: int16x4_t) -> i32 {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let b: i16 = simd_extract!(b, N as u32);
        vqdmullh_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulls_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulls_laneq_s32<const N: i32>(a: i32, b: int32x4_t) -> i64 {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        let b: i32 = simd_extract!(b, N as u32);
        vqdmulls_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmullh_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull, N = 4))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmullh_laneq_s16<const N: i32>(a: i16, b: int16x8_t) -> i32 {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        let b: i16 = simd_extract!(b, N as u32);
        vqdmullh_s16(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmullh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmullh_s16(a: i16, b: i16) -> i32 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    unsafe { simd_extract!(vqdmull_s16(a, b), 0) }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulls_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulls_lane_s32<const N: i32>(a: i32, b: int32x2_t) -> i64 {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        let b: i32 = simd_extract!(b, N as u32);
        vqdmulls_s32(a, b)
    }
}
#[doc = "Signed saturating doubling multiply long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqdmulls_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqdmull))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqdmulls_s32(a: i32, b: i32) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqdmulls.scalar"
        )]
        fn _vqdmulls_s32(a: i32, b: i32) -> i64;
    }
    unsafe { _vqdmulls_s32(a, b) }
}
#[doc = "Signed saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovn_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovn_high_s16(a: int8x8_t, b: int16x8_t) -> int8x16_t {
    unsafe {
        simd_shuffle!(
            a,
            vqmovn_s16(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovn_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovn_high_s32(a: int16x4_t, b: int32x4_t) -> int16x8_t {
    unsafe { simd_shuffle!(a, vqmovn_s32(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovn_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovn_high_s64(a: int32x2_t, b: int64x2_t) -> int32x4_t {
    unsafe { simd_shuffle!(a, vqmovn_s64(b), [0, 1, 2, 3]) }
}
#[doc = "Signed saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovn_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqxtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovn_high_u16(a: uint8x8_t, b: uint16x8_t) -> uint8x16_t {
    unsafe {
        simd_shuffle!(
            a,
            vqmovn_u16(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovn_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqxtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovn_high_u32(a: uint16x4_t, b: uint32x4_t) -> uint16x8_t {
    unsafe { simd_shuffle!(a, vqmovn_u32(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovn_high_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqxtn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovn_high_u64(a: uint32x2_t, b: uint64x2_t) -> uint32x4_t {
    unsafe { simd_shuffle!(a, vqmovn_u64(b), [0, 1, 2, 3]) }
}
#[doc = "Saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovnd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovnd_s64(a: i64) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.scalar.sqxtn.i32.i64"
        )]
        fn _vqmovnd_s64(a: i64) -> i32;
    }
    unsafe { _vqmovnd_s64(a) }
}
#[doc = "Saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovnd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqxtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovnd_u64(a: u64) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.scalar.uqxtn.i32.i64"
        )]
        fn _vqmovnd_u64(a: u64) -> u32;
    }
    unsafe { _vqmovnd_u64(a) }
}
#[doc = "Saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovnh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovnh_s16(a: i16) -> i8 {
    unsafe { simd_extract!(vqmovn_s16(vdupq_n_s16(a)), 0) }
}
#[doc = "Saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovns_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovns_s32(a: i32) -> i16 {
    unsafe { simd_extract!(vqmovn_s32(vdupq_n_s32(a)), 0) }
}
#[doc = "Saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovnh_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqxtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovnh_u16(a: u16) -> u8 {
    unsafe { simd_extract!(vqmovn_u16(vdupq_n_u16(a)), 0) }
}
#[doc = "Saturating extract narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovns_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqxtn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovns_u32(a: u32) -> u16 {
    unsafe { simd_extract!(vqmovn_u32(vdupq_n_u32(a)), 0) }
}
#[doc = "Signed saturating extract unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovun_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtun2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovun_high_s16(a: uint8x8_t, b: int16x8_t) -> uint8x16_t {
    unsafe {
        simd_shuffle!(
            a,
            vqmovun_s16(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating extract unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovun_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtun2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovun_high_s32(a: uint16x4_t, b: int32x4_t) -> uint16x8_t {
    unsafe { simd_shuffle!(a, vqmovun_s32(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating extract unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovun_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtun2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovun_high_s64(a: uint32x2_t, b: int64x2_t) -> uint32x4_t {
    unsafe { simd_shuffle!(a, vqmovun_s64(b), [0, 1, 2, 3]) }
}
#[doc = "Signed saturating extract unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovunh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtun))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovunh_s16(a: i16) -> u8 {
    unsafe { simd_extract!(vqmovun_s16(vdupq_n_s16(a)), 0) }
}
#[doc = "Signed saturating extract unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovuns_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtun))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovuns_s32(a: i32) -> u16 {
    unsafe { simd_extract!(vqmovun_s32(vdupq_n_s32(a)), 0) }
}
#[doc = "Signed saturating extract unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqmovund_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqxtun))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqmovund_s64(a: i64) -> u32 {
    unsafe { simd_extract!(vqmovun_s64(vdupq_n_s64(a)), 0) }
}
#[doc = "Signed saturating negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqneg_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqneg))]
pub fn vqneg_s64(a: int64x1_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqneg.v1i64"
        )]
        fn _vqneg_s64(a: int64x1_t) -> int64x1_t;
    }
    unsafe { _vqneg_s64(a) }
}
#[doc = "Signed saturating negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqnegq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqneg))]
pub fn vqnegq_s64(a: int64x2_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqneg.v2i64"
        )]
        fn _vqnegq_s64(a: int64x2_t) -> int64x2_t;
    }
    unsafe { _vqnegq_s64(a) }
}
#[doc = "Signed saturating negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqnegb_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqneg))]
pub fn vqnegb_s8(a: i8) -> i8 {
    unsafe { simd_extract!(vqneg_s8(vdup_n_s8(a)), 0) }
}
#[doc = "Signed saturating negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqnegh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqneg))]
pub fn vqnegh_s16(a: i16) -> i16 {
    unsafe { simd_extract!(vqneg_s16(vdup_n_s16(a)), 0) }
}
#[doc = "Signed saturating negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqnegs_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqneg))]
pub fn vqnegs_s32(a: i32) -> i32 {
    unsafe { simd_extract!(vqneg_s32(vdup_n_s32(a)), 0) }
}
#[doc = "Signed saturating negate"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqnegd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqneg))]
pub fn vqnegd_s64(a: i64) -> i64 {
    unsafe { simd_extract!(vqneg_s64(vdup_n_s64(a)), 0) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlah_lane_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlah_lane_s16<const LANE: i32>(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int16x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlah_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlah_lane_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlah_lane_s32<const LANE: i32>(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vqrdmlah_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlah_laneq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlah_laneq_s16<const LANE: i32>(a: int16x4_t, b: int16x4_t, c: int16x8_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let c: int16x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlah_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlah_laneq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlah_laneq_s32<const LANE: i32>(a: int32x2_t, b: int32x2_t, c: int32x4_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vqrdmlah_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahq_lane_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahq_lane_s16<const LANE: i32>(a: int16x8_t, b: int16x8_t, c: int16x4_t) -> int16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int16x8_t = simd_shuffle!(
            c,
            c,
            [
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32
            ]
        );
        vqrdmlahq_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahq_lane_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahq_lane_s32<const LANE: i32>(a: int32x4_t, b: int32x4_t, c: int32x2_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlahq_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahq_laneq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahq_laneq_s16<const LANE: i32>(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let c: int16x8_t = simd_shuffle!(
            c,
            c,
            [
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32
            ]
        );
        vqrdmlahq_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahq_laneq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahq_laneq_s32<const LANE: i32>(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlahq_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlah_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlah_s16(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlah.v4i16"
        )]
        fn _vqrdmlah_s16(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t;
    }
    unsafe { _vqrdmlah_s16(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlah.v8i16"
        )]
        fn _vqrdmlahq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t;
    }
    unsafe { _vqrdmlahq_s16(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlah_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlah_s32(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlah.v2i32"
        )]
        fn _vqrdmlah_s32(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t;
    }
    unsafe { _vqrdmlah_s32(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlah.v4i32"
        )]
        fn _vqrdmlahq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t;
    }
    unsafe { _vqrdmlahq_s32(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahh_lane_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahh_lane_s16<const LANE: i32>(a: i16, b: i16, c: int16x4_t) -> i16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqrdmlahh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahh_laneq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahh_laneq_s16<const LANE: i32>(a: i16, b: i16, c: int16x8_t) -> i16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vqrdmlahh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahs_lane_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahs_lane_s32<const LANE: i32>(a: i32, b: i32, c: int32x2_t) -> i32 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqrdmlahs_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahs_laneq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahs_laneq_s32<const LANE: i32>(a: i32, b: i32, c: int32x4_t) -> i32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqrdmlahs_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahh_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahh_s16(a: i16, b: i16, c: i16) -> i16 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    let c: int16x4_t = vdup_n_s16(c);
    unsafe { simd_extract!(vqrdmlah_s16(a, b, c), 0) }
}
#[doc = "Signed saturating rounding doubling multiply accumulate returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlahs_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlah))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlahs_s32(a: i32, b: i32, c: i32) -> i32 {
    let a: int32x2_t = vdup_n_s32(a);
    let b: int32x2_t = vdup_n_s32(b);
    let c: int32x2_t = vdup_n_s32(c);
    unsafe { simd_extract!(vqrdmlah_s32(a, b, c), 0) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlsh_lane_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlsh_lane_s16<const LANE: i32>(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int16x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlsh_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlsh_lane_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlsh_lane_s32<const LANE: i32>(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vqrdmlsh_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlsh_laneq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlsh_laneq_s16<const LANE: i32>(a: int16x4_t, b: int16x4_t, c: int16x8_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let c: int16x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlsh_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlsh_laneq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlsh_laneq_s32<const LANE: i32>(a: int32x2_t, b: int32x2_t, c: int32x4_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vqrdmlsh_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshq_lane_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshq_lane_s16<const LANE: i32>(a: int16x8_t, b: int16x8_t, c: int16x4_t) -> int16x8_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int16x8_t = simd_shuffle!(
            c,
            c,
            [
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32
            ]
        );
        vqrdmlshq_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshq_lane_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshq_lane_s32<const LANE: i32>(a: int32x4_t, b: int32x4_t, c: int32x2_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlshq_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshq_laneq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshq_laneq_s16<const LANE: i32>(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe {
        let c: int16x8_t = simd_shuffle!(
            c,
            c,
            [
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32,
                LANE as u32
            ]
        );
        vqrdmlshq_s16(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshq_laneq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshq_laneq_s32<const LANE: i32>(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe {
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vqrdmlshq_s32(a, b, c)
    }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlsh_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlsh_s16(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlsh.v4i16"
        )]
        fn _vqrdmlsh_s16(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t;
    }
    unsafe { _vqrdmlsh_s16(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlsh.v8i16"
        )]
        fn _vqrdmlshq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t;
    }
    unsafe { _vqrdmlshq_s16(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlsh_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlsh_s32(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlsh.v2i32"
        )]
        fn _vqrdmlsh_s32(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t;
    }
    unsafe { _vqrdmlsh_s32(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrdmlsh.v4i32"
        )]
        fn _vqrdmlshq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t;
    }
    unsafe { _vqrdmlshq_s32(a, b, c) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshh_lane_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshh_lane_s16<const LANE: i32>(a: i16, b: i16, c: int16x4_t) -> i16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqrdmlshh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshh_laneq_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshh_laneq_s16<const LANE: i32>(a: i16, b: i16, c: int16x8_t) -> i16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vqrdmlshh_s16(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshs_lane_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshs_lane_s32<const LANE: i32>(a: i32, b: i32, c: int32x2_t) -> i32 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqrdmlshs_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshs_laneq_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh, LANE = 1))]
#[rustc_legacy_const_generics(3)]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshs_laneq_s32<const LANE: i32>(a: i32, b: i32, c: int32x4_t) -> i32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqrdmlshs_s32(a, b, simd_extract!(c, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshh_s16)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshh_s16(a: i16, b: i16, c: i16) -> i16 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    let c: int16x4_t = vdup_n_s16(c);
    unsafe { simd_extract!(vqrdmlsh_s16(a, b, c), 0) }
}
#[doc = "Signed saturating rounding doubling multiply subtract returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmlshs_s32)"]
#[inline]
#[target_feature(enable = "rdm")]
#[cfg_attr(test, assert_instr(sqrdmlsh))]
#[stable(feature = "rdm_intrinsics", since = "1.62.0")]
pub fn vqrdmlshs_s32(a: i32, b: i32, c: i32) -> i32 {
    let a: int32x2_t = vdup_n_s32(a);
    let b: int32x2_t = vdup_n_s32(b);
    let c: int32x2_t = vdup_n_s32(c);
    unsafe { simd_extract!(vqrdmlsh_s32(a, b, c), 0) }
}
#[doc = "Signed saturating rounding doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmulhh_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrdmulh, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrdmulhh_lane_s16<const LANE: i32>(a: i16, b: int16x4_t) -> i16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqrdmulhh_s16(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmulhh_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrdmulh, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrdmulhh_laneq_s16<const LANE: i32>(a: i16, b: int16x8_t) -> i16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { vqrdmulhh_s16(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmulhs_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrdmulh, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrdmulhs_lane_s32<const LANE: i32>(a: i32, b: int32x2_t) -> i32 {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { vqrdmulhs_s32(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmulhs_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrdmulh, LANE = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrdmulhs_laneq_s32<const LANE: i32>(a: i32, b: int32x4_t) -> i32 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { vqrdmulhs_s32(a, simd_extract!(b, LANE as u32)) }
}
#[doc = "Signed saturating rounding doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmulhh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrdmulh))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrdmulhh_s16(a: i16, b: i16) -> i16 {
    unsafe { simd_extract!(vqrdmulh_s16(vdup_n_s16(a), vdup_n_s16(b)), 0) }
}
#[doc = "Signed saturating rounding doubling multiply returning high half"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrdmulhs_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrdmulh))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrdmulhs_s32(a: i32, b: i32) -> i32 {
    unsafe { simd_extract!(vqrdmulh_s32(vdup_n_s32(a), vdup_n_s32(b)), 0) }
}
#[doc = "Signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshlb_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshlb_s8(a: i8, b: i8) -> i8 {
    let a: int8x8_t = vdup_n_s8(a);
    let b: int8x8_t = vdup_n_s8(b);
    unsafe { simd_extract!(vqrshl_s8(a, b), 0) }
}
#[doc = "Signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshlh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshlh_s16(a: i16, b: i16) -> i16 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    unsafe { simd_extract!(vqrshl_s16(a, b), 0) }
}
#[doc = "Unsigned signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshlb_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshlb_u8(a: u8, b: i8) -> u8 {
    let a: uint8x8_t = vdup_n_u8(a);
    let b: int8x8_t = vdup_n_s8(b);
    unsafe { simd_extract!(vqrshl_u8(a, b), 0) }
}
#[doc = "Unsigned signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshlh_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshlh_u16(a: u16, b: i16) -> u16 {
    let a: uint16x4_t = vdup_n_u16(a);
    let b: int16x4_t = vdup_n_s16(b);
    unsafe { simd_extract!(vqrshl_u16(a, b), 0) }
}
#[doc = "Signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshld_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshld_s64(a: i64, b: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrshl.i64"
        )]
        fn _vqrshld_s64(a: i64, b: i64) -> i64;
    }
    unsafe { _vqrshld_s64(a, b) }
}
#[doc = "Signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshls_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshls_s32(a: i32, b: i32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqrshl.i32"
        )]
        fn _vqrshls_s32(a: i32, b: i32) -> i32;
    }
    unsafe { _vqrshls_s32(a, b) }
}
#[doc = "Unsigned signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshls_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshls_u32(a: u32, b: i32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqrshl.i32"
        )]
        fn _vqrshls_u32(a: u32, b: i32) -> u32;
    }
    unsafe { _vqrshls_u32(a, b) }
}
#[doc = "Unsigned signed saturating rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshld_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshld_u64(a: u64, b: i64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqrshl.i64"
        )]
        fn _vqrshld_u64(a: u64, b: i64) -> u64;
    }
    unsafe { _vqrshld_u64(a, b) }
}
#[doc = "Signed saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrn_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrn_high_n_s16<const N: i32>(a: int8x8_t, b: int16x8_t) -> int8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vqrshrn_n_s16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrn_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrn_high_n_s32<const N: i32>(a: int16x4_t, b: int32x4_t) -> int16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vqrshrn_n_s32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrn_high_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrn_high_n_s64<const N: i32>(a: int32x2_t, b: int64x2_t) -> int32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vqrshrn_n_s64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Unsigned saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrn_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrn_high_n_u16<const N: i32>(a: uint8x8_t, b: uint16x8_t) -> uint8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vqrshrn_n_u16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Unsigned saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrn_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrn_high_n_u32<const N: i32>(a: uint16x4_t, b: uint32x4_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vqrshrn_n_u32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Unsigned saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrn_high_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrn_high_n_u64<const N: i32>(a: uint32x2_t, b: uint64x2_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vqrshrn_n_u64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Unsigned saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrnd_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrnd_n_u64<const N: i32>(a: u64) -> u32 {
    static_assert!(N >= 1 && N <= 32);
    let a: uint64x2_t = vdupq_n_u64(a);
    unsafe { simd_extract!(vqrshrn_n_u64::<N>(a), 0) }
}
#[doc = "Unsigned saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrnh_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrnh_n_u16<const N: i32>(a: u16) -> u8 {
    static_assert!(N >= 1 && N <= 8);
    let a: uint16x8_t = vdupq_n_u16(a);
    unsafe { simd_extract!(vqrshrn_n_u16::<N>(a), 0) }
}
#[doc = "Unsigned saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrns_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqrshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrns_n_u32<const N: i32>(a: u32) -> u16 {
    static_assert!(N >= 1 && N <= 16);
    let a: uint32x4_t = vdupq_n_u32(a);
    unsafe { simd_extract!(vqrshrn_n_u32::<N>(a), 0) }
}
#[doc = "Signed saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrnh_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrnh_n_s16<const N: i32>(a: i16) -> i8 {
    static_assert!(N >= 1 && N <= 8);
    let a: int16x8_t = vdupq_n_s16(a);
    unsafe { simd_extract!(vqrshrn_n_s16::<N>(a), 0) }
}
#[doc = "Signed saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrns_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrns_n_s32<const N: i32>(a: i32) -> i16 {
    static_assert!(N >= 1 && N <= 16);
    let a: int32x4_t = vdupq_n_s32(a);
    unsafe { simd_extract!(vqrshrn_n_s32::<N>(a), 0) }
}
#[doc = "Signed saturating rounded shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrnd_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrnd_n_s64<const N: i32>(a: i64) -> i32 {
    static_assert!(N >= 1 && N <= 32);
    let a: int64x2_t = vdupq_n_s64(a);
    unsafe { simd_extract!(vqrshrn_n_s64::<N>(a), 0) }
}
#[doc = "Signed saturating rounded shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrun_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrun2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrun_high_n_s16<const N: i32>(a: uint8x8_t, b: int16x8_t) -> uint8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vqrshrun_n_s16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating rounded shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrun_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrun2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrun_high_n_s32<const N: i32>(a: uint16x4_t, b: int32x4_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vqrshrun_n_s32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating rounded shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrun_high_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrun2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrun_high_n_s64<const N: i32>(a: uint32x2_t, b: int64x2_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vqrshrun_n_s64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Signed saturating rounded shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrund_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrun, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrund_n_s64<const N: i32>(a: i64) -> u32 {
    static_assert!(N >= 1 && N <= 32);
    let a: int64x2_t = vdupq_n_s64(a);
    unsafe { simd_extract!(vqrshrun_n_s64::<N>(a), 0) }
}
#[doc = "Signed saturating rounded shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshrunh_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrun, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshrunh_n_s16<const N: i32>(a: i16) -> u8 {
    static_assert!(N >= 1 && N <= 8);
    let a: int16x8_t = vdupq_n_s16(a);
    unsafe { simd_extract!(vqrshrun_n_s16::<N>(a), 0) }
}
#[doc = "Signed saturating rounded shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqrshruns_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqrshrun, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqrshruns_n_s32<const N: i32>(a: i32) -> u16 {
    static_assert!(N >= 1 && N <= 16);
    let a: int32x4_t = vdupq_n_s32(a);
    unsafe { simd_extract!(vqrshrun_n_s32::<N>(a), 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlb_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlb_n_s8<const N: i32>(a: i8) -> i8 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(vqshl_n_s8::<N>(vdup_n_s8(a)), 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshld_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshld_n_s64<const N: i32>(a: i64) -> i64 {
    static_assert_uimm_bits!(N, 6);
    unsafe { simd_extract!(vqshl_n_s64::<N>(vdup_n_s64(a)), 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlh_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlh_n_s16<const N: i32>(a: i16) -> i16 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(vqshl_n_s16::<N>(vdup_n_s16(a)), 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshls_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshls_n_s32<const N: i32>(a: i32) -> i32 {
    static_assert_uimm_bits!(N, 5);
    unsafe { simd_extract!(vqshl_n_s32::<N>(vdup_n_s32(a)), 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlb_n_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlb_n_u8<const N: i32>(a: u8) -> u8 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(vqshl_n_u8::<N>(vdup_n_u8(a)), 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshld_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshld_n_u64<const N: i32>(a: u64) -> u64 {
    static_assert_uimm_bits!(N, 6);
    unsafe { simd_extract!(vqshl_n_u64::<N>(vdup_n_u64(a)), 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlh_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlh_n_u16<const N: i32>(a: u16) -> u16 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(vqshl_n_u16::<N>(vdup_n_u16(a)), 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshls_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshls_n_u32<const N: i32>(a: u32) -> u32 {
    static_assert_uimm_bits!(N, 5);
    unsafe { simd_extract!(vqshl_n_u32::<N>(vdup_n_u32(a)), 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlb_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlb_s8(a: i8, b: i8) -> i8 {
    let c: int8x8_t = vqshl_s8(vdup_n_s8(a), vdup_n_s8(b));
    unsafe { simd_extract!(c, 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlh_s16(a: i16, b: i16) -> i16 {
    let c: int16x4_t = vqshl_s16(vdup_n_s16(a), vdup_n_s16(b));
    unsafe { simd_extract!(c, 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshls_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshls_s32(a: i32, b: i32) -> i32 {
    let c: int32x2_t = vqshl_s32(vdup_n_s32(a), vdup_n_s32(b));
    unsafe { simd_extract!(c, 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlb_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlb_u8(a: u8, b: i8) -> u8 {
    let c: uint8x8_t = vqshl_u8(vdup_n_u8(a), vdup_n_s8(b));
    unsafe { simd_extract!(c, 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlh_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlh_u16(a: u16, b: i16) -> u16 {
    let c: uint16x4_t = vqshl_u16(vdup_n_u16(a), vdup_n_s16(b));
    unsafe { simd_extract!(c, 0) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshls_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshls_u32(a: u32, b: i32) -> u32 {
    let c: uint32x2_t = vqshl_u32(vdup_n_u32(a), vdup_n_s32(b));
    unsafe { simd_extract!(c, 0) }
}
#[doc = "Signed saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshld_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshld_s64(a: i64, b: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqshl.i64"
        )]
        fn _vqshld_s64(a: i64, b: i64) -> i64;
    }
    unsafe { _vqshld_s64(a, b) }
}
#[doc = "Unsigned saturating shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshld_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshld_u64(a: u64, b: i64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqshl.i64"
        )]
        fn _vqshld_u64(a: u64, b: i64) -> u64;
    }
    unsafe { _vqshld_u64(a, b) }
}
#[doc = "Signed saturating shift left unsigned"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlub_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshlu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlub_n_s8<const N: i32>(a: i8) -> u8 {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_extract!(vqshlu_n_s8::<N>(vdup_n_s8(a)), 0) }
}
#[doc = "Signed saturating shift left unsigned"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlud_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshlu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlud_n_s64<const N: i32>(a: i64) -> u64 {
    static_assert_uimm_bits!(N, 6);
    unsafe { simd_extract!(vqshlu_n_s64::<N>(vdup_n_s64(a)), 0) }
}
#[doc = "Signed saturating shift left unsigned"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshluh_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshlu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshluh_n_s16<const N: i32>(a: i16) -> u16 {
    static_assert_uimm_bits!(N, 4);
    unsafe { simd_extract!(vqshlu_n_s16::<N>(vdup_n_s16(a)), 0) }
}
#[doc = "Signed saturating shift left unsigned"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshlus_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshlu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshlus_n_s32<const N: i32>(a: i32) -> u32 {
    static_assert_uimm_bits!(N, 5);
    unsafe { simd_extract!(vqshlu_n_s32::<N>(vdup_n_s32(a)), 0) }
}
#[doc = "Signed saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrn_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrn_high_n_s16<const N: i32>(a: int8x8_t, b: int16x8_t) -> int8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vqshrn_n_s16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrn_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrn_high_n_s32<const N: i32>(a: int16x4_t, b: int32x4_t) -> int16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vqshrn_n_s32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrn_high_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrn_high_n_s64<const N: i32>(a: int32x2_t, b: int64x2_t) -> int32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vqshrn_n_s64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Unsigned saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrn_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrn_high_n_u16<const N: i32>(a: uint8x8_t, b: uint16x8_t) -> uint8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vqshrn_n_u16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Unsigned saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrn_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrn_high_n_u32<const N: i32>(a: uint16x4_t, b: uint32x4_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vqshrn_n_u32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Unsigned saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrn_high_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrn_high_n_u64<const N: i32>(a: uint32x2_t, b: uint64x2_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vqshrn_n_u64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Signed saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrnd_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrnd_n_s64<const N: i32>(a: i64) -> i32 {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqshrn.i32"
        )]
        fn _vqshrnd_n_s64(a: i64, n: i32) -> i32;
    }
    unsafe { _vqshrnd_n_s64(a, N) }
}
#[doc = "Unsigned saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrnd_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrnd_n_u64<const N: i32>(a: u64) -> u32 {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqshrn.i32"
        )]
        fn _vqshrnd_n_u64(a: u64, n: i32) -> u32;
    }
    unsafe { _vqshrnd_n_u64(a, N) }
}
#[doc = "Signed saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrnh_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrnh_n_s16<const N: i32>(a: i16) -> i8 {
    static_assert!(N >= 1 && N <= 8);
    unsafe { simd_extract!(vqshrn_n_s16::<N>(vdupq_n_s16(a)), 0) }
}
#[doc = "Signed saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrns_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrns_n_s32<const N: i32>(a: i32) -> i16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_extract!(vqshrn_n_s32::<N>(vdupq_n_s32(a)), 0) }
}
#[doc = "Unsigned saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrnh_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrnh_n_u16<const N: i32>(a: u16) -> u8 {
    static_assert!(N >= 1 && N <= 8);
    unsafe { simd_extract!(vqshrn_n_u16::<N>(vdupq_n_u16(a)), 0) }
}
#[doc = "Unsigned saturating shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrns_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(uqshrn, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrns_n_u32<const N: i32>(a: u32) -> u16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_extract!(vqshrn_n_u32::<N>(vdupq_n_u32(a)), 0) }
}
#[doc = "Signed saturating shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrun_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrun2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrun_high_n_s16<const N: i32>(a: uint8x8_t, b: int16x8_t) -> uint8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vqshrun_n_s16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Signed saturating shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrun_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrun2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrun_high_n_s32<const N: i32>(a: uint16x4_t, b: int32x4_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vqshrun_n_s32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Signed saturating shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrun_high_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrun2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrun_high_n_s64<const N: i32>(a: uint32x2_t, b: int64x2_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vqshrun_n_s64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Signed saturating shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrund_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrun, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrund_n_s64<const N: i32>(a: i64) -> u32 {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_extract!(vqshrun_n_s64::<N>(vdupq_n_s64(a)), 0) }
}
#[doc = "Signed saturating shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshrunh_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrun, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshrunh_n_s16<const N: i32>(a: i16) -> u8 {
    static_assert!(N >= 1 && N <= 8);
    unsafe { simd_extract!(vqshrun_n_s16::<N>(vdupq_n_s16(a)), 0) }
}
#[doc = "Signed saturating shift right unsigned narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqshruns_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sqshrun, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqshruns_n_s32<const N: i32>(a: i32) -> u16 {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_extract!(vqshrun_n_s32::<N>(vdupq_n_s32(a)), 0) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubb_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqsub))]
pub fn vqsubb_s8(a: i8, b: i8) -> i8 {
    let a: int8x8_t = vdup_n_s8(a);
    let b: int8x8_t = vdup_n_s8(b);
    unsafe { simd_extract!(vqsub_s8(a, b), 0) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubh_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqsub))]
pub fn vqsubh_s16(a: i16, b: i16) -> i16 {
    let a: int16x4_t = vdup_n_s16(a);
    let b: int16x4_t = vdup_n_s16(b);
    unsafe { simd_extract!(vqsub_s16(a, b), 0) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubb_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqsub))]
pub fn vqsubb_u8(a: u8, b: u8) -> u8 {
    let a: uint8x8_t = vdup_n_u8(a);
    let b: uint8x8_t = vdup_n_u8(b);
    unsafe { simd_extract!(vqsub_u8(a, b), 0) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubh_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqsub))]
pub fn vqsubh_u16(a: u16, b: u16) -> u16 {
    let a: uint16x4_t = vdup_n_u16(a);
    let b: uint16x4_t = vdup_n_u16(b);
    unsafe { simd_extract!(vqsub_u16(a, b), 0) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubs_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqsub))]
pub fn vqsubs_s32(a: i32, b: i32) -> i32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqsub.i32"
        )]
        fn _vqsubs_s32(a: i32, b: i32) -> i32;
    }
    unsafe { _vqsubs_s32(a, b) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubd_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(sqsub))]
pub fn vqsubd_s64(a: i64, b: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sqsub.i64"
        )]
        fn _vqsubd_s64(a: i64, b: i64) -> i64;
    }
    unsafe { _vqsubd_s64(a, b) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubs_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqsub))]
pub fn vqsubs_u32(a: u32, b: u32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqsub.i32"
        )]
        fn _vqsubs_u32(a: u32, b: u32) -> u32;
    }
    unsafe { _vqsubs_u32(a, b) }
}
#[doc = "Saturating subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqsubd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(uqsub))]
pub fn vqsubd_u64(a: u64, b: u64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uqsub.i64"
        )]
        fn _vqsubd_u64(a: u64, b: u64) -> u64;
    }
    unsafe { _vqsubd_u64(a, b) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl1(a: int8x16_t, b: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl1.v8i8"
        )]
        fn _vqtbl1(a: int8x16_t, b: uint8x8_t) -> int8x8_t;
    }
    unsafe { _vqtbl1(a, b) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl1q(a: int8x16_t, b: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl1.v16i8"
        )]
        fn _vqtbl1q(a: int8x16_t, b: uint8x16_t) -> int8x16_t;
    }
    unsafe { _vqtbl1q(a, b) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl1_s8(a: int8x16_t, b: uint8x8_t) -> int8x8_t {
    vqtbl1(a, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl1q_s8(a: int8x16_t, b: uint8x16_t) -> int8x16_t {
    vqtbl1q(a, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl1_u8(a: uint8x16_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vqtbl1(transmute(a), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1q_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl1q_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vqtbl1q(transmute(a), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl1_p8(a: poly8x16_t, b: uint8x8_t) -> poly8x8_t {
    unsafe { transmute(vqtbl1(transmute(a), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl1q_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl1q_p8(a: poly8x16_t, b: uint8x16_t) -> poly8x16_t {
    unsafe { transmute(vqtbl1q(transmute(a), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl2(a: int8x16_t, b: int8x16_t, c: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl2.v8i8"
        )]
        fn _vqtbl2(a: int8x16_t, b: int8x16_t, c: uint8x8_t) -> int8x8_t;
    }
    unsafe { _vqtbl2(a, b, c) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl2q(a: int8x16_t, b: int8x16_t, c: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl2.v16i8"
        )]
        fn _vqtbl2q(a: int8x16_t, b: int8x16_t, c: uint8x16_t) -> int8x16_t;
    }
    unsafe { _vqtbl2q(a, b, c) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2_s8(a: int8x16x2_t, b: uint8x8_t) -> int8x8_t {
    vqtbl2(a.0, a.1, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2q_s8(a: int8x16x2_t, b: uint8x16_t) -> int8x16_t {
    vqtbl2q(a.0, a.1, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2_u8(a: uint8x16x2_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vqtbl2(transmute(a.0), transmute(a.1), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2_u8(a: uint8x16x2_t, b: uint8x8_t) -> uint8x8_t {
    let mut a: uint8x16x2_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vqtbl2(transmute(a.0), transmute(a.1), b));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2q_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2q_u8(a: uint8x16x2_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vqtbl2q(transmute(a.0), transmute(a.1), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2q_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2q_u8(a: uint8x16x2_t, b: uint8x16_t) -> uint8x16_t {
    let mut a: uint8x16x2_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vqtbl2q(transmute(a.0), transmute(a.1), b));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2_p8(a: poly8x16x2_t, b: uint8x8_t) -> poly8x8_t {
    unsafe { transmute(vqtbl2(transmute(a.0), transmute(a.1), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2_p8(a: poly8x16x2_t, b: uint8x8_t) -> poly8x8_t {
    let mut a: poly8x16x2_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vqtbl2(transmute(a.0), transmute(a.1), b));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2q_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2q_p8(a: poly8x16x2_t, b: uint8x16_t) -> poly8x16_t {
    unsafe { transmute(vqtbl2q(transmute(a.0), transmute(a.1), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl2q_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl2q_p8(a: poly8x16x2_t, b: uint8x16_t) -> poly8x16_t {
    let mut a: poly8x16x2_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(vqtbl2q(transmute(a.0), transmute(a.1), b));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl3(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl3.v8i8"
        )]
        fn _vqtbl3(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: uint8x8_t) -> int8x8_t;
    }
    unsafe { _vqtbl3(a, b, c, d) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl3q(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl3.v16i8"
        )]
        fn _vqtbl3q(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: uint8x16_t) -> int8x16_t;
    }
    unsafe { _vqtbl3q(a, b, c, d) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3_s8(a: int8x16x3_t, b: uint8x8_t) -> int8x8_t {
    vqtbl3(a.0, a.1, a.2, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3q_s8(a: int8x16x3_t, b: uint8x16_t) -> int8x16_t {
    vqtbl3q(a.0, a.1, a.2, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3_u8(a: uint8x16x3_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vqtbl3(transmute(a.0), transmute(a.1), transmute(a.2), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3_u8(a: uint8x16x3_t, b: uint8x8_t) -> uint8x8_t {
    let mut a: uint8x16x3_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t =
            transmute(vqtbl3(transmute(a.0), transmute(a.1), transmute(a.2), b));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3q_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3q_u8(a: uint8x16x3_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vqtbl3q(transmute(a.0), transmute(a.1), transmute(a.2), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3q_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3q_u8(a: uint8x16x3_t, b: uint8x16_t) -> uint8x16_t {
    let mut a: uint8x16x3_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t =
            transmute(vqtbl3q(transmute(a.0), transmute(a.1), transmute(a.2), b));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3_p8(a: poly8x16x3_t, b: uint8x8_t) -> poly8x8_t {
    unsafe { transmute(vqtbl3(transmute(a.0), transmute(a.1), transmute(a.2), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3_p8(a: poly8x16x3_t, b: uint8x8_t) -> poly8x8_t {
    let mut a: poly8x16x3_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t =
            transmute(vqtbl3(transmute(a.0), transmute(a.1), transmute(a.2), b));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3q_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3q_p8(a: poly8x16x3_t, b: uint8x16_t) -> poly8x16_t {
    unsafe { transmute(vqtbl3q(transmute(a.0), transmute(a.1), transmute(a.2), b)) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl3q_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl3q_p8(a: poly8x16x3_t, b: uint8x16_t) -> poly8x16_t {
    let mut a: poly8x16x3_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t =
            transmute(vqtbl3q(transmute(a.0), transmute(a.1), transmute(a.2), b));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl4(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: int8x16_t, e: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl4.v8i8"
        )]
        fn _vqtbl4(
            a: int8x16_t,
            b: int8x16_t,
            c: int8x16_t,
            d: int8x16_t,
            e: uint8x8_t,
        ) -> int8x8_t;
    }
    unsafe { _vqtbl4(a, b, c, d, e) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbl4q(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: int8x16_t, e: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbl4.v16i8"
        )]
        fn _vqtbl4q(
            a: int8x16_t,
            b: int8x16_t,
            c: int8x16_t,
            d: int8x16_t,
            e: uint8x16_t,
        ) -> int8x16_t;
    }
    unsafe { _vqtbl4q(a, b, c, d, e) }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4_s8(a: int8x16x4_t, b: uint8x8_t) -> int8x8_t {
    vqtbl4(a.0, a.1, a.2, a.3, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4q_s8(a: int8x16x4_t, b: uint8x16_t) -> int8x16_t {
    vqtbl4q(a.0, a.1, a.2, a.3, b)
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4_u8(a: uint8x16x4_t, b: uint8x8_t) -> uint8x8_t {
    unsafe {
        transmute(vqtbl4(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ))
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4_u8(a: uint8x16x4_t, b: uint8x8_t) -> uint8x8_t {
    let mut a: uint8x16x4_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.3 = unsafe {
        simd_shuffle!(
            a.3,
            a.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vqtbl4(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4q_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4q_u8(a: uint8x16x4_t, b: uint8x16_t) -> uint8x16_t {
    unsafe {
        transmute(vqtbl4q(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ))
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4q_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4q_u8(a: uint8x16x4_t, b: uint8x16_t) -> uint8x16_t {
    let mut a: uint8x16x4_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.3 = unsafe {
        simd_shuffle!(
            a.3,
            a.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vqtbl4q(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4_p8(a: poly8x16x4_t, b: uint8x8_t) -> poly8x8_t {
    unsafe {
        transmute(vqtbl4(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ))
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4_p8(a: poly8x16x4_t, b: uint8x8_t) -> poly8x8_t {
    let mut a: poly8x16x4_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.3 = unsafe {
        simd_shuffle!(
            a.3,
            a.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vqtbl4(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4q_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4q_p8(a: poly8x16x4_t, b: uint8x16_t) -> poly8x16_t {
    unsafe {
        transmute(vqtbl4q(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ))
    }
}
#[doc = "Table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbl4q_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbl4q_p8(a: poly8x16x4_t, b: uint8x16_t) -> poly8x16_t {
    let mut a: poly8x16x4_t = a;
    a.0 = unsafe {
        simd_shuffle!(
            a.0,
            a.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.1 = unsafe {
        simd_shuffle!(
            a.1,
            a.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.2 = unsafe {
        simd_shuffle!(
            a.2,
            a.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    a.3 = unsafe {
        simd_shuffle!(
            a.3,
            a.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(vqtbl4q(
            transmute(a.0),
            transmute(a.1),
            transmute(a.2),
            transmute(a.3),
            b,
        ));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx1(a: int8x8_t, b: int8x16_t, c: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx1.v8i8"
        )]
        fn _vqtbx1(a: int8x8_t, b: int8x16_t, c: uint8x8_t) -> int8x8_t;
    }
    unsafe { _vqtbx1(a, b, c) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx1q(a: int8x16_t, b: int8x16_t, c: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx1.v16i8"
        )]
        fn _vqtbx1q(a: int8x16_t, b: int8x16_t, c: uint8x16_t) -> int8x16_t;
    }
    unsafe { _vqtbx1q(a, b, c) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx1_s8(a: int8x8_t, b: int8x16_t, c: uint8x8_t) -> int8x8_t {
    vqtbx1(a, b, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx1q_s8(a: int8x16_t, b: int8x16_t, c: uint8x16_t) -> int8x16_t {
    vqtbx1q(a, b, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx1_u8(a: uint8x8_t, b: uint8x16_t, c: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vqtbx1(transmute(a), transmute(b), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1q_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx1q_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vqtbx1q(transmute(a), transmute(b), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx1_p8(a: poly8x8_t, b: poly8x16_t, c: uint8x8_t) -> poly8x8_t {
    unsafe { transmute(vqtbx1(transmute(a), transmute(b), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx1q_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx1q_p8(a: poly8x16_t, b: poly8x16_t, c: uint8x16_t) -> poly8x16_t {
    unsafe { transmute(vqtbx1q(transmute(a), transmute(b), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx2(a: int8x8_t, b: int8x16_t, c: int8x16_t, d: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx2.v8i8"
        )]
        fn _vqtbx2(a: int8x8_t, b: int8x16_t, c: int8x16_t, d: uint8x8_t) -> int8x8_t;
    }
    unsafe { _vqtbx2(a, b, c, d) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx2q(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx2.v16i8"
        )]
        fn _vqtbx2q(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: uint8x16_t) -> int8x16_t;
    }
    unsafe { _vqtbx2q(a, b, c, d) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2_s8(a: int8x8_t, b: int8x16x2_t, c: uint8x8_t) -> int8x8_t {
    vqtbx2(a, b.0, b.1, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2q_s8(a: int8x16_t, b: int8x16x2_t, c: uint8x16_t) -> int8x16_t {
    vqtbx2q(a, b.0, b.1, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2_u8(a: uint8x8_t, b: uint8x16x2_t, c: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vqtbx2(transmute(a), transmute(b.0), transmute(b.1), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2_u8(a: uint8x8_t, b: uint8x16x2_t, c: uint8x8_t) -> uint8x8_t {
    let mut b: uint8x16x2_t = b;
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vqtbx2(transmute(a), transmute(b.0), transmute(b.1), c));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2q_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2q_u8(a: uint8x16_t, b: uint8x16x2_t, c: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vqtbx2q(transmute(a), transmute(b.0), transmute(b.1), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2q_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2q_u8(a: uint8x16_t, b: uint8x16x2_t, c: uint8x16_t) -> uint8x16_t {
    let mut b: uint8x16x2_t = b;
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x16_t =
        unsafe { simd_shuffle!(c, c, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t =
            transmute(vqtbx2q(transmute(a), transmute(b.0), transmute(b.1), c));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2_p8(a: poly8x8_t, b: poly8x16x2_t, c: uint8x8_t) -> poly8x8_t {
    unsafe { transmute(vqtbx2(transmute(a), transmute(b.0), transmute(b.1), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2_p8(a: poly8x8_t, b: poly8x16x2_t, c: uint8x8_t) -> poly8x8_t {
    let mut b: poly8x16x2_t = b;
    let a: poly8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vqtbx2(transmute(a), transmute(b.0), transmute(b.1), c));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2q_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2q_p8(a: poly8x16_t, b: poly8x16x2_t, c: uint8x16_t) -> poly8x16_t {
    unsafe { transmute(vqtbx2q(transmute(a), transmute(b.0), transmute(b.1), c)) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx2q_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx2q_p8(a: poly8x16_t, b: poly8x16x2_t, c: uint8x16_t) -> poly8x16_t {
    let mut b: poly8x16x2_t = b;
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x16_t =
        unsafe { simd_shuffle!(c, c, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t =
            transmute(vqtbx2q(transmute(a), transmute(b.0), transmute(b.1), c));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx3(a: int8x8_t, b: int8x16_t, c: int8x16_t, d: int8x16_t, e: uint8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx3.v8i8"
        )]
        fn _vqtbx3(a: int8x8_t, b: int8x16_t, c: int8x16_t, d: int8x16_t, e: uint8x8_t)
            -> int8x8_t;
    }
    unsafe { _vqtbx3(a, b, c, d, e) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx3q(a: int8x16_t, b: int8x16_t, c: int8x16_t, d: int8x16_t, e: uint8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx3.v16i8"
        )]
        fn _vqtbx3q(
            a: int8x16_t,
            b: int8x16_t,
            c: int8x16_t,
            d: int8x16_t,
            e: uint8x16_t,
        ) -> int8x16_t;
    }
    unsafe { _vqtbx3q(a, b, c, d, e) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3_s8(a: int8x8_t, b: int8x16x3_t, c: uint8x8_t) -> int8x8_t {
    vqtbx3(a, b.0, b.1, b.2, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3q_s8(a: int8x16_t, b: int8x16x3_t, c: uint8x16_t) -> int8x16_t {
    vqtbx3q(a, b.0, b.1, b.2, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3_u8(a: uint8x8_t, b: uint8x16x3_t, c: uint8x8_t) -> uint8x8_t {
    unsafe {
        transmute(vqtbx3(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3_u8(a: uint8x8_t, b: uint8x16x3_t, c: uint8x8_t) -> uint8x8_t {
    let mut b: uint8x16x3_t = b;
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vqtbx3(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3q_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3q_u8(a: uint8x16_t, b: uint8x16x3_t, c: uint8x16_t) -> uint8x16_t {
    unsafe {
        transmute(vqtbx3q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3q_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3q_u8(a: uint8x16_t, b: uint8x16x3_t, c: uint8x16_t) -> uint8x16_t {
    let mut b: uint8x16x3_t = b;
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x16_t =
        unsafe { simd_shuffle!(c, c, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vqtbx3q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3_p8(a: poly8x8_t, b: poly8x16x3_t, c: uint8x8_t) -> poly8x8_t {
    unsafe {
        transmute(vqtbx3(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3_p8(a: poly8x8_t, b: poly8x16x3_t, c: uint8x8_t) -> poly8x8_t {
    let mut b: poly8x16x3_t = b;
    let a: poly8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vqtbx3(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3q_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3q_p8(a: poly8x16_t, b: poly8x16x3_t, c: uint8x16_t) -> poly8x16_t {
    unsafe {
        transmute(vqtbx3q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx3q_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx3q_p8(a: poly8x16_t, b: poly8x16x3_t, c: uint8x16_t) -> poly8x16_t {
    let mut b: poly8x16x3_t = b;
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x16_t =
        unsafe { simd_shuffle!(c, c, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(vqtbx3q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            c,
        ));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx4(
    a: int8x8_t,
    b: int8x16_t,
    c: int8x16_t,
    d: int8x16_t,
    e: int8x16_t,
    f: uint8x8_t,
) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx4.v8i8"
        )]
        fn _vqtbx4(
            a: int8x8_t,
            b: int8x16_t,
            c: int8x16_t,
            d: int8x16_t,
            e: int8x16_t,
            f: uint8x8_t,
        ) -> int8x8_t;
    }
    unsafe { _vqtbx4(a, b, c, d, e, f) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4q)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
fn vqtbx4q(
    a: int8x16_t,
    b: int8x16_t,
    c: int8x16_t,
    d: int8x16_t,
    e: int8x16_t,
    f: uint8x16_t,
) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.tbx4.v16i8"
        )]
        fn _vqtbx4q(
            a: int8x16_t,
            b: int8x16_t,
            c: int8x16_t,
            d: int8x16_t,
            e: int8x16_t,
            f: uint8x16_t,
        ) -> int8x16_t;
    }
    unsafe { _vqtbx4q(a, b, c, d, e, f) }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4_s8(a: int8x8_t, b: int8x16x4_t, c: uint8x8_t) -> int8x8_t {
    vqtbx4(a, b.0, b.1, b.2, b.3, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4q_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4q_s8(a: int8x16_t, b: int8x16x4_t, c: uint8x16_t) -> int8x16_t {
    vqtbx4q(a, b.0, b.1, b.2, b.3, c)
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4_u8(a: uint8x8_t, b: uint8x16x4_t, c: uint8x8_t) -> uint8x8_t {
    unsafe {
        transmute(vqtbx4(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4_u8(a: uint8x8_t, b: uint8x16x4_t, c: uint8x8_t) -> uint8x8_t {
    let mut b: uint8x16x4_t = b;
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.3 = unsafe {
        simd_shuffle!(
            b.3,
            b.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vqtbx4(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4q_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4q_u8(a: uint8x16_t, b: uint8x16x4_t, c: uint8x16_t) -> uint8x16_t {
    unsafe {
        transmute(vqtbx4q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4q_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4q_u8(a: uint8x16_t, b: uint8x16x4_t, c: uint8x16_t) -> uint8x16_t {
    let mut b: uint8x16x4_t = b;
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.3 = unsafe {
        simd_shuffle!(
            b.3,
            b.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x16_t =
        unsafe { simd_shuffle!(c, c, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vqtbx4q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4_p8(a: poly8x8_t, b: poly8x16x4_t, c: uint8x8_t) -> poly8x8_t {
    unsafe {
        transmute(vqtbx4(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4_p8(a: poly8x8_t, b: poly8x16x4_t, c: uint8x8_t) -> poly8x8_t {
    let mut b: poly8x16x4_t = b;
    let a: poly8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.3 = unsafe {
        simd_shuffle!(
            b.3,
            b.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vqtbx4(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4q_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4q_p8(a: poly8x16_t, b: poly8x16x4_t, c: uint8x16_t) -> poly8x16_t {
    unsafe {
        transmute(vqtbx4q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ))
    }
}
#[doc = "Extended table look-up"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vqtbx4q_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(tbx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vqtbx4q_p8(a: poly8x16_t, b: poly8x16x4_t, c: uint8x16_t) -> poly8x16_t {
    let mut b: poly8x16x4_t = b;
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    b.0 = unsafe {
        simd_shuffle!(
            b.0,
            b.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.1 = unsafe {
        simd_shuffle!(
            b.1,
            b.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.2 = unsafe {
        simd_shuffle!(
            b.2,
            b.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    b.3 = unsafe {
        simd_shuffle!(
            b.3,
            b.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    let c: uint8x16_t =
        unsafe { simd_shuffle!(c, c, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(vqtbx4q(
            transmute(a),
            transmute(b.0),
            transmute(b.1),
            transmute(b.2),
            transmute(b.3),
            c,
        ));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Rotate and exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrax1q_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[cfg_attr(test, assert_instr(rax1))]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
pub fn vrax1q_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.rax1"
        )]
        fn _vrax1q_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _vrax1q_u64(a, b) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbit_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbit_s8(a: int8x8_t) -> int8x8_t {
    unsafe { simd_bitreverse(a) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbitq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbitq_s8(a: int8x16_t) -> int8x16_t {
    unsafe { simd_bitreverse(a) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbit_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbit_u8(a: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vrbit_s8(transmute(a))) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbit_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbit_u8(a: uint8x8_t) -> uint8x8_t {
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vrbit_s8(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbitq_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbitq_u8(a: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vrbitq_s8(transmute(a))) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbitq_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbitq_u8(a: uint8x16_t) -> uint8x16_t {
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vrbitq_s8(transmute(a)));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbit_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbit_p8(a: poly8x8_t) -> poly8x8_t {
    unsafe { transmute(vrbit_s8(transmute(a))) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbit_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbit_p8(a: poly8x8_t) -> poly8x8_t {
    let a: poly8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vrbit_s8(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbitq_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbitq_p8(a: poly8x16_t) -> poly8x16_t {
    unsafe { transmute(vrbitq_s8(transmute(a))) }
}
#[doc = "Reverse bit order"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrbitq_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(rbit))]
pub fn vrbitq_p8(a: poly8x16_t) -> poly8x16_t {
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(vrbitq_s8(transmute(a)));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Reciprocal estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpe_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecpe))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpe_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpe.v1f64"
        )]
        fn _vrecpe_f64(a: float64x1_t) -> float64x1_t;
    }
    unsafe { _vrecpe_f64(a) }
}
#[doc = "Reciprocal estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpeq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecpe))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpeq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpe.v2f64"
        )]
        fn _vrecpeq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrecpeq_f64(a) }
}
#[doc = "Reciprocal estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecped_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecpe))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecped_f64(a: f64) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpe.f64"
        )]
        fn _vrecped_f64(a: f64) -> f64;
    }
    unsafe { _vrecped_f64(a) }
}
#[doc = "Reciprocal estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpes_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecpe))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpes_f32(a: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpe.f32"
        )]
        fn _vrecpes_f32(a: f32) -> f32;
    }
    unsafe { _vrecpes_f32(a) }
}
#[doc = "Reciprocal estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpeh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(frecpe))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vrecpeh_f16(a: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpe.f16"
        )]
        fn _vrecpeh_f16(a: f16) -> f16;
    }
    unsafe { _vrecpeh_f16(a) }
}
#[doc = "Floating-point reciprocal step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecps_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecps_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecps.v1f64"
        )]
        fn _vrecps_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t;
    }
    unsafe { _vrecps_f64(a, b) }
}
#[doc = "Floating-point reciprocal step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpsq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpsq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecps.v2f64"
        )]
        fn _vrecpsq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrecpsq_f64(a, b) }
}
#[doc = "Floating-point reciprocal step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpsd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpsd_f64(a: f64, b: f64) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecps.f64"
        )]
        fn _vrecpsd_f64(a: f64, b: f64) -> f64;
    }
    unsafe { _vrecpsd_f64(a, b) }
}
#[doc = "Floating-point reciprocal step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpss_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecps))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpss_f32(a: f32, b: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecps.f32"
        )]
        fn _vrecpss_f32(a: f32, b: f32) -> f32;
    }
    unsafe { _vrecpss_f32(a, b) }
}
#[doc = "Floating-point reciprocal step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpsh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(frecps))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vrecpsh_f16(a: f16, b: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecps.f16"
        )]
        fn _vrecpsh_f16(a: f16, b: f16) -> f16;
    }
    unsafe { _vrecpsh_f16(a, b) }
}
#[doc = "Floating-point reciprocal exponent"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpxd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecpx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpxd_f64(a: f64) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpx.f64"
        )]
        fn _vrecpxd_f64(a: f64) -> f64;
    }
    unsafe { _vrecpxd_f64(a) }
}
#[doc = "Floating-point reciprocal exponent"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpxs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frecpx))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrecpxs_f32(a: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpx.f32"
        )]
        fn _vrecpxs_f32(a: f32) -> f32;
    }
    unsafe { _vrecpxs_f32(a) }
}
#[doc = "Floating-point reciprocal exponent"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrecpxh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(frecpx))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vrecpxh_f16(a: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frecpx.f16"
        )]
        fn _vrecpxh_f16(a: f16) -> f16;
    }
    unsafe { _vrecpxh_f16(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_f16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_f16(a: float16x4_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_f16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_f16(a: float16x4_t) -> float64x1_t {
    let a: float16x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_f16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_f16(a: float16x8_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_f16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_f16(a: float16x8_t) -> float64x2_t {
    let a: float16x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f16_f64(a: float64x1_t) -> float16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f16_f64(a: float64x1_t) -> float16x4_t {
    unsafe {
        let ret_val: float16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f16_f64(a: float64x2_t) -> float16x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f16_f64(a: float64x2_t) -> float16x8_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: float16x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p128)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p128(a: p128) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p128)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p128(a: p128) -> float64x2_t {
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_f32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_f32(a: float32x2_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_f32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_f32(a: float32x2_t) -> float64x1_t {
    let a: float32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p64_f32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p64_f32(a: float32x2_t) -> poly64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p64_f32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p64_f32(a: float32x2_t) -> poly64x1_t {
    let a: float32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_f32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_f32(a: float32x4_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_f32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_f32(a: float32x4_t) -> float64x2_t {
    let a: float32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_f32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_f32(a: float32x4_t) -> poly64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_f32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_f32(a: float32x4_t) -> poly64x2_t {
    let a: float32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f32_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f32_f64(a: float64x1_t) -> float32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f32_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f32_f64(a: float64x1_t) -> float32x2_t {
    unsafe {
        let ret_val: float32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s8_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s8_f64(a: float64x1_t) -> int8x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s8_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s8_f64(a: float64x1_t) -> int8x8_t {
    unsafe {
        let ret_val: int8x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s16_f64(a: float64x1_t) -> int16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s16_f64(a: float64x1_t) -> int16x4_t {
    unsafe {
        let ret_val: int16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s32_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s32_f64(a: float64x1_t) -> int32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s32_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s32_f64(a: float64x1_t) -> int32x2_t {
    unsafe {
        let ret_val: int32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s64_f64(a: float64x1_t) -> int64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u8_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u8_f64(a: float64x1_t) -> uint8x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u8_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u8_f64(a: float64x1_t) -> uint8x8_t {
    unsafe {
        let ret_val: uint8x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u16_f64(a: float64x1_t) -> uint16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u16_f64(a: float64x1_t) -> uint16x4_t {
    unsafe {
        let ret_val: uint16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u32_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u32_f64(a: float64x1_t) -> uint32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u32_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u32_f64(a: float64x1_t) -> uint32x2_t {
    unsafe {
        let ret_val: uint32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u64_f64(a: float64x1_t) -> uint64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p8_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p8_f64(a: float64x1_t) -> poly8x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p8_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p8_f64(a: float64x1_t) -> poly8x8_t {
    unsafe {
        let ret_val: poly8x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p16_f64(a: float64x1_t) -> poly16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p16_f64(a: float64x1_t) -> poly16x4_t {
    unsafe {
        let ret_val: poly16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p64_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p64_f64(a: float64x1_t) -> poly64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p128_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p128_f64(a: float64x2_t) -> p128 {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p128_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p128_f64(a: float64x2_t) -> p128 {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f32_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f32_f64(a: float64x2_t) -> float32x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f32_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f32_f64(a: float64x2_t) -> float32x4_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: float32x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s8_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s8_f64(a: float64x2_t) -> int8x16_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s8_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s8_f64(a: float64x2_t) -> int8x16_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: int8x16_t = transmute(a);
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s16_f64(a: float64x2_t) -> int16x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s16_f64(a: float64x2_t) -> int16x8_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: int16x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s32_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s32_f64(a: float64x2_t) -> int32x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s32_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s32_f64(a: float64x2_t) -> int32x4_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: int32x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s64_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s64_f64(a: float64x2_t) -> int64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s64_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s64_f64(a: float64x2_t) -> int64x2_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: int64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u8_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u8_f64(a: float64x2_t) -> uint8x16_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u8_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u8_f64(a: float64x2_t) -> uint8x16_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(a);
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u16_f64(a: float64x2_t) -> uint16x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u16_f64(a: float64x2_t) -> uint16x8_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: uint16x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u32_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u32_f64(a: float64x2_t) -> uint32x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u32_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u32_f64(a: float64x2_t) -> uint32x4_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: uint32x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u64_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u64_f64(a: float64x2_t) -> uint64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u64_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u64_f64(a: float64x2_t) -> uint64x2_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: uint64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p8_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p8_f64(a: float64x2_t) -> poly8x16_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p8_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p8_f64(a: float64x2_t) -> poly8x16_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(a);
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p16_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p16_f64(a: float64x2_t) -> poly16x8_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p16_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p16_f64(a: float64x2_t) -> poly16x8_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: poly16x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_f64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_f64(a: float64x2_t) -> poly64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_f64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_f64(a: float64x2_t) -> poly64x2_t {
    let a: float64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: poly64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s8(a: int8x8_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s8(a: int8x8_t) -> float64x1_t {
    let a: int8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s8(a: int8x16_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s8(a: int8x16_t) -> float64x2_t {
    let a: int8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s16(a: int16x4_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s16(a: int16x4_t) -> float64x1_t {
    let a: int16x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s16(a: int16x8_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s16(a: int16x8_t) -> float64x2_t {
    let a: int16x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s32(a: int32x2_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s32(a: int32x2_t) -> float64x1_t {
    let a: int32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s32(a: int32x4_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s32(a: int32x4_t) -> float64x2_t {
    let a: int32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_s64(a: int64x1_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p64_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p64_s64(a: int64x1_t) -> poly64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s64(a: int64x2_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_s64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_s64(a: int64x2_t) -> float64x2_t {
    let a: int64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_s64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_s64(a: int64x2_t) -> poly64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_s64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_s64(a: int64x2_t) -> poly64x2_t {
    let a: int64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: poly64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u8(a: uint8x8_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u8(a: uint8x8_t) -> float64x1_t {
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u8(a: uint8x16_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u8(a: uint8x16_t) -> float64x2_t {
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u16(a: uint16x4_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u16(a: uint16x4_t) -> float64x1_t {
    let a: uint16x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u16(a: uint16x8_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u16(a: uint16x8_t) -> float64x2_t {
    let a: uint16x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u32(a: uint32x2_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u32(a: uint32x2_t) -> float64x1_t {
    let a: uint32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u32(a: uint32x4_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u32(a: uint32x4_t) -> float64x2_t {
    let a: uint32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_u64(a: uint64x1_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_p64_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_p64_u64(a: uint64x1_t) -> poly64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u64(a: uint64x2_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_u64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_u64(a: uint64x2_t) -> float64x2_t {
    let a: uint64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_u64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_u64(a: uint64x2_t) -> poly64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_p64_u64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_p64_u64(a: uint64x2_t) -> poly64x2_t {
    let a: uint64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: poly64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_p8(a: poly8x8_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_p8(a: poly8x8_t) -> float64x1_t {
    let a: poly8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p8(a: poly8x16_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p8(a: poly8x16_t) -> float64x2_t {
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_p16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_p16(a: poly16x4_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_p16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_p16(a: poly16x4_t) -> float64x1_t {
    let a: poly16x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p16(a: poly16x8_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p16(a: poly16x8_t) -> float64x2_t {
    let a: poly16x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f32_p64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f32_p64(a: poly64x1_t) -> float32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f32_p64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f32_p64(a: poly64x1_t) -> float32x2_t {
    unsafe {
        let ret_val: float32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_f64_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_f64_p64(a: poly64x1_t) -> float64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_s64_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_s64_p64(a: poly64x1_t) -> int64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpret_u64_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpret_u64_p64(a: poly64x1_t) -> uint64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f32_p64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f32_p64(a: poly64x2_t) -> float32x4_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f32_p64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f32_p64(a: poly64x2_t) -> float32x4_t {
    let a: poly64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: float32x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p64(a: poly64x2_t) -> float64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_f64_p64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_f64_p64(a: poly64x2_t) -> float64x2_t {
    let a: poly64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: float64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s64_p64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s64_p64(a: poly64x2_t) -> int64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_s64_p64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_s64_p64(a: poly64x2_t) -> int64x2_t {
    let a: poly64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: int64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u64_p64)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u64_p64(a: poly64x2_t) -> uint64x2_t {
    unsafe { transmute(a) }
}
#[doc = "Vector reinterpret cast operation"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vreinterpretq_u64_p64)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub fn vreinterpretq_u64_p64(a: poly64x2_t) -> uint64x2_t {
    let a: poly64x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: uint64x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Floating-point round to 32-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32x_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32x))]
pub fn vrnd32x_f32(a: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint32x.v2f32"
        )]
        fn _vrnd32x_f32(a: float32x2_t) -> float32x2_t;
    }
    unsafe { _vrnd32x_f32(a) }
}
#[doc = "Floating-point round to 32-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32xq_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32x))]
pub fn vrnd32xq_f32(a: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint32x.v4f32"
        )]
        fn _vrnd32xq_f32(a: float32x4_t) -> float32x4_t;
    }
    unsafe { _vrnd32xq_f32(a) }
}
#[doc = "Floating-point round to 32-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32xq_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32x))]
pub fn vrnd32xq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint32x.v2f64"
        )]
        fn _vrnd32xq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrnd32xq_f64(a) }
}
#[doc = "Floating-point round to 32-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32x_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32x))]
pub fn vrnd32x_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.frint32x.f64"
        )]
        fn _vrnd32x_f64(a: f64) -> f64;
    }
    unsafe { transmute(_vrnd32x_f64(simd_extract!(a, 0))) }
}
#[doc = "Floating-point round to 32-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32z_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32z))]
pub fn vrnd32z_f32(a: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint32z.v2f32"
        )]
        fn _vrnd32z_f32(a: float32x2_t) -> float32x2_t;
    }
    unsafe { _vrnd32z_f32(a) }
}
#[doc = "Floating-point round to 32-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32zq_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32z))]
pub fn vrnd32zq_f32(a: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint32z.v4f32"
        )]
        fn _vrnd32zq_f32(a: float32x4_t) -> float32x4_t;
    }
    unsafe { _vrnd32zq_f32(a) }
}
#[doc = "Floating-point round to 32-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32zq_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32z))]
pub fn vrnd32zq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint32z.v2f64"
        )]
        fn _vrnd32zq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrnd32zq_f64(a) }
}
#[doc = "Floating-point round to 32-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd32z_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint32z))]
pub fn vrnd32z_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.frint32z.f64"
        )]
        fn _vrnd32z_f64(a: f64) -> f64;
    }
    unsafe { transmute(_vrnd32z_f64(simd_extract!(a, 0))) }
}
#[doc = "Floating-point round to 64-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64x_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64x))]
pub fn vrnd64x_f32(a: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint64x.v2f32"
        )]
        fn _vrnd64x_f32(a: float32x2_t) -> float32x2_t;
    }
    unsafe { _vrnd64x_f32(a) }
}
#[doc = "Floating-point round to 64-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64xq_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64x))]
pub fn vrnd64xq_f32(a: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint64x.v4f32"
        )]
        fn _vrnd64xq_f32(a: float32x4_t) -> float32x4_t;
    }
    unsafe { _vrnd64xq_f32(a) }
}
#[doc = "Floating-point round to 64-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64xq_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64x))]
pub fn vrnd64xq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint64x.v2f64"
        )]
        fn _vrnd64xq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrnd64xq_f64(a) }
}
#[doc = "Floating-point round to 64-bit integer, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64x_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64x))]
pub fn vrnd64x_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.frint64x.f64"
        )]
        fn _vrnd64x_f64(a: f64) -> f64;
    }
    unsafe { transmute(_vrnd64x_f64(simd_extract!(a, 0))) }
}
#[doc = "Floating-point round to 64-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64z_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64z))]
pub fn vrnd64z_f32(a: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint64z.v2f32"
        )]
        fn _vrnd64z_f32(a: float32x2_t) -> float32x2_t;
    }
    unsafe { _vrnd64z_f32(a) }
}
#[doc = "Floating-point round to 64-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64zq_f32)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64z))]
pub fn vrnd64zq_f32(a: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint64z.v4f32"
        )]
        fn _vrnd64zq_f32(a: float32x4_t) -> float32x4_t;
    }
    unsafe { _vrnd64zq_f32(a) }
}
#[doc = "Floating-point round to 64-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64zq_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64z))]
pub fn vrnd64zq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frint64z.v2f64"
        )]
        fn _vrnd64zq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrnd64zq_f64(a) }
}
#[doc = "Floating-point round to 64-bit integer toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd64z_f64)"]
#[inline]
#[target_feature(enable = "neon,frintts")]
#[unstable(feature = "stdarch_neon_ftts", issue = "117227")]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(frint64z))]
pub fn vrnd64z_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.frint64z.f64"
        )]
        fn _vrnd64z_f64(a: f64) -> f64;
    }
    unsafe { transmute(_vrnd64z_f64(simd_extract!(a, 0))) }
}
#[doc = "Floating-point round to integral, toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrnd_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_trunc(a) }
}
#[doc = "Floating-point round to integral, toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrndq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_trunc(a) }
}
#[doc = "Floating-point round to integral, toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrnd_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_trunc(a) }
}
#[doc = "Floating-point round to integral, toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrndq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_trunc(a) }
}
#[doc = "Floating-point round to integral, toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrnd_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_trunc(a) }
}
#[doc = "Floating-point round to integral, toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrndq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_trunc(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnda_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrnda_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_round(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndaq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrndaq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_round(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnda_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrnda_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_round(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndaq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrndaq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_round(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrnda_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrnda_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_round(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndaq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrndaq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_round(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndah_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frinta))]
pub fn vrndah_f16(a: f16) -> f16 {
    unsafe { roundf16(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to away"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintz))]
pub fn vrndh_f16(a: f16) -> f16 {
    unsafe { truncf16(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndi_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndi_f16(a: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.v4f16"
        )]
        fn _vrndi_f16(a: float16x4_t) -> float16x4_t;
    }
    unsafe { _vrndi_f16(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndiq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndiq_f16(a: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.v8f16"
        )]
        fn _vrndiq_f16(a: float16x8_t) -> float16x8_t;
    }
    unsafe { _vrndiq_f16(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndi_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndi_f32(a: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.v2f32"
        )]
        fn _vrndi_f32(a: float32x2_t) -> float32x2_t;
    }
    unsafe { _vrndi_f32(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndiq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndiq_f32(a: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.v4f32"
        )]
        fn _vrndiq_f32(a: float32x4_t) -> float32x4_t;
    }
    unsafe { _vrndiq_f32(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndi_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndi_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.v1f64"
        )]
        fn _vrndi_f64(a: float64x1_t) -> float64x1_t;
    }
    unsafe { _vrndi_f64(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndiq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndiq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.v2f64"
        )]
        fn _vrndiq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrndiq_f64(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndih_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frinti))]
pub fn vrndih_f16(a: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.nearbyint.f16"
        )]
        fn _vrndih_f16(a: f16) -> f16;
    }
    unsafe { _vrndih_f16(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndm_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndm_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_floor(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndmq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndmq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_floor(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndm_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndm_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_floor(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndmq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndmq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_floor(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndm_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndm_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_floor(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndmq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndmq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_floor(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndmh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintm))]
pub fn vrndmh_f16(a: f16) -> f16 {
    unsafe { floorf16(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndn_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintn))]
pub fn vrndn_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.roundeven.v1f64"
        )]
        fn _vrndn_f64(a: float64x1_t) -> float64x1_t;
    }
    unsafe { _vrndn_f64(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndnq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintn))]
pub fn vrndnq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.roundeven.v2f64"
        )]
        fn _vrndnq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrndnq_f64(a) }
}
#[doc = "Floating-point round to integral, toward minus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndnh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintn))]
pub fn vrndnh_f16(a: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.roundeven.f16"
        )]
        fn _vrndnh_f16(a: f16) -> f16;
    }
    unsafe { _vrndnh_f16(a) }
}
#[doc = "Floating-point round to integral, to nearest with ties to even"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndns_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintn))]
pub fn vrndns_f32(a: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.roundeven.f32"
        )]
        fn _vrndns_f32(a: f32) -> f32;
    }
    unsafe { _vrndns_f32(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndp_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndp_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_ceil(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndpq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndpq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_ceil(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndp_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndp_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_ceil(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndpq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndpq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_ceil(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndp_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndp_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_ceil(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndpq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndpq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_ceil(a) }
}
#[doc = "Floating-point round to integral, toward plus infinity"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndph_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintp))]
pub fn vrndph_f16(a: f16) -> f16 {
    unsafe { ceilf16(a) }
}
#[doc = "Floating-point round to integral exact, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndx_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndx_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_round_ties_even(a) }
}
#[doc = "Floating-point round to integral exact, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndxq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndxq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_round_ties_even(a) }
}
#[doc = "Floating-point round to integral exact, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndx_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndx_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_round_ties_even(a) }
}
#[doc = "Floating-point round to integral exact, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndxq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndxq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_round_ties_even(a) }
}
#[doc = "Floating-point round to integral exact, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndx_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndx_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_round_ties_even(a) }
}
#[doc = "Floating-point round to integral exact, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndxq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndxq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_round_ties_even(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrndxh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(frintx))]
pub fn vrndxh_f16(a: f16) -> f16 {
    round_ties_even_f16(a)
}
#[doc = "Signed rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshld_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(srshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshld_s64(a: i64, b: i64) -> i64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.srshl.i64"
        )]
        fn _vrshld_s64(a: i64, b: i64) -> i64;
    }
    unsafe { _vrshld_s64(a, b) }
}
#[doc = "Unsigned rounding shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshld_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(urshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshld_u64(a: u64, b: i64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.urshl.i64"
        )]
        fn _vrshld_u64(a: u64, b: i64) -> u64;
    }
    unsafe { _vrshld_u64(a, b) }
}
#[doc = "Signed rounding shift right"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrd_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(srshr, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrd_n_s64<const N: i32>(a: i64) -> i64 {
    static_assert!(N >= 1 && N <= 64);
    vrshld_s64(a, -N as i64)
}
#[doc = "Unsigned rounding shift right"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrd_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(urshr, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrd_n_u64<const N: i32>(a: u64) -> u64 {
    static_assert!(N >= 1 && N <= 64);
    vrshld_u64(a, -N as i64)
}
#[doc = "Rounding shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrn_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(rshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrn_high_n_s16<const N: i32>(a: int8x8_t, b: int16x8_t) -> int8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vrshrn_n_s16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Rounding shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrn_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(rshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrn_high_n_s32<const N: i32>(a: int16x4_t, b: int32x4_t) -> int16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vrshrn_n_s32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Rounding shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrn_high_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(rshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrn_high_n_s64<const N: i32>(a: int32x2_t, b: int64x2_t) -> int32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vrshrn_n_s64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Rounding shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrn_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(rshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrn_high_n_u16<const N: i32>(a: uint8x8_t, b: uint16x8_t) -> uint8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vrshrn_n_u16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Rounding shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrn_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(rshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrn_high_n_u32<const N: i32>(a: uint16x4_t, b: uint32x4_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vrshrn_n_u32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Rounding shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrshrn_high_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(rshrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrshrn_high_n_u64<const N: i32>(a: uint32x2_t, b: uint64x2_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vrshrn_n_u64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Reciprocal square-root estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrte_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrte))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrte_f64(a: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrte.v1f64"
        )]
        fn _vrsqrte_f64(a: float64x1_t) -> float64x1_t;
    }
    unsafe { _vrsqrte_f64(a) }
}
#[doc = "Reciprocal square-root estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrteq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrte))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrteq_f64(a: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrte.v2f64"
        )]
        fn _vrsqrteq_f64(a: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrsqrteq_f64(a) }
}
#[doc = "Reciprocal square-root estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrted_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrte))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrted_f64(a: f64) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrte.f64"
        )]
        fn _vrsqrted_f64(a: f64) -> f64;
    }
    unsafe { _vrsqrted_f64(a) }
}
#[doc = "Reciprocal square-root estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrtes_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrte))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrtes_f32(a: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrte.f32"
        )]
        fn _vrsqrtes_f32(a: f32) -> f32;
    }
    unsafe { _vrsqrtes_f32(a) }
}
#[doc = "Reciprocal square-root estimate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrteh_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(frsqrte))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vrsqrteh_f16(a: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrte.f16"
        )]
        fn _vrsqrteh_f16(a: f16) -> f16;
    }
    unsafe { _vrsqrteh_f16(a) }
}
#[doc = "Floating-point reciprocal square root step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrts_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrts))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrts_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrts.v1f64"
        )]
        fn _vrsqrts_f64(a: float64x1_t, b: float64x1_t) -> float64x1_t;
    }
    unsafe { _vrsqrts_f64(a, b) }
}
#[doc = "Floating-point reciprocal square root step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrtsq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrts))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrtsq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrts.v2f64"
        )]
        fn _vrsqrtsq_f64(a: float64x2_t, b: float64x2_t) -> float64x2_t;
    }
    unsafe { _vrsqrtsq_f64(a, b) }
}
#[doc = "Floating-point reciprocal square root step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrtsd_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrts))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrtsd_f64(a: f64, b: f64) -> f64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrts.f64"
        )]
        fn _vrsqrtsd_f64(a: f64, b: f64) -> f64;
    }
    unsafe { _vrsqrtsd_f64(a, b) }
}
#[doc = "Floating-point reciprocal square root step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrtss_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(frsqrts))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsqrtss_f32(a: f32, b: f32) -> f32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrts.f32"
        )]
        fn _vrsqrtss_f32(a: f32, b: f32) -> f32;
    }
    unsafe { _vrsqrtss_f32(a, b) }
}
#[doc = "Floating-point reciprocal square root step"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsqrtsh_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(test, assert_instr(frsqrts))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vrsqrtsh_f16(a: f16, b: f16) -> f16 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.frsqrts.f16"
        )]
        fn _vrsqrtsh_f16(a: f16, b: f16) -> f16;
    }
    unsafe { _vrsqrtsh_f16(a, b) }
}
#[doc = "Signed rounding shift right and accumulate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsrad_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(srshr, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsrad_n_s64<const N: i32>(a: i64, b: i64) -> i64 {
    static_assert!(N >= 1 && N <= 64);
    let b: i64 = vrshrd_n_s64::<N>(b);
    a.wrapping_add(b)
}
#[doc = "Unsigned rounding shift right and accumulate."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsrad_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(urshr, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsrad_n_u64<const N: i32>(a: u64, b: u64) -> u64 {
    static_assert!(N >= 1 && N <= 64);
    let b: u64 = vrshrd_n_u64::<N>(b);
    a.wrapping_add(b)
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "little")]
#[cfg_attr(test, assert_instr(rsubhn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_s16(a: int8x8_t, b: int16x8_t, c: int16x8_t) -> int8x16_t {
    let x: int8x8_t = vrsubhn_s16(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "little")]
#[cfg_attr(test, assert_instr(rsubhn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_s32(a: int16x4_t, b: int32x4_t, c: int32x4_t) -> int16x8_t {
    let x: int16x4_t = vrsubhn_s32(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "little")]
#[cfg_attr(test, assert_instr(rsubhn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_s64(a: int32x2_t, b: int64x2_t, c: int64x2_t) -> int32x4_t {
    let x: int32x2_t = vrsubhn_s64(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "little")]
#[cfg_attr(test, assert_instr(rsubhn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_u16(a: uint8x8_t, b: uint16x8_t, c: uint16x8_t) -> uint8x16_t {
    let x: uint8x8_t = vrsubhn_u16(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "little")]
#[cfg_attr(test, assert_instr(rsubhn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_u32(a: uint16x4_t, b: uint32x4_t, c: uint32x4_t) -> uint16x8_t {
    let x: uint16x4_t = vrsubhn_u32(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "little")]
#[cfg_attr(test, assert_instr(rsubhn2))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_u64(a: uint32x2_t, b: uint64x2_t, c: uint64x2_t) -> uint32x4_t {
    let x: uint32x2_t = vrsubhn_u64(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "big")]
#[cfg_attr(test, assert_instr(rsubhn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_s16(a: int8x8_t, b: int16x8_t, c: int16x8_t) -> int8x16_t {
    let x: int8x8_t = vrsubhn_s16(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "big")]
#[cfg_attr(test, assert_instr(rsubhn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_s32(a: int16x4_t, b: int32x4_t, c: int32x4_t) -> int16x8_t {
    let x: int16x4_t = vrsubhn_s32(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "big")]
#[cfg_attr(test, assert_instr(rsubhn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_s64(a: int32x2_t, b: int64x2_t, c: int64x2_t) -> int32x4_t {
    let x: int32x2_t = vrsubhn_s64(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "big")]
#[cfg_attr(test, assert_instr(rsubhn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_u16(a: uint8x8_t, b: uint16x8_t, c: uint16x8_t) -> uint8x16_t {
    let x: uint8x8_t = vrsubhn_u16(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "big")]
#[cfg_attr(test, assert_instr(rsubhn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_u32(a: uint16x4_t, b: uint32x4_t, c: uint32x4_t) -> uint16x8_t {
    let x: uint16x4_t = vrsubhn_u32(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Rounding subtract returning high narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vrsubhn_high_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_endian = "big")]
#[cfg_attr(test, assert_instr(rsubhn))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vrsubhn_high_u64(a: uint32x2_t, b: uint64x2_t, c: uint64x2_t) -> uint32x4_t {
    let x: uint32x2_t = vrsubhn_u64(b, c);
    unsafe { simd_shuffle!(a, x, [0, 1, 2, 3]) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vset_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vset_lane_f64<const LANE: i32>(a: f64, b: float64x1_t) -> float64x1_t {
    static_assert!(LANE == 0);
    unsafe { simd_insert!(b, LANE as u32, a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsetq_lane_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(nop, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsetq_lane_f64<const LANE: i32>(a: f64, b: float64x2_t) -> float64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe { simd_insert!(b, LANE as u32, a) }
}
#[doc = "SHA512 hash update part 2"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsha512h2q_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[cfg_attr(test, assert_instr(sha512h2))]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
pub fn vsha512h2q_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sha512h2"
        )]
        fn _vsha512h2q_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _vsha512h2q_u64(a, b, c) }
}
#[doc = "SHA512 hash update part 1"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsha512hq_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[cfg_attr(test, assert_instr(sha512h))]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
pub fn vsha512hq_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sha512h"
        )]
        fn _vsha512hq_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _vsha512hq_u64(a, b, c) }
}
#[doc = "SHA512 schedule update 0"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsha512su0q_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[cfg_attr(test, assert_instr(sha512su0))]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
pub fn vsha512su0q_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sha512su0"
        )]
        fn _vsha512su0q_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _vsha512su0q_u64(a, b) }
}
#[doc = "SHA512 schedule update 1"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsha512su1q_u64)"]
#[inline]
#[target_feature(enable = "neon,sha3")]
#[cfg_attr(test, assert_instr(sha512su1))]
#[stable(feature = "stdarch_neon_sha3", since = "1.79.0")]
pub fn vsha512su1q_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sha512su1"
        )]
        fn _vsha512su1q_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t;
    }
    unsafe { _vsha512su1q_u64(a, b, c) }
}
#[doc = "Signed Shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshld_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sshl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshld_s64(a: i64, b: i64) -> i64 {
    unsafe { transmute(vshl_s64(transmute(a), transmute(b))) }
}
#[doc = "Unsigned Shift left"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshld_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ushl))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshld_u64(a: u64, b: i64) -> u64 {
    unsafe { transmute(vshl_u64(transmute(a), transmute(b))) }
}
#[doc = "Signed shift left long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshll_high_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sshll2, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshll_high_n_s8<const N: i32>(a: int8x16_t) -> int16x8_t {
    static_assert!(N >= 0 && N <= 8);
    unsafe {
        let b: int8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        vshll_n_s8::<N>(b)
    }
}
#[doc = "Signed shift left long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshll_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sshll2, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshll_high_n_s16<const N: i32>(a: int16x8_t) -> int32x4_t {
    static_assert!(N >= 0 && N <= 16);
    unsafe {
        let b: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        vshll_n_s16::<N>(b)
    }
}
#[doc = "Signed shift left long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshll_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sshll2, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshll_high_n_s32<const N: i32>(a: int32x4_t) -> int64x2_t {
    static_assert!(N >= 0 && N <= 32);
    unsafe {
        let b: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        vshll_n_s32::<N>(b)
    }
}
#[doc = "Signed shift left long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshll_high_n_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ushll2, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshll_high_n_u8<const N: i32>(a: uint8x16_t) -> uint16x8_t {
    static_assert!(N >= 0 && N <= 8);
    unsafe {
        let b: uint8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        vshll_n_u8::<N>(b)
    }
}
#[doc = "Signed shift left long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshll_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ushll2, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshll_high_n_u16<const N: i32>(a: uint16x8_t) -> uint32x4_t {
    static_assert!(N >= 0 && N <= 16);
    unsafe {
        let b: uint16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        vshll_n_u16::<N>(b)
    }
}
#[doc = "Signed shift left long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshll_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(ushll2, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshll_high_n_u32<const N: i32>(a: uint32x4_t) -> uint64x2_t {
    static_assert!(N >= 0 && N <= 32);
    unsafe {
        let b: uint32x2_t = simd_shuffle!(a, a, [2, 3]);
        vshll_n_u32::<N>(b)
    }
}
#[doc = "Shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshrn_high_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(shrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshrn_high_n_s16<const N: i32>(a: int8x8_t, b: int16x8_t) -> int8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vshrn_n_s16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshrn_high_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(shrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshrn_high_n_s32<const N: i32>(a: int16x4_t, b: int32x4_t) -> int16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vshrn_n_s32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshrn_high_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(shrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshrn_high_n_s64<const N: i32>(a: int32x2_t, b: int64x2_t) -> int32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vshrn_n_s64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshrn_high_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(shrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshrn_high_n_u16<const N: i32>(a: uint8x8_t, b: uint16x8_t) -> uint8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe {
        simd_shuffle!(
            a,
            vshrn_n_u16::<N>(b),
            [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
        )
    }
}
#[doc = "Shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshrn_high_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(shrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshrn_high_n_u32<const N: i32>(a: uint16x4_t, b: uint32x4_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe { simd_shuffle!(a, vshrn_n_u32::<N>(b), [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Shift right narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vshrn_high_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(shrn2, N = 2))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vshrn_high_n_u64<const N: i32>(a: uint32x2_t, b: uint64x2_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe { simd_shuffle!(a, vshrn_n_u64::<N>(b), [0, 1, 2, 3]) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_s8<const N: i32>(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v8i8"
        )]
        fn _vsli_n_s8(a: int8x8_t, b: int8x8_t, n: i32) -> int8x8_t;
    }
    unsafe { _vsli_n_s8(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_s8<const N: i32>(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    static_assert_uimm_bits!(N, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v16i8"
        )]
        fn _vsliq_n_s8(a: int8x16_t, b: int8x16_t, n: i32) -> int8x16_t;
    }
    unsafe { _vsliq_n_s8(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_s16<const N: i32>(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(N, 4);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v4i16"
        )]
        fn _vsli_n_s16(a: int16x4_t, b: int16x4_t, n: i32) -> int16x4_t;
    }
    unsafe { _vsli_n_s16(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_s16<const N: i32>(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    static_assert_uimm_bits!(N, 4);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v8i16"
        )]
        fn _vsliq_n_s16(a: int16x8_t, b: int16x8_t, n: i32) -> int16x8_t;
    }
    unsafe { _vsliq_n_s16(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_s32<const N: i32>(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    static_assert!(N >= 0 && N <= 31);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v2i32"
        )]
        fn _vsli_n_s32(a: int32x2_t, b: int32x2_t, n: i32) -> int32x2_t;
    }
    unsafe { _vsli_n_s32(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_s32<const N: i32>(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    static_assert!(N >= 0 && N <= 31);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v4i32"
        )]
        fn _vsliq_n_s32(a: int32x4_t, b: int32x4_t, n: i32) -> int32x4_t;
    }
    unsafe { _vsliq_n_s32(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_s64<const N: i32>(a: int64x1_t, b: int64x1_t) -> int64x1_t {
    static_assert!(N >= 0 && N <= 63);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v1i64"
        )]
        fn _vsli_n_s64(a: int64x1_t, b: int64x1_t, n: i32) -> int64x1_t;
    }
    unsafe { _vsli_n_s64(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_s64<const N: i32>(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    static_assert!(N >= 0 && N <= 63);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsli.v2i64"
        )]
        fn _vsliq_n_s64(a: int64x2_t, b: int64x2_t, n: i32) -> int64x2_t;
    }
    unsafe { _vsliq_n_s64(a, b, N) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_u8<const N: i32>(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { transmute(vsli_n_s8::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_u8<const N: i32>(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { transmute(vsliq_n_s8::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_u16<const N: i32>(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    static_assert_uimm_bits!(N, 4);
    unsafe { transmute(vsli_n_s16::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_u16<const N: i32>(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    static_assert_uimm_bits!(N, 4);
    unsafe { transmute(vsliq_n_s16::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_u32<const N: i32>(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    static_assert!(N >= 0 && N <= 31);
    unsafe { transmute(vsli_n_s32::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_u32<const N: i32>(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    static_assert!(N >= 0 && N <= 31);
    unsafe { transmute(vsliq_n_s32::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_u64<const N: i32>(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    static_assert!(N >= 0 && N <= 63);
    unsafe { transmute(vsli_n_s64::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_u64<const N: i32>(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    static_assert!(N >= 0 && N <= 63);
    unsafe { transmute(vsliq_n_s64::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_p8<const N: i32>(a: poly8x8_t, b: poly8x8_t) -> poly8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { transmute(vsli_n_s8::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_p8<const N: i32>(a: poly8x16_t, b: poly8x16_t) -> poly8x16_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { transmute(vsliq_n_s8::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_p16<const N: i32>(a: poly16x4_t, b: poly16x4_t) -> poly16x4_t {
    static_assert_uimm_bits!(N, 4);
    unsafe { transmute(vsli_n_s16::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_p16<const N: i32>(a: poly16x8_t, b: poly16x8_t) -> poly16x8_t {
    static_assert_uimm_bits!(N, 4);
    unsafe { transmute(vsliq_n_s16::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsli_n_p64)"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsli_n_p64<const N: i32>(a: poly64x1_t, b: poly64x1_t) -> poly64x1_t {
    static_assert!(N >= 0 && N <= 63);
    unsafe { transmute(vsli_n_s64::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift Left and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsliq_n_p64)"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(test, assert_instr(sli, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsliq_n_p64<const N: i32>(a: poly64x2_t, b: poly64x2_t) -> poly64x2_t {
    static_assert!(N >= 0 && N <= 63);
    unsafe { transmute(vsliq_n_s64::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift left and insert"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vslid_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sli, N = 2))]
pub fn vslid_n_s64<const N: i32>(a: i64, b: i64) -> i64 {
    static_assert!(N >= 0 && N <= 63);
    unsafe { transmute(vsli_n_s64::<N>(transmute(a), transmute(b))) }
}
#[doc = "Shift left and insert"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vslid_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, not(target_env = "msvc")), assert_instr(sli, N = 2))]
pub fn vslid_n_u64<const N: i32>(a: u64, b: u64) -> u64 {
    static_assert!(N >= 0 && N <= 63);
    unsafe { transmute(vsli_n_u64::<N>(transmute(a), transmute(b))) }
}
#[doc = "SM3PARTW1"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3partw1q_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3partw1))]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3partw1q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3partw1"
        )]
        fn _vsm3partw1q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vsm3partw1q_u32(a, b, c) }
}
#[doc = "SM3PARTW2"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3partw2q_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3partw2))]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3partw2q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3partw2"
        )]
        fn _vsm3partw2q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vsm3partw2q_u32(a, b, c) }
}
#[doc = "SM3SS1"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3ss1q_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3ss1))]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3ss1q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3ss1"
        )]
        fn _vsm3ss1q_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vsm3ss1q_u32(a, b, c) }
}
#[doc = "SM3TT1A"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3tt1aq_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3tt1a, IMM2 = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3tt1aq_u32<const IMM2: i32>(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(IMM2, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3tt1a"
        )]
        fn _vsm3tt1aq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t, n: i64) -> uint32x4_t;
    }
    unsafe { _vsm3tt1aq_u32(a, b, c, IMM2 as i64) }
}
#[doc = "SM3TT1B"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3tt1bq_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3tt1b, IMM2 = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3tt1bq_u32<const IMM2: i32>(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(IMM2, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3tt1b"
        )]
        fn _vsm3tt1bq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t, n: i64) -> uint32x4_t;
    }
    unsafe { _vsm3tt1bq_u32(a, b, c, IMM2 as i64) }
}
#[doc = "SM3TT2A"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3tt2aq_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3tt2a, IMM2 = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3tt2aq_u32<const IMM2: i32>(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(IMM2, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3tt2a"
        )]
        fn _vsm3tt2aq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t, n: i64) -> uint32x4_t;
    }
    unsafe { _vsm3tt2aq_u32(a, b, c, IMM2 as i64) }
}
#[doc = "SM3TT2B"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm3tt2bq_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm3tt2b, IMM2 = 0))]
#[rustc_legacy_const_generics(3)]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm3tt2bq_u32<const IMM2: i32>(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(IMM2, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm3tt2b"
        )]
        fn _vsm3tt2bq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t, n: i64) -> uint32x4_t;
    }
    unsafe { _vsm3tt2bq_u32(a, b, c, IMM2 as i64) }
}
#[doc = "SM4 key"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm4ekeyq_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm4ekey))]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm4ekeyq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm4ekey"
        )]
        fn _vsm4ekeyq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vsm4ekeyq_u32(a, b) }
}
#[doc = "SM4 encode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsm4eq_u32)"]
#[inline]
#[target_feature(enable = "neon,sm4")]
#[cfg_attr(test, assert_instr(sm4e))]
#[unstable(feature = "stdarch_neon_sm4", issue = "117226")]
pub fn vsm4eq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.sm4e"
        )]
        fn _vsm4eq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vsm4eq_u32(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqadd_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqadd_u8(a: uint8x8_t, b: int8x8_t) -> uint8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v8i8"
        )]
        fn _vsqadd_u8(a: uint8x8_t, b: int8x8_t) -> uint8x8_t;
    }
    unsafe { _vsqadd_u8(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqaddq_u8(a: uint8x16_t, b: int8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v16i8"
        )]
        fn _vsqaddq_u8(a: uint8x16_t, b: int8x16_t) -> uint8x16_t;
    }
    unsafe { _vsqaddq_u8(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqadd_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqadd_u16(a: uint16x4_t, b: int16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v4i16"
        )]
        fn _vsqadd_u16(a: uint16x4_t, b: int16x4_t) -> uint16x4_t;
    }
    unsafe { _vsqadd_u16(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqaddq_u16(a: uint16x8_t, b: int16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v8i16"
        )]
        fn _vsqaddq_u16(a: uint16x8_t, b: int16x8_t) -> uint16x8_t;
    }
    unsafe { _vsqaddq_u16(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqadd_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqadd_u32(a: uint32x2_t, b: int32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v2i32"
        )]
        fn _vsqadd_u32(a: uint32x2_t, b: int32x2_t) -> uint32x2_t;
    }
    unsafe { _vsqadd_u32(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqaddq_u32(a: uint32x4_t, b: int32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v4i32"
        )]
        fn _vsqaddq_u32(a: uint32x4_t, b: int32x4_t) -> uint32x4_t;
    }
    unsafe { _vsqaddq_u32(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqadd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqadd_u64(a: uint64x1_t, b: int64x1_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v1i64"
        )]
        fn _vsqadd_u64(a: uint64x1_t, b: int64x1_t) -> uint64x1_t;
    }
    unsafe { _vsqadd_u64(a, b) }
}
#[doc = "Unsigned saturating Accumulate of Signed value."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(usqadd))]
pub fn vsqaddq_u64(a: uint64x2_t, b: int64x2_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.v2i64"
        )]
        fn _vsqaddq_u64(a: uint64x2_t, b: int64x2_t) -> uint64x2_t;
    }
    unsafe { _vsqaddq_u64(a, b) }
}
#[doc = "Unsigned saturating accumulate of signed value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddb_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(usqadd))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqaddb_u8(a: u8, b: i8) -> u8 {
    unsafe { simd_extract!(vsqadd_u8(vdup_n_u8(a), vdup_n_s8(b)), 0) }
}
#[doc = "Unsigned saturating accumulate of signed value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddh_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(usqadd))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqaddh_u16(a: u16, b: i16) -> u16 {
    unsafe { simd_extract!(vsqadd_u16(vdup_n_u16(a), vdup_n_s16(b)), 0) }
}
#[doc = "Unsigned saturating accumulate of signed value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqaddd_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(usqadd))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqaddd_u64(a: u64, b: i64) -> u64 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.i64"
        )]
        fn _vsqaddd_u64(a: u64, b: i64) -> u64;
    }
    unsafe { _vsqaddd_u64(a, b) }
}
#[doc = "Unsigned saturating accumulate of signed value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqadds_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(usqadd))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqadds_u32(a: u32, b: i32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.usqadd.i32"
        )]
        fn _vsqadds_u32(a: u32, b: i32) -> u32;
    }
    unsafe { _vsqadds_u32(a, b) }
}
#[doc = "Calculates the square root of each lane."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrt_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fsqrt))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vsqrt_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_fsqrt(a) }
}
#[doc = "Calculates the square root of each lane."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrtq_f16)"]
#[inline]
#[cfg_attr(test, assert_instr(fsqrt))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
pub fn vsqrtq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_fsqrt(a) }
}
#[doc = "Calculates the square root of each lane."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrt_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fsqrt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqrt_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_fsqrt(a) }
}
#[doc = "Calculates the square root of each lane."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrtq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fsqrt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqrtq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_fsqrt(a) }
}
#[doc = "Calculates the square root of each lane."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrt_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fsqrt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqrt_f64(a: float64x1_t) -> float64x1_t {
    unsafe { simd_fsqrt(a) }
}
#[doc = "Calculates the square root of each lane."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrtq_f64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(fsqrt))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsqrtq_f64(a: float64x2_t) -> float64x2_t {
    unsafe { simd_fsqrt(a) }
}
#[doc = "Floating-point round to integral, using current rounding mode"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsqrth_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg_attr(test, assert_instr(fsqrt))]
pub fn vsqrth_f16(a: f16) -> f16 {
    unsafe { sqrtf16(a) }
}
#[doc = "Shift Right and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsri_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sri, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsri_n_s8<const N: i32>(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsri.v8i8"
        )]
        fn _vsri_n_s8(a: int8x8_t, b: int8x8_t, n: i32) -> int8x8_t;
    }
    unsafe { _vsri_n_s8(a, b, N) }
}
#[doc = "Shift Right and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsriq_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sri, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsriq_n_s8<const N: i32>(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    static_assert!(N >= 1 && N <= 8);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsri.v16i8"
        )]
        fn _vsriq_n_s8(a: int8x16_t, b: int8x16_t, n: i32) -> int8x16_t;
    }
    unsafe { _vsriq_n_s8(a, b, N) }
}
#[doc = "Shift Right and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsri_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sri, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsri_n_s16<const N: i32>(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsri.v4i16"
        )]
        fn _vsri_n_s16(a: int16x4_t, b: int16x4_t, n: i32) -> int16x4_t;
    }
    unsafe { _vsri_n_s16(a, b, N) }
}
#[doc = "Shift Right and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsriq_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sri, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsriq_n_s16<const N: i32>(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vsri.v8i16"
        )]
        fn _vsriq_n_s16(a: int16x8_t, b: int16x8_t, n: i32) -> int16x8_t;
    }
    unsafe { _vsriq_n_s16(a, b, N) }
}
#[doc = "Shift Right and Insert (immediate)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vsri_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(test, assert_instr(sri, N = 1))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vsri